/***************************************************************************
                          guimodeselector.cpp  -  description
                             -------------------
    begin                : Fre Jun 6 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "guimodeselector.h"

// Qt includes
#include <qbuttongroup.h>
#include <qframe.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qradiobutton.h>

// KDE includes
#include <klocale.h>

GUIModeSelector::GUIModeSelector()
{
    optionWizard = optionTabs = 0;
}

GUIModeSelector::~GUIModeSelector()
{
}

bool GUIModeSelector::useWizard() const
{
    return optionWizard->isChecked();
}

void GUIModeSelector::setUseWizard( bool b )
{
    optionWizard->setChecked( b );
    optionTabs->setChecked( !b );
}

const QString GUIModeSelector::guiModeCaption() const
{
    return i18n("Look and Feel");
}

void GUIModeSelector::createFrame( QFrame* frame )
{
    QVBoxLayout* layout = new QVBoxLayout( frame );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );

    QButtonGroup* group = new QButtonGroup( frame );
    group->setColumnLayout(0, Qt::Vertical );
    QVBoxLayout* lgroup = new QVBoxLayout( group->layout() );

    optionWizard = new QRadioButton( group );
    optionWizard->setText( i18n("Use &wizard style GUI (beginners)") );
    optionTabs = new QRadioButton( group );
    optionTabs->setText( i18n("Use &tabbed GUI (advanced users)") );

    lgroup->addWidget( new QLabel( i18n("Configure the look and feel of the KRename GUI:<br>"), group ) );
    lgroup->addWidget( optionWizard );
    lgroup->addWidget( optionTabs );
    lgroup->addItem( spacer );

    layout->addWidget( group );
    layout->addItem( spacer );   
}


