/***************************************************************************
                         helpdialog.cpp  -  description
                             -------------------
    begin                : Fr Nov 15 13:44:19 CEST 2001
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "helpdialog.h"
#include "krenameimpl.h"

// Qt includes
#include <qcombobox.h>
#include <qlayout.h>
#include <qlineedit.h>

// KDE includes
#include <klocale.h>
#include <klistview.h>
#include <kpushbutton.h>
#include <kstdguiitem.h>

void HelpDialogData::remove( const QString & headline )
{
    if( m_map.contains( headline ) ) {
        m_map.remove( headline );
        m_icons.remove( headline );
        
        emit updateHeadline();                
        emit updateItems();
    }
}

void HelpDialogData::add( const QString & headline, QStringList* commands, const QPixmap & icon, bool first )
{
    m_map.insert( headline, *commands );
    m_icons.insert( headline, icon );
    if( first )
        m_first = headline;
        
    emit updateHeadline();
    emit updateItems();
}

QStringList HelpDialogData::tokens() const
{
    QStringList list;
    
#if QT_VERSION >= 0x030005
    // map.keys() seems only to be avaible in Qt >= 3.0.5
    QStringList keys = m_map.keys();
#else
    QStringList keys;
    QMap<QString, QStringList>::Iterator it;
    for ( it = m_map.begin(); it != m_map.end(); ++it )
        keys.append( it.key() );
#endif

    for( unsigned int i = 0; i < keys.count(); i++ )
        for( unsigned int z = 0; z < m_map[keys[i]].count(); z++ )
            list.append( m_map[keys[i]][z].section( ";;", 0, 0 ) );
        
    return list;
}


HelpDialog::HelpDialog( HelpDialogData* data, QWidget* parent,
    const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    text = NULL;

    resize( 500, 400 ); 
    setCaption( i18n( "Help" ) );
    HelpDialogLayout = new QVBoxLayout( this, 11, 6, "HelpDialogLayout"); 

    comboHeadline = new QComboBox( FALSE, this, "comboHeadline" );
    HelpDialogLayout->addWidget( comboHeadline );

    list = new KListView( this, "list" );
    list->addColumn( i18n( "Token" ) );
    list->addColumn( i18n( "Description" ) );
    HelpDialogLayout->addWidget( list );

    Layout1 = new QHBoxLayout( 0, 0, 6, "Layout1"); 
    QSpacerItem* spacer = new QSpacerItem( 91, 0, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout1->addItem( spacer );

    buttonAdd = new KPushButton( this, "buttonAdd" );
    buttonAdd->setText( i18n( "&Add" ) );
    Layout1->addWidget( buttonAdd );

    buttonClose = createButton( KStdGuiItem::close(), this );
    Layout1->addWidget( buttonClose );
    HelpDialogLayout->addLayout( Layout1 );

    // signals and slots connections
    connect( buttonClose, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( buttonAdd, SIGNAL( clicked() ), this, SLOT( execute() ) );
    connect( list, SIGNAL( executed(QListViewItem*) ), this, SLOT( execute() ) );
    connect( comboHeadline, SIGNAL( activated(int) ), this, SLOT(updateItems() ) );
    
    m_data = data;
    connect( m_data, SIGNAL( updateItems() ), this, SLOT( updateItems() ) );
    connect( m_data, SIGNAL( updateHeadline() ), this, SLOT( updateHeadline() ) );
}

HelpDialog::~HelpDialog()
{
    disconnect( m_data, SIGNAL( updateItems() ), this, SLOT( updateItems() ) );
    disconnect( m_data, SIGNAL( updateHeadline() ), this, SLOT( updateHeadline() ) );
}

void HelpDialog::execute()
{
    if(!list->currentItem())
        return;

    QString t = text->text();

    t.insert( text->cursorPosition(), list->currentItem()->text( 0 ) );
    text->setText( t );
    
    if( isModal() )
        accept();
}

void HelpDialog::updateItems()
{
    list->clear();
    QStringList items = m_data->map()[comboHeadline->currentText()];

    for( unsigned int i = 0; i < items.count(); i++ ) {
        QString tmp = items[i];
        new KListViewItem( list, tmp.section( ";;", 0, 0 ), tmp.section( ";;", 1, 1 ) );
    }
}

void HelpDialog::updateHeadline()
{
    comboHeadline->clear();
    QMap<QString,QStringList> m = m_data->map();
    QMap<QString,QPixmap> ic = m_data->icons();
    
    comboHeadline->insertItem( ic[m_data->first()], m_data->first() );    
    QMap<QString, QStringList>::Iterator it;
    for ( it = m.begin(); it != m.end(); ++it )
        if( it.key() != m_data->first() )
            comboHeadline->insertItem( ic[it.key()], it.key() );    
}

