/***************************************************************************
 *   Copyright (C) 2006 by the KSmoothDock team   *
 *   dangvd@yahoo.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CLOCK_H
#define CLOCK_H

#include <qobject.h>
#include "iconlessdockitem.h"

/**
 * @short Clock class
 * @author the KSmoothDock team <dangvd@yahoo.com>
 */

#include <qcolor.h>
#include <qfont.h>

#include "datepicker.h"

class Clock : public QObject, public IconlessDockItem
{
    Q_OBJECT
public:
    /// Constructors
    Clock();

    Clock(KSmoothDock* parent, int itemId, QString desc, int desktop, int minSize, int maxSize, double whRatio, Qt::Orientation orientation);

    /// Draw itself into the offscreen buffer
    virtual void draw(QPixmap& buffer, int x, int y, int size);

    /// Mouse pressed event handler
    virtual void mousePressEvent(QMouseEvent* e);

    /// Get description
    virtual QString getDescription();

    void setFontFace(QString fontFace);
    
    void setFontItalic(bool val);
    
    void setFontBold(bool val);
    
    void setFontSize(int size);
    
    void setFontColor(QColor color);

    void set24HourClock(bool val);

    /// Show/hide the calendar
    void toggleCalendar();
public slots:
    void updateTime();

    void configure();

private:
    QFont m_font;
    QColor m_fontColor;
    bool m_use24HourClock;
    QString m_text; // the time text, e.g. 20:55

    DatePicker* m_calendar; // the calendar
};

#endif
