/***************************************************************************
 *   Copyright (C) 2006 by the KSmoothDock team   *
 *   dangvd@yahoo.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DOCKSTATE_H
#define DOCKSTATE_H

/**
 * @short Abstract base class for all dock state classes
 * @author the KSmoothDock team <dangvd@yahoo.com>
 */

#include<qevent.h>

class KSmoothDock;

class DockState {
public:
    /// Constructor
    DockState(KSmoothDock* dock);

    /// Dock created event
    virtual void dockCreatedEvent() {};

    /// Paint event handler    
    virtual void paintEvent(QPaintEvent* e) = 0;

    /// Mouse pressed event handler
    virtual void mousePressEvent(QMouseEvent* e) = 0;
    
    /// Mouse moved event handler
    virtual void mouseMoveEvent(QMouseEvent* e) = 0;

    /// Enter event handler
    virtual void enterEvent(QEvent* e) = 0;

    /// Leave event handler
    virtual void leaveEvent(QEvent* e) = 0;

    /// Update the dock when the active window has been changed
    virtual void activeWindowChanged(WId id) {};

    /// Update the layout
    virtual void updateLayout(bool reset = true) = 0;

    /// Update background
    virtual void updateBackground() = 0;

    /// Update a specific item
    virtual void updateItem(int itemIndex) = 0;

    /// Update autohide mode
    virtual void updateAutohideMode() {};

protected:
    KSmoothDock* m_dock; // the dock
};

#endif
