/***************************************************************************
                          confmenudialog.h  -  description
                             -------------------
    begin                : Tue Jun 10 22:18:34 BST 2003
    copyright            : (C) 2004 by KSmoothDock team
    email                : dangvd@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONFMENUDIALOG_H
#define CONFMENUDIALOG_H

#include <qvariant.h>
#include <qdialog.h>
#include <qptrlist.h>

const int LAUNCHER_CONFIG_DIALOG_ICON_SIZE = 32;

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QSpacerItem;
class QGroupBox;
class QButtonGroup;
class QPushButton;
class QLabel;
class KListBox;
class QListBoxItem;
class QLineEdit;
class KIconButton;
class Launcher;

class LauncherConfigDialog : public QDialog
{
    Q_OBJECT

public:
    LauncherConfigDialog( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~LauncherConfigDialog();

	void update();		

signals:
	void updated();

public slots:
    virtual void btAdd_clicked();
    virtual void btRemove_clicked();
    virtual void btUpdate_clicked();
    virtual void btMoveUp__clicked();
    virtual void btMoveDown_clicked();
    virtual void btBrowse_clicked();
    virtual void btFolderLink_clicked();
    virtual void btApply_clicked();
    virtual void btClose_clicked();
	virtual void btOpenMenuFolder_clicked();
    virtual void btSync_clicked();

protected slots:
    virtual void languageChange();

	void selectedItemChanged();

private:
	void saveAll();

private:
	QPtrList<Launcher> items; // command array
    QString menuPath;

    QGroupBox* groupBox1;
    QLabel* textLabel1;
    QLabel* textLabel2;
    QLabel* textLabel3;
    KListBox* lbItems;
    QLineEdit* edtCommand;
    QLineEdit* edtName;
    KIconButton* ibtIcon;
    QButtonGroup* buttonGroup1;
    QPushButton* btMoveDown;
    QPushButton* btMoveUp_;
    QPushButton* btUpdate;
    QPushButton* btRemove;
    QPushButton* btAdd;
    QGroupBox* groupBox2;
    QPushButton* btOpenMenuFolder;
    QPushButton* btSync;
    QPushButton* btBrowse;
    QPushButton* btFolderLink;
    QPushButton* btApply;
    QPushButton* btClose;
};

#endif // CONFMENUDIALOG_H
