/***************************************************************************
 *   Copyright (C) 2007 by The KSmoothDock team   *
 *   dangvd@yahoo.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <iostream>
#include "ksmoothdock.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static const char description[] =
    I18N_NOOP("A KDE KPart Application");

static const char version[] = "4.5";

static const char RESET_CONFIG[] = "resetConfig";

static const char RESET_LAUNCHERS[] = "resetLaunchers";

static KCmdLineOptions options[] =
{
//    { "+[URL]", I18N_NOOP( "Document to open" ), 0 },
    { RESET_CONFIG, I18N_NOOP("reset configuration data"), 0 },
    { RESET_LAUNCHERS, I18N_NOOP("reset quick launchers data"), 0 },
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
    KAboutData about("ksmoothdock", I18N_NOOP("KSmoothDock"), version, description,
		     KAboutData::License_GPL, "(C) 2007 The KSmoothDock team", 0, 0, "dangvd@yahoo.com");
    about.addAuthor( "The KSmoothDock team", 0, "dangvd@yahoo.com" );
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );
    KApplication app;
    KSmoothDock *mainWin = 0;

    if (app.isRestored())
    {
        //RESTORE(KSmoothDock);
    }
    else
    {
        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

        /// @todo do something with the command line args here

        mainWin = new KSmoothDock(args->isSet(RESET_CONFIG), args->isSet(RESET_LAUNCHERS));
        app.setMainWidget( mainWin );
        mainWin->show();

    }

    // mainWin has WDestructiveClose flag by default, so it will delete itself.
    return app.exec();
}

