/***************************************************************************
 *   Copyright (C) 2006 by the KSmoothDock team   *
 *   dangvd@yahoo.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef TASK_H
#define TASK_H

#include <qobject.h>
#include "iconbaseddockitem.h"

/**
 * @short Class represents a running task
 * @author the KSmoothDock team <dangvd@yahoo.com>
 */

#include <qtimer.h>

class Task : public QObject, public IconBasedDockItem
{
    Q_OBJECT
public:
    Task();

    Task(KSmoothDock* parent, int itemId, QString desc, int desktop, QPixmap& icon, int minSize, int maxSize, Qt::Orientation orientation, int winId);

    /// Draw itself into the offscreen buffer
    virtual void draw(QPixmap& buffer, int x, int y, int size);

    /// Mouse pressed event handler
    virtual void mousePressEvent(QMouseEvent* e);

    /// return window id
    WId getWinId();

    /// get demands attention
    bool getDemandsAttention();

    /// set demands attention
    void setDemandsAttention(bool value);

public slots:
    /// minimise a task
    void minTask();

    /// maximise a task
    void maxTask();

    /// close a task
    void closeTask();

    /// the internal timer ticked
    void timerTicked();

private:
    WId m_winId;
    bool m_demandsAttention; // does the task demand attention?
    QTimer* m_timer; // internal timer, used to flash the icon when the task demands attention
    char m_timerCount; // timer's count
};

#endif
