/***************************************************************************
 *   Copyright (C) 2006 by the KSmoothDock team   *
 *   dangvd@yahoo.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef TOOLTIP_H
#define TOOLTIP_H

#include <qwidget.h>

/**
 * @short Tooltip class
 * @author the KSmoothDock team <dangvd@yahoo.com>
 */

#include <qcolor.h>
#include <qfont.h>

class Tooltip : public QWidget
{
    Q_OBJECT
public:
    Tooltip(QWidget* parent = 0, const char* name = 0);

    void setText(QString s);
    void setFontFace(QString fontFace);
    void setFontItalic(bool val);
    void setFontBold(bool val);
    void setFontSize(int size);
    void setFontColor(QColor color);
    void setBackgroundColor(QColor color); 

    void updateLayout();

protected:
    void paintEvent(QPaintEvent* e);

private:
    QString m_text;
    QFont m_font;
    QColor m_fontColor;
    int m_fontSize;
    QColor m_backgroundColor;
};

#endif
