/***************************************************************************
                          welcomedialog.cpp  -  description
                             -------------------
    begin                : May 7 22:18:34 BST 2004
    copyright            : (C) 2003-2005 by KSmoothDock team
    email                : dangvd@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/// @TODO: re-format the file according to KSmoothDock v4.0's coding style

#include <klocale.h>

#include <qvariant.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qcombobox.h>

#include "welcomedialog.h"

/*
 *  Constructs a WelcomeDialog as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
WelcomeDialog::WelcomeDialog( QWidget* parent, const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    if ( !name )
	setName( "WelcomeDialog" );

    textLabel2 = new QLabel( this, "textLabel2" );
    textLabel2->setGeometry( QRect( 20, 60, 490, 41 ) );

    groupBox1 = new QGroupBox( this, "groupBox1" );
    groupBox1->setGeometry( QRect( 20, 110, 490, 100 ) );

    buttonGroup2 = new QButtonGroup( groupBox1, "buttonGroup2" );
    buttonGroup2->setGeometry( QRect( 20, 30, 340, 60 ) );
    buttonGroup2->setLineWidth( 0 );

    rbNormalZoom = new QRadioButton( buttonGroup2, "rbNormalZoom" );
    rbNormalZoom->setGeometry( QRect( 10, 0, 20, 20 ) );
    rbNormalZoom->setChecked( TRUE );

    rbParabolicZoom = new QRadioButton( buttonGroup2, "rbParabolicZoom" );
    rbParabolicZoom->setGeometry( QRect( 10, 31, 20, 20 ) );

    textLabel3 = new QLabel( groupBox1, "textLabel3" );
    textLabel3->setGeometry( QRect( 60, 24, 200, 30 ) );

    textLabel4 = new QLabel( groupBox1, "textLabel4" );
    textLabel4->setGeometry( QRect( 60, 55, 180, 30 ) );

    groupBox2 = new QGroupBox( this, "groupBox2" );
    groupBox2->setGeometry( QRect( 20, 220, 490, 190 ) );

    cbClock = new QCheckBox( groupBox2, "cbClock" );
    cbClock->setGeometry( QRect( 30, 160, 16, 16 ) );

    cbPager = new QCheckBox( groupBox2, "cbPager" );
    cbPager->setGeometry( QRect( 30, 70, 16, 16 ) );

    textLabel6 = new QLabel( groupBox2, "textLabel6" );
    textLabel6->setGeometry( QRect( 80, 20, 340, 41 ) );

    cbQuickLaunch = new QCheckBox( groupBox2, "cbQuickLaunch" );
    cbQuickLaunch->setEnabled( FALSE );
    cbQuickLaunch->setGeometry( QRect( 30, 30, 16, 21 ) );
    cbQuickLaunch->setChecked( TRUE );

    textLabel7 = new QLabel( groupBox2, "textLabel7" );
    textLabel7->setGeometry( QRect( 80, 63, 171, 31 ) );

    textLabel2_3 = new QLabel( groupBox2, "textLabel2_3" );
    textLabel2_3->setGeometry( QRect( 80, 103, 131, 31 ) );

    cbShowWinAllDesks = new QCheckBox( groupBox2, "cbShowWinAllDesks" );
    cbShowWinAllDesks->setGeometry( QRect( 110, 134, 16, 16 ) );

    textLabel1_3 = new QLabel( groupBox2, "textLabel1_3" );
    textLabel1_3->setGeometry( QRect( 160, 122, 261, 41 ) );

    textLabel9 = new QLabel( groupBox2, "textLabel9" );
    textLabel9->setGeometry( QRect( 80, 154, 141, 30 ) );

    cbTaskbar = new QCheckBox( groupBox2, "cbTaskbar" );
    cbTaskbar->setGeometry( QRect( 30, 110, 16, 16 ) );

    pushButton3 = new QPushButton( this, "pushButton3" );
    pushButton3->setGeometry( QRect( 210, 510, 121, 41 ) );

    textLabel1 = new QLabel( this, "textLabel1" );
    textLabel1->setGeometry( QRect( 20, 0, 490, 61 ) );

    groupBox3 = new QGroupBox(this, "groupBox3");
    groupBox3->setGeometry( QRect(20, 420, 490, 80) );

    cbAutohide = new QCheckBox(groupBox3, "cbAutohide");
    cbAutohide->setGeometry( QRect(30, 20, 20, 20));

    lbAutohide = new QLabel(groupBox3, "lbAutohide");
    lbAutohide->setGeometry( QRect(60, 20, 180, 20) );

    lbPosition = new QLabel(groupBox3, "lbPosition");
    lbPosition->setGeometry( QRect(30, 50, 100, 20) );

    cbbPosition = new QComboBox(groupBox3, "cbbPosition");
    cbbPosition->setGeometry( QRect(140, 50, 80, 22));

    languageChange();
    resize( QSize(530, 568).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );

    // signals and slots connections
    connect( pushButton3, SIGNAL( clicked() ), this, SLOT( pushButton3_clicked() ) );
    connect( cbTaskbar, SIGNAL( stateChanged(int) ), this, SLOT( cbTaskbar_stateChanged(int) ) );

    // init variables
    cbPager->setChecked(true);
    cbTaskbar->setChecked(true);
    cbClock->setChecked(true);
    cbShowWinAllDesks->setEnabled(cbTaskbar->isChecked());
    cbShowWinAllDesks->setChecked(true);
    cbbPosition->setCurrentItem(3);
}

/*
 *  Destroys the object and frees any allocated resources
 */
WelcomeDialog::~WelcomeDialog()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void WelcomeDialog::languageChange()
{
    setCaption( tr2i18n( "Welcome to KSmoothDock!" ) );
    textLabel2->setText( tr2i18n( "<font color=\"#aa0000\">Note: you can always change these options (as well as other options) later by right-click on the dock,\n"
"then click on \"Edit Preferences\".</font>" ) );
    groupBox1->setTitle( tr2i18n( "The zooming mode you want to use" ) );
    buttonGroup2->setTitle( QString::null );    
    textLabel3->setText( tr2i18n( "Normal Smooth Zooming Mode" ) );
    textLabel4->setText( tr2i18n( "Parabolic Zooming Mode" ) );
    groupBox2->setTitle( tr2i18n( "The components of KSmoothDock you want to use" ) );
    cbPager->setText( QString::null );
    textLabel6->setText( tr2i18n( "Quick launch menu (always enabled by default)" ) );
    cbQuickLaunch->setText( QString::null );
    textLabel7->setText( tr2i18n( "Pager" ) );
    textLabel2_3->setText( tr2i18n( "Taskbar" ) );
    textLabel1_3->setText( tr2i18n( "Show windows from all desktops" ) );
    textLabel9->setText( tr2i18n( "Clock" ) );
    pushButton3->setText( tr2i18n( "&OK" ) );
    pushButton3->setAccel( QKeySequence( tr2i18n( "Alt+O" ) ) );
    textLabel1->setText( tr2i18n( "<font color=\"#0000ff\">It seems you are running KSmoothDock for the first time!<br>\n"
"Please choose your initial basic setup.</font>" ) );
    groupBox3->setTitle(tr2i18n("Other settings"));
    lbAutohide->setText(tr2i18n("Hide the dock automatically"));
    lbPosition->setText(tr2i18n("Panel Position"));
    cbbPosition->insertItem(tr2i18n("Top"));
    cbbPosition->insertItem(tr2i18n("Bottom"));
    cbbPosition->insertItem(tr2i18n("Left"));
    cbbPosition->insertItem(tr2i18n("Right"));
}

void WelcomeDialog::pushButton3_clicked()
{
    accept();
}

void WelcomeDialog::cbTaskbar_stateChanged( int )
{
    cbShowWinAllDesks->setEnabled(cbTaskbar->isChecked());
}

ZoomMode WelcomeDialog::getZoomMode() {
    ZoomMode zoomMode = (rbNormalZoom->isOn()) ? NORMAL_ZOOM : PARABOLIC_ZOOM;
    return zoomMode;
}

int WelcomeDialog::isShowingPager() {
    int showPager = (cbPager->isChecked()) ? 1 : 0;
    return showPager;
}

int WelcomeDialog::isShowingTaskbar() {    
    int showTaskbar = (cbTaskbar->isChecked()) ? 1 : 0;
    return showTaskbar;
}

int WelcomeDialog::isShowingClock() {
    int showClock = (cbClock->isChecked()) ? 1 : 0;
    return showClock;
}

int WelcomeDialog::isShowingWindowsAllDesktops() {
	int res = (cbShowWinAllDesks->isChecked()) ? 1 : 0;
    return res;
}

int WelcomeDialog::isAutohide() {
    int res = (cbAutohide->isChecked()) ? 1 : 0;
    return res;
}

PanelPosition WelcomeDialog::getPosition() {
    switch (cbbPosition->currentItem()) {
        case 0: return TOP;
        case 1: return BOTTOM;
        case 2: return LEFT;
        case 3: return RIGHT;
    }
}

#include "welcomedialog.moc"
