/*
Part of KSudoku project
http://ksudoku.sf.net
(c) 2005 Francesco Rossi <redsh@email.it>
(c) 2007 Johannes Bergmeier <Johannes.Bergmeier@gmx.net>
	 Mick Kappenburg <ksudoku@kappenburg.net>
	 Francesco Rossi <redsh@email.it>

This is free software released under GNU GENERAL PUBLIC LICENSE (GPLv2)
See COPYING file in project root directory for more information.

See the credits for this file in AUTHORS file in project root directory
*/
//
// C++ Implementation: drawfactory
//
// Description: 
//
//
// Author:  <>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "drawfactory.h"

#include "ksudoku_types.h"
#include "puzzle.h"
#include "sudokudraw.h"
#include "roxdokudraw.h"

namespace ksudoku {

DrawFactory::DrawFactory()
{
}

DrawFactory::~DrawFactory()
{
}

DrawBase* DrawFactory::create_instance(Puzzle const& puzzle, Symbols const& symbols) const
{
	switch(puzzle.gameType()){
		case sudoku:
			return new SudokuDraw(puzzle, symbols);
			break;
		case roxdoku:
			///@TODO enable roxdoku prints or give warning
			return 0;//new RoxdokuDraw(puzzle, symbols);
			break;
		default:
			return 0;
			break;
	}
}


}
