/*
   
        (c) 2006 by Thomas Michel <tom.michel@arcor.de>

        Kwlan is free software; you can redistribute it and/or modify
        it under the terms of the GNU Library General Public License as
        published by the Free Software Foundation; either version 2 of
        the License, or (at your option) any later version.

        Kwlan is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU Library General Public License for more details.

        You should have received a copy of the GNU Library General Public License
        along with this library; see the file COPYING.LIB.  If not, write to
        the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
        Boston, MA 02110-1301, USA.
*/

#include <qtimer.h>

#include <kdebug.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kpassdlg.h>

#include "globals.h"
#include "configuration.h"
#include "kwlansuprocess.h"

KwlanSuProcess::KwlanSuProcess(QObject *parent, const char *name):
  SuProcessBase(parent, name)
{
  m_pwstate = 0;
  m_keep = 1; // Show "Keep password" checkbox
  m_restart = false;
  m_parent = parent;
}

KwlanSuProcess::~KwlanSuProcess()
{
  m_password.fill(0);
}

bool KwlanSuProcess::start(RunMode runmode, Communication comm)
{
  if (runmode == DontCare)
    kdWarning() << k_funcinfo << "KwlanSuProcess can be started only in NotifyOnExit or Block mode" << endl; 

  connect(this, SIGNAL( processExited(SuProcessBase *) ), 
                  this, SLOT( slotProcessExited(SuProcessBase *) ));

  SuProcessBase::start(runmode, comm);
  return TRUE;
}

void KwlanSuProcess::setDescription(const QString &desc)
{
  m_desc = desc.ascii();
}

void KwlanSuProcess::setRestart(bool restart)
{
  m_restart = restart;
}


void KwlanSuProcess::slotProcessExited(SuProcessBase *proc)
{
    // leave error handling to kdesu
    //emit processExited( this);
    //return;
    if (::debugOutput) kdDebug() << "SUProcess exited with status " << proc->exitStatus() << endl;
    if (proc->exitStatus()) 
    {
        if (m_restart) {
        // We are allowed to restart - ask the user
            QString prompt = i18n("<qt>Kwlan was unable to"
                    "<p align=\"center\"><b>%1</b></p>"
                    "This may be caused by temporary malfunction or system misconfiguration "
                    "(e.g. absence of the utility called). You may want to run this task again and see "
                    "if this helps. Do you want to restart the task?</qt>"
                                 ).arg(m_desc); 

            int result = KMessageBox::questionYesNo(0, prompt, i18n("Error has occured"));
      
        // The user decided to try again
            if (result == KMessageBox::Yes) {
                m_pwstate = 0;
                m_keep = 1;
                QTimer::singleShot(0, proc, SLOT(restart()));
            } 
        // The user declined the request - just delete the process.
            else
            {
                emit processExited( this);
            //proc->deleteLater();    
            }
        }
        else {
      // Error has occured but we are not allowed to restart - show message box and delete the process
            QString prompt = i18n("<qt>Kwlan was unable to"
                    "<p align=\"center\"><b>%1</b></p>"
                    "This may be caused by system misconfiguration e.g. absence "
                    "of the utility called or incorrect parameters passed. "
                    "Please check this and try again."
                                 ).arg(m_desc); 
			     
            KMessageBox::error(0, prompt, i18n("Error has occured"));
            emit processExited( this);
        //proc->deleteLater();
        }
    }
    else
    {
        emit processExited( this);
        //proc->deleteLater(); 
    }
  // First,check if auth is ok
}
