/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details. 
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef DlgCleanCache_H_Included
#define DlgCleanCache_H_Included

#include "BaseDlgCleanCache.h"

class DlgCleanCache: public BaseDlgCleanCache 
  {
    Q_OBJECT
    
    public:
      enum
        {
          c_cleanHeaders  = 0x01,
          c_cleanPackages = 0x02,
          c_cleanMetadata = 0x04,
          c_cleanCache    = 0x08,
          c_cleanDBCache  = 0x10,
          c_cleanAll      = c_cleanHeaders 
                              | c_cleanPackages | c_cleanMetadata 
                              | c_cleanCache | c_cleanDBCache
        };
    
    private:
      void          enableSelection(bool bEnable);

    public:
                    DlgCleanCache(QWidget * pParent = 0);

      int           cleanWhich() const;


    protected slots:
      virtual void  slotRadioAllStateChanged(int state);
  };

#endif
