/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef DlgFindPackages_H_Included
#define DlgFindPackages_H_Included

#include <qstringlist.h>

#include "BaseDlgFindPackages.h"


class DlgFindPackages: public BaseDlgFindPackages
  {
    Q_OBJECT

    public:
      enum E_Mode
        {
          c_Search,
          c_Provides
        };

    private:
      static E_Mode   m_mode;
      static bool     m_bInstall;
      static QString  m_strPattern;

    public:
                      DlgFindPackages (QWidget * pParent = 0, const char * pName = 0);

      void            setOnlyUpdates  (bool bOnlyUpdates);
      void            setPatterns     (const QStringList & strList);

      bool            onlyUpdates     () const;
      QStringList &   getPatterns     (QStringList & strList) const;

      E_Mode          getMode         () const { return m_mode; }
      bool            getInstall      () const { return m_bInstall; }

    protected slots:
      virtual void    slotPatternsChanged ();
      virtual void    accept              ();
  };

#endif
