/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef DlgRemovePkgs_H_Included
#define DlgRemovePkgs_H_Included

#include "ProcessDlg.h"

class KTextEdit;
class QPushButton;

class DlgRemovePkgs : public ProcessDlg
  {
    Q_OBJECT

    private:
      KTextEdit   * m_pOutputView;
      QPushButton * m_pButtonOk,
                  * m_pButtonCancel;

    public:
                  DlgRemovePkgs     (const QStringList  & pkgList,
                                     QWidget            * pParent = 0,
                                     const char         * pName   = 0);
      virtual   ~ DlgRemovePkgs     ();

    protected slots:
      void        slotProcessStarted();
      void        slotProcessExited ();
      void        slotReadyStdout   ();
      void        slotReadyStderr   ();
  };

#endif
