/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details. 
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef UserEvents_H_Included
#define UserEvents_H_Included

#include <qevent.h>
#include <qprocess.h>


enum
  {
    c_evt_ThreadDone = QEvent::User + 1,
    c_evt_StdOut,
    c_evt_StdErr,
    c_evt_FileChanged,
    c_evt_ProcessStarted,
    c_evt_ShowPkgInfo
    
  };


class OutputData
  {
    public:
      enum E_Type
        {
          c_Stdout,
          c_Stderr
        };

    private:
      QString   m_strText;
      E_Type    m_type;

    public:
                OutputData(QString strText, E_Type type)
                  : m_strText(strText),
                    m_type(type)
                {
                }

      QString   getText() const { return m_strText; }
      E_Type    getType() const { return m_type; }
  };

  
class StdOutData : public OutputData
  {
    public:
               StdOutData(QString strText)
                  : OutputData(strText, c_Stdout)
               {
               }
  };
  

class StdErrData : public OutputData
  {
    public:
               StdErrData(QString strText)
                  : OutputData(strText, c_Stderr)
               {
               }
  };
 

class StdOutEvent : public QCustomEvent
  {
    public:
                          StdOutEvent(QString strText)
                            : QCustomEvent(QEvent::Type(c_evt_StdOut),  new StdOutData(strText))
                          {
                          }

     const StdOutData   * getStdOutData() const
                          {
                              return static_cast<StdOutData *>(data());
                          }

     QString              getText() const
                          {
                              return getStdOutData()->getText();
                          }
  };
  
  
class StdErrEvent : public QCustomEvent
  {
    public:
                          StdErrEvent(QString strText)
                            : QCustomEvent(QEvent::Type(c_evt_StdErr),  new StdErrData(strText))
                          {
                          }
                
     const StdErrData   * getStdErrData() const
                          {
                              return static_cast<StdErrData *>(data());
                          }
                          
     QString              getText() const
                          {
                              return getStdErrData()->getText();
                          }
  };
  

class FileChangedEvent : public QCustomEvent
  {
    private:
      QString             m_strFileName;
    
    public:
                          FileChangedEvent(QString strFileName)

                            : QCustomEvent(c_evt_FileChanged),
                              m_strFileName(strFileName)

                          {
                          }

     QString              getFileName() const { return m_strFileName; }
  };
 

class ProcessStartedEvent : public QCustomEvent
  {
    private:
      QProcess::PID       m_pid;
    
    public:
                          ProcessStartedEvent(QProcess::PID pid)

                            : QCustomEvent(c_evt_ProcessStarted),
                              m_pid(pid)

                          {
                          }

     QProcess::PID        getPID() const { return m_pid; }
  };
 

class ShowPkgInfoEvent : public QCustomEvent
  {
    private:
      QString             m_strDescription;
    
    public:
                          ShowPkgInfoEvent(QString strDescription)

                            : QCustomEvent(c_evt_ShowPkgInfo),
                              m_strDescription(strDescription)

                          {
                          }

     QString              getDescription() const { return m_strDescription; }
  };
 
#endif
