#include "node.h"

#define CM_TYPE_ORTHO            (cm_ortho_get_type ())
#define CM_ORTHO(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), CM_TYPE_ORTHO, CmOrtho))
#define CM_ORTHO_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  CM_TYPE_ORTHO, CmOrthoClass))
#define CM_IS_ORTHO(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CM_TYPE_ORTHO))
#define CM_IS_ORTHO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  CM_TYPE_ORTHO))
#define CM_ORTHO_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  CM_TYPE_ORTHO, CmOrthoClass))

typedef struct _CmOrtho CmOrtho;
typedef struct _CmOrthoClass CmOrthoClass;

struct _CmOrtho
{
    CmNode	parent_instance;
    
    int		x;
    int		y;
    int		width;
    int		height;

    CmNode *	child;
};

struct _CmOrthoClass
{
    CmNodeClass parent_class;
};

GType cm_ortho_get_type (void);

CmOrtho *cm_ortho_new      (CmNode  *child,
			    int      x,
			    int      y,
			    int      width,
			    int      height);
void     cm_ortho_set_axes (CmOrtho *ortho,
			    int      x,
			    int      y,
			    int      width,
			    int      height);

