/**
 * @file libgalago-gtk/galago-gtk-service-combo-box.h Service ComboBox widget
 *
 * @Copyright (C) 2004-2006 Christian Hammond.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_GTK_SERVICE_COMBO_BOX_H_
#define _GALAGO_GTK_SERVICE_COMBO_BOX_H_

#include <gtk/gtk.h>

typedef struct _GalagoGtkServiceComboBox      GalagoGtkServiceComboBox;
typedef struct _GalagoGtkServiceComboBoxClass GalagoGtkServiceComboBoxClass;
typedef struct _GalagoGtkServiceComboBoxPriv  GalagoGtkServiceComboBoxPriv;

#include <libgalago/galago.h>

#define GALAGO_GTK_TYPE_SERVICE_COMBO_BOX (galago_gtk_service_combo_box_get_type())
#define GALAGO_GTK_SERVICE_COMBO_BOX(obj) \
		(G_TYPE_CHECK_INSTANCE_CAST((obj), GALAGO_GTK_TYPE_SERVICE_COMBO_BOX, GalagoGtkServiceComboBox))
#define GALAGO_GTK_SERVICE_COMBO_BOX_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_CAST((klass), GALAGO_GTK_TYPE_SERVICE_COMBO_BOX, GalagoGtkServiceComboBoxClass))
#define GALAGO_GTK_IS_SERVICE_COMBO_BOX(obj) \
		(G_TYPE_CHECK_INSTANCE_TYPE((obj), GALAGO_GTK_TYPE_SERVICE_COMBO_BOX))
#define GALAGO_GTK_IS_SERVICE_COMBO_BOX_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_TYPE((klass), GALAGO_GTK_TYPE_SERVICE_COMBO_BOX))
#define GALAGO_GTK_SERVICE_COMBO_BOX_GET_CLASS(obj) \
		(G_TYPE_INSTANCE_GET_CLASS ((obj), GALAGO_GTK_TYPE_SERVICE_COMBO_BOX, GalagoGtkServiceComboBoxClass))

struct _GalagoGtkServiceComboBox
{
	GtkComboBox parent_object;

	GalagoGtkServiceComboBoxPriv *priv;

	void (*gtk_reserved1)(void);
	void (*gtk_reserved2)(void);
	void (*gtk_reserved3)(void);
	void (*gtk_reserved4)(void);
};

struct _GalagoGtkServiceComboBoxClass
{
	GtkComboBoxClass parent_class;

	/* Signals */
	void (*service_changed)(GalagoGtkServiceComboBox *list,
							GalagoService *service);

	void (*gtk_reserved1)(void);
	void (*gtk_reserved2)(void);
	void (*gtk_reserved3)(void);
	void (*gtk_reserved4)(void);
};

G_BEGIN_DECLS

GType galago_gtk_service_combo_box_get_type(void);

GtkWidget *galago_gtk_service_combo_box_new(void);

void galago_gtk_service_combo_box_set_service(
	GalagoGtkServiceComboBox *combobox, const GalagoService *service);
GalagoService *galago_gtk_service_combo_box_get_service(
	const GalagoGtkServiceComboBox *combobox);

G_END_DECLS

#endif /* _GALAGO_GTK_SERVICE_COMBO_BOX_H_ */
