# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###
# Based on qlscrobbler.py from quodlibet
# Copyright (C) 2005 by Joshua Kwan <joshk@triplehelix.org>,
#                       Joe Wreschnig <piman@sacredchao.net>
###

import gobject
import md5
import time
import urllib
import urllib2

from song import sType

import threading

from helper import helper
import config

PROTOCOL_VERSION = 1.1
if True:
    #FIXME: Need change client ID when i receive mine if one days audioscrobbler want answer me
    CLIENT = "xms"
    VERSION = 0.7
else:
    CLIENT = "tst"
    VERSION = 1.0

URL = "http://post.audioscrobbler.com/?hs=true&p=%s&c=%s&v=%s" % ( PROTOCOL_VERSION, CLIENT, VERSION)

class AudioScrobblerBadUser(Exception):
    pass
class AudioScrobblerCatastrophicFailure(Exception):
    pass
class AudioScrobblerBadAuth(Exception):
    pass

class AudioScrobblerManager:
    def __init__(self):

        self.password_hash = None
        self.submit_url = None
        self.queue = []
        self.interval_time = 0

        self.condition = threading.Condition()
        self.thread = threading.Thread(target=self.submit)
        self.thread.setDaemon(True)     # exit if only this thread is left
        self.thread.start()
        
        helper.connect("song-report",self.helper_cb)

    def get_stamp(self):
        return time.strftime("%Y-%m-%d %H:%M:%S", time.gmtime())
    
    def helper_cb(self,helper,song):
        self.add(song)
    
    def add(self,song,stamp=None):
        #some sanity control
        if song.get("#duration")<=30*1000 or \
           song.get("title")=="" or \
           song.get_type() not in sType.shoucast_report:
               return

        self.condition.acquire()
        if config.get("audioscrobbler","enable")=="true":
            self.username = config.get("audioscrobbler","username")
            self.md5_pass = config.get("audioscrobbler","password")
            self.queue.append((song,stamp or self.get_stamp()))
            #print "Queuing: %s - %s" % (song.sprint("artist"), song.sprint("title"))
            self.condition.notify()
        self.condition.release()

    def send_handshake(self):
        url = URL + "&u=%s" % self.username    

        #print "Sending handshake to Audioscrobbler."
        #print url
        resp = None
        try:
                resp = urllib2.urlopen(url);
        except Exception,e:
                print "Server not responding, handshake failed.",e
                return False

        # check response
        lines = resp.read().rstrip().split("\n")
        status = lines.pop(0)

        if status.startswith("UPDATE"): print "Please update: %s" % status
        
        
        if status == "UPTODATE" or status.startswith("UPDATE"): 
            challenge = lines.pop(0)
            
            #print "Chanllenge ",self.challenge

            hasher = md5.new()
            hasher.update(self.md5_pass)
            hasher.update(challenge)
            self.password_hash = hasher.hexdigest()

            self.submit_url = lines.pop(0)
            print "Handshake SUCCESS",self.password_hash


        try: self.interval_time = int(lines.pop(0).split()[1])
        except: pass
 
        if status == "UPTODATE" or status.startswith("UPDATE"): return True
        elif status == "BADUSER": raise AudioScrobblerBadUser()
        else: print "Handshake failed: %s" % status; return False


    def submit(self):
        while True:
            self.condition.acquire()
            while not self.queue:
                self.condition.wait()
            self.condition.release()
            self.interval_time = 10
            try:
                while not self.send_handshake():
                    time.sleep(self.interval_time)
            except AudioScrobblerBadUser:
                print "Authentication failed: invalid username or bad password."
                self.condition.acquire()
                config.set("audioscrobbler","enable","false")
                self.queue = []
                self.condition.release()
                time.sleep(self.interval_time)
            else:
                last_handshake = time.time()
                submission_failures = 0
                while submission_failures < 3:
                    time.sleep(self.interval_time)
                    self.condition.acquire()
                    while not self.queue:
                        self.condition.wait()
                    tmp_queue = self.queue[:10]
                    self.condition.release()
                    try:
                        if self.submit_songs(tmp_queue): 
                            self.condition.acquire()
                            del self.queue[:len(tmp_queue)]
                            self.condition.release()
                    except AudioScrobblerCatastrophicFailure:
                        submission_failures += 1
                    except AudioScrobblerBadAuth:
                        break
                time.sleep(max(self.interval_time, 30*60 + last_handshake - time.time()))
 
    def submit_songs(self, tmp_queue):
        data = {
                        'u': self.username,
                        's': self.password_hash
                }

        for i, (song, stamp) in enumerate(tmp_queue):
            print ("Sending song: %s - %s" % (song.get_str('artist'), song.get_str('title')))
            data["a[%d]" % i] = song.get_str('artist').encode('utf-8')
            data["t[%d]" % i] = song.get_str('title').encode('utf-8')
            data["l[%d]" % i] = str(song.get('#duration')).encode('utf-8')
            data["b[%d]" % i] = song.get_str('album').encode('utf-8')
            data["m[%d]" % i] = ""
            data["i[%d]" % i] = stamp



        (host, file) = self.submit_url[7:].split("/")
        url = "http://" + host + "/" + file
        resp = None
        try:
                data_str = urllib.urlencode(data)
                resp = urllib2.urlopen(url, data_str)
                resp_save = resp.read()
        except Exception,e:
                print "Audioscrobbler server not responding, will try later.",e
                raise AudioScrobblerCatastrophicFailure()

        lines = resp_save.rstrip().split("\n")

        try: (status, interval) = lines
        except:
                try: status = lines[0]
                except:
                        print "Status incorect"
                        return False
        else: self.interval_time = int(interval.split()[1])

        #print "Submission status: %s" % status

        if status == "BADAUTH":
            print "Authentication failed: invalid username or bad password."
            print url
            print data
            raise AudioScrobblerBadAuth()
        
        elif status == "OK":
             print "Submit succesfull"
             return True
         
        elif status.startswith("FAILED"):
            print "FAILED response from server: %s" % status
            print "Dumping full response:"
            print resp_save
        else:
            print "Unknown response from server: %s" % status
            print "Dumping full response:"
            print resp_save
            
        return False
