# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###


import gobject

global helper
helper = None

class Helper(gobject.GObject):
    SIGNAL = (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_PYOBJECT,gobject.TYPE_PYOBJECT))
    SIGNAL_SIMPLE = (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_PYOBJECT,))
    SIGNAL_COMP = (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_PYOBJECT,gobject.TYPE_PYOBJECT,gobject.TYPE_INT))
    SIGNAL_COMP2 = (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_PYOBJECT,gobject.TYPE_PYOBJECT,gobject.TYPE_PYOBJECT))
    __gsignals__ = {
        "pl-add-songs" : SIGNAL,
        "pl-insert-songs" : SIGNAL_COMP,
        "pl-remove-songs" : SIGNAL_COMP2,
        "pl-smart-populate" : SIGNAL,
        "added" : SIGNAL_SIMPLE,
        "deleted" : SIGNAL_SIMPLE,
        "changed" : SIGNAL_SIMPLE,
        "playlist-added" : SIGNAL_SIMPLE,
        "playlist-removed" : SIGNAL_SIMPLE,
        "cur-playlist-enqueue" : SIGNAL_SIMPLE,
        "cur-playlist-play" : SIGNAL_SIMPLE,
        "config-changed" : (gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE,
                (gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_STRING)),
                
        "source-updated" : SIGNAL_SIMPLE,
        "edit-source" : SIGNAL_SIMPLE,
        "edit-playlist" :  SIGNAL_SIMPLE,
        
        "show-wikipedia" :(gobject.SIGNAL_RUN_LAST,  gobject.TYPE_NONE ,(gobject.TYPE_STRING,gobject.TYPE_PYOBJECT,)),
        "show-lyrics" :SIGNAL_SIMPLE,
        "song-report" :SIGNAL_SIMPLE,
        "control-action" : (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_STRING,)),
        "volume" : (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_FLOAT,)),
        "play-device" :  (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_STRING,)),    
        "library-loaded" : SIGNAL_SIMPLE,
        
        
    }
    def __init__(self):
        super(Helper,self).__init__()

    def pl_add_songs(self,pl,songs):
        self.emit("pl-add-songs",pl,songs)
        
    def pl_insert_songs(self,pl,songs,pos):
        self.emit("pl-insert-songs",pl,songs,pos)
        
    def pl_remove_songs(self,pl,songs,pos):
        self.emit("pl-remove-songs",pl,songs,pos)
        
    def pl_smart_populate(self,pl,songs):
        self.emit("pl-smart-populate",pl,songs)
        
    def add_songs(self,songs):
        self.emit("added",songs)

    def change_songs(self,songs):
        self.emit("changed",songs)

    def delete_songs(self,songs):
        self.emit("deleted",songs)
        
    def cur_playlist_enqueue(self,song):
        self.emit("cur-playlist-enqueue",song)
        
    def cur_playlist_play(self,song):
        self.emit("cur-playlist-play",song)
        
    def playlist_added(self,pl):
        self.emit("playlist-added",pl)
        
    def playlist_removed(self,pl):
        self.emit("playlist-removed",pl)
        
    def config_change(self,section,option,value):
        self.emit("config-changed",section,option,value)
        
    def update_source(self):
        self.emit("source-updated",None)
        
    def edit_playlist(self,pl):
        self.emit("edit-playlist",pl)
        
    def edit_source(self):
        self.emit("edit-source",None)
        
    def show_wikipedia(self,type,song):
        self.emit("show-wikipedia",type,song)
        
    def show_lyrics(self,song):
        self.emit("show-lyrics",song)
    
    def control(self,action):
        self.emit("control-action",action)    
        
    def volume(self,value):
        self.emit("volume",value)
        
    def play_device(self,path):
        self.emit("play-device",path)
    """
        emitted when song are considered as really be played
        Respect audioscrobbler desired behavior
    """
    def report_song(self,song):
        self.emit("song-report",song)

    def library_loaded(self,lib):
        self.emit("library-loaded",lib)
helper = Helper()
