# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###


import gtk
import gobject

import utils
import config

from helper import helper

class PlayerControl(gtk.HBox):
    __gsignals__ = {
        "control-action" : (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_STRING,))
    }
    def __init__(self,player):
        super(PlayerControl,self).__init__(False,3)


        def build_btn(label,stock,msg):
            btn = gtk.Button()
            btn.add(gtk.image_new_from_stock(stock, gtk.ICON_SIZE_LARGE_TOOLBAR))
            btn.connect("clicked",lambda w:self.emit("control-action",msg))
            utils.set_tip(btn,label)
            return btn

        self.pack_start(build_btn(_("Previous"),gtk.STOCK_MEDIA_PREVIOUS,"previous"),False,False)
        self.pack_start(build_btn(_("Play"),gtk.STOCK_MEDIA_PLAY,"play"),False,False)
        self.pack_start(build_btn(_("Next"),gtk.STOCK_MEDIA_NEXT,"next"),False,False)

        self.vol = VolumeSlider(player)
        #utils.set_tip(self.vol,_("Volume"))
        self.pack_start(self.vol,False,False)
        self.vol.set_size_request(36,-1)

        if player.video_widget and config.get("player","enable_vis")=="true":
            self.frame_video = gtk.Frame()
            self.frame_video.set_shadow_type(gtk.SHADOW_IN)
            self.pack_start(self.frame_video,True,True)
            self.frame_video.add(player.video_widget)

        player.connect("played",self.swap_btn_play,gtk.STOCK_MEDIA_PAUSE)
        player.connect("paused",self.swap_btn_play,gtk.STOCK_MEDIA_PLAY)

    def swap_btn_play(self,obj,stock):
        btn = self.get_children()[1].child.set_from_stock(stock,gtk.ICON_SIZE_LARGE_TOOLBAR)



class PlayerPlaylistControl(gtk.HBox):
    def __init__(self,playlist):
        super(PlayerPlaylistControl,self).__init__(False,3)

        def build_btn(label,func,stock=None,icon_name=None,type=gtk.Button):
            b = type()
            if stock:
                cont = gtk.image_new_from_stock(stock, gtk.ICON_SIZE_LARGE_TOOLBAR)
            elif icon_name:
                cont = gtk.image_new_from_icon_name(icon_name, gtk.ICON_SIZE_LARGE_TOOLBAR)
            else:
                cont = gtk.Label(label)
                cont.set_alignement(0,0.5)
            b.add(cont)
            b.id_click = b.connect("clicked",func)
            utils.set_tip(b,label)
            b.set_size_request(36,-1)
            b.show_all()
            return b
        
        self.pack_start(build_btn(_("Save playlist"),playlist.save_to_library,stock=gtk.STOCK_SAVE),False,False)
        self.pack_start(build_btn(_("Clear playlist"),playlist.clear,stock=gtk.STOCK_CLEAR),False,False)
        self.pack_start(build_btn(_("Shuffle playlist"),playlist.shuffle,icon_name="stock_shuffle"),False,False)
        self.pack_start(build_btn(_("Repeat playlist mode"),playlist.repeat,icon_name="stock_repeat",type=gtk.ToggleButton),False,False)

        self.btn_repeat = self.get_children()[3]
        if config.getboolean("setting","repeat_mode"):
            self.btn_repeat.set_active(True)
            
        helper.connect("config-changed",self.change_repeat)
        
    def change_repeat(self,helper,section,option,value):
        if section=="setting" and option == "repeat_mode":
            self.btn_repeat.handler_block(self.btn_repeat.id_click)
            self.btn_repeat.set_active(value=="true")
            self.btn_repeat.handler_unblock(self.btn_repeat.id_click)
#########
#Based on quodlibet Copyright 2005 Joe Wreschnig piman[AT]sacredchao[DOT]net
#Change to have a one click control
#########
class PopupSlider(gtk.EventBox):
    # Based on the Rhythmbox volume control button; thanks to Colin Walters,
    # Richard Hult, Michael Fulbright, Miguel de Icaza, and Federico Mena.
    __id_press_signal = None
    timeout = False
    click_timeout = 250
    pop_time = 0L
    def __init__(self, child=None, adj=None, req=None):
        gtk.EventBox.__init__(self)
        self.button = gtk.Button()

        if child: self.button.add(child)
        self.add(self.button)
        self.button.connect('button-press-event', self.__button_press)
        self.show_all()

        window = self.__window = gtk.Window(gtk.WINDOW_POPUP)
        self.__adj = adj or self._adj

        frame = gtk.Frame()
        frame.set_border_width(0)
        frame.set_shadow_type(gtk.SHADOW_OUT)

        btnup = gtk.Button("+")
        btnup.set_relief(gtk.RELIEF_NONE)
        btnup.set_focus_on_click(False)
        btnup.connect("pressed",self.__btn_pressed,+1)
        btnup.connect("released",self.__btn_release)
        btndown = gtk.Button("-")
        btndown.set_relief(gtk.RELIEF_NONE)
        btndown.set_focus_on_click(False)
        btndown.connect("pressed",self.__btn_pressed,-1)
        btndown.connect("released",self.__btn_release)

        self.__req = (req or self._req)
        
        self.scale = self.Scale(self.__adj)
        self.scale.set_size_request(*self.__req)
        self.scale.connect('button-press-event', self.__scale_press)
        self.scale.connect('button-release-event', self.__scale_release)
        self.scale.set_draw_value(False)
        self.scale.set_update_policy(gtk.UPDATE_CONTINUOUS)
        
        window.connect('button-press-event', self.__win_press)
        window.add(frame)

        
        box = self.Box()
        box.pack_start(btnup)
        box.pack_start(self.scale)
        box.pack_start(btndown)
        frame.add(box)
        
        self.connect('scroll-event', self.__scroll, self.scale)
        self.__window.connect('scroll-event', self.__window_scroll)
        btnup.connect_object('scroll-event', self.emit, 'scroll-event')
        btndown.connect_object('scroll-event', self.emit, 'scroll-event')
        box.connect_object('scroll-event', self.emit, 'scroll-event')
        self.scale.connect_object('scroll-event', self.emit, 'scroll-event')
    
    def __btn_release(self,widget):
        try: gobject.source_remove(self.__id_press_signal)
        except:pass
        
    def __btn_pressed(self,widget,sens):
        try: gobject.source_remove(self.__id_press_signal)
        except:pass
        self.__change_vol(sens)
        self.__id_press_signal = gobject.timeout_add(200,self.__change_vol,sens)
            
    def __change_vol(self,sens):
        self.__adj.set_value(self.__adj.get_value()+(sens*self.__adj.get_property("step-increment")))
        return True
    
    def __window_scroll(self, window, event):
        self.emit('scroll-event', event)


    def __button_press(self, button,event):
        if self.__window.get_property('visible'): return
        
        x, y = button.window.get_origin()
        x += button.allocation.x
        y += button.allocation.y
        
        # position roughly 
        self.__window.move(int(x), y - int((self.__req[1])/2) )
        self.__window.show_all()
        dx, dy = self.__window.window.get_origin()
        dy += self.__window.allocation.y
        sx, sy = self.scale.window.get_origin()
        sy += self.scale.allocation.y
        ystartoff = sy - dy
        mouse_y = event.y
        self.timeout = True
        
        min_slider_size = self.scale.style_get_property("slider-length")
        # position (needs widget to be shown already) 
        v = self._adj.get_value() / (self._adj.upper - self._adj.lower)
        x += (button.allocation.width - self.__window.allocation.width)/2
        y -= ystartoff
        y -=  min_slider_size /2
        m = self.scale.allocation.height - min_slider_size
        y -= m * (1.0 -v)
        y += mouse_y
        self.__window.move(int(x),int(y))
        sx, sy = self.scale.window.get_origin()
        
        
        self.__window.grab_focus()
        self.__window.grab_add()
        pointer = gtk.gdk.pointer_grab(
            self.__window.window, True,
            gtk.gdk.BUTTON_PRESS_MASK |
            gtk.gdk.BUTTON_RELEASE_MASK |
            gtk.gdk.BUTTON_MOTION_MASK |
            gtk.gdk.POINTER_MOTION_MASK |
            gtk.gdk.SCROLL_MASK, None, None, gtk.get_current_event_time())
        keyboard = gtk.gdk.keyboard_grab(
            self.__window.window, True, gtk.get_current_event_time())

        """if pointer != gtk.gdk.GRAB_SUCCESS or keyboard != gtk.gdk.GRAB_SUCCESS:
            self.__window.grab_remove()
            self.__window.hide()

            if pointer == gtk.gdk.GRAB_SUCCESS:
                gtk.gdk.pointer_ungrab(gtk.get_current_event_time())
            if keyboard == gtk.gdk.GRAB_SUCCESS:
                gtk.gdk.keyboark_ungrab(gtk.get_current_event_time())
        else:   """ 
        min_slider_size = self.scale.style_get_property("slider-length")
        e = event.copy()
        e.window = self.scale.window
        e.x = float(self.scale.allocation.width / 2.0)
        m = self.scale.allocation.height - min_slider_size
        e.y = float((1.0 - v) * m) + min_slider_size /2
        self.scale.emit("button-press-event",e)
        e.window = event.window
        self.pop_time = event.time

    def __scroll(self, widget, ev, hscale):
        adj = self.__adj
        v = hscale.get_value()
        if ev.direction in self.UP: v += adj.step_increment
        else: v -= adj.step_increment
        v = min(adj.upper, max(adj.lower, v))
        hscale.set_value(v)

    def __win_press(self, widget, ev):
        if ev.type == gtk.gdk.BUTTON_PRESS:
            self.__popup_hide(ev)
            return True
        return False

    def __scale_press(self, hscale, ev):
        self.__window.grab_remove()
        return False
        
    def __scale_release(self, hscale, ev):
        if self.timeout:
            if ev.time > self.pop_time + self.click_timeout:
                self.__popup_hide(ev)
                return False
            self.timeout = False
        self.__window.grab_add()
        return False
        
    def __popup_hide(self,event):
        self.__window.grab_remove()
        gtk.gdk.pointer_ungrab(gtk.get_current_event_time())
        gtk.gdk.keyboard_ungrab(gtk.get_current_event_time())
        self.__window.hide()
        self.timeout = False
        #e = event.copy()
        
        e = gtk.gdk.Event(gtk.gdk.BUTTON_RELEASE)
        e.window = self.button.window
        e.time = event.time
        e.x = event.x
        e.y = event.y
        e.button = event.button
        e.send_event = event.send_event
        e.state = event.state
        e.x_root = event.y_root
        
        self.button.emit("button-release-event",e)
        e.window = event.window

class PopupVSlider(PopupSlider):
    Scale = gtk.VScale
    Box = gtk.VBox
    _req = (-1, 100)
    _adj = gtk.Adjustment(0, 0, 1, 0.05, 0.1, 0)
    UP = [gtk.gdk.SCROLL_UP, gtk.gdk.SCROLL_LEFT]

class VolumeSlider(PopupVSlider):
        def __init__(self,player):
            
            self.player = player
            
            i = gtk.image_new_from_icon_name(
               "stock_volume-max", gtk.ICON_SIZE_LARGE_TOOLBAR)
            PopupVSlider.__init__(self, i)
            self.scale.set_update_policy(gtk.UPDATE_CONTINUOUS)

            self.scale.connect('value-changed', self.__volume_changed,player)
            self.scale.set_inverted(True)
            self.scale.set_range(0,1)
            self.get_value = self.scale.get_value
            self.set_value = self.scale.set_value
            volume = float(config.get("player","volume"))
            self.change_volume(None,volume)
            helper.connect("volume",self.change_volume)
            self.show_all()
            
        def change_volume(self,helper,value):
            self.set_value(value)
            self.__volume_changed(self.scale,self.player)


        def __volume_changed(self, slider,player):
            val = slider.get_value()
            if val > 0.66 : img = "stock_volume-max"
            elif val > 0.33: img = "stock_volume-med"
            elif val > 0: img = "stock_volume-min"
            else: img = "stock_volume-mute"

            self.child.child.set_from_icon_name(img, gtk.ICON_SIZE_LARGE_TOOLBAR)
            val = (2 ** val) - 1
            config.set("player","volume","%f"%val)
            player.volume = val




