# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###






import gtk


class ScrolledWindow(gtk.ScrolledWindow):
    def __init__(self,widget,use_view_port=False,shadow=gtk.SHADOW_IN):
        super(ScrolledWindow,self).__init__()
        self.set_policy(gtk.POLICY_NEVER,gtk.POLICY_AUTOMATIC)
        if use_view_port:
            self.add_with_viewport(widget)
        else:
            self.add(widget)
        self.set_shadow_type(shadow)
        
        
class SimpleVBox(gtk.VBox):
    expand = False
    fill = False
    padding=0
    spacing=0
    homogeneous=False
    border_width = 0
    
    def __init__(self,*args,**kargs):
        for key,value in kargs.iteritems():
            setattr(self,key,value)
            
        super(SimpleVBox,self).__init__(self.homogeneous,self.spacing)
        for w in args:
            self.pack_start(w,self.expand,self.fill,self.padding)
            
        self.set_property("border_width",self.border_width)
        
class SimpleHBox(gtk.HBox):
    expand = False
    fill = False
    padding=0
    spacing=0
    homogeneous=False
    border_width = 0
    
    def __init__(self,*args,**kargs):
        for key,value in kargs.iteritems():
            setattr(self,key,value)
        super(SimpleHBox,self).__init__(self.homogeneous,self.spacing)
        for w in args:
            self.pack_start(w,self.expand,self.fill,self.padding)
        self.set_property("border_width",self.border_width)
            
class Label(gtk.Label):
    use_markup = False
    align =(0,0.5)
    def __init__(self,label,*args,**kargs):
        for key,value in kargs.iteritems():
            setattr(self,key,value)
            
        super(Label,self).__init__(label)
        self.set_alignment(*self.align)
        self.set_use_markup(self.use_markup)
            
            
class SimpleTable(gtk.Table):
    def __init__(self,*args,**kargs):
        super(SimpleTable,self).__init__(*args,**kargs)
        self.index = {}
        
    def pack_start_col(self, n , widget):
        if not self.index.has_key(n):  self.index[n] = 0
        else: self.index[n] += 1
        self.attach( widget, n, n+1, self.index[n], self.index[n]+1 )    
        
        
        