# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###


import gtk

import utils

from widget.timer import SongTimer
from widget.cover import PlayerCoverButton
from widget.control import PlayerControl,PlayerPlaylistControl
from widget.information import PlayInfo
from widget.misc import ScrolledWindow
from widget.player_playlist import PlayerPlaylist
from widget.dynamic_playlist import DynamicPlaylist

class PlayerUI(gtk.VBox):
    def __init__(self,player):
        super(PlayerUI,self).__init__()
        
        self.player = player

        player.connect("play-end",self.control,"next")
        
        
        self.player_control = PlayerControl(player)
        self.player_control.connect("control-action",self.control)
        
        hbox_h = gtk.HBox()
        hbox_h.pack_start(self.player_control,True,True)
        hbox_h.set_spacing(6)

        st = SongTimer(player)
        bbox = gtk.VBox()
        bbox.pack_start(PlayInfo(player),True,True)
        bbox.pack_start(st.get_label(),False,False)
        #bbox.set_spacing(6)
        
        hbox_c = gtk.HBox()
        hbox_c.pack_start(PlayerCoverButton(player),False,False)
        hbox_c.pack_start(bbox,True,True)
        hbox_c.set_spacing(6)
        
        gbox = gtk.VBox()
        gbox.pack_start(hbox_h,False,False)
        gbox.pack_start(hbox_c,False,False)
        gbox.pack_start(st,False,False)
        gbox.set_spacing(6)
        
        self.pack_start(gbox,False,False)
        
        # PLAYLIST 
        self.title_playlist = gtk.Label()
        self.title_playlist.set_markup("<span size=\"large\"><b>"+_("Current playling")+"</b></span>")
        self.title_playlist.set_alignment(0,1)
        
        
        self.playlist = PlayerPlaylist(player)
        self.playlist.connect("playlist-modified",self.playlist_modified)
        
        dynamic_playlist = DynamicPlaylist(self.playlist)
        
        self.playlist_control = PlayerPlaylistControl(self.playlist)
        
        bottom_box = gtk.HBox(False,6)
        bottom_box.pack_start(dynamic_playlist.get_expander(),True,True)
        bottom_box.pack_start(self.playlist_control,False,False)
        
        self.box_playlist = gtk.VBox()
        self.box_playlist.pack_start(self.title_playlist,False,False)
        self.box_playlist.pack_start(ScrolledWindow(self.playlist),True,True)
        self.box_playlist.pack_start(bottom_box,False,False)
        self.box_playlist.pack_start(dynamic_playlist.get_widget(),False,False)
        self.box_playlist.set_spacing(6)
        
        self.pack_start(self.box_playlist,True,True)
        
        self.set_spacing(12)

        self.playlist.load()
        
        
    def playlist_modified(self,playlist):
        markup = "<span size=\"large\"><b>"+_("Now playing")+"</b>"+"</span>"
        markup += " - "
        markup += "<i>("+_("Total time")+" : "+utils.duration_to_string(playlist.total_duration,"00:00")+")</i>"
        self.title_playlist.set_markup(markup)


    def control(self, w, action, player=None):
        if not player : player = self.player
        
        #print "playlist_action",action

        if action in ["play","pause"]:
            if not player.paused:
                player.pause()
            else:
                if not player.is_playable():
                    song = self.playlist.get_next_song()
                    if song!=None:
                        player.play_new(song)
                    else:
                        player.pause()
                elif len(self.playlist.get_model())!=0 or player.is_playable():
                    player.play()
                else:
                    player.pause()
            

        if action == "next":
            song = self.playlist.get_next_song()
            if song!=None:
                player.play_new(song)
            else:
                player.pause()
                if player.song:
                    player.set_song(player.song)
            
            

        if action == "previous":
            song = self.playlist.get_previous_song()
            if song!=None:
                player.play_new(song)
            else:
                player.pause()
                if player.song:
                    player.set_song(player.song)
            
            
        if action == "shuffle":
            self.playlist.shuffle()
            
        if action == "repeat":
            self.playlist.repeat()
        if action == "clear":
            self.playlist.clear()

        #print "playlist_action ok"