# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import gtk,gobject
import stock
import utils
import const
from helper import helper

from widget.progress import action_progress    
from widget.song_editor import SongEditor


class SongMenu(gtk.Menu):
    def __init__(self,pl,play=True,enqueue=True, \
                  delete=True,deletedisk=True, \
                  info=True, edit=True,musicbrainz=True):
        super(SongMenu,self).__init__()
        self.songs = []
        
        self.pl = pl
        
        if play:
            self.insert_item(self.play,stock.PLAY)
        if enqueue:
            self.insert_item(self.enqueue,stock.ENQUEUE)
        if delete:
            self.insert_item(self.delete,stock.DELETE)
        if deletedisk:
            self.append_sep()
            self.insert_item(self.deletedisk,stock.DELETE_DISK)
        if info:
            self.append_sep()
            self.insert_item(self.wiki_artist,stock.WIKI_ARTIST)
            self.insert_item(self.wiki_album,stock.WIKI_ALBUM)
            self.insert_item(self.lyrics,stock.LYRICS)
            
        if edit:
            self.append_sep()
            self.insert_item(self.edit,stock.EDIT)

        self.show_all()
        
    def play(self,w):
        if len(self.songs)>0:
            helper.cur_playlist_play(self.songs)
                
    def enqueue(self,w):
        if len(self.songs)>0: 
            helper.cur_playlist_enqueue(self.songs)
        
    def delete(self,w):
        self.pl.library.delete_songs(self.songs)

    def deletedisk(self,w):
        for song in self.songs:
            if not utils.move_to_trash(song.get("uri")):
                print "Failed to delete ",song.get_path()
        self.pl.library.delete_songs(self.songs)
    
    def wiki_artist(self,w):
        helper.show_wikipedia("artist",self.songs[0])
    
    def wiki_album(self,w):
        helper.show_wikipedia("album",self.songs[0])
    
    def lyrics(self,w):
        helper.show_lyrics(self.songs[0])  
    
    def edit(self,w):
        SongEditor(self.songs)
    
    def popup(self,songs):
        self.songs = songs
        super(SongMenu,self).popup(None,None,None,0,gtk.get_current_event_time())
       
        
    def append_sep(self):
        self.append(gtk.SeparatorMenuItem())
        
    def insert_sep(self,pos):
        self.insert(gtk.SeparatorMenuItem(),pos)
        
        
    def insert_item(self,func,stock,pos=-1):
        item = gtk.ImageMenuItem(stock)
        item.connect("activate",func)
        self.insert(item,pos)
        
    def insert_item_text(self,func,text,pos=-1):
        item = gtk.MenuItem(text)
        item.connect("activate",func)
        self.insert(item,pos)
        
