# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import gtk
import gobject

from helper import helper
import utils
import const
from time import time


class IncorrectFunctionUse(Exception):
    pass

class SongModel(gtk.ListStore):
    def __init__(self,treeview,*types):
        if len(types)>0:
            super(SongModel,self).__init__(object,*types)
        else:
            super(SongModel,self).__init__()
        self.__column_tags = ()
        self.__sig = None
        
        self.tree = treeview
        
        self.sort_by_func = None
        self.__sort_by_param = None
        
        self.songs_cache = []
        
        self.pending_events = []
    
    def set_get_sort_by_func(self,func,*param):
        self.sort_by_func = func
        self.__sort_by_param = param
        
    def set_column_type(self,*types):
        super(SongModel,self).set_column_type(object,*types)
        
    def set_column_tags(self,*tags):    
        self.__column_tags = tags
    
    def get_tuple(self,song):
        tuple = song,
        i = 1
        for tag in self.__column_tags:
            if self.get_column_type(i) == gobject.TYPE_STRING:
                t = song.get_str(tag),
            else:
                t = song.get(tag),
            tuple = tuple + t
            i += 1
        return tuple
    
    """""""""""""""""""""""""""
        FUNC ACTION
    """""""""""""""""""""""""""
    def stop_fill(self):
        self.clear()
        if self.__sig!=None : gobject.source_remove(self.__sig)

    def fill(self,songs):
        self.songs_cache = songs
        if self.sort_by_func:
            self.set_songs(songs)
        else:
            if self.__sig!=None : gobject.source_remove(self.__sig)
            self.tree.set_model(None)
            self.clear()
            songs = [self.get_tuple(song) for song in songs]
            self.__sig = gobject.idle_add(self.__idle_add,songs)

    def __idle_add(self,songs_to_add):
        if self.__sig!=None : gobject.source_remove(self.__sig)
        for song_tuple in songs_to_add[:const.SONG_POPULATE]: self.append(song_tuple)
        if len(songs_to_add[const.SONG_POPULATE:])>0: self.__sig = gobject.idle_add(self.__idle_add,songs_to_add[100:])
        else: self.tree.set_model(self)    
            
    def get_sort_by(self):
        if self.sort_by_func:
            return self.sort_by_func(*self.__sort_by_param)
        else:
            return None,None
    
    def set_songs(self, songs=None):
        #print "set_songs()"     
        if not songs : songs = self.songs_cache
        tag, reverse = self.get_sort_by()
        if tag: 
            songs = [(song.get_sortable(tag), song.sort_key, song) for song in songs]
            
        songs.sort()
        if reverse: songs.reverse()
        
        if tag: 
            songs = [self.get_tuple(song[2]) for song in songs]
        else:
            songs = [self.get_tuple(song) for song in songs]

        if self.__sig!=None : gobject.source_remove(self.__sig)
        #self.get_toplevel().window.set_cursor(gtk.gdk.Cursor(gtk.gdk.WATCH))
        super(SongModel,self).clear()
        self.__sig = gobject.idle_add(self.__idle_add,songs)
        
    def remove_songs(self,helper,songs):
        iter_to_delete =[]    
        def find_iter(model, path, iter,songs):
            if model[iter][0] in songs:
                iter_to_delete.append(iter)
            
        self.foreach(find_iter,songs)
        iter_to_delete.reverse()
        for iter in iter_to_delete:
            del self[iter]
            
        self.songs_cache = filter(lambda s: s not in songs,self.songs_cache)
            
    
    def change_songs(self,helper,songs):
        self.tree.set_model(None)    
        #if not self.sort_by_func:   
        def update(model, path, iter,songs):
            if model[path][0] in songs:
                model[path] = self.get_tuple(songs[songs.index(model[iter][0])])
        self.foreach(update,songs)     
        
        def update(s):
            if s in songs:
                return songs[songs.index(s)]
            else:
                return s
        self.songs_cache = map(update,self.songs_cache)
         
        """else:
            self.remove_songs(None,songs)
            self.append_songs(songs)"""
        self.tree.set_model(self)
        
    def insert_songs(self,pos,songs):
        if not self.sort_by_func:
            for song in songs:    
                self.songs_cache.insert(pos,song)
                self.insert(pos,self.get_tuple(song))
                pos += 1
        else:
            raise IncorrectFunctionUse
        
        
    def append_songs(self,songs):
        if not self.sort_by_func:
            self.songs_cache.extend(songs)        
            for song in songs:
                self.append(self.get_tuple(song))
        else:
            tag, reverse = self.get_sort_by()
            songs = [(song.get_sortable(tag),song.sort_key,song) for song in songs]
            songs.sort()
            if reverse: songs.reverse()
            self.deb = time()
            self.pending_events.append(gobject.idle_add(self.idle_append_songs,tag,songs,reverse))
            
    def clear(self):
        self.songs_cache = []
        for event in self.pending_events:
            try: gobject.source_remove(event)
            except: pass
            
        #self.tree.set_model(None)
        super(SongModel,self).clear()
        #self.tree.set_model(self)
        
    #@utils.profiling
    def idle_append_songs(self,tag,songs,reverse,index = 0):
        #self.tree.set_model(None)    
        for cur_song in songs[:const.SONG_POPULATE]:
            cur_song_info = (cur_song[0],cur_song[1])
            self.songs_cache.append(cur_song[2])
            
            if len(self)==0:
                self.append(self.get_tuple(cur_song[2]))
            else:
                while True:
                    if index>=len(self):
                        self.append(self.get_tuple(cur_song[2]))      
                        break                      
                    else:    
                        cur_model_song = (self[index][0].get_sortable(tag),self[index][0].sort_key)
                        #print cur_song_info == cur_model_song
                        if cur_song_info == cur_model_song:
                            #Song already in the treeview
                            break
                        elif not reverse and cur_song_info < cur_model_song: 
                            self.insert(index,self.get_tuple(cur_song[2]))
                            break
                        elif reverse and cur_song_info > cur_model_song: 
                            self.insert(index,self.get_tuple(cur_song[2]))
                        index += 1
        if len(songs[const.SONG_POPULATE:])>0:
            self.pending_events.append(gobject.idle_add(self.idle_append_songs,tag,songs[const.SONG_POPULATE:],reverse,index))
        else:
            pass
            #self.tree.set_model(self)    
            #print "Fill in ",time() - self.deb
            
    
