# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###


import gtk
import gobject

import config
import stock
import utils
import const

from helper import helper

class TrayIcon(gobject.GObject):
    __gsignals__ = {
        "control-action" : (gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE, (gobject.TYPE_STRING,))
    }
    def __init__(self,window,player):
        super(TrayIcon,self).__init__()

        self.win = window
        player.connect("played",self.on_play)
        player.connect("paused",self.on_pause)

        self.eventbox = gtk.EventBox()
        try: import egg.trayicon
        except: self.tray=None
        else:
            self.tray = egg.trayicon.TrayIcon("Listen")
            self.tray.add(self.eventbox)


        self.eventbox.connect("button_press_event", self.on_button_press_event )
        self.eventbox.connect("scroll-event",self.on_scroll_event)
        
        self.tray_image = gtk.Image()
        self.tray_image.set_from_file(const.PIXMAP_DIR+"/listen_tray.png")
        self.eventbox.add(self.tray_image)
        
        menu_ui = """
        <ui>
            <popup name="TrayIconMenu">
              <menuitem name="play" action="play"/>
              <menuitem name="pause" action="pause"/>
              <menuitem name="next" action="next"/>
              <menuitem name="previous" action="previous"/>
              <separator/>
              <menuitem name="quit" action="quit"/>
            </popup>
        </ui>
        """
        self.uimanager = gtk.UIManager()
        self.uimanager.add_ui_from_string(menu_ui)
        accelgroup = self.uimanager.get_accel_group()

        actiongroup = gtk.ActionGroup('Listen')
        actiongroup.add_actions([('play', gtk.STOCK_MEDIA_PLAY, _('_Play'), None, _('Play'), lambda w:self.emit("control-action",w.get_name())),
                                 ('pause', gtk.STOCK_MEDIA_PAUSE, _('_Pause'), None, _('Pause'), lambda w:self.emit("control-action",w.get_name())),
                                 ('next', gtk.STOCK_MEDIA_NEXT, _('_Next'), None, _('Next'), lambda w:self.emit("control-action",w.get_name())),
                                 ('previous', gtk.STOCK_MEDIA_PREVIOUS, _('_Previous'), None, _('Previous'),lambda w:self.emit("control-action",w.get_name())),
                                 ('quit', gtk.STOCK_QUIT, _('_Quit'), None, _('Quit Listen'), lambda w:self.emit("control-action",w.get_name()))])

        self.uimanager.insert_action_group(actiongroup, 1)
        #self.add_accel_group(accelgroup)
        self.pause = self.uimanager.get_action("/TrayIconMenu/pause")
        self.pause.set_visible(False)
        self.play =  self.uimanager.get_action("/TrayIconMenu/play")
        self.menu = self.uimanager.get_widget("/TrayIconMenu")
        self.menu.connect("selection-done",self.on_selection_done)
        self.show_menu=False
        
        
        
        gtk.quit_add(0,self.cacher)


    def on_delete(self,win,event):
        pass

    def update_tooltips(self):
        if config.get("osd","enable")=="false":
            s = self.win.player_ui.player.song
            if s:
                text = ""            
                text += s.get_str("title")
                if s.get("artist"):
                    text += " - "+s.get("artist")
                text += "\n"
                if self.win.player_ui.player.paused:
                    text += _("Paused")+", "
                value = self.win.player_ui.player.get_position()
                text += utils.duration_to_string(value,"00:00")+" "+_("of")+" "+utils.duration_to_string(s.get("#duration"),"00:00")
            else:
                text = _("No Playing")
        else:
            text = None
        utils.set_tip(self.eventbox,text)
        return True

    def on_scroll_event(self,widget,event):
        self.win.player_ui.player_control.vol.emit("scroll-event",event)

    def on_selection_done(self,widget):
        self.show_menu=False

    def on_pause(self,player):
        self.pause.set_visible(False)
        self.play.set_visible(True)

    def on_play(self,player):
        self.pause.set_visible(True)
        self.play.set_visible(False)
        
    def position_menu(self,menu):
        #Grab from deskbar applet
        align_to = self.eventbox
        direction = self.eventbox.get_direction()

        screen = menu.get_screen()
        monitor_num = screen.get_monitor_at_window(align_to.window)
        if monitor_num < 0:
                monitor_num = 0

        monitor = screen.get_monitor_geometry (monitor_num)
        menu.set_monitor (monitor_num)

        tx, ty = align_to.window.get_origin()
        twidth, theight = menu.get_child_requisition()

        tx += align_to.allocation.x
        ty += align_to.allocation.y
        if direction == gtk.TEXT_DIR_RTL:
                tx += align_to.allocation.width - twidth

        if (ty + align_to.allocation.height + theight) <= monitor.y + monitor.height:
                ty += align_to.allocation.height
        elif (ty - theight) >= monitor.y:
                ty -= theight
        elif monitor.y + monitor.height - (ty + align_to.allocation.height) > ty:
                ty += align_to.allocation.height
        else:
                ty -= theight

        if tx < monitor.x:
                x = monitor.x
        elif tx > max(monitor.x, monitor.x + monitor.width - twidth):
                x = max(monitor.x, monitor.x + monitor.width - twidth)
        else:
                x = tx
        y = ty

        return (x, y, False)

    def on_button_press_event(self , widget, event):
        if event.button == 1:
            if event.state == gtk.gdk.CONTROL_MASK:
                helper.control("previous")
            else:
                if self.win.get_property('visible'):
                    if self.win.is_active():
                        self.cacher()
                    else:
                        self.win.present()
                else:
                    self.montrer()

        elif event.button == 2:
            helper.control("play")

        elif event.button == 3:
            if event.state == gtk.gdk.CONTROL_MASK:
                helper.control("next")
            else:
                self.show_menu=True
                #self.player.osd.hide_osd(None,None)
                self.menu.popup(None,None,self.position_menu,event.button,event.time)


    def cacher(self):
        if self.win.window:
            event = self.win.window.get_state()
            if event == gtk.gdk.WINDOW_STATE_MAXIMIZED:
                config.set("window","state","maximized")
            else:
                config.set("window","state","normal")
            self.win.hide_all()

    def montrer(self):
        self.win.move(int(config.get("window","x")),int(config.get("window","y")))
        window_state = config.get("window","state")
        if window_state == "maximized" :
            self.win.maximize()
        if window_state == "normal":
            self.win.unmaximize()
        self.win.show_all()

