/*==============================================================================

FICHIER     : [dvdtools.h]

DATE        : 2005/12/0001 22:05:05

CREATEUR    : [Linux!jef]

COMMENTAIRE :

================================================================================

==============================================================================*/

#ifndef __DVDTOOLS_H__
#define __DVDTOOLS_H__

#	include <dvdread/dvd_reader.h>
#	include <dvdread/ifo_read.h>
#	include <dvdread/ifo_print.h>
#	include <dvdread/nav_read.h>

#define 	stAudio		0
#define		stVideo		1
#define		stSubpicture	2
#define 	stOther		3

#define MAX_PGCS	100
typedef struct {
	int vts;
	ifo_handle_t *	ifo;
	vtsi_mat_t *	vtsi_mat;
	pgcit_t *	vts_pgcit;
	int		nrPgc;
	pgc_t *		pgcs[MAX_PGCS];
	unsigned long	duree;
	int		sectors;
	int		nrSubp;
} Piste_t;

/*@$#[dvdtools.c] global proto. AutoProtoSigV1.1. date: 106/01/18 22:49:40 */
#include "proto.h"
#ifdef __cplusplus
extern "C" {
#endif
int MilliSeconde PROTO((dvd_time_t *dt));
int isNavPack PROTO((unsigned char *_ptr));
int IdentifyStream PROTO((unsigned char *buffer, int *packetType));
int GetStreamID PROTO((int type));
pgc_t * GetPgc PROTO(( int noPisteVideo ));
char * BuildChapitreString( int noPisteVideo );
void SavePalette( int noPisteVideo, char * pFile );
char * AudioLang( int noPisteVideo, int noPisteAudio );
char * SubLang( int noPisteVideo, int noSubtitle );
char * AudioFormat( int noPisteVideo, int noPisteAudio );
ssize_t MyDVDReadBlocks( dvd_file_t * dvdFile, int noSect, size_t nbSect, unsigned char * buffer );
Piste_t * GetPiste( int noPisteVideo );
void RazPistes();

#ifdef __cplusplus
}
#endif
/*@$% end of AutoProtoSigV1.1 (Dont remove this line) [-I ../include]*/
#endif	/* __DVDTOOLS_H__ */

