<?php
/**
 * Kazakh (قازاقشا)
 *
 * @package MediaWiki
 * @subpackage Language
 *
 */

$fallback = 'kk-kz';

$rtl = true;

$digitTransformTable = array(
	"0" => "۰",
	"1" => "۱",
	"2" => "۲",
	"3" => "۳",
	"4" => "۴",
	"5" => "۵",
	"6" => "۶",
	"7" => "۷",
	"8" => "۸",
	"9" => "۹",
	"%" => "٪",
);

$separatorTransformTable = array(
	"," => "٬",
	"." => "٫", // wrong table?
);

$defaultUserOptionOverrides = array(
	# Swap sidebar to right side by default
	'quickbar' => 2,
	# Underlines seriously harm legibility. Force off:
	'underline' => 0,
);

$extraUserToggles = array(
	'nolangconversion'
);

$fallback8bitEncoding = 'windows-1256';

$linkPrefixExtension = true;

$namespaceNames = array(
	NS_MEDIA            => 'تاسپا',
	NS_SPECIAL          => 'ارنايى',
	# NS_MAIN	            => '',
	NS_TALK	            => 'تالقىلاۋ',
	NS_USER             => 'قاتىسۋشى',
	NS_USER_TALK        => 'قاتىسۋشى_تالقىلاۋى',
	# NS_PROJECT set by $wgMetaNamespace
	NS_PROJECT_TALK     => '$1_تالقىلاۋى',
	NS_IMAGE            => 'سۋرەت',
	NS_IMAGE_TALK       => 'سۋرەت_تالقىلاۋى',
	NS_MEDIAWIKI        => 'مەدياۋيكي',
	NS_MEDIAWIKI_TALK   => 'مەدياۋيكي_تالقىلاۋى',
	NS_TEMPLATE         => 'ٴۇلگٴى',
	NS_TEMPLATE_TALK    => 'ٴۇلگٴى_تالقىلاۋى',
	NS_HELP             => 'انىقتاما',
	NS_HELP_TALK        => 'انىقتاما_تالقىلاۋى',
	NS_CATEGORY         => 'سانات',
	NS_CATEGORY_TALK    => 'سانات_تالقىلاۋى'
);

$namespaceAliases = array(
	# Aliases to kk-kz namespaces
	'Таспа'               => NS_MEDIA,
	'Арнайы'              => NS_SPECIAL,
	'Талқылау'            => NS_TALK,
	'Қатысушы'            => NS_USER,
	'Қатысушы_талқылауы'  => NS_USER_TALK,
	'$1_талқылауы'        => NS_PROJECT_TALK,
	'Сурет'               => NS_IMAGE,
	'Сурет_талқылауы'     => NS_IMAGE_TALK,
	'МедиаУики'           => NS_MEDIAWIKI,
	'МедиаУики_талқылауы' => NS_MEDIAWIKI_TALK,
	'Үлгі'                => NS_TEMPLATE,
	'Үлгі_талқылауы'      => NS_TEMPLATE_TALK,
	'Анықтама'            => NS_HELP,
	'Анықтама_талқылауы'  => NS_HELP_TALK,
	'Санат'               => NS_CATEGORY,
	'Санат_талқылауы'     => NS_CATEGORY_TALK,
	# Aliases to kk-tr namespaces
	'Taspa'               => NS_MEDIA,
	'Arnaýı'              => NS_SPECIAL,
	'Talqılaw'            => NS_TALK,
	'Qatıswşı'            => NS_USER,
	'Qatıswşı_talqılawı'  => NS_USER_TALK,
	'$1_talqılawı'        => NS_PROJECT_TALK,
	'Swret'               => NS_IMAGE,
	'Swret_talqılawı'     => NS_IMAGE_TALK,
	'MedïaWïkï'           => NS_MEDIAWIKI,
	'MedïaWïkï_talqılawı' => NS_MEDIAWIKI_TALK,
	'Ülgi'                => NS_TEMPLATE,
	'Ülgi_talqılawı'      => NS_TEMPLATE_TALK,
	'Anıqtama'            => NS_HELP,
	'Anıqtama_talqılawı'  => NS_HELP_TALK,
	'Sanat'               => NS_CATEGORY,
	'Sanat_talqılawı'     => NS_CATEGORY_TALK,
);

$quickbarSettings = array(
	'ەشقانداي', 'سولعا بەكٴىتٴىلگەن', 'وڭعا بەكٴىتٴىلگەن', 'سولعا قالقىعان', 'وڭعا قالقىعان'
);

$skinNames = array(
	'standard'    => 'داعدىلى',
	'nostalgia'   => 'اڭساۋ',
	'cologneblue' => 'كٴولن زەڭگٴىرلٴىگٴى',
	'davinci'     => 'دا ۆينچي',
	'mono'        => 'دارا',
	'monobook'    => 'دارا كٴىتاپ',
	'myskin'      => 'ٴوز مٴانەرٴىم',
	'chick'       => 'بالاپان',
	'simple'      => 'كٴادٴىمگٴى'
);

$defaultDateFormat = 'ymd';

$dateFormats = array(
	'mdy time' => 'H:i',
	'mdy date' => 'xg j, Y',
	'mdy both' => 'H:i, xg j, Y',

	'dmy time' => 'H:i',
	'dmy date' => 'j F, Y',
	'dmy both' => 'H:i, j F, Y',

	'ymd time' => 'H:i',
	'ymd date' => 'Y" ج" xg j',
	'ymd both' => 'H:i, Y" ج" xg j',

	'ISO 8601 time' => 'xnH:xni:xns',
	'ISO 8601 date' => 'xnY-xnm-xnd',
	'ISO 8601 both' => 'xnY-xnm-xnd"T"xnH:xni:xns',
);


#-------------------------------------------------------------------
# Default messages
#-------------------------------------------------------------------

$messages = array(
# User preference toggles
'tog-underline'               => 'سٴىلتەمەنٴى استىنان سىز:',
'tog-highlightbroken'         => 'جوقتالعان سٴىلتەمەلەردٴى <a href="" class="new">بىلاي</a> پٴىشٴىمدە (باسقاشا: بىلاي <a href="" class="internal">?</a> سيياقتى).',
'tog-justify'                 => 'ەجەلەردٴى ەنٴى بويىنشا تۋرالاۋ',
'tog-hideminor'               => 'جۋىقتاعى ٴوزگەرٴىستەردە شاعىن تٴۇزەتۋدٴى جاسىر',
'tog-extendwatchlist'         => 'باقىلاۋ تٴىزٴىمدٴى ۇلعايت (بارلىق جارامدى ٴوزگەرٴىستەردٴى كٴورسەت)',
'tog-usenewrc'                => 'كەڭەيتٴىلگەن جۋىقتاعى ٴوزگەرٴىستەر (JavaScript)',
'tog-numberheadings'          => 'بٴولٴىم تاقىرىپتارىن ٴوزدٴىك تٴۇردە نومٴىرلە',
'tog-showtoolbar'             => 'ٴوڭدەۋ قۋرالدار جولاعىن كٴورسەت (JavaScript)',
'tog-editondblclick'          => 'قوس نۇقىمداپ ٴوڭدەۋ (JavaScript)',
'tog-editsection'             => 'بٴولٴىمدەردٴى [ٴوڭدەۋ] سٴىلتەمەسٴىمەن ٴوڭدەۋٴىن ەندٴىر',
'tog-editsectiononrightclick' => 'بٴولٴىم اتاۋىن وڭ جاق نۇقۋمەن<br />ٴوڭدەۋٴىن ەندٴىر (JavaScript)',
'tog-showtoc'                 => 'مازمۇنىن كٴورسەت (3-تەن ارتىق بٴولٴىمٴى بارىلارعا)',
'tog-rememberpassword'        => 'كٴىرگەنٴىمدٴى بۇل كومپييۋتەردە ۇمىتپا',
'tog-editwidth'               => 'ٴوڭدەۋ اۋماعى تولىق ەنٴىمەن',
'tog-watchcreations'          => 'مەن باستاعان بەتتەردٴى باقىلاۋ تٴىزٴىمٴىمە قوس',
'tog-watchdefault'            => 'مەن ٴوڭدەگەن بەتتەردٴى باقىلاۋ تٴىزٴىمٴىمە قوس',
'tog-minordefault'            => 'بارلىق تٴۇزەتۋلەردٴى ٴادەپكٴىدەن شاعىن دەپ بەلگٴىلە',
'tog-previewontop'            => 'قاراپ شىعۋدى ٴوڭدەۋ اۋماعىنىڭ ٴۇستٴىنە سال',
'tog-previewonfirst'          => 'بٴىرٴىنشٴى ٴوڭدەگەندە قاراپ شىعۋ',
'tog-nocache'                 => 'بەت قوسالقى قالتاسىن ٴوشٴىر',
'tog-enotifwatchlistpages'    => 'باقىلانعان بەت ٴوزگەرگەندە ماعان حات جٴىبەر',
'tog-enotifusertalkpages'     => 'تالقىلاۋىم ٴوزگەرگەندە ماعان حات جٴىبەر',
'tog-enotifminoredits'        => 'شاعىن تٴۇزەتۋ تۋرالى دا ماعان حات جٴىبەر',
'tog-enotifrevealaddr'        => 'ە-پوشتا جايىمدى ەسكەرتۋ حاتتا اشىق كٴورسەت',
'tog-shownumberswatching'     => 'باقىلاپ تۇرعان قاتىسۋشىلاردىڭ سانىن كٴورسەت',
'tog-fancysig'                => 'قام قولتاڭبا (ٴوزدٴىك سٴىلتەمەسٴىز;)',
'tog-externaleditor'          => 'سىرتقى ٴوڭدەۋٴىشتٴى ٴادەپكٴىدەن قولدان',
'tog-externaldiff'            => 'سىرتقى ايىرماعىشتى ٴادەپكٴىدەن قولدان',
'tog-showjumplinks'           => '«ٴوتٴىپ كەتۋ» قاتىناۋ سٴىلتەمەلەرٴىن ەندٴىر',
'tog-uselivepreview'          => 'تۋرا قاراپ شىعۋدى قولدانۋ (JavaScript) (سىناق تٴۇرٴىندە)',
'tog-autopatrol'              => 'تٴۇزەتۋٴىمدٴى كٴۇزەتكە بەلگٴىلە',
'tog-forceeditsummary'        => 'ٴوڭدەۋ سيپاتتاماسى بوس قالعاندا ماعان ەسكەرت',
'tog-watchlisthideown'        => 'تٴۇزەتۋٴىمدٴى باقىلاۋ تٴىزٴىمنەن جاسىر',
'tog-watchlisthidebots'       => 'بوت تٴۇزەتۋٴىن باقىلاۋ تٴىزٴىمنەن جاسىر',
'tog-nolangconversion'        => 'تٴىل تٴۇرٴىن اۋدارماۋ',

'underline-always'  => 'ٴارقاشان',
'underline-never'   => 'ەشقاشان',
'underline-default' => 'شولعىش بويىنشا',

'skinpreview' => '(قاراپ شىعۋ)',

# Dates
'sunday'        => 'جەكسەنبٴى',
'monday'        => 'دٴۇيسەنبٴى',
'tuesday'       => 'سەيسەنبٴى',
'wednesday'     => 'سٴارسەنبٴى',
'thursday'      => 'بەيسەنبٴى',
'friday'        => 'جۇما',
'saturday'      => 'سەنبٴى',
'sun'           => 'جەك',
'mon'           => 'دٴۇي',
'tue'           => 'بەي',
'wed'           => 'سٴار',
'thu'           => 'بەي',
'fri'           => 'جۇم',
'sat'           => 'سەن',
'january'       => 'قاڭتار',
'february'      => 'اقپان',
'march'         => 'ناۋرىز',
'april'         => 'cٴاۋٴىر',
'may_long'      => 'مامىر',
'june'          => 'ماۋسىم',
'july'          => 'شٴىلدە',
'august'        => 'تامىز',
'september'     => 'قىركٴۇيەك',
'october'       => 'قازان',
'november'      => 'قاراشا',
'december'      => 'جەلتوقسان',
'january-gen'   => 'قانتاردىڭ',
'february-gen'  => 'اقپاننىڭ',
'march-gen'     => 'ناۋرىزدىڭ',
'april-gen'     => 'سٴاۋٴىردٴىڭ',
'may-gen'       => 'مامىردىڭ',
'june-gen'      => 'ماۋسىمنىڭ',
'july-gen'      => 'شٴىلدەنٴىڭ',
'august-gen'    => 'تامىزدىڭ',
'september-gen' => 'قىركٴۇيەكتٴىڭ',
'october-gen'   => 'قازاننىڭ',
'november-gen'  => 'قاراشانىڭ',
'december-gen'  => 'جەلتوقساننىڭ',
'jan'           => 'قان',
'feb'           => 'اقپ',
'mar'           => 'ناۋ',
'apr'           => 'cٴاۋ',
'may'           => 'مام',
'jun'           => 'ماۋ',
'jul'           => 'شٴىل',
'aug'           => 'تام',
'sep'           => 'قىر',
'oct'           => 'قاز',
'nov'           => 'قار',
'dec'           => 'جەل',

# Bits of text used by many pages
'categories'            => 'بارلىق سانات تٴىزٴىمٴى',
'pagecategories'        => '{{PLURAL:$1|سانات|ساناتتار}}',
'category_header'       => '«$1» ساناتىنداعى بەتتەر',
'subcategories'         => 'تٴومەنگٴى ساناتتار',
'category-media-header' => '«$1» ساناتىنداعى تاسپالار',

'linkprefix'        => '/^(.*?)([a-zäçéğıïñöşüýа-яёәіңғүұқөһA-ZÄÇÉĞİÏÑÖŞÜÝА-ЯЁӘІҢҒҮҰҚӨҺʺʹ«„]+)$/sDu',
'mainpage'          => 'باستى بەت',
'mainpagetext'      => "<big>'''مەدياۋيكي باعدارلاماسى سٴاتتٴى ورناتىلدى.'''</big>",
'mainpagedocfooter' => 'ۋيكي باعدارلاماسىن پايدالانۋ اقپاراتى ٴۇشٴىن [http://meta.wikimedia.org/wiki/Help:Contents پايدالانۋشى نۇسقاۋلارىمەن] تانىسىڭىز.

== باستاۋ ==

* [http://www.mediawiki.org/wiki/Help:Configuration_settings باپتاۋ قالاۋلارى تٴىزٴىمٴى]
* [http://www.mediawiki.org/wiki/Help:FAQ مەدياۋيكي جسج]
* [http://mail.wikimedia.org/mailman/listinfo/mediawiki-announce مەدياۋيكي حات تاراتۋ تٴىزٴىمٴى]',

'portal'          => 'قاۋىم پورتالى',
'portal-url'      => '{{ns:project}}:قاۋىم_پورتالى',
'about'           => 'بٴىز تۋرالى',
'aboutsite'       => '{{SITENAME}} تۋرالى',
'aboutpage'       => '{{ns:project}}:بٴىز_تۋرالى',
'article'         => 'ماعلۇمات',
'help'            => 'انىقتاما',
'helppage'        => '{{ns:help}}:مازمۇنى',
'bugreports'      => 'قاتە ەسەپتەمەلەرٴى',
'bugreportspage'  => '{{ns:project}}:قاتە_ەسەپتەمەلەرٴى',
'sitesupport'     => 'دەمەۋشٴىلٴىك',
'sitesupport-url' => '{{ns:project}}:جٴاردەم',
'faq'             => 'جسج',
'faqpage'         => '{{ns:project}}:جسج',
'edithelp'        => 'ٴوندەۋ انىقتاماسى',
'newwindow'       => '(جاڭا تەرەزەدە اشىلادى)',
'edithelppage'    => '{{ns:help}}:ٴوڭدەۋ',
'cancel'          => 'بولدىرماۋ',
'qbfind'          => 'تابۋ',
'qbbrowse'        => 'شولۋ',
'qbedit'          => 'ٴوڭدەۋ',
'qbpageoptions'   => 'وسى بەت',
'qbpageinfo'      => 'مٴاتٴىن ارالىعى',
'qbmyoptions'     => 'بەتتەرٴىم',
'qbspecialpages'  => 'ارنايى بەتتەر',
'moredotdotdot'   => 'كٴوبٴىرەك…',
'mypage'          => 'جەكە بەتٴىم',
'mytalk'          => 'تالقىلاۋىم',
'anontalk'        => 'IP تالقىلاۋى',
'navigation'      => 'باعىتتاۋ',

# Metadata in edit box
'metadata_help' => 'مەتا-دەرەكتەر (تٴۇسٴىندٴىرمەلەر ٴۇشٴىن [[{{ns:project}}:مەتا-دەرەكتەر]] بەتٴىن قاراڭىز):',

'currentevents'     => 'اعىمداعى وقيعالار',
'currentevents-url' => 'اعىمداعى_وقيعالار',

'disclaimers'       => 'جاۋاپكەرشٴىلٴىكتەن باس تارتۋ',
'disclaimerpage'    => '{{ns:project}}:جاۋاپكەرشٴىلٴىكتەن_باس_تارتۋ',
'privacy'           => 'جەكە قۇپيياسىن ساقتاۋ',
'privacypage'       => '{{ns:project}}:جەكە_قۇپيياسىن_ساقتاۋ',
'errorpagetitle'    => 'قاتە',
'returnto'          => '$1 دەگەنگە ورالۋ.',
'tagline'           => '{{GRAMMAR:ablative|{{SITENAME}}}}',
'search'            => 'ٴىزدەۋ',
'searchbutton'      => 'ٴىزدەۋ',
'go'                => 'ٴوتۋ',
'searcharticle'     => 'ٴوتۋ',
'history'           => 'بەت تاريحى',
'history_short'     => 'تاريحى',
'updatedmarker'     => 'سوڭعى كٴىرگەننەن بەرٴى جاڭارتىلعان',
'info_short'        => 'اقپارات',
'printableversion'  => 'باسىپ شىعارۋعا',
'permalink'         => 'تۇراقتى سٴىلتەمە',
'print'             => 'باسىپ شىعارۋ',
'edit'              => 'ٴوڭدەۋ',
'editthispage'      => 'بەتتٴى ٴوڭدەۋ',
'delete'            => 'جويۋ',
'deletethispage'    => 'بەتتٴى جويۋ',
'undelete_short'    => '{{PLURAL:$1|بٴىر|$1}} تٴۇزەتۋدٴى قايتارۋ',
'protect'           => 'قورعاۋ',
'protectthispage'   => 'بەتتٴى قورعاۋ',
'unprotect'         => 'قورعاماۋ',
'unprotectthispage' => 'بەتتٴى قورعاماۋ',
'newpage'           => 'جاڭا بەت',
'talkpage'          => 'بەتتٴى تالقىلاۋ',
'specialpage'       => 'ارنايى بەت',
'personaltools'     => 'جەكە قۇرالدار',
'postcomment'       => 'مٴاندەمە جٴىبەرۋ',
'articlepage'       => 'ماعلۇمات بەتٴىن قاراۋ',
'talk'              => 'تالقىلاۋ',
'views'             => 'كٴورٴىنٴىس',
'toolbox'           => 'قۇرالدار',
'userpage'          => 'قاتىسۋشىنىڭ بەتٴىن قاراۋ',
'projectpage'       => 'جوبا بەتٴىن قاراۋ',
'imagepage'         => 'سۋرەت بەتٴىن قاراۋ',
'mediawikipage'     => 'حابار بەتٴىن قاراۋ',
'templatepage'      => 'ٴۇلگٴى بەتٴىن قاراۋ',
'viewhelppage'      => 'انىقتاما بەتٴىن قاراۋ',
'categorypage'      => 'سانات بەتٴىن قاراۋ',
'viewtalkpage'      => 'تالقىلاۋ بەتٴىن قاراۋ',
'otherlanguages'    => 'باسقا تٴىلدەردە',
'redirectedfrom'    => '($1 بەتٴىنەن ايداتىلعان)',
'redirectpagesub'   => 'ايداتۋ بەتٴى',
'lastmodifiedat'    => 'بۇل بەتتٴىڭ ٴوزگەرتٴىلگەن سوڭعى كەزٴى: $2, $1.', # $1 date, $2 time
'viewcount'         => 'بۇل بەت {{plural:$1|بٴىر|$1}} رەت قارالعان.',
'copyright'         => 'ماعلۇمات $1 قۇجاتى بويىنشا قاتىناۋلى.',
'protectedpage'     => 'قورعاۋلى بەت',
'jumpto'            => 'مىناعان ٴوتٴىپ كەتۋ:',
'jumptonavigation'  => 'باعىتتاۋ',
'jumptosearch'      => 'ٴىزدەۋ',

'badaccess'        => 'رۇقسات قاتەسٴى',
'badaccess-group0' => 'سۇرانىسقان ٴارەكەتٴىڭٴىزدٴى جەگۋٴىڭٴىزگە رۇقسات ەتٴىلمەيدٴى.',
'badaccess-group1' => 'سۇرانىسقان ٴارەكەتٴىڭٴىز $1 توبىنىڭ قاتىسۋشىلارىنا شەكتەلەدٴى.',
'badaccess-group2' => 'سۇرانىسقان ٴارەكەتٴىڭٴىز $1 توپتارى بٴىرٴىنٴىڭ قاتۋسىشىلارىنا شەكتەلەدٴى.',
'badaccess-groups' => 'سۇرانىسقان ٴارەكەتٴىڭٴىز $1 توپتارى بٴىرٴىنٴىڭ قاتۋسىشىلارىنا شەكتەلەدٴى.',

'versionrequired'     => 'MediaWiki $1 نۇسقاسى قاجەت',
'versionrequiredtext' => 'وسى بەتتٴى قولدانۋ ٴۇشٴىن MediaWiki $1 نۇسقاسى قاجەت. [[{{ns:special}}:Version]] بەتٴىن قاراڭىز.',

'ok'                  => 'جارايدى',
'pagetitle'           => '$1 — {{SITENAME}}',
'retrievedfrom'       => '«$1» دەگەننەن الىنعان',
'youhavenewmessages'  => 'سٴىزدە $1 بار ($2).',
'newmessageslink'     => 'جاڭا حابارلار',
'newmessagesdifflink' => 'سوڭعى ٴوزگەرٴىسٴىنە',
'editsection'         => 'ٴوڭدەۋ',
'editold'             => 'ٴوڭدەۋ',
'editsectionhint'     => 'بٴولٴىمدٴى ٴوڭدەۋ: $1',
'toc'                 => 'مازمۇنى',
'showtoc'             => 'كٴورسەت',
'hidetoc'             => 'جاسىر',
'thisisdeleted'       => 'قارايمىز با, نە قايتارامىز با?: $1',
'viewdeleted'         => 'قارايمىز با?: $1',
'restorelink'         => 'جويىلعان {{PLURAL:$1|بٴىر|$1}} تٴۇزەتۋ',
'feedlinks'           => 'ارنا:',
'feed-invalid'        => 'جارامسىز جازىلىم ارنا تٴۇرٴى.',

# Short words for each namespace, by default used in the 'article' tab in monobook
'nstab-main'      => 'ماعلۇمات',
'nstab-user'      => 'جەكە بەتٴى',
'nstab-media'     => 'تاسپا بەتٴى',
'nstab-special'   => 'ارنايى',
'nstab-project'   => 'جوبا بەتٴى',
'nstab-image'     => 'فايل',
'nstab-mediawiki' => 'جٴۇيە حابارى',
'nstab-template'  => 'ٴۇلگٴى',
'nstab-help'      => 'انىقتاما',
'nstab-category'  => 'سانات',

# Main script and global functions
'nosuchaction'      => 'مۇنداي ٴارەكەت جوق',
'nosuchactiontext'  => 'وسى URL جايىمەن ەنگٴىزٴىلگەن ٴارەكەتتٴى
وسى ۋيكي جورامالداپ بٴىلمەدٴى.',
'nosuchspecialpage' => 'بۇل ارنايى بەت ەمەس',
'nospecialpagetext' => 'سٴىز سۇرانىسقان ارنايى بەت جارامسىز. بارلىق جارامدى ارنايى بەتتەر تٴىزٴىمٴىن [[{{ns:special}}:Specialpages]] بەتٴىندە تابا الاسىز.',

# General errors
'error'                => 'قاتە',
'databaseerror'        => 'دەرەكقوردىڭ قاتەسٴى',
'dberrortext'          => 'دەرەكقورعا سۇرانىس جاسالعاندا سينتاكسيس قاتەسٴى كەزدەستٴى.
بۇل باعدارلامانىڭ قاتەسٴىن كٴورسەتۋ مٴۇمكٴىن.
دەرەكقورعا سوڭعى بولعان سۇرانىس:
<blockquote><tt>$1</tt></blockquote>
مىنا فۋنكتسيياسىنان «<tt>$2</tt>».
MySQL قايتارعان قاتەسٴى «<tt>$3: $4</tt>».',
'dberrortextcl'        => 'دەرەكقورعا سۇرانىس جاسالعاندا سينتاكسيس قاتەسٴى كەزدەستٴى.
دەرەكقورعا سوڭعى بولعان سۇرانىس:
«$1»
مىنا فۋنكتسيياسىنان: «$2».
MySQL قايتارعان قاتەسٴى «$3: $4»',
'noconnect'            => 'عافۋ ەتٴىڭٴىز! بۇل ۋيكيدە كەيبٴىر تەحنيكالىق قيىنشىلىقتار كەزدەستٴى, سوندىقتان دەرەكقور سەرۆەرٴىنە قاتىناسۋ المايدى. <br />
$1',
'nodb'                 => '$1 دەرەكقورى تالعانبادى',
'cachederror'          => 'تٴومەندە سۇرانعان بەتتٴىڭ قوسالقى قالتاداعى كٴوشٴىرمەسٴى, وسى بەت جاڭارتىلماعان بولۋى مٴۇمكٴىن.',
'laggedslavemode'      => 'نازار سالىڭىز: بەتتە جۋىقتاعى جاڭالاۋلار بولماۋى مٴۇمكٴىن.',
'readonly'             => 'دەرەكقورى قۇلىپتالعان',
'enterlockreason'      => 'قۇلىپتاۋ سەبەبٴىن ەنگٴىزٴىڭٴىز, قاي ۋاقىتقا دەيٴىن
قۇلىپتالعانىن قوسا',
'readonlytext'         => 'اعىمدا دەرەكقور جاڭا جازبا جٴانە تاعى باسقا ٴوزگەرٴىستەر جاساۋدان قۇلىپتالىنعان. بۇل دەرەكقوردى جٴوندەتۋ باعدارلامالارىن ورىنداۋ ٴۇشٴىن بولۋى مٴۇمكٴىن, بۇنى بٴىتٴىرگەننەن سوڭ قالٴىپتٴى ٴىسكە قايتارىلادى.

قۇلىپتاعان ٴاكٴىمشٴى بۇنى بىلاي تٴۇسٴىندٴىرەدٴى: $1',
'missingarticle'       => 'ٴىزدەستٴىرٴىلگەن «$1» اتاۋلى بەت مٴاتٴىنٴى دەرەكقوردا تابىلمادى.

بۇل داعدىدا ەسكٴىرگەن ايىرما سٴىلتەمەسٴىنە نەمەسە جويىلعان بەت تاريحىنىڭ سٴىلتەمەسٴىنە
ەرگەننەن بولۋى مٴۇمكٴىن.

ەگەر بۇل بولجام دۇرىس سەبەپ بولماسا, باعدارلامامىزداعى قاتەگە تاپ بولۋىڭىز مٴۇمكٴىن.
بۇل تۋرالى ناقتى URL جايىن كٴورسەتٴىپ ٴاكٴىمشٴىگە ەسەپتەمە جٴىبەرٴىڭٴىز.',
'readonly_lag'         => 'جەتەك دەرەكقور سەرۆەرلەر باستاۋىشپەن قاداملانعاندا وسى دەرەكقور ٴوزدٴىك تٴۇرٴىندە قۇلىپتالىنعان',
'internalerror'        => 'ٴىشكٴى قاتە',
'filecopyerror'        => '«$1» فايلى «$2» فايلىنا كٴوشٴىرٴىلمەدٴى.',
'filerenameerror'      => '«$1» فايل اتى «$2» اتىنا ٴوزگەرتٴىلمەدٴى.',
'filedeleteerror'      => '«$1» فايلى جويىلمايدى.',
'filenotfound'         => '«$1» فايلى تابىلمادى.',
'unexpected'           => 'كٴۇتٴىلمەگەن ماعىنا: «$1» = «$2».',
'formerror'            => 'قاتە: جٴىبەرۋ ٴۇلگٴىتٴى ەمەس',
'badarticleerror'      => 'وسىنداي ٴارەكەت مىنا بەتتە اتقارىلمايدى.',
'cannotdelete'         => 'ايتىلمىش بەت نە سۋرەت جويىلمايدى. (بۇنى باسقا بٴىرەۋ جويعان شىعار.)',
'badtitle'             => 'جارامسىز اتاۋ',
'badtitletext'         => 'سۇرانىسقان بەت اتاۋى جارامسىز, بوس, تٴىلارا سٴىلتەمەسٴى نە ۋيكي-ارا اتاۋى مٴۇلتٴىك بولعان. اتاۋلاردا سٴۇەمەلدەمەگەن بٴىرقاتار ٴارٴىپتەر بولۋى مٴۇمكٴىن.',
'perfdisabled'         => 'عافۋ ەتٴىڭٴىز! وسى قاسيەت, دەرەكقوردىڭ جىلدامىلىعىنا ٴاسەر ەتٴىپ, ەشكٴىمگە ۋيكيدٴى پايدالانۋعا بەرمەگەسٴىن, ۋاقىتشا ٴوشٴىرٴىلگەن.',
'perfdisabledsub'      => 'مىندا $1 بەتٴىنٴىڭ ساقتالعان كٴوشٴىرمەسٴى:', # obsolete?
'perfcached'           => 'كەلەسٴى دەرەك قوسالقى قالتاسىنان الىنعان, سوندىقتان تولىقتاي جاڭالانماعان بولۋى مٴۇمكٴىن.',
'perfcachedts'         => 'كەلەسٴى دەرەك قوسالقى قالتاسىنان الىنعان, سوڭعى جاڭالانلعان كەزٴى: $1.',
'wrong_wfQuery_params' => 'wfQuery() فۋنكتسيياسىندا جارامسىز باپتار<br />
فۋنكتسييا: $1<br />
سۇرانىس: $2',
'viewsource'           => 'قاينارىن قاراۋ',
'viewsourcefor'        => '$1 قاينارى',
'protectedtext'        => 'بۇل بەت ٴوڭدەۋ بولدىرماۋ ٴۇشٴىن قۇلىپتالىنعان.

بۇل بەتتٴىڭ قاينارىن قاراۋىڭىزعا جٴانە كٴوشٴىرٴىپ الۋڭىزعا بولادى:',
'protectedinterface'   => 'بۇل بەت باعدارلامانىڭ تٴىلدەسۋ مٴاتٴىنٴىن جەتٴىستٴىرەدٴى, سوندىقتان قييانات كەلتٴىرمەۋ ٴۇشٴىن ٴوزگەرتۋٴى قۇلىپتالعان.',
'editinginterface'     => "'''نازار سالىڭىز:''' باعدارلاماعا تٴىلدەسۋ مٴاتٴىنٴىن جەتٴىستٴىرەتٴىن MediaWiki بەتٴىن ٴوڭدەپ جاتىرسىز. بۇل بەتتٴىڭ ٴوزگەرتۋٴى بارلىق پايدالانۋشىلار تٴىلدەسۋٴىنە ٴاسەر ەتەدٴى.",
'sqlhidden'            => '(SQL سۇرانىسى جاسىرىلدى)',

# Login and logout pages
'logouttitle'                => 'قاتىسۋشى شىعۋى',
'logouttext'                 => '<strong>ەندٴى جٴۇيەدەن شىقتىڭىز.</strong><br />
بۇل كومپييۋتەردەن ٴالٴى دە جٴۇيەگە كٴىرمەستەن {{SITENAME}} جوباسىن
شولۋىڭىز مٴۇمكٴىن, نەمەسە باسقا پايدالانۋشىنىڭ جٴۇيەگە كٴىرۋٴى مٴۇمكٴىن.
كەيبٴىر بەتتەردە ٴالٴى دە جٴۇيەگە كٴىرگەنٴىڭٴىزدەي كٴورٴىنۋٴى مٴۇمكٴىندٴىگٴىن
ەسكەرتەمٴىز; بۇل شولعىشتىڭ قوسالقى قالتاسىن بوساتۋ ارقىلى شەشٴىلەدٴى.',
'welcomecreation'            => '== قوش كەلدٴىڭٴىز, $1! ==

تٴىركەلگٴىڭٴىز جاسالدى. {{SITENAME}} باپتاۋىڭىزدى قالاۋىڭىزبەن ٴوزگەرتۋدٴى ۇمىتپاڭىز.',
'loginpagetitle'             => 'قاتىسۋشى كٴىرۋٴى',
'yourname'                   => 'قاتىسۋشى اتىڭىز',
'yourpassword'               => 'قۇپييا سٴوزٴىڭٴىز',
'yourpasswordagain'          => 'قۇپييا سٴوزدٴى قايتالاپ ەنگٴىزٴىڭٴىز',
'remembermypassword'         => 'مەنٴىڭ كٴىرگەنٴىمدٴى بۇل كومپييۋتەردە ۇمىتپا',
'yourdomainname'             => 'جەلٴى ٴۇيشٴىگٴىڭٴىز',
'externaldberror'            => 'وسىندا سىرتقى تەڭدەستٴىرۋ دەرەكقورىندا قاتە بولدى, نەمەسە سىرتقى تٴىركەلگٴىڭٴىزدٴى جاڭالاۋعا رۇقسات جوق.',
'loginproblem'               => '<b>كٴىرۋٴىڭٴىز كەزٴىندە وسىندا قيىندىققا تاپ بولدىق.</b><br />تاعى دا قايتالاپ قاراڭىز.',
'alreadyloggedin'            => '<strong>$1 دەگەن قاتىسۋشى, كٴىرٴىپسٴىز تٴۇگە!<strong><br />',
'login'                      => 'كٴىرۋ',
'loginprompt'                => '{{SITENAME}} تورابىنا كٴىرۋ ٴۇشٴىن «cookies» قاسيەتٴىن ەندٴىرۋٴىڭٴىز قاجەت.',
'userlogin'                  => 'كٴىرۋ / تٴىركەلگٴى جاساۋ',
'logout'                     => 'شىعۋ',
'userlogout'                 => 'شىعۋ',
'notloggedin'                => 'كٴىرمەگەنسٴىز',
'nologin'                    => 'تٴىركەلگٴىڭٴىز جوق پا? $1.',
'nologinlink'                => 'جاساڭىز',
'createaccount'              => 'تٴىركەلگٴى جاسا',
'gotaccount'                 => 'تٴىركەلگٴىڭٴىز بار ما?  $1.',
'gotaccountlink'             => 'كٴىرٴىڭٴىز',
'createaccountmail'          => 'ە-پوشتامەن',
'badretype'                  => 'ەنگٴىزگەن قۇپييا سٴوزدەرٴىڭٴىز بٴىر بٴىرٴىنە سٴايكەس ەمەس.',
'userexists'                 => 'ەنگٴىزگەن قاتىسۋشى اتىڭىزدى بٴىرەۋ پايدالانىپ جاتىر. باسقا اتاۋ تانداڭىز.',
'youremail'                  => 'ە-پوشتا جايىڭىز *:',
'username'                   => 'قاتىسۋشى اتىڭىز:',
'uid'                        => 'قاتىسۋشى تەڭدەستٴىرۋٴىڭٴىز:',
'yourrealname'               => 'شىن اتىڭىز *:',
'yourlanguage'               => 'تٴىلٴىڭٴىز:',
'yourvariant'                => 'تٴۇرٴى',
'yournick'                   => 'لاقاپ اتىڭىز:',
'badsig'                     => 'قام قولتاڭباڭىز جارامسىز; HTML بەلگٴىشەلەرٴىن تەكسەرٴىڭٴىز.',
'email'                      => 'ە-پوشتاڭىز',
'prefs-help-email-enotif'    => 'ەگەر سونى باپتاساڭىز, وسى ە-پوشتا جايى سٴىزگە ەسكەرتۋ حات جٴىبەرۋگە قولدانىلادى.',
'prefs-help-realname'        => '* شىن اتىڭىز (مٴىندەتتٴى ەمەس): ەنگٴىزسەڭٴىز, شىعارماڭىزدىڭ اۋتورلىعىن بەلگٴىلەۋٴى ٴۇشٴىن قولدانىلادى.',
'loginerror'                 => 'كٴىرۋ قاتەسٴى',
'prefs-help-email'           => '* ە-پوشتاڭىز (مٴىندەتتٴى ەمەس): «قاتىسۋشى» نەمەسە «قاتىسۋشى تالقىلاۋ» بەتٴىڭٴىزدەر ارقىلى باسقالارعا بايلانىسۋ مٴۇمكٴىندٴىك بەرەدٴى. ٴوزٴىڭٴىزدٴىڭ كٴىم ەكەنٴىڭٴىزدٴى بٴىلدٴىرتپەيدٴى.',
'nocookiesnew'               => 'قاتىسۋشى تٴىركەلگٴىسٴى جاسالدى, تەك ٴالٴى كٴىرمەگەنسٴىز. {{SITENAME}} جوباسىنا قاتىسۋشى كٴىرۋ ٴۇشٴىن «cookies» قاسيەتٴى قاجەت. شولعىشىڭىزدا «cookies» قاسيەتٴى ٴوشٴىرٴىلگەن. سونى ەندٴىرٴىڭٴىز دە جاڭا قاتىسۋشى اتىڭىزدى جٴانە قۇپييا سٴوزٴىڭٴىزدٴى ەنگٴىزٴىپ كٴىرٴىڭٴىز.',
'nocookieslogin'             => 'قاتىسۋشى كٴىرۋ ٴۇشٴىن {{SITENAME}} جوباسى «cookies» قاسيەتٴىن قولدانادى. شولعىشىڭىزدا «cookies» قاسيەتٴى ٴوشٴىرٴىلگەن. سونى ەندٴىرٴىڭٴىز دە قايتالاپ كٴىرٴىڭٴىز.',
'noname'                     => 'قاتىسۋشى اتىن دۇرىس ەنگٴىزبەدٴىڭٴىز.',
'loginsuccesstitle'          => 'كٴىرۋٴىڭٴىز سٴاتتٴى ٴوتتٴى',
'loginsuccess'               => "'''سٴىز ەندٴى {{SITENAME}} جوباسىنا «$1» رەتٴىندە كٴىرٴىپ وتىرسىز.'''",
'nosuchuser'                 => 'مىندا «$1» اتاۋلى قاتىسۋشى جوق. ەملەڭٴىزدٴى تەكسەرٴىڭٴىز, نەمەسە جاڭا تٴىركەلگٴى جاساڭىز.',
'nosuchusershort'            => 'مىندا «$1» دەگەن قاتىسۋشى اتاۋى جوق. ەملەڭٴىزدٴى تەكسەرٴىڭٴىز.',
'nouserspecified'            => 'قاتىسۋشى اتىن ەنگٴىزٴىۋٴىڭٴىز قاجەت.',
'wrongpassword'              => 'ەنگٴىزگەن قۇپييا سٴوز جارامسىز. قايتالاپ كٴورٴىڭٴىز.',
'wrongpasswordempty'         => 'قۇپييا سٴوز بوستى بوپتى. قايتالاپ كٴورٴىڭٴىز.',
'mailmypassword'             => 'قۇپييا سٴوزٴىمدٴى حاتپەن جٴىبەر',
'passwordremindertitle'      => 'قۇپييا سٴوز تۋرالى {{SITENAME}} جوباسىنىڭ ەسكەرتۋٴى',
'passwordremindertext'       => 'كەيبٴىرەۋ (IP جايى: $1, بٴالكٴىم, ٴوزٴىڭٴىز بولارسىز)
{{SITENAME}} ٴۇشٴىن بٴىزدەن جاڭا قۇپييا سٴوزٴىن جٴىبەرۋٴىن سۇرانىسقان ($4).
«$2» قاتىسۋشىنىڭ قۇپييا سٴوزٴى «$3» بولدى ەندٴى.
قازٴىر كٴىرۋٴىڭٴىز جٴانە قۇپييا سٴوزٴىڭٴىزدٴى اۋىسترۋىڭىز قاجەت.

ەگەر باسقا بٴىرەۋ بۇل سۇرانىستى جاساسا, نەمەسە قۇپييا سٴوزٴىڭٴىزدٴى ۇمىتساڭىز دا,
جٴانە بۇنى ٴوزگەرتكٴىڭٴىز كەلمەسە دە, وسى حابارلاماعا اڭعارماۋىڭىزعا دا بولادى,
ەسكٴى قۇپييا سٴوزٴىڭٴىزدٴى ٴارٴىعاراي قولدانىپ.',
'noemail'                    => 'مىندا «$1» قاتىسۋشىنىڭ ە-پوشتاسى جوق.',
'passwordsent'               => 'جاڭا قۇپييا سٴوز «$1» ٴۇشٴىن
تٴىركەلگەن ە-پوشتا جايىنا جٴىبەرٴىلدٴى.
قابىلداعاننان كەيٴىن كٴىرگەندە سونى ەنگٴىزٴىڭٴىز.',
'blocked-mailpassword'       => 'IP جايىڭىزدان ٴوڭدەۋ بۇعاتتالعان, سوندىقتان
قيياناتشىلىقتان ساقتانۋ ٴۇشٴىن قۇپييا سٴوز جٴىبەرۋ قىزمەتٴىنٴىڭ ٴارەكەتٴى رۇقسات ەتٴىلمەيدٴى.',
'eauthentsent'               => 'كۋٴالاندىرۋ حاتى اتالعان ە-پوشتا جايىنا جٴىبەرٴىلدٴى.
باسقا ە-پوشتا حاتىن جٴىبەرۋدٴىڭ الدىنان, تٴىركەلگٴى شىنىنان سٴىزدٴىكٴى ەكەنٴىن
كۋٴالاندىرۋ ٴۇشٴىن حاتتاعى نۇسقاۋلارعا ەرٴىڭٴىز.',
'throttled-mailpassword'     => 'سوڭعى $1 ساعاتتا قۇپييا سٴوز ەسكەرتۋ حاتى جٴىبەرٴىلدٴى تٴۇگە.
قيياناتشىلىققا كەدەرگٴى بولۋ ٴۇشٴىن, $1 ساعات سايىن تەك بٴىر عانا قۇپييا سٴوز ەسكەرتۋ
حاتى جٴىبەرٴىلەدٴى.',
'mailerror'                  => 'حات جٴىبەرۋ قاتەسٴى: $1',
'acct_creation_throttle_hit' => 'عافۋ ەتٴىڭٴىز, سٴىز $1 تٴىركەلگٴى جاساپسىز تٴۇگە. ونان ارتىق ٴىستەي المايسىز.',
'emailauthenticated'         => 'ە-پوشتا جايىڭىز كۋٴالاندىرىلعان كەزٴى: $1.',
'emailnotauthenticated'      => 'ە-پوشتا جايىڭىز ٴالٴى كۋٴالاندىرعان جوق.
تٴومەندەگٴى قاسيەتتتەر ٴۇشٴىن ەشقانداي حات جٴىبەرٴىلمەيدٴى.',
'noemailprefs'               => 'وسى قاسيەتتەر ٴىستەۋٴى ٴۇشٴىن ە-پوشتا جايىڭىزدى ەنگٴىزٴىڭٴىز.',
'emailconfirmlink'           => 'ە-پوشتا جايىڭىزدى كۋٴالاندىرىڭىز',
'invalidemailaddress'        => 'وسى ە-پوشتا جايدا جارامسىز پٴىشٴىم بولعان, قابىل ەتٴىلمەيدٴى.
دۇرىس پٴىشٴىمدەلگەن جايدى ەنگٴىزٴىڭٴىز, نە اۋماقتى بوس قالدىرىڭىز.',
'accountcreated'             => 'تٴىركەلگٴى جاسالدى',
'accountcreatedtext'         => '$1 ٴۇشٴىن قاتىسۋشى تٴىركەلگٴىسٴى جاسالدى.',

# Edit page toolbar
'bold_sample'     => 'جۋان مٴاتٴىن',
'bold_tip'        => 'جۋان مٴاتٴىن',
'italic_sample'   => 'قيعاش مٴاتٴىن',
'italic_tip'      => 'قيعاش مٴاتٴىن',
'link_sample'     => 'سٴىلتەمە اتاۋى',
'link_tip'        => 'ٴىشكٴى سٴىلتەمە',
'extlink_sample'  => 'http://www.example.com سٴىلتەمە اتاۋى',
'extlink_tip'     => 'سىرتقى سٴىلتەمە (الدىنان http:// ەنگٴىزۋٴىن ۇمىتپاڭىز)',
'headline_sample' => 'تاقىرىپ مٴاتٴىنٴى',
'headline_tip'    => '1-شٴى دەڭگەيلٴى تاقىرىپ',
'math_sample'     => 'فورمۋلانى مىندا ەنگٴىزٴىڭٴىز',
'math_tip'        => 'ماتەماتيكا فورمۋلاسى (LaTeX)',
'nowiki_sample'   => 'پٴىشٴىمدەلمەيتٴىن مٴاتٴىندٴى وسىندا ەنگٴىزٴىڭٴىز',
'nowiki_tip'      => 'ۋيكي پٴىشٴىمٴىن ەلەمەۋ',
'image_sample'    => 'Example.jpg',
'image_tip'       => 'كٴىرٴىكتٴىرٴىلگەن سۋرەت',
'media_sample'    => 'Example.ogg',
'media_tip'       => 'تاسپا فايلىنىڭ سٴىلتەمەسٴى',
'sig_tip'         => 'قولتاڭباڭىز جٴانە ۋاقىت بەلگٴىسٴى',
'hr_tip'          => 'دەرەلەي سىزىق (ٴۇنەمدٴى قولدانىڭىز)',

# Edit pages
'summary'                   => 'سيپاتتاماسى',
'subject'                   => 'تاقىرىبى/باسى',
'minoredit'                 => 'بۇل شاعىن تٴۇزەتۋ',
'watchthis'                 => 'بەتتٴى باقىلاۋ',
'savearticle'               => 'بەتتٴى ساقتا!',
'preview'                   => 'قاراپ شىعۋ',
'showpreview'               => 'قاراپ شىعۋ',
'showlivepreview'           => 'تۋرا قاراپ شىعۋ',
'showdiff'                  => 'ٴوزگەرٴىستەردٴى كٴورسەت',
'anoneditwarning'           => "'''نازار سالىڭىز:''' سٴىز جٴۇيەگە كٴىرمەگەنسٴىز. IP جايىڭىز بۇل بەتتٴىڭ ٴوڭدەۋ تاريحىندا جازىلىپ الىنادى.",
'missingsummary'            => "'''ەسكەرتۋ:''' تٴۇزەتۋ سيپاتتاماسىن ەنگٴىزبەپسٴىز. «ساقتاۋ» تٴۇيمەسٴىن تاعى باسساڭىز, تٴۇزەتۋٴىڭٴىز مٴاندەمەسٴىز ساقتالادى.",
'missingcommenttext'        => 'تٴومەندە مٴاندەمەڭٴىزدٴى ەنگٴىزٴىڭٴىز.',
'missingcommentheader'      => "'''ەسكەرتۋ:''' بۇل مٴاندەمەگە تاقىرىپ/باسجول جەتٴىستٴىرمەپسٴىز. ەگەر تاعى دا ساقتاۋ تٴۇيمەسٴىن نۇقىساڭىز, تٴۇزەتۋٴىڭٴىز سولسىز ساقتالادى.",
'summary-preview'           => 'سيپاتتاماسىن قاراپ شىعۋ',
'subject-preview'           => 'تاقىرىبىن/باسىن قاراپ شىعۋ',
'blockedtitle'              => 'پايدالانۋشى بۇعاتتالعان',
'blockedtext'               => "<big>'''قاتىسۋشى اتىڭىز نە IP جايىڭىز بۇعاتتالعان.'''</big>

بۇعاتتاۋدى $1 ٴىستەگەن. بەلگٴىلەنگەن سەبەبٴى: ''$2''.

وسى بۇعاتتاۋدى تالقىلاۋ ٴۇشٴىن $1 دەگەنمەن نە باسقا [[{{ns:project}}:ٴاكٴىمشٴىلەر|ٴاكٴىمشٴىمەن]] قاتىناسۋىڭىزعا بولادى.
[[{{ns:special:Preferences|تٴىركەلگٴى باپتاۋلارىن]] قولدانىپ جارامدى ە-پوشتا جايىن ەنگٴىزگەنشە دەيٴىن
«قاتىسۋشىعا حات جازۋ» قاسيەتٴىن پايدالانىلمايسىز. اعىمدىق IP جايىڭىز $3 بولعان. بۇنى ٴاربٴىر سۇرانىسىڭىزعا قوسىڭىز.",
'blockedoriginalsource'     => "تٴومەندە '''$1''' دەگەننٴىڭ قاينارى كٴورسەتٴىلەدٴى:",
'blockededitsource'         => "تٴومەندە '''$1''' دەگەنگە جاسالعان '''تٴۇزەتۋڭٴىزدٴىڭ''' مٴاتٴىنٴى كٴورسەتٴىلەدٴى:",
'whitelistedittitle'        => 'ٴوڭدەۋ ٴۇشٴىن كٴىرۋٴىڭٴىز جٴون.',
'whitelistedittext'         => 'بەتتەردٴى ٴوڭدەۋ ٴۇشٴىن $1 جٴون.',
'whitelistreadtitle'        => 'وقۋ ٴۇشٴىن كٴىرۋٴىڭٴىز جٴون',
'whitelistreadtext'         => 'بەتتەردٴى وقۋ ٴۇشٴىن [[{{ns:special}}:Userlogin|كٴىرۋٴىڭٴىز]] جٴون.',
'whitelistacctitle'         => 'سٴىزگە تٴىركەلگٴى جاساۋعا رۇقسات بەرٴىلمەگەن',
'whitelistacctext'          => 'وسى ۋيكيدە باسقالارعا تٴىركەلگٴى جاساۋ ٴۇشٴىن [[{{ns:Special}}:Userlogin|كٴىرۋٴىڭٴىز]] قاجەت جٴانە جاناسىمدى رۇقساتتارىن بيلەۋ قاجەت.',
'confirmedittitle'          => 'ە-پوشتا جايىن كۋٴالاندىرۋ حاتىن قايتا ٴوڭدەۋ قاجەت',
'confirmedittext'           => 'بەتتەردٴى ٴوڭدەۋ ٴۇشٴىن الدىن الا ە-پوشتا جايىڭىزدى كۋٴالاندىرۋىڭىز قاجەت. جايىڭىزدى [[{{ns:Special}}:Preferences|قاتىسۋشى باپتاۋى]] ارقىلى ەنگٴىزٴىڭٴىز جٴانە تەكسەرتكٴىڭٴىز.',
'loginreqtitle'             => 'كٴىرۋٴىڭٴىز قاجەت',
'loginreqlink'              => 'كٴىرۋ',
'loginreqpagetext'          => 'باسقا بەتتەردٴى كٴورۋ ٴۇشٴىن سٴىز $1 بولۋىڭىز قاجەت.',
'accmailtitle'              => 'قۇپييا سٴوز جٴىبەرٴىلدٴى.',
'accmailtext'               => '$2 جايىنا «$1» قۇپييا سٴوزٴى جٴىبەرٴىلدٴى.',
'newarticle'                => '(جاڭا)',
'newarticletext'            => 'سٴىلتەمەگە ەرٴىپ ٴالٴى باستالماعان بەتكە
كەلٴىپسٴىز. بەتتٴى باستاۋ ٴۇشٴىن, تٴومەندەگٴى اۋماقتا مٴاتٴىنٴىڭٴىزدٴى
تەرٴىڭٴىز (كٴوبٴىرەك اقپارات ٴۇشٴىن [[{{ns:help}}:مازمۇنى|كٴومەك بەتٴىن]]
قاراڭىز).ەگەر جاڭىلعاننان وسىندا كەلگەن بولساڭىز, شولعىشىڭىز
«ارتقا» دەگەن تٴۇيمەسٴىن نۇقىڭىز.',
'anontalkpagetext'          => "----''بۇل تٴىركەلگٴىسٴىز (نەمەسە تٴىركەلگٴىسٴىن قولدانباعان) پايدالانۋشىنىڭ تالقىلاۋ بەتٴى. وسى پايدالانۋشىنى بٴىز تەك ساندىق IP جايىمەن تەڭدەستٴىرەمٴىز. وسىنداي IP جايلار بٴىرنەشە پايدالانۋشىعا ورتاق بولۋى مٴۇمكٴىن. ەگەر سٴىز تٴىركەلگٴىسٴىز پايدالانۋشى بولساڭىز جٴانە سٴىزگە قاتىسسىز مٴاندەمەلەر جٴىبەرٴىلگەنٴىن سەزسەڭٴىز, باسقا تٴىركەلگٴىسٴىز پايدالانۋشىلارمەن ارالاستىرماۋى ٴۇشٴىن [[{{ns:special}}:Userlogin|تٴىركەلگٴى جاساڭىز نە كٴىرٴىڭٴىز]].''",
'noarticletext'             => 'بۇل بەتتە اعىمدا ەش مٴاتٴىن جوق, باسقا بەتتەردەن وسى بەت اتاۋىن [[{{ns:special}}:Search/{{PAGENAME}}|ٴىزدەپ كٴورۋٴىڭٴىزگە]] نەمەسە وسى بەتتٴى [{{fullurl:{{FULLPAGENAME}}|action=edit}} تٴۇزەتۋٴىڭٴىزگە] بولادى.',
'clearyourcache'            => "'''اڭعارتپا:''' ساقتاعاننان كەيٴىن ٴوزگەرٴىستەردٴى كٴورۋ ٴۇشٴىن شولعىش قوسالقى قالتاسىن بوساتۋ كەرەگٴى مٴۇمكٴىن. '''Mozilla  / Safari:''' ''Shift'' پەرنەسٴىن باسىپ تۇرىپ ''Reload'' (''قايتا جٴۇكتەۋ'') تٴۇيمەسٴىن نۇقىڭىز (نە ''Ctrl-Shift-R'' باسىڭىز); ''IE:'' ''Ctrl-F5'' باسىڭىز; '''Opera / Konqueror''' ''F5'' پەرنەسٴىن باسىڭىز.",
'usercssjsyoucanpreview'    => '<strong>باسالقى:</strong> ساقتاۋ الدىندا جاڭا CSS/JS فايلىن تەكسەرۋ ٴۇشٴىن «قاراپ شىعۋ» تٴۇيمەسٴىن قولدانىڭىز.',
'usercsspreview'            => "'''مىناۋ CSS مٴاتٴىنٴىن تەك قاراپ شىعۋ ەكەنٴىن ۇمىتپاڭىز, ول ٴالٴى ساقتالعان جوق!'''",
'userjspreview'             => "'''مىناۋ JavaScript قاتىسۋشى باعدارلاماسىن تەكسەرۋ/قاراپ شىعۋ ەكەنٴىن ۇمىتپاڭىز, ول ٴالٴى ساقتالعان جوق!'''",
'userinvalidcssjstitle'     => "'''نازار سالىڭىز:''' مىندا «$1» اتاۋلى بەزەندٴىرۋ مٴانەرٴى جوق. پايدالانۋشىنىڭ .css جٴانە .js فايل اتاۋى كٴىشٴى ٴارٴىپپپەن جازىلاتىنىن ۇمىتپاڭىز, مىسالعا {{ns:user}}:Foo/monobook.css دەگەندٴى {{ns:user}}:Foo/Monobook.css دەگەنمەن سالىستىرىڭىز.",
'updated'                   => '(جاڭارتىلعان)',
'note'                      => '<strong>اڭعارتپا:</strong>',
'previewnote'               => '<strong>مىناۋ تەك قاراپ شىعۋ ەكەنٴىن ۇمىتپاڭىز; تٴۇزەتۋلەر ٴالٴى ساقتالعان جوق!</strong>',
'session_fail_preview'      => '<strong>عافۋ ەتٴىڭٴىز! سەسسييا دەرەكتەرٴى ىسىراپ قالعاندىقتان ٴوڭدەۋٴىڭٴىزدٴى جٴوندەي المايمىز.
مٴاتٴىنٴىڭٴىزدٴى ساقتاپ قايتالاپ كٴورٴىڭٴىز. ەگەر ٴالٴى ٴىس ٴوتپەيتٴىن بولسا, شىعىپ جٴانە كەرٴى كٴىرٴىپ كٴورٴىڭٴىز.</strong>',
'previewconflict'           => 'بۇل قاراپ شىعۋ جوعارىداعى ٴوڭدەۋ اۋماعىنداعى مٴاتٴىنگە ساقتاعان كەزٴىندەگٴى دەي ىقپال ەتەدٴى.',
'session_fail_preview_html' => "<strong>عافۋ ەتٴىڭٴىز! سەسسييا دەرەكتەرٴى ىسىراپ قالعاندىقتان ٴوڭدەۋٴىڭٴىزدٴى جٴوندەي المايمىز.</strong>

''وسى ۋيكيدە قام HTML ەندٴىرٴىلگەن, JavaScript شابۋىلداردان قورعانۋ ٴۇشٴىن الدىن الا قاراپ شىعۋ جاسىرىلعان.''

<strong>ەگەر بۇل ٴوڭدەۋ ادال تالاپ بولسا, قايتارىپ كٴورٴىڭٴىز. ەگەر ٴالٴى دە ٴىستەمەسە, شىعىپ, سوسىن كەرٴى كٴىرٴىپ كٴورٴىڭٴىز.</strong>",
'importing'                 => 'سىرتتان الۋدا: $1',
'editing'                   => 'ٴوڭدەۋدە: $1',
'editinguser'               => 'قاتىسۋشىنى ٴوڭدەۋدە: <b>$1</b>',
'editingsection'            => 'ٴوڭدەۋدە: $1 (بٴولٴىمٴى)',
'editingcomment'            => 'ٴوڭدەۋدە: $1 (مٴاندەمەسٴى)',
'editconflict'              => 'ٴوڭدەۋ ەگەسٴى: $1',
'explainconflict'           => 'وسى بەتتٴى سٴىز ٴوڭدەي باستاعاندا باسقا كەيبٴىرەۋ بەتتٴى ٴوزگەرتكەن.
جوعارعى اۋماقتا بەتتٴىڭ اعىمدىق مٴاتٴىنٴى بار.
تٴومەنگٴى اۋماقتا سٴىز ٴوزگەرتكەن مٴاتٴىنٴى كٴورسەتٴىلەدٴى.
ٴوزگەرتۋٴىڭٴىزدٴى اعىمدىق مٴاتٴىنگە ٴۇستەۋٴىڭٴىز جٴون.
"بەتتٴى ساقتا!" تٴۇيمەسٴىنە باسقاندا
<b>تەك</b> جوعارعى اۋماقتاعى مٴاتٴىن ساقتالادى.<br />',
'yourtext'                  => 'مٴاتٴىنٴىڭٴىز',
'storedversion'             => 'ساقتالعان نۇسقاسى',
'nonunicodebrowser'         => '<strong>اڭعارتپا: شولعىشىڭىز Unicode بەلگٴىلەۋٴىنە ٴۇيلەسٴىمدٴى ەمەس, سوندىقتان لاتىن ەمەس ٴارٴىپتەرٴى بار بەتتەردٴى ٴوڭدەۋ زٴىل بولۋ مٴۇمكٴىن. جۇمىس ٴىستەۋگە ىقتيمالدىق بەرۋ ٴۇشٴىن, <strong>تٴومەنگٴى ٴوڭدەۋ اۋماعىندا ASCII ەمەس ٴارٴىپتەر ونالتىلىق سانىمەن كٴورسەتٴىلەدٴى</strong>.',
'editingold'                => '<strong>اڭعارتپا: وسى بەتتٴىڭ ەرتەرەك نۇسقاسىن
ٴوڭدەپ جاتىرسىز.
بۇنى ساقتاساڭىز, وسى نۋسقادان سوڭعى بارلىق تٴۇزەتۋلەر جويىلادى.</strong>',
'yourdiff'                  => 'ايىرمالار',
'copyrightwarning'          => '{{SITENAME}} جوباسىنا قوسىلعان بٴۇكٴىل ٴۇلەس $2 (كٴوبٴىرەك اقپارات ٴۇشٴىن: $1) قۇجاتىنا ساي جٴىبەرٴىلگەن بولىپ سانالادى. ەگەر جازۋىڭىزدىڭ ەركٴىن كٴوشٴىرٴىلٴىپ تٴۇزەتٴىلۋٴىن قالاماساڭىز, مىندا ۇسىنباۋىڭىز جٴون.<br />
تاعى, قوسقان ٴۇلەسٴىڭٴىز - ٴوزٴىڭٴىزدٴىڭ جازعانىعىز, نە اشىق اقپارات كٴوزدەرٴىنەن الىنعان ماعلۇمات بولعانىن ۋٴادە ەتەسٴىز.<br />
<strong>اۆتورلىق قۇقىقپەن قورعاۋلى اقپاراتتى رۇقساتسىز قوسپاڭىز!</strong>',
'copyrightwarning2'         => 'ەستە تۇرسىن: بارلىق {{SITENAME}} جوباسىنا بەرٴىلگەن ٴۇلەستەر باسقا ۋلەس بەرۋشٴىلەرمەن تٴۇزەتۋگە, ٴوزگەرتۋگە, نە الاستانۋعا مٴۇمكٴىن. العىسسىز تٴۇزەتۋگە ەنجارلان بولساڭىز, وندا شىعارماڭىزدى مىندا جارييالاماڭىز.<br />
تاعى, وسىنى ٴوزٴىڭٴىز جازعانىڭىزدى, نە بارشا قازىناسىنان, نەمەسە سونداي-اق اقىسىز اشىق قاينارىنان كٴوشٴىرگەنٴىڭٴىزدٴى
دٴال وسىنداي بٴىزگە مٴىندەتتەمە بەرەسٴىز (كٴوبٴىرەك اقپارات ٴۇشٴىن $1 قۋجاتىن قاراڭىز).<br />
<strong>اۋتورلىق قۇقىقپەن قورعاۋلى اقپاراتتى رۇقساتسىز قوسپاڭىز!</strong>',
'longpagewarning'           => '<strong>نازار سالىڭىز: بۇل بەتتٴىڭ مٴولشەرٴى — $1 كيلوبايت; كەيبٴىر
شولعىشتاردا بەت مٴولشەرٴى 32 كب جەتسە نە ونى اسسا ٴوڭدەۋ كٴۇردەلٴى بولۋى مٴۇمكٴىن.
بەتتٴى بٴىرنەشە كٴىشكٴىن بٴولٴىمدەرگە بٴولٴىپ كٴورٴىڭٴىز.</strong>',
'longpageerror'             => '<strong>قاتە: جٴىبەرەتٴىن مٴاتٴىنٴىڭٴىزدٴىن مٴولشەرٴى — $1 كب, ەڭ كٴوبٴى $2 كب
رۇقسات ەتٴىلگەن مٴولشەرٴىنەن اسقان. بۇل ساقتاي الىنبايدى.</strong>',
'readonlywarning'           => '<strong>نازار سالىڭىز: دەرەكقور جٴوندەتۋ ٴۇشٴىن قۇلىپتالعان,
سوندىقتان دٴال قازٴىر تٴۇزەتۋٴىڭٴىزدٴى ساقتاي المايسىز. سوسىن قولدانۋعا ٴۇشٴىن مٴاتٴانٴىڭٴىزدٴى كٴوشٴىرٴىپ,
ٴوز كومپٴۇتەرٴىڭٴىزدە فايلعا ساقتاڭىز.</strong>',
'protectedpagewarning'      => '<strong>نازار سالىڭىز: بۇل بەت قورعالعان. تەك ٴاكٴىمشٴى رۇقساتى بار قاتىسۋشىلار ٴوڭدەۋ جاساي الادى.</strong>',
'semiprotectedpagewarning'  => "'''اڭعارتپا:''' بەت [[{{ns:project}}:جارتىلاي قورعاۋ ساياساتى|قورعالعان]], سوندىقتان وسىنى تەك رۇقساتى بار قاتىسۋشىلار ٴوڭدەي الادى.",
'templatesused'             => 'بۇل بەتتە قولدانىلعان ٴۇلگٴىلەر:',
'templatesusedpreview'      => 'بۇنى قاراپ شىعۋعا قولدانىلعان ٴۇلگٴىلەر:',
'templatesusedsection'      => 'بۇل بٴولٴىمدە قولدانىلعان ٴۇلگٴىلەر:',
'edittools'                 => '<!-- مىنداعى ماعلۇمات ٴوڭدەۋ جٴانە قوتارۋ ٴۇلگٴىتترٴىڭٴىڭ استىندا كٴورسەتٴىلەدٴى. -->',
'nocreatetitle'             => 'بەتتٴى باستاۋ شەكتەلگەن',
'nocreatetext'              => 'بۇل توراپتا جاڭا بەت باستاۋى شەكتەلگەن.
كەرٴى قايتىپ بار بەتتٴى ٴوڭدەۋٴىڭٴىزگە بولادى, نەمەسە [[{{ns:special}}:Userlogin|كٴىرۋٴىڭٴىزگە نە تٴىركەلگٴى جاساۋعا]] بولادى.',
'cantcreateaccounttitle'    => 'تٴىركەلگٴى جاسالمادى',
'cantcreateaccounttext'     => 'وسى IP جايدان (<b>$1</b>) تٴىركەلگٴى جاساۋى بۇعاتتالعان.
بٴالكٴىم سەبەبٴى, وقۋ ورنىڭىزدان, نەمەسە ينتەرنەت جەتكٴىزۋشٴىدەن
ٴۇزبەي بۇزاقىلىق بولعانى.',

# History pages
'revhistory'                  => 'نۇسقالار تاريحى',
'viewpagelogs'                => 'وسى بەتكە قاتىستى جۋرنالداردى قاراۋ',
'nohistory'                   => 'وسى بەتتٴىنٴىڭ نۇسقالار تاريحى جوق.',
'revnotfound'                 => 'نۇسقا تابىلمادى',
'revnotfoundtext'             => 'وسى سۇرانىسقان بەتتٴىڭ ەسكٴى نۇسقاسى تابىلعان جوق.
وسى بەتتٴى اشۋعا پايدالانعان URL جايىن قايتا تەكسەرٴىپ شىعىڭىز.',
'loadhist'                    => 'بەت تاريحىن جٴۇكتەۋٴى',
'currentrev'                  => 'اعىمدىق نۇسقاسى',
'revisionasof'                => '$1 كەزٴىندەگٴى نۇسقاسى',
'revision-info'               => '$1 كەزٴىندەگٴى $2 جاساعان نۇسقاسى',
'previousrevision'            => '← ەسكٴىلەۋ نۇسقاسى',
'nextrevision'                => 'جاڭالاۋ نۇسقاسى →',
'currentrevisionlink'         => 'اعىمدىق نۇسقاسى',
'cur'                         => 'اعىم.',
'next'                        => 'كەل.',
'last'                        => 'سوڭ.',
'orig'                        => 'تٴۇپ.',
'histlegend'                  => 'ايىرماسىن كٴورۋ: سالىستىرامىن دەگەن نۇسقالاردى تاڭداپ, نە <Enter> پەرنەسٴىن, نە تٴومەندەگٴى تٴۇيمەنٴى باسىڭىز.<br />
شارتتى بەلگٴىلەر: (اعىم.) = اعىمدىق نۇسقامەن ايىرماسى,
(سوڭ.) = الدىڭعى نۇسقامەن ايىرماسى, ش = شاعىن تٴۇزەتۋ',
'deletedrev'                  => '[جويىلعان]',
'histfirst'                   => 'ەڭ العاشقىسىنا',
'histlast'                    => 'ەڭ سوڭعىسىنا',
'rev-deleted-comment'         => '(مٴاندەمە الاستاتىلدى)',
'rev-deleted-user'            => '(قاتىسۋشى اتى الاستاتىلدى)',
'rev-deleted-text-permission' => '<div class="mw-warning plainlinks">
وسى بەتتٴىڭ نۇسقاسى جارييا مۇراعاتتارىنان الاستاتىلعان.
بۇل جايتقا [{{fullurl:{{ns:special}}:Log/delete|page={{PAGENAMEE}}}} جويۋ جۋرنالىندا] ەگجەي-تەگجەي مٴالٴىمەتتەر بولۋى مٴۇمكٴىن.
</div>',
'rev-deleted-text-view'       => '<div class="mw-warning plainlinks">
وسى بەتتٴىڭ نۇسقاسى جارييا مۇراعاتتارىنان الاستاتىلعان.
سونى وسى توراپتىڭ ٴاكٴىمشٴىسٴى بوپ كٴورۋٴىڭٴىز مٴۇمكٴىن;
بۇل جايتقا [{{fullurl:{{ns:special}}:Log/delete|page={{PAGENAMEE}}}} جويۋ جۋرنالىندا] ەگجەي-تەگجەي مٴالمەتتەر بولۋى مٴۇمكٴىن.
</div>',
'rev-delundel'                => 'كٴورسەت/جاسىر',

'history-feed-title'          => 'نۇسقالار تاريحى',
'history-feed-description'    => 'بۇل بەتتٴىڭ ۋيكيدەگٴى نۇسقالار تاريحى',
'history-feed-item-nocomment' => '$1 دەگەن $2 كەزٴىندە', # user at time
'history-feed-empty'          => 'سۇرانعان بەت جوق.
بۇل بەت ۋيكيدەن جويىلعان, نەمەسە قايتا اتالعان.
سٴايكەسٴى بار جاڭا بەتتەردٴى [[{{ns:special}}:Search|ۋيكيدەن ٴىزدەپ]] قاراڭىز.',

# Revision deletion
'revisiondelete'            => 'نۇسقالاردى جويۋ/قايتارۋ',
'revdelete-nooldid-title'   => 'نىسانا نۇسقاسى جوق',
'revdelete-nooldid-text'    => 'وسى ٴارەكەتتٴى ورىنداۋ ٴۇشٴىن اقىرعى نۇسقاسىن
نە نۇسقالارىن ەنگٴىزبەپسٴىز.',
'revdelete-selected'        => '[[:$1]] دەگەننٴىڭ تالعانىلعان نۇسقاسى:',
'revdelete-text'            => 'جويىلعان نۇسقالاردى ٴالٴى دە بەت تاريحىندا كٴورۋگە بولادى,
بٴىراق ونىڭ مٴاتٴىن ماعلۇماتى بارشاعا قاتىنالمايدى.

وسى ۋيكيدٴىڭ باسقا ٴاكٴىمشٴىلەرٴى جاسىرىن ماعلۇماتقا قاتىناي الادى,
جٴانە توراپ وپەراتورلارى قوسىمشا شەكتەۋ ەندٴىرگەنشە دەيٴىن,
وسى تٴىلدەسۋ ارقىلى جويىلعاندى كەرٴى قايتارا الادى.',
'revdelete-legend'          => 'نۇسقانىنىڭ شەكتەۋلەرٴى:',
'revdelete-hide-text'       => 'نۇسقا مٴاتٴىنٴىن جاسىر',
'revdelete-hide-comment'    => 'تٴۇزەتۋ مٴاندەمەسٴىن جاسىر',
'revdelete-hide-user'       => 'ٴوڭدەۋشٴى اتىن (IP جايىن) جاسىر',
'revdelete-hide-restricted' => 'وسى شەكتەۋلەردٴى بارشاعا سيياقتى ٴاكٴىمشٴىلەرگە دە قولدانۋ',
'revdelete-log'             => 'جۋرنال مٴاندەمەسٴى:',
'revdelete-submit'          => 'تالعانعان نۇسقاعا قولدانۋ',
'revdelete-logentry'        => '[[$1]] دەگەنگە نۇسقا كٴورٴىنٴىسٴىن ٴوزگەرتتٴى',

# Diffs
'difference'                => '(نۇسقالار اراسىنداعى ايىرماشىلىق)',
'loadingrev'                => 'ايىرما ٴۇشٴىن نۇسقا جٴۇكتەۋ',
'lineno'                    => 'جول $1:',
'editcurrent'               => 'وسى بەتتٴىڭ اعىمدىق نۇسقاسىن ٴوڭدەۋ',
'selectnewerversionfordiff' => 'سالىستىرۋ ٴۇشٴىن جاڭالاۋ نۇسقاسىن تالعاڭىز',
'selectolderversionfordiff' => 'سالىستىرۋ ٴۇشٴىن ەسكٴىلەۋ نۇسقاسىن تالعاڭىز',
'compareselectedversions'   => 'تاڭداعان نۇسقالاردى سالىستىرۋ',

# Search results
'searchresults'         => 'ٴىزدەستٴىرۋ نٴاتيجەلەرٴى',
'searchresulttext'      => 'وسى {{SITENAME}} جوباسىندا ٴىزدەستٴىرۋ تۋرالى كٴوبٴىرەك اقپارات ٴۇشٴىن, [[{{ns:project}}:ٴىزدەۋ|{{SITENAME}} ٴىزدەۋ نۇسقاۋلارىن]] قاراڭىز.',
'searchsubtitle'        => "ٴىزدەستٴىرۋ سۇرانىسىڭىز: '''[[:$1]]'''",
'searchsubtitleinvalid' => "ٴىزدەستٴىرۋ سۇرانىسىڭىز: '''$1'''",
'badquery'              => 'ٴىزدەستٴىرۋ سۇرانىس جارامسىز پٴىشٴىمدەلگەن',
'badquerytext'          => 'عافۋ ەتٴىڭٴىز, سۇرانىسىڭىزدى ورىنداي المادىق.
بۇل ٴۇش ٴارٴىپتەن كەم سٴوزدٴى ٴىزدەستٴىرۋگە تالاپتانعانىڭىزدان
بولۋعا مٴۇمكٴىن, ول ٴالٴى دە سٴۇيەمەلدەنبەگەن.
تاعى دا بۇل سٴويلەمدٴى دۇرىس ەنگٴىزبەگەندٴىكتەن دە بولۋعا مٴۇمكٴىن,
مىسالى, «بالىق جٴانە جٴانە قابىرشاق».
باسقا سۇرانىس جاساپ كٴورٴىڭٴىز',
'matchtotals'           => '«$1» ٴىزدەستٴىرۋ سۇرانىسى $2 بەتتٴىڭ اتاۋىنا
جٴانە $3 بەتتٴىڭ مٴاتٴىنٴىنە سٴايكەس.',
'noexactmatch'          => "'''وسىندا «$1» اتاۋلى بەت جوق.''' بۇل بەتتٴى ٴوزٴىڭٴىز '''[[:$1|باستاي  الاسىز]].'''",
'titlematches'          => 'بەت اتاۋى سٴايكەسٴى',
'notitlematches'        => 'ەش بەت اتاۋى سٴايكەس ەمەس',
'textmatches'           => 'بەت مٴاتٴىنٴىڭ سٴايكەسٴى',
'notextmatches'         => 'ەش بەت مٴاتٴىنٴى سٴايكەس ەمەس',
'prevn'                 => 'الدىڭعى $1',
'nextn'                 => 'كەلەسٴى $1',
'viewprevnext'          => 'كٴورسەتٴىلۋٴى: ($1) ($2) ($3) جازبا.',
'showingresults'        => 'تٴومەندە نٴومٴىر <b>$2</b> دەگەننەن باستاپ <b>$1</b> نٴاتيجەگە دەيٴىن كٴورسەتٴىلگەن.',
'showingresultsnum'     => 'تٴومەندە نٴومٴىر <b>$2</b> دەگەننەن باستاپ <b>$3</b> نٴاتيجە كٴورسەتٴىلگەن.',
'nonefound'             => "'''اڭعارتپا''': تابۋ سٴاتسٴىز بٴىتۋٴى جيٴى «بولعان» جٴانە «دەگەن» سيياقتى
تٴىزٴىمدەلمەيتٴىن جالپى سٴوزدەرمەن ٴىزدەستٴىرۋدەن بولۋى مٴۇمكٴىن,
نەمەسە بٴىردەن ارتىق ٴىزدەستٴىرۋ شارت سٴوزدەرٴىن ەگٴىزگەننەن (نٴاتيجەلەردە تەك
بارلىق شارت سٴوزدەر كەدەسسە كٴورسەتٴىلەدٴى) بولۋى مٴۇمكٴىن.",
'powersearch'           => 'ٴىزدەۋ',
'powersearchtext'       => 'مىنا ەسٴىم ايالاردا ٴىزدەۋ:<br />$1<br />$2 ايداتۋلاردى تٴىزٴىمدەۋ<br />ٴىزدەستٴىرۋ سۇرانىسى: $3 $9',
'searchdisabled'        => '{{SITENAME}} جوباسىندا ٴىشكٴى ٴىزدەۋٴى ٴوشٴىرٴىلگەن. ٴازٴىرشە Google نەمەسە Yahoo! ارقىلى ٴىزدەۋگە بولادى. اڭعارتپا: {{SITENAME}} ماعلۇمات تٴىزٴىمٴىدەۋلەرٴى ولاردا ەسكٴىرگەن بولۋعا مٴۇمكٴىن.',
'blanknamespace'        => '(نەگٴىزگٴى)',

# Preferences page
'preferences'           => 'باپتاۋلار',
'mypreferences'         => 'باپتاۋىم',
'prefsnologin'          => 'كٴىرمەگەنسٴىز',
'prefsnologintext'      => 'باپتاۋلاردى قالاۋ ٴۇشٴىن الدىن الا [[{{ns:special}}:Userlogin|كٴىرۋٴىڭٴىز]] قاجەت.',
'prefsreset'            => 'باپتاۋلار ارقاۋدان قايتا ورناتىلدى.',
'qbsettings'            => 'مٴازٴىر ايماعى',
'changepassword'        => 'قۇپييا سٴوز ٴوزگەرتۋ',
'skin'                  => 'بەزەندٴىرۋ',
'math'                  => 'ماتەماتيكا',
'dateformat'            => 'كٴۇن-اي پٴىشٴىمٴى',
'datedefault'           => 'ەش قالاۋسىز',
'datetime'              => 'ۋاقىت',
'math_failure'          => 'ٴوڭدەتۋ سٴاتسٴىز بٴىتتٴى',
'math_unknown_error'    => 'بەلگٴىسٴىز قاتە',
'math_unknown_function' => 'بەلگٴىسٴىز فۋنكتسييا',
'math_lexing_error'     => 'لەكسيكا قاتەسٴى',
'math_syntax_error'     => 'سينتاكسيس قاتەسٴى',
'math_image_error'      => 'PNG اۋدارىسى سٴاتسٴىز بٴىتتٴى; latex, dvips, gs جٴانە convert باعدارلامالارىنىڭ مٴۇلتٴىكسٴىز ورناتۋىن تەكسەرٴىڭٴىز',
'math_bad_tmpdir'       => 'ماتەماتيكانىڭ ۋاقىتشا قالتاسىنا جازىلمادى, نە قالتا جاسالمادى',
'math_bad_output'       => 'ماتەماتيكانىڭ بەرٴىس قالتاسىنا جازىلمادى, نە قالتا جاسالمادى',
'math_notexvc'          => 'texvc باعدارلاماسى جوعالتىلعان; باپتاۋ ٴۇشٴىن math/README قۇجاتىن قاراڭىز.',
'prefs-personal'        => 'جەكە دەرەكتەرٴى',
'prefs-rc'              => 'جۋىقتاعى ٴوزگەرٴىستەر',
'prefs-watchlist'       => 'باقىلاۋ',
'prefs-watchlist-days'  => 'باقىلاۋ تٴىزٴىمٴىندە كٴورسەتەرٴىن كٴۇن سانى:',
'prefs-watchlist-edits' => 'كەڭەيتٴىلگەن باقىلاۋ تٴىزٴىمٴى تٴۇزەتۋ كٴورسەتەرٴىن سانى:',
'prefs-misc'            => 'قوسىمشا',
'saveprefs'             => 'ساقتا',
'resetprefs'            => 'تاستا',
'oldpassword'           => 'اعىمدىق قۇپييا سٴوز:',
'newpassword'           => 'جاڭا قۇپييا سٴوز:',
'retypenew'             => 'جاڭا قۇپييا سٴوزدٴى قايتالاڭىز:',
'textboxsize'           => 'ٴوڭدەۋ',
'rows'                  => 'جولدار:',
'columns'               => 'باعاندار:',
'searchresultshead'     => 'ٴىزدەۋ',
'resultsperpage'        => 'بەت سايىن نٴاتيجە سانى:',
'contextlines'          => 'نٴاتيجە سايىن جول سانى:',
'contextchars'          => 'جول سايىن ٴارٴىپ سانى:',
'stubthreshold'         => 'بٴىتەمە كٴورستەتۋٴىن انىقتاۋ تابالدىرىعى:',
'recentchangescount'    => 'جۋىقتاعى ٴوزگەرٴىستەردەگٴى اتاۋلار:',
'savedprefs'            => 'باپتاۋلارىڭىز ساقتالدى.',
'timezonelegend'        => 'ۋاقىت بەلدەۋٴى',
'timezonetext'          => 'جەرگٴىلٴىكتٴى ۋاقىتىڭىزبەن سەرۆەر ۋاقىتىنىڭ (UTC) اراسىنداعى ساعات سانى.',
'localtime'             => 'جەرگٴىلٴىكتٴى ۋاقىت',
'timezoneoffset'        => 'ىعىستىرۋ¹',
'servertime'            => 'سەرۆەر ۋاقىتى',
'guesstimezone'         => 'شولعىشتان الىپ تولتىرۋ',
'allowemail'            => 'باسقادان حات قابىلداۋىن ەندٴىرۋ',
'defaultns'             => 'مىنا ەسٴىم ايالاردا ٴادەپكٴىدەن ٴىزدەۋ:',
'default'               => 'ٴادەپكٴى',
'files'                 => 'فايلدار',

# User rights
'userrights-lookup-user'     => 'قاتىسۋشى توپتارىن مەڭگەرۋ',
'userrights-user-editname'   => 'قاتىسۋشى اتىن ەنگٴىزٴىڭٴىز:',
'editusergroup'              => 'قاتىسۋشى توپتارىن ٴوڭدەۋ',
'userrights-editusergroup'   => 'قاتىسۋشى توپتارىن ٴوڭدەۋ',
'saveusergroups'             => 'قاتىسۋشى توپتارىن ساقتاۋ',
'userrights-groupsmember'    => 'مٴۇشەلٴىگٴى:',
'userrights-groupsavailable' => 'قاتىناۋلى توپتار:',
'userrights-groupshelp'      => 'قاتىسۋشىنى ٴۇستەيتٴىن نە الاستاتىن توپتاردى تالعاڭىز.
تالعاۋى ٴوشٴىرٴىلگەن توپتار ٴوزگەرتٴىلٴىمەيدٴى. توپتاردىڭ تالعاۋىن CTRL + سول جاق نۇقۋمەن ٴوشٴىرۋٴىڭٴىزگە بولادى.',

# Groups
'group'            => 'توپ:',
'group-bot'        => 'بوتتار',
'group-sysop'      => 'ٴاكٴىمشٴىلەر',
'group-bureaucrat' => 'تٴورەشٴىلەر',
'group-all'        => '(بارلىعى)',

'group-bot-member'        => 'بوت',
'group-sysop-member'      => 'ٴاكٴىمشٴى',
'group-bureaucrat-member' => 'تٴورەشٴى',

'grouppage-bot'        => '{{ns:project}}:بوتتار',
'grouppage-sysop'      => '{{ns:project}}:ٴاكٴىمشٴىلەر',
'grouppage-bureaucrat' => '{{ns:project}}:تٴورەشٴىلەر',

# Recent changes
'changes'                           => 'ٴوزگەرٴىس',
'recentchanges'                     => 'جۋىقتاعى ٴوزگەرٴىستەر',
'recentchangestext'                 => 'بۇل بەتتە وسى ۋيكيدەگٴى بولعان جۋىقتاعى ٴوزگەرٴىستەر بايقالادى.',
'rcnote'                            => '$3 كەزٴىنە دەيٴىن — تٴومەندە سوڭعى <strong>$2</strong> كٴۇندەگٴى, سوڭعى <strong>$1</strong> ٴوزگەرٴىس كٴورسەتٴىلگەن.',
'rcnotefrom'                        => '<b>$2</b> كەزٴىنەن بەرٴى — تٴومەندە ٴوزگەرٴىستەر <b>$1</b> دەيٴىن كٴورسەتٴىلگەن.',
'rclistfrom'                        => '$1 كەزٴىنەن بەرٴى — جاڭا ٴوزگەرٴىستەردٴى كٴورسەت.',
'rcshowhideminor'                   => 'شاعىن تٴۇزەتۋدٴى $1',
'rcshowhidebots'                    => 'بوتتاردى $1',
'rcshowhideliu'                     => 'تٴىركەلگەندٴى $1',
'rcshowhideanons'                   => 'تٴىركەلگٴىسٴىزدٴى $1',
'rcshowhidepatr'                    => 'كٴۇزەتتەگٴى تٴۇزەتۋلەردٴى $1',
'rcshowhidemine'                    => 'تٴۇزەتۋٴىمدٴى $1',
'rclinks'                           => 'سوڭعى $2 كٴۇندە بولعان, سوڭعى $1 ٴوزگەرٴىستٴى كٴورسەت<br />$3',
'diff'                              => 'ايىرم.',
'hist'                              => 'تار.',
'hide'                              => 'جاسىر',
'show'                              => 'كٴورسەت',
'minoreditletter'                   => 'ش',
'newpageletter'                     => 'ج',
'boteditletter'                     => 'ب',
'sectionlink'                       => '→',
'number_of_watching_users_pageview' => '[باقىلاعان $1 قاتىسۋشى]',
'rc_categories'                     => 'ساناتتارعا شەكتەۋ ("|" بەلگٴىسٴىمەن بٴولٴىكتەڭٴىز)',
'rc_categories_any'                 => 'قايسىبٴىر',

# Upload
'upload'                      => 'فايل قوتارۋ',
'uploadbtn'                   => 'قوتار!',
'reupload'                    => 'قايتالاپ قوتارۋ',
'reuploaddesc'                => 'قوتارۋ ٴۇلگٴىتٴىنە ورالۋ.',
'uploadnologin'               => 'كٴىرمەگەنسٴىز',
'uploadnologintext'           => 'فايل قوتارۋ ٴۇشٴىن
[[{{ns:special}}:Userlogin|كٴىرۋٴىڭٴىز]] قاجەت.',
'upload_directory_read_only'  => 'قوتارۋ قالتاسىنا ($1) جازۋعا ۆەب-سەرۆەرگە رۇقسات بەرٴىلمەگەن.',
'uploaderror'                 => 'قوتارۋ قاتەسٴى',
'uploadtext'                  => "تٴومەندەگٴى ٴۇلگٴىت فايل قوتارۋعا قولدانىلادى, الدىنداعى سۋرەتتەردٴى قاراۋ ٴۇشٴىن نە ٴىزدەۋ ٴۇشٴىن [[{{ns:special}}:Imagelist|قوتارىلعان فايلدار تٴىزٴىمٴىنە]] بارىڭىز, قوتارۋ مەن جويۋ تاعى دا [[{{ns:special}}:Log/upload|قوتارۋ جۋرنالىنا]] جازىلىپ الىنادى.

سۋرەتتەردٴى بەتكە كٴىرگٴىزۋ ٴۇشٴىن, فايلعا تۋرا بايلانىستراتىن
'''<nowiki>[[{{ns:image}}:File.jpg]]</nowiki>''',
'''<nowiki>[[{{ns:image}}:File.png|بالاما مٴاتٴىن]]</nowiki>''' نەمەسە
'''<nowiki>[[{{ns:media}}:File.ogg]]</nowiki>''' سٴىلتەمە پٴىشٴىمٴىن قولدانىڭىز.",
'uploadlog'                   => 'قوتارۋ جۋرنالى',
'uploadlogpage'               => 'قوتارۋ جۋرنالى',
'uploadlogpagetext'           => 'تٴومەندە جۋىقتاعى قوتارىلعان فايل تٴىزٴىمٴى.',
'filename'                    => 'فايل اتى',
'filedesc'                    => 'سيپاتتاماسى',
'fileuploadsummary'           => 'سيپاتتاماسى:',
'filestatus'                  => 'اۋتورلىق قۇقىقتارى كٴۇيٴى',
'filesource'                  => 'فايل قاينارى',
'copyrightpage'               => '{{ns:project}}:اۋتورلىق قۇقىقتار',
'copyrightpagename'           => '{{SITENAME}} اۋتورلىق قۇقىقتارى',
'uploadedfiles'               => 'قوتارىلعان فايلدار',
'ignorewarning'               => 'نازار سالۋدى ەلەمەۋ جٴانە فايلدى ٴاردەقاشان ساقتاۋ.',
'ignorewarnings'              => 'ٴارقايسى نازار سالۋلاردى ەلەمەۋ',
'minlength'                   => 'فايل اتىندا ەڭ كەمٴىندە ٴۇش ٴارٴىپ بولۋى كەرەك.',
'illegalfilename'             => '«$1» فايل اتاۋىندا بەت اتاۋلارىندا رۇقسات ەتٴىلمەگەن نىشاندار بار. فايلدى قايتا اتاڭىز, سوسىن قايتا جۋكتەپ كٴورٴىڭٴىز.',
'badfilename'                 => 'فايلدىڭ اتى «$1» بوپ ٴوزگەرتٴىلدٴى.',
'badfiletype'                 => '«.$1» ۇسىنىلماعان سۋرەت فايلىنىڭ كەڭەيتٴىمٴى.',
'largefile'                   => 'فايل مٴولشەرٴىن $1 بايتتان اسىرماۋعا تىرىسىڭىز, بۇل فايل مٴولشەرٴى $2 بايت',
'largefileserver'             => 'وسى فايلدىڭ مٴولشەرٴى سەرۆەردٴىڭ قالاۋىنان اسىپ كەتكەن.',
'emptyfile'                   => 'قوتارىلعان فايلىڭىز بوس سيياقتى. بۇل فايل اتاۋى جانساق ەنگٴىزٴىلگەنٴىنەن بولۋى مٴۇمكٴىن. قوتارعىڭىز كەلگەن فايل شىنىندا دا وسى فايل بولعانىن تەكسەرٴىپ الىڭىز.',
'fileexists'                  => 'وسىنداي اتاۋلى فايل بار تٴۇگە. قايتا جازۋدىڭ الدىنان $1 تەكسەرٴىپ شىعىڭىز.',
'fileexists-forbidden'        => 'وسىنداي اتاۋلى فايل بار تٴۇگە. كەرٴى قايتىڭىز دا, جٴانە وسى فايلدى باسقا اتىمەن قوتارىڭىز. [[{{ns:image}}:$1|thumb|center|$1]]',
'fileexists-shared-forbidden' => 'وسىنداي اتاۋلى فايل ورتاق فايل ارقاۋىندا بار تٴۇگە. كەرٴى قايتىڭىز دا, وسى فايلدى جاڭا اتىمەن قوتارىڭىز. [[{{ns:image}}:$1|thumb|center|$1]]',
'successfulupload'            => 'قوتارۋ سٴاتتٴى ٴوتتٴى',
'fileuploaded'                => '«$1» فايلى سٴاتتٴى قوتارىلدى!
وسى سٴىلتەمەگە ەرٴىپ — $2, سيپاتتاما بەتٴىنە بارىڭىز دا, جٴانە وسى فايل تۋرالى
اقپارات تولتىرىڭىز: قايدان الىنعانىن, قاشان جاسالعانىن, كٴىم جاساعانىن,
تاعى باسقا بٴىلەتٴىڭٴىزدٴى. بۇل سۋرەت بولسا, مىناداي پٴىشٴىمٴىمەن كٴىرٴىستٴىرۋگە بولادى: <tt><nowiki>[[سۋرەت:$1|thumb|سيپاتتاماسى]]</nowiki></tt>',
'uploadwarning'               => 'قوتارۋ تۋرالى نازار سالۋ',
'savefile'                    => 'فايلدى ساقتاۋ',
'uploadedimage'               => '«[[$1]]» فايلىن قوتاردى',
'uploaddisabled'              => 'فايل قوتارۋى ٴوشٴىرٴىلگەن',
'uploaddisabledtext'          => 'وسى ۋيكيدە فايل قوتارۋى ٴوشٴىرٴىلگەن.',
'uploadscripted'              => 'وسى فايلدا, ۆەب شولعىشتى اعات تٴۇسٴىندٴىككە كەلتٴىرەتٴىڭ HTML بەلگٴىلەۋ, نە سكريپت كودى بار.',
'uploadcorrupt'               => 'وسى فايل بٴۇلدٴىرٴىلگەن, نە ٴادەپسٴىز كەڭەيتٴىمٴى بار. فايلدى تەكسەرٴىپ, قوتارۋىن قايتالاڭىز.',
'uploadvirus'                 => 'وسى فايلدا ۆيرۋس بولۋى مٴۇمكٴىن! ەگجەي-تەگجەي اقپاراتى: $1',
'sourcefilename'              => 'قاينارداعى فايل اتى',
'destfilename'                => 'اقىرعى فايل اتى',
'watchthisupload'             => 'وسى بەتتٴى باقىلاۋ',
'filewasdeleted'              => 'وسى اتاۋى بار فايل بۇرىن قوتارىلعان, سوسىن جويىلدىرىلعان. قايتا قوتارۋ الدىنان $1 دەگەندٴى تەكسەرٴىڭٴىز.',

'upload-proto-error'      => 'جارامسىز حاتتامالىق',
'upload-proto-error-text' => 'سىرتتان قوتارۋ ٴۇشٴىن URL جايلارى <code>http://</code> نەمەسە <code>ftp://</code> دەگەندەردەن باستالۋ قاجەت.',
'upload-file-error'       => 'ٴىشكٴى قاتە',
'upload-file-error-text'  => 'سەرۆەردە ۋاقىتشا فايل جاساۋى ٴىشكٴى قاتەگە ۇشىراستى. بۇل جٴۇيەنٴىڭ ٴاكٴىمشٴىمەن قاتىناسىڭىز.',
'upload-misc-error'       => 'بەلگٴىسٴىز قوتارۋ قاتەسٴى',
'upload-misc-error-text'  => 'قوتارۋ كەزٴىندە بەلگٴىسٴىز قاتە ۇشىراستى. قايسى URL جايى جارامدى جٴانە قاتىناۋلى ەكەنٴىن تەكسەرٴىپ شىعىڭىز دا قايتالاپ كٴورٴىڭٴىز. ەگەر بۇل مٴاسەلە ٴالدە دە قالسا, جٴۇيە ٴاكٴىمشٴىمەن قاتىناسىڭىز.',

# Some likely curl errors. More could be added from <http://curl.haxx.se/libcurl/c/libcurl-errors.html>
'upload-curl-error6'       => 'URL جايى جەتٴىلمەدٴى',
'upload-curl-error6-text'  => 'بەرٴىلگەن URL جايى جەتٴىلمەدٴى. قايسى URL جايى دۇرىس ەكەنٴىن جٴانە توراپ ٴىستە ەكەنٴىن قايتالاپ قاتاڭ تەكسەرٴىڭٴىز.',
'upload-curl-error28'      => 'قوتارۋعا بەرٴىلگەن ۋاقىت بٴىتتٴى',
'upload-curl-error28-text' => 'توراپتىڭ جاۋاپ بەرۋٴى تىم ۇزاق ۋاقىتقا سوزىلدى. بۇل توراپ ٴىستە ەكەنٴىن تەكسەرٴىپ شىعىڭىز, از ۋاقىت كٴىدٴىرە تۇرىڭىز دا تاعى قايتالاپ كٴورٴىڭٴىز. تالابىڭىزدى جٴۇكتەلۋٴى ازداۋ كەزٴىندە قايتالاۋعا بولمىس.',

'license'            => 'ليتسەنزيياسى',
'nolicense'          => 'ەشتەڭە تالعانباعان',
'upload_source_url'  => ' (جارامدى, بارشاعا قاتىناۋلى URL جاي)',
'upload_source_file' => ' (كومپييۋتەرٴىڭٴىزدەگٴى فايل)',

# Image list
'imagelist'                 => 'فايل تٴىزٴىمٴى',
'imagelisttext'             => "تٴومەندە ''$2'' سۇرىپتالعان '''$1''' فايل تٴىزٴىمٴى.",
'imagelistforuser'          => 'مىندا تەك $1 جٴۇكتەگەن سۋرەتتەر كٴورسەتٴىلەدٴى.',
'getimagelist'              => 'فايل تٴىزٴىمدەۋٴى',
'ilsubmit'                  => 'ٴىزدەۋ',
'showlast'                  => 'سوڭعى $1 فايل $2 سۇرىپتاپ كٴورسەت.',
'byname'                    => 'اتىمەن',
'bydate'                    => 'كٴۇن-ايمەن',
'bysize'                    => 'مٴولشەرٴىمەن',
'imgdelete'                 => 'جويۋ',
'imgdesc'                   => 'سيپپ.',
'imgfile'                   => 'فايل',
'imglegend'                 => 'شارتتى بەلگٴىلەر: (سيپپ.) — فايل سيپاتتاماسىن كٴورسەتۋ/ٴوڭدەۋ.',
'imghistory'                => 'فايل تاريحى',
'revertimg'                 => 'قايت.',
'deleteimg'                 => 'جويۋ',
'deleteimgcompletely'       => 'وسى فايلدىڭ بارلىق نۇسقالارىن جوي',
'imghistlegend'             => 'شارتتى بەلگٴىلەر: (اعىم.) = اعىمدىق فايل, (جويۋ) = ەسكٴى نۇسقاسىن
جويۋ, (قاي.) = ەسكٴى نۇسقاسىنا قايتارۋ.
<br /><i>قوتارىلعان فايلدى كٴورۋ ٴۇشٴىن كٴۇن-ايىنا نۇقىڭىز</i>.',
'imagelinks'                => 'سٴىلتەمەلەرٴى',
'linkstoimage'              => 'بۇل فايلعا كەلەسٴى بەتتەر سٴىلتەيدٴى:',
'nolinkstoimage'            => 'بۇل فايلعا ەش بەت سٴىلتەمەيدٴى.',
'sharedupload'              => 'بۇل فايل ورتاق ارقاۋىنا قوتارىلعان سوندىقتان باسقا جوبالاردا قولدانۋى مٴۇمكٴىن.',
'shareduploadwiki'          => 'بىلايعى اقپارات ٴۇشٴىن $1 دەگەندٴى قاراڭىز.',
'shareduploadwiki-linktext' => 'فايل سيپاتتاماسى بەتٴى',
'noimage'                   => 'مىناداي اتاۋلى فايل جوق, $1 مٴۇمكٴىندٴىگٴىڭٴىز بار.',
'noimage-linktext'          => 'وسىنى قوتارۋ',
'uploadnewversion-linktext' => 'بۇل فايلدىڭ جاڭا نۇسقاسىن قوتارۋ',
'imagelist_date'            => 'كٴۇن-ايى',
'imagelist_name'            => 'اتاۋى',
'imagelist_user'            => 'قاتىسۋشى',
'imagelist_size'            => 'مٴولشەرٴى (بايت)',
'imagelist_description'     => 'سيپاتتاماسى',
'imagelist_search_for'      => 'سۋرەتتٴى اتىمەن ٴىزدەۋ:',

# MIME search
'mimesearch' => 'فايلدى MIME تٴۇرٴىمەن ٴىزدەۋ',
'mimetype'   => 'MIME تٴۇرٴى:',
'download'   => 'جٴۇكتەۋ',

# Unwatched pages
'unwatchedpages' => 'باقىلانباعان بەتتەر',

# List redirects
'listredirects' => 'ايداتۋ بەت تٴىزٴىمٴى',

# Unused templates
'unusedtemplates'     => 'پايدالانىلماعان ٴۇلگٴىلەر',
'unusedtemplatestext' => 'بۇل بەت باسقا بەتكە كٴىرٴىcتٴىرٴىلمەگەن ٴۇلگٴى ەسٴىم اياىسىنداعى بارلىق بەتتەردٴى تٴىزٴىمدەيدٴى. ٴۇلگٴىلەردٴى جويۋ الدىنان بۇنىڭ باسقا سٴىلتەمەلەرٴىن تەكسەرٴىپ شىعۋىن ۇمىتپاڭىز',
'unusedtemplateswlh'  => 'باسقا سٴىلتەمەلەر',

# Random redirect
'randomredirect' => 'كەزدەيسوق ايداتۋ',

# Statistics
'statistics'             => 'جوبا ساناعى',
'sitestats'              => '{{SITENAME}} ساناعى',
'userstats'              => 'قاتىسۋشى ساناعى',
'sitestatstext'          => "مىنداعى دەرەكقوردا بۇلايشا '''$1''' بەت بار.
بۇنىڭ ٴىشٴىندە «تالقىلاۋ» بەتتەرٴى, {{SITENAME}} جوباسى تۋرالى بەتتەر, كٴىشكەنە «بٴىتەمە»
بەتتەر, ايداتۋلار, ماعلۇمات بەت دەپ سانالمايتىن, بٴالكٴىم, تاعى دا باسقالار.
وسىنى ەسەپتەن شىعارعاندا, مىندا ماعلۇماتتى دەپ سانالاتىن
'''$2''' بەت بار شىعار.

توراپقا '''$8''' فايل قوتارىلعان.

وسى ۋيكي جوباسى ورناتىلعاننان بەرٴى بۇلايشا بەتتەر '''$3''' رەت قارالعان,
جٴانە بەتتەر '''$4''' رەت ٴوڭدەلگەن.
بۇنىڭ نٴاتيجەسٴىندە ورتا ەسەپپەن بٴىر بەت سايىن '''$5''' ٴوڭدەۋ ٴىستەلٴىنگەن, جٴانە بٴىر ٴوڭدەۋ سايىن '''$6''' رەت قاراۋ كەلگەن.

اعىمدىق [http://meta.wikimedia.org/wiki/Help:Job_queue تاپسىرىم كەزەگٴى] ۇزىندىلىعى: '''$7'''.",
'userstatstext'          => "مىندا '''$1''' تٴىركەلگەن قاتىسۋشى بار, سونىڭ ٴىشٴىندە
'''$2''' (نەمەسە '''$4 %''') $5 بار.",
'statistics-mostpopular' => 'ەڭ كٴوپ قارالعان بەتتەر',

'disambiguations'     => 'ايرىقتى بەتتەر',
'disambiguationspage' => '{{ns:template}}:Disambig',
'disambiguationstext' => 'كەلەسٴى بەتتەر <i>ايرىقتى بەتكە</i> سٴىلتەيدٴى. بۇنىڭ ورنىنا بەلگٴىلٴى تاقىرىپقا سٴىلتەۋٴى قاجەت.<br />بەتكە $1 سٴىلتەگەن جاعدايدا, بەت ايرىقتى دەپ سانالادى.<br />باسقا ەسٴىم اياسىنان نۇسقايتىن سٴىلتەمەلەر مىندا <i>تٴىزٴىمدەلمەيدٴى</i>.',

'doubleredirects'     => 'شىنجىرلى ايداتۋلار',
'doubleredirectstext' => 'ٴاربٴىر جولداعى بٴىرٴىنشٴى مەن ەكٴىنشٴى ايداتۋ سٴىلتەمەلەرٴى بار, سونىمەن بٴىرگە ەكٴىنشٴى ايداتۋ مٴاتٴىننٴىڭ بٴىرٴىنشٴى جولى بار. ٴادەتتە بٴىرٴىنشٴى سٴىلتەمە ايدايتىن «شىن» اقىرعى بەتتٴىڭ اتاۋى بولۋى قاجەت.',

'brokenredirects'     => 'ەش بەتكە كەلتٴىرمەيتٴىن ايداتۋلار',
'brokenredirectstext' => 'كەلەسٴى ايداتۋلار جوق بەتتەرگە سٴىلتەيدٴى:',

# Miscellaneous special pages
'nbytes'                  => '$1 بايت',
'ncategories'             => '$1 سانات',
'nlinks'                  => '$1 سٴىلتەمە',
'nmembers'                => '$1 بۋىن',
'nrevisions'              => '$1 نۇسقا',
'nviews'                  => '$1 رەت قارالعان',
'lonelypages'             => 'ەش بەت سٴىلتەمەگەن بەتتەر',
'lonelypagestext'         => 'كەلەسٴى بەتتەرگە وسى جوباداعى باسقا بەتتەر سٴىلتەمەيدٴى.',
'uncategorizedpages'      => 'ەش ساناتقا كٴىرمەگەن بەتتەر',
'uncategorizedcategories' => 'ەش ساناتقا كٴىرمەگەن ساناتتار',
'uncategorizedimages'     => 'ەش ساناتقا كٴىرمەگەن سۋرەتتەر',
'unusedcategories'        => 'پايدالانىلماعان ساناتتار',
'unusedimages'            => 'پايدالانىلماعان فايلدار',
'popularpages'            => 'ٴايگٴىلٴى بەتتەر',
'wantedcategories'        => 'باستالماعان ساناتتار',
'wantedpages'             => 'باستالماعان بەتتەر',
'mostlinked'              => 'ەڭ كٴوپ سٴىلتەنگەن بەتتەر',
'mostlinkedcategories'    => 'ەڭ كٴوپ سٴىلتەنگەن ساناتتار',
'mostcategories'          => 'ەڭ كٴوپ ساناتتارعا كٴىرگەن بەتتەر',
'mostimages'              => 'ەڭ كٴوپ سٴىلتەنگەن سۋرەتتەر',
'mostrevisions'           => 'ەڭ كٴوپ تٴۇزەتٴىلگەن بەتتەر',
'allpages'                => 'بارلىق بەت تٴىزٴىمٴى',
'prefixindex'             => 'بەت باستاۋ تٴىزٴىمٴى',
'randompage'              => 'كەزدەيسوق بەت',
'shortpages'              => 'ەڭ قىسقا بەتتەر',
'longpages'               => 'ەڭ ٴۇلكەن بەتتەر',
'deadendpages'            => 'ەش بەتكە سٴىلتەمەيتٴىن بەتتەر',
'deadendpagestext'        => 'كەلەسٴى بەتتەر وسى جوباداعى باسقا بەتتەرگە سٴىلتەمەيدٴى.',
'listusers'               => 'بارلىق قاتىسۋشى تٴىزٴىمٴى',
'specialpages'            => 'ارنايى بەتتەر',
'spheading'               => 'بارشانىڭ ارنايى بەتتەرٴى',
'restrictedpheading'      => 'شەكتەۋلٴى ارنايى بەتتەر',
'recentchangeslinked'     => 'قاتىستى تٴۇزەتۋلەر',
'rclsub'                  => '(«$1» بەتٴىنەن سٴىلتەنگەن بەتتەرگە)',
'newpages'                => 'ەڭ جاڭا بەتتەر',
'newpages-username'       => 'قاتىسۋشى اتى:',
'ancientpages'            => 'ەڭ ەسكٴى بەتتەر',
'intl'                    => 'تٴىلارالىق سٴىلتەمەلەر',
'move'                    => 'جىلجىتۋ',
'movethispage'            => 'بەتتٴى جىلجىتۋ',
'unusedimagestext'        => '<p>ەسكەرتۋ: باسقا ۆەب توراپتار فايلدىڭ
URL جايىنا تٴىكەلەي سٴىلتەۋٴى مٴۇمكٴىن. سوندىقتان, بەلسەندٴى پايدالانۋىنا اڭعارماي,
وسى تٴىزٴىمدە قالۋى مٴۇمكٴىن.</p>',
'unusedcategoriestext'    => 'كەلەسٴى سانات بەتتەر بار بولىپ تۇر, بٴىراق وعان ەشقانداي بەت, نە سانات كٴىرمەيدٴى.',
'booksources'             => 'كٴىتاپ قاينارلارى',
'categoriespagetext'      => 'وسىندا ۋيكيدەگٴى بارلىق ساناتتارىنىڭ تٴىزٴىمٴى بەرٴىلٴىپ تۇر.',
'data'                    => 'دەرەكتەر',
'userrights'              => 'قاتىسۋشىلار قۇقىقتارىن مەڭگەرۋ',
'groups'                  => 'قاتىسۋشى توپتارى',
'booksourcetext'          => 'تٴومەندە جاڭا جٴانە قولدانعان كٴىتاپتار ساتاتىن
توراپتارىنىڭ سٴىلتەمەلەرٴى تٴىزٴىمدەلگەن. بۇل توراپتاردا ٴىزدەلگەن كٴىتاپتار
تۋرالى بىلايعى اقپارات بولۋعا مٴۇمكٴىن.',
'isbn'                    => 'ISBN بەلگٴىسٴى',
'alphaindexline'          => '$1 — $2',
'version'                 => 'جٴۇيە نۇسقاسى',
'log'                     => 'جۋرنالدار',
'alllogstext'             => 'بٴىرٴىككەن قوتارۋ, جويۋ, قورعاۋ, بۇعاتتاۋ جٴانە ٴاكٴىمشٴىلٴىك جۋرنالدارىن كٴورسەتۋ.
جۋرنال تٴۇرٴىن, قاتىسۋشى اتىن, تيٴىستٴى بەتٴىن تالعاپ, تارىلتىپ قاراۋىڭىزعا بولادى.',
'logempty'                => 'جۋرنالدا سٴايكەس دانالار جوق.',

# Special:Allpages
'nextpage'          => 'كەلەسٴى بەتكە ($1)',
'allpagesfrom'      => 'مىنا بەتتەن باستاپ كٴورسەتۋ:',
'allarticles'       => 'بارلىق بەت تٴىزٴىمٴى',
'allinnamespace'    => 'بارلىق بەت ($1 ەسٴىم اياسى)',
'allnotinnamespace' => 'بارلىق بەت ($1 ەسٴىم اياسىنان تىس)',
'allpagesprev'      => 'الدىڭعىعا',
'allpagesnext'      => 'كەلەسٴىگە',
'allpagessubmit'    => 'ٴوتۋ',
'allpagesprefix'    => 'مىنادان باستالعان بەتتەردٴى كٴورسەتۋ:',
'allpagesbadtitle'  => 'الىنعان بەت اتاۋى جارامسىز بولعان, نەمەسە تٴىل-ارالىق نە ۋيكي-ارالىق باستاۋى بار بولدى. اتاۋدا قولدانۋعا بولمايتىن نىشاندار بولۋى مٴۇمكٴىن.',

# Special:Listusers
'listusersfrom' => 'مىنا قاتىسۋشىدان باستاپ كٴورسەتۋ:',

# E-mail user
'mailnologin'     => 'ە-پوشتا جايى جٴىبەرٴىلگەن جوق',
'mailnologintext' => 'باسقا قاتىسۋشىعا حات جٴىبەرۋ ٴۇشٴىن
[[{{ns:special}}:Userlogin|كٴىرۋٴىڭٴىز]] قاجەت, جٴانە [[{{ns:special}}:Preferences|باپتاۋىڭىزدا]]
كۋٴالاندىرىلعان ە-پوشتا جايى بولۋى جٴون.',
'emailuser'       => 'قاتىسۋشىعا حات جازۋ',
'emailpage'       => 'قاتىسۋشىعا حات جٴىبەرۋ',
'emailpagetext'   => 'ەگەر بۇل قاتىسۋشى باپتاۋلارىندا كۋٴالاندىرعان ە-پوشتا
جايىن ەنگٴىزسە, تٴومەندەگٴى ٴۇلگٴىت ارقىلى بۇعان جالعىز ە-پوشتا حاتىن جٴىبەرۋگە بولادى.
قاتىسۋشى باپتاۋىڭىزدا ەنگٴىزگەن ە-پوشتا جايىڭىز
«كٴىمنەن» دەگەن باس جولاعىندا كٴورٴىنەدٴى, سوندىقتان
حات الۋشىسى تۋرا جاۋاپ بەرە الادى.',
'usermailererror' => 'Mail نىسانى قاتە قايتاردى:',
'defemailsubject' => '{{SITENAME}} ە-پوشتاسىنىڭ حاتى',
'noemailtitle'    => 'بۇل ە-پوشتا جايى ەمەس',
'noemailtext'     => 'وسى قاتىسۋشى جارامدى ە-پوشتا جايىن ەنگٴىزبەگەن,
نەمەسە باسقالاردان حات قابىلداۋىن ٴوشٴىرگەن.',
'emailfrom'       => 'كٴىمنەن',
'emailto'         => 'كٴىمگە',
'emailsubject'    => 'تاقىرىبى',
'emailmessage'    => 'حات',
'emailsend'       => 'جٴىبەرۋ',
'emailccme'       => 'حاتىمدىڭ كٴوشٴىرمەسٴىن ماعان دا جٴىبەر.',
'emailccsubject'  => '$1 دەگەنگە جٴىبەرٴىلگەن حاتىڭىزدىڭ كٴوشٴىرمەسٴى: $2',
'emailsent'       => 'حات جٴىبەرٴىلدٴى',
'emailsenttext'   => 'ە-پوشتا حاتىڭىز جٴىبەرٴىلدٴى.',

# Watchlist
'watchlist'            => 'باقىلاۋىم',
'watchlistfor'         => "('''$1''' باقىلاۋلارى)",
'nowatchlist'          => 'باقىلاۋ تٴىزٴىمٴىڭٴىزدە ەشبٴىر دانا جوق',
'watchlistanontext'    => 'باقىلاۋ تٴىزٴىمٴىڭٴىزدەگٴى دانالاردى قاراۋ, نە ٴوڭدەۋ ٴۇشٴىن $1 قاجەت.',
'watchlistcount'       => "'''باقىلاۋ تٴىزٴىمٴىڭٴىزدە (تالقىلاۋ بەتتەردٴى قوسا) $1 دانا بار.'''",
'clearwatchlist'       => 'باقىلاۋ تٴىزٴىمٴىن تازالاۋ',
'watchlistcleartext'   => 'سولاردى تولىق الاستاتۋعا باتىلسىز با?',
'watchlistclearbutton' => 'باقىلاۋ تٴىزٴىمٴىن تازالاۋ',
'watchlistcleardone'   => 'باقىلاۋ تٴىزٴىمٴىڭٴىز تازارتىلدى. $1 دانا الاستاتىلدى.',
'watchnologin'         => 'كٴىرمەگەنسٴىز',
'watchnologintext'     => 'باقىلاۋ تٴىزٴىمٴىڭٴىزدٴى ٴوزگەرتۋ ٴۇشٴىن [[{{ns:special}}:Userlogin|كٴىرۋٴىڭٴىز]] جٴون.',
'addedwatch'           => 'باقىلاۋ تٴىزٴىمٴىنە قوسىلدى',
'addedwatchtext'       => "«[[:$1]]» بەتٴى [[{{ns:special}}:Watchlist|باقىلاۋ تٴىزٴىمٴىڭٴىزگە]] قوسىلدى.
وسى بەتتٴىڭ جٴانە سونىڭ تالقىلاۋ بەتٴىنٴىڭ كەلەشەكتەگٴى ٴوزگەرٴىستەرٴى مىندا تٴىزٴىمدەلەدٴى.
سوندا بەتتٴىڭ اتاۋى تابۋعا جەڭٴىلدەتٴىپ [[{{ns:special}}:Recentchanges|جۋىقتاعى ٴوزگەرٴىستەر تٴىزٴىمٴىندە]]
'''جۋان ٴارپٴىمەن''' كٴورسەتٴىلەدٴى.

وسى بەتتٴى سوڭىنان باقىلاۋ تٴىزٴىمنەن الاستاتىڭىز كەلسە «باقىلاماۋ» پاراعىن نۇقىڭىز.",
'removedwatch'         => 'باقىلاۋ تٴىزٴىمٴىڭٴىزدەن الاستاتىلدى',
'removedwatchtext'     => '«[[:$1]]» بەتٴى باقىلاۋ تٴىزٴىمٴىڭٴىزدەن الاستاتىلدى.',
'watch'                => 'باقىلاۋ',
'watchthispage'        => 'بەتتٴى باقىلاۋ',
'unwatch'              => 'باقىلاماۋ',
'unwatchthispage'      => 'باقىلاۋدى توقتاتۋ',
'notanarticle'         => 'ماعلۇمات بەتٴى ەمەس',
'watchnochange'        => 'كٴورسەتٴىلگەن مەرزٴىمدە ەشبٴىر باقىلانعان دانا ٴوڭدەلگەن جوق.',
'watchdetails'         => "* باقىلاۋ تٴىزٴىمٴىندە (تالقىلاۋ بەتتەرٴىسٴىز) '''$1''' بەت بار.
* [[{{ns:special}}:Watchlist/edit|بٴۇكٴىل تٴىزٴىمدٴى قاراۋ جٴانە ٴوزگەرتۋ]].
* [[{{ns:special}}:Watchlist/clear|تٴىزٴىمدەگٴى بارلىق دانا الاستاتۋ]].",
'wlheader-enotif'      => '* ەسكەرتۋ حات جٴىبەرۋٴى ەندٴىرٴىلگەن.',
'wlheader-showupdated' => "* سوڭعى كٴىرگەنٴىمنەن بەرٴى تٴۇزەتٴىلگەن بەتتەردٴى '''جۋان''' مٴاتٴىنمەن كٴورسەت",
'watchmethod-recent'   => 'باقىلاۋلى بەتتەردٴىڭ جۋىقتاعى ٴوزگەرٴىستەرٴىن تەكسەرۋ',
'watchmethod-list'     => 'جۋىقتاعى ٴوزگەرٴىستەردە باقىلاۋلى بەتتەردٴى تەكسەرۋ',
'removechecked'        => 'بەلگٴىلەنگەندٴى باقىلاۋ تٴىزٴىمٴىنەن الاستاتۋ',
'watchlistcontains'    => 'باقىلاۋ تٴىزٴىمٴىڭٴىزدە $1 بەت بار.',
'watcheditlist'        => "وسىندا ٴالٴىپپەم سۇرىپتالعان باقىلانعان ماعلۇمات بەتتەرٴىڭٴىز تٴىزٴىمدەلٴىنگەن.
بەتتەردٴى الاستاتۋ ٴۇشٴىن ونىڭ قاسىنداعى قاباشاقتاردى بەلگٴىلەپ, تٴومەندەگٴى ''بەلگٴىلەنگەندٴى الاستات'' تٴۇيمەسٴىن نۇقىڭىز
(ماعلۇمات بەتٴىن جويعاندا تالقىلاۋ بەتٴى دە بٴىرگە جويىلادى).",
'removingchecked'      => 'سۇرانعان دانالاردى باقىلاۋ تٴىزٴىمنەن الاستاۋى…',
'couldntremove'        => '«$1» دەگەن دانا الاستاتىلمادى…',
'iteminvalidname'      => '«$1» داناسىنىڭ جارامسىز اتاۋىنان شاتاق تۋدى…',
'wlnote'               => 'تٴومەندە سوڭعى <b>$2</b> ساعاتتاعى, سوڭعى $1 ٴوزگەرٴىس كٴورسەتٴىلگەن.',
'wlshowlast'           => 'سوڭعى $1 ساعاتتاعى, $2 كٴۇندەگٴى, $3 بولعان ٴوزگەرٴىستٴى كٴورسەتۋ',
'wlsaved'              => 'بۇل باقىلۋ تٴىزٴىمٴىڭٴىزدٴىڭ ساقتالعان نۇسقاسى.',
'wlhideshowown'        => 'تٴۇزەتۋٴىمدٴى $1',
'wlhideshowbots'       => 'بوتتاردى $1',
'wldone'               => 'ٴىس بٴىتتٴى.',

'enotif_mailer'      => '{{SITENAME}} ەسكەرتۋ حات جٴىبەرۋ قىزمەتٴى',
'enotif_reset'       => 'بارلىق بەت كارالدٴى دەپ بەلگٴىلە',
'enotif_newpagetext' => 'مىناۋ جاڭا بەت.',
'changed'            => 'ٴوزگەرتتٴى',
'created'            => 'جاسادى',
'enotif_subject'     => '{{SITENAME}} جوباسىندا $PAGEEDITOR $PAGETITLE اتاۋلى بەتتٴى $CHANGEDORCREATED',
'enotif_lastvisited' => 'سوڭعى كٴىرۋٴىڭٴىزدەن بەرٴى بولعان ٴوزگەرٴىستەر ٴۇشٴىن $1 دەگەندٴى قاراڭىز.',
'enotif_body'        => 'قۇرمەتتٴى $WATCHINGUSERNAME,

{{SITENAME}} جوباسىدا $PAGEEDITDATE كەزٴىندە $PAGEEDITOR $PAGETITLE اتاۋلى بەتتٴى $CHANGEDORCREATED, اعىمدىق نۇسقاسىن $PAGETITLE_URL جايىنان قاراڭىز.

$NEWPAGE

ٴوڭدەۋشٴى سيپاتتاماسى: $PAGESUMMARY $PAGEMINOREDIT

ٴوڭدەۋشٴىمەن قاتىناسۋ:
ە-پوشتا: $PAGEEDITOR_EMAIL
ۋيكي: $PAGEEDITOR_WIKI

بىلايعى ٴوزگەرٴىستەر بولعاندا دا سٴىز وسى بەتكە بارعانشا دەيٴىن ەشقانداي باسقا ەسكەرتۋ حاتتار جٴىبەرٴىلمەيدٴى. سونىمەن قاتار باقىلاۋ تٴىزٴىمٴىڭٴىزدەگٴى بەت ەسكەرتپەلٴىك بەلگٴىسٴىن ٴادەپكە كٴۇيٴىنە كەلتٴىرٴىڭٴىز.

             سٴىزدٴىڭ دوستى {{SITENAME}} ەسكەرتۋ قىزمەتٴى

----
باقىلاۋ تٴىزٴىمٴىڭٴىزدٴى باپتاۋ ٴۇشٴىن, مىندا بارىڭىز
{{fullurl:{{ns:special}}:Watchlist/edit}}

سىن-پٴىكٴىر بەرۋ جٴانە بىلايعى جٴاردەم الۋ ٴۇشٴىن:
{{fullurl:{{ns:help}}:مازمۇنى}}',

# Delete/protect/revert
'deletepage'                  => 'بەتتٴى جويۋ',
'confirm'                     => 'راستاۋ',
'excontent'                   => 'بولعان ماعلۇماتى: «$1»',
'excontentauthor'             => 'بولعان ماعلۇماتى: «$1» (تەك «[[Special:Contributions/$2|$2]]» ٴۇلەسٴى)',
'exbeforeblank'               => 'تازارتۋ الدىنداعى بولعان ماعلۇماتى: «$1»',
'exblank'                     => 'بەت بوستى بولدى',
'confirmdelete'               => 'جويۋدى راستاۋ',
'deletesub'                   => '(«$1» جويۋى)',
'historywarning'              => 'نازار سالىڭىز: جويۋعا ارنالعان بەتتە ٴوز تاريحى بار:',
'confirmdeletetext'           => 'بەتتٴى نەمەسە سۋرەتتٴى بارلىق تاريحىمەن
بٴىرگە دەرەكقوردان ٴاردايىم جويىعىڭىز كەلەتٴىن سيياقتى.
بۇنى جويۋدىڭ زاردابىن تٴۇسٴىنٴىپ شىن نيەتتەنگەنٴىڭٴىزدٴى, جٴانە
[[{{ns:project}}:ساياسات]]قا لايىقتى دەپ
سەنگەنٴىڭٴىزدٴى راستاڭىز.',
'actioncomplete'              => 'ٴارەكەت بٴىتتٴى',
'deletedtext'                 => '«$1» جويىلدى.
جۋىقتاعى جويۋلار تۋرالى جازبالارىن $2 دەگەننەن قاراڭىز.',
'deletedarticle'              => '«[[$1]]» بەتٴىن جويدى',
'dellogpage'                  => 'جويۋ_جۋرنالى',
'dellogpagetext'              => 'تٴومەندە جۋىقتاعى جويۋلاردىڭ تٴىزٴىمٴى بەرٴىلگەن.',
'deletionlog'                 => 'جويۋ جۋرنالى',
'reverted'                    => 'ەرتەرەك نۇسقاسىنا قايتارىلعان',
'deletecomment'               => 'جويۋدىڭ سەبەبٴى',
'imagereverted'               => 'ەرتەرەك نۇسقاسىنا قايتارۋ سٴاتتٴى ٴوتتٴى.',
'rollback'                    => 'تٴۇزەتۋلەردٴى قايتارۋ',
'rollback_short'              => 'قايتارۋ',
'rollbacklink'                => 'قايتارۋ',
'rollbackfailed'              => 'قايتارۋ سٴاتسٴىز اياقتالدى',
'cantrollback'                => 'تٴۇزەتۋ قايتارىلمايدى. بۇل بەتتٴىڭ سوڭعى ٴۇلەسكەرٴى تەك باستاۋىش اۋتورى.',
'alreadyrolled'               => '[[{{ns:user}}:$2|$2]] ([[{{ns:user_talk}}:$2|تالقىلاۋى]]) دەگەندٴى جاساعان [[:$1]]
بەتٴىنٴىڭ سوڭعى ٴوڭدەۋٴىنەن قايتارۋ ٴوتپەدٴى; كەيبٴىرەۋ وسى قازٴىر بەتتٴى ٴوڭدەپ نە قايتارىپ جاتىر تٴۇگە.

سوڭعى ٴوڭدەۋدٴى [[{{ns:user}}:$3|$3]] ([[{{ns:user_talk}}:$3|تالقىلاۋى]]) دەگەندٴى جاساعان.',
'editcomment'                 => 'تٴۇزەتۋدٴىڭ بولعان مٴاندەمەسٴى: "<i>$1</i>".', # only shown if there is an edit comment
'revertpage'                  => '[[{{ns:special}}:Contributions/$2|$2]] ([[{{ns:user_talk}}:$2|تالقىلاۋى]]) تٴۇزەتۋٴىنەن [[{{ns:user}}:$1|$1]] سوڭعى نۇسقاسىنا قايتاردى',
'sessionfailure'              => 'كٴىرۋ سەسسيياسىندا شاتاق بولعان سيياقتى;
سەسسيياعا شابۋىلداۋداردان قورعانۋ ٴۇشٴىن, وسى ٴارەكەت توقتاتىلدى.
«ارتقا» تٴۇيمەسٴىن باسىڭىز, جٴانە بەتتٴى كەرٴى جٴۇكتەڭٴىز, سوسىن قايتالاپ كٴورٴىڭٴىز.',
'protectlogpage'              => 'قورعاۋ_جۋرنالى',
'protectlogtext'              => 'تٴومەندە بەتتەردٴىڭ قورعاۋ/قورعاماۋ تٴىزٴىمٴى بەرٴىلگەن.',
'protectedarticle'            => '«$1» قورعالدى',
'unprotectedarticle'          => '«[[$1]]» قورعالمادى',
'protectsub'                  => '(«$1» قورعاۋدا)',
'confirmprotecttext'          => 'وسى بەتتٴى راسىندا دا قورعاۋ قاجەت پە?',
'confirmprotect'              => 'قورعاۋدى راستاۋ',
'protectmoveonly'             => 'تەك جىلجىتۋدان قورعاۋ',
'protectcomment'              => 'قورعاۋ سەبەبٴى',
'unprotectsub'                => '(«$1» قورعاماۋدا)',
'confirmunprotecttext'        => 'وسى بەتتٴى راستان قورعاماۋ قاجەت پە?',
'confirmunprotect'            => 'قورعاماۋدى راستاۋ',
'unprotectcomment'            => 'قورعاماۋ سەبەبٴى',
'protect-unchain'             => 'جىلجىتۋعا رۇقسات بەرۋ',
'protect-text'                => '<strong>$1</strong> بەتٴىنٴىڭ قورعاۋ دەڭگەيٴىن قاراي جٴانە ٴوزگەرتە الاسىز.',
'protect-viewtext'            => 'تٴىركەلگٴىڭٴىز بەت قورعانىسى دەنگەيلەرٴىن ٴوزگەرتۋگە رۇقسات بەرمەيدٴى.
مىنا <strong>$1</strong> بەتتٴىڭ اعىمدىق باپتاۋلارى:',
'protect-default'             => '(ٴادەپكٴى)',
'protect-level-autoconfirmed' => 'تٴىركەلگٴىسٴىز پايدالانۋشىلارعا تيىم',
'protect-level-sysop'         => 'تەك ٴاكٴىمشٴىلەرگە رۇقسات',

# Restrictions (nouns)
'restriction-edit' => 'ٴوڭدەۋ',
'restriction-move' => 'جىلجىتۋ',

# Undelete
'undelete'                 => 'جويىلعان بەتتەردٴى قاراۋ',
'undeletepage'             => 'جويىلعان بەتتەردٴى قاراۋ جٴانە قايتارۋ',
'viewdeletedpage'          => 'جويىلعان بەتتەردٴى قاراۋ',
'undeletepagetext'         => 'كەلەسٴى بەتتەر جويىلدى دەپ بەلگٴىلەنگەن, بٴىراق ماعلۇماتى مۇراعاتتا جاتقان,
سوندىقتان كەرٴى قايتارۋعا ٴازٴىر. مۇراعات مەرزٴىم بويىنشا تازالانىپ تۇرۋى مٴۇمكٴىن.',
'undeleteextrahelp'        => "بٴۇكٴىل بەتتٴى قايتارۋ ٴۇشٴىن, بارلىق قاباشاقتاردى بوس قالدىرىپ
'''''قايتار!''''' تٴۇيمەسٴىن نۇقىڭىز. بٴولەكشە قايتارۋ ورىنداۋ ٴۇشٴىن, قايتارايىن دەگەن نۇسقالارىنا سٴايكەس
قاباشاقتارىن بەلگٴىلەڭٴىز دە, جٴانە '''''قايتار!''''' تٴۇيمەسٴىن نۇقىڭىز. '''''تاستا''''' تٴۇيمەسٴىن
نۇقىعاندا مٴاندەمە اۋماعى مەن بارلىق قاباشاقتار تازالانادى.",
'undeletearticle'          => 'جويىلعان بەتتٴى قايتارۋ',
'undeleterevisions'        => '$1 نۇسقا مۇراعاتتالعان',
'undeletehistory'          => 'ەگەر بەت ماعلۇماتىن قايتارساڭىز,تاريحىندا بارلىق نۇسقالار دا
قايتارىلادى. ەگەر جويۋدان سوڭ دٴال سولاي اتاۋىمەن جاڭا بەت جاسالسا, قايتارىلعان نۇسقالار
تاريحتىڭ ەڭ ادىندا كٴورسەتٴىلەدٴى, جٴانە كٴورسەتٴىلٴىپ تۇرعان بەتتٴىڭ اعىمدىق نۇسقاسى
ٴوزدٴىك تٴۇردە الماستىرىلمايدى.',
'undeletehistorynoadmin'   => 'بۇل بەت جويىلعان. جويۋ سەبەبٴى الدىنداعى ٴوڭدەگەن قاتىسۋشىلار
ەگجەي-تەگجەيلەرٴىمەن بٴىرگە تٴومەندەگٴى سيپاتتاماسىندا كٴورسەتٴىلگەن.
وسى جويىلعان نۇسقالاردىڭ مٴاتٴىنٴى تەك ٴاكٴىمشٴىلەرگە قاتىناۋلى.',
'undeleterevision'         => '$1 كەزٴىندەگٴى جويىلعان نۇسقاسىن',
'undeleterevision-missing' => 'جارامسىز نە جوعالعان نۇسقا. سٴىلتەمەڭٴىز جارامسىز بولۋى مٴۇمكٴىن, نە
نۇسقا قايتارىلعان تٴۇگە نەمەسە مۇراعاتتان الاستاتىلعان.',
'undeletebtn'              => 'قايتار!',
'undeletereset'            => 'تاستا',
'undeletecomment'          => 'مٴاندەمەسٴى:',
'undeletedarticle'         => '«[[$1]]» قايتاردى',
'undeletedrevisions'       => '$1 نۇسقاسى قايتارىلعان',
'undeletedrevisions-files' => '$1 نۇسقا جٴانە $2 فايل قايتارىلدى',
'undeletedfiles'           => '$1 فايل قايتارىلدى',
'cannotundelete'           => 'قايتارۋ سٴاتسٴىز بٴىتتٴى; تاعى بٴىرەۋ سٴىزدەن بۇرىن سول بەتتٴى قايتارعان بولار.',
'undeletedpage'            => "<big>'''$1 قايتارىلدى'''</big>

جۋىقتاعى جويۋ مەن قايتارۋ جٴونٴىندە [[{{ns:special}}:Log/delete|جويۋ جۋرنالىن]] قاراڭىز.",

# Namespace form on various pages
'namespace' => 'ەسٴىم اياسى:',
'invert'    => 'تالعاۋدى كەرٴىلەۋ',

# Contributions
'contributions' => 'قاتىسۋشى ٴۇلەسٴى',
'mycontris'     => 'ٴۇلەسٴىم',
'contribsub'    => '$1 ٴۇلەسٴى',
'nocontribs'    => 'وسى ٴىزدەۋ شارتىنا سٴايكەس ٴوزگەرٴىستەر تابىلعان جوق.',
'ucnote'        => 'تٴومەندە وسى قاتىسۋشىنىڭ سوڭعى <b>$2</b> كٴۇندەگٴى, سوڭعى <b>$1</b> ٴوزگەرٴىسٴى كٴورسەتلەدٴى.',
'uclinks'       => 'سوڭعى $2 كٴۇندەگٴى, سوڭعى $1 ٴوزگەرٴىسٴىن قاراۋ.',
'uctop'         => ' (ٴۇستٴى)',
'newbies'       => 'جاڭا قاتىسۋشىلار',

'sp-newimages-showfrom' => '$1 كەزٴىنەن بەرٴى — جاڭا سۋرەتتەردٴى كٴورسەت',

'sp-contributions-newest'      => 'ەڭ جاڭاسىنا',
'sp-contributions-oldest'      => 'ەڭ ەسكٴىسٴىنە',
'sp-contributions-newer'       => 'جاڭالاۋ $1',
'sp-contributions-older'       => 'ەسكٴىلەۋ $1',
'sp-contributions-newbies-sub' => 'جاڭا قاتىسۋشىلارعا',

# What links here
'whatlinkshere' => 'سٴىلتەگەن بەتتەر',
'notargettitle' => 'اقىرعى اتاۋ جوق',
'notargettext'  => 'وسى ٴارەكەت ورىندالاتىن نىسانا بەت,
نە قاتىسۋشى كٴورسەتٴىلمەگەن.',
'linklistsub'   => '(سٴىلتەمەلەر تٴىزٴىمٴى)',
'linkshere'     => "'''[[:$1]]''' دەگەنگە مىنا بەتتەر سٴىلتەيدٴى:",
'nolinkshere'   => "'''[[:$1]]''' دەگەنگە ەش بەت سٴىلتەمەيدٴى.",
'isredirect'    => 'ايداتۋ بەتٴى',
'istemplate'    => 'كٴىرٴىكتٴىرۋ',

# Block/unblock
'blockip'                     => 'پايدالانۋشىنى بۇعاتتاۋ',
'blockiptext'                 => 'تٴومەندەگٴى ٴۇلگٴىت پايدالانۋشىنىڭ جازۋ رۇقساتىن
بەلگٴىلٴى IP جايىمەن نە اتاۋىمەن بۇعاتتاۋ ٴۇشٴىن قولدانىلادى.
بۇنى تەك بۇزاقىلىققا كەدەرگٴى ٴىستەۋ ٴۇشٴىن جٴانە دە
[[{{ns:project}}:ساياسات|ساياسات]] بويىنشا اتقارۋىڭىز جٴون.
تٴومەندە تيٴىستٴى سەبەبٴىن تولتىرىپ كٴورسەتٴىڭٴىز (مىسالى, دٴايەككە بۇزاقىلىقپەن
ٴوزگەرتكەن بەتتەردٴى كەلتٴىرٴىپ).',
'ipaddress'                   => 'IP جاي',
'ipadressorusername'          => 'IP جاي نە قاتىسۋشى اتى',
'ipbexpiry'                   => 'بٴىتەتٴىن مەرزٴىمٴى',
'ipbreason'                   => 'سەبەبٴى',
'ipbanononly'                 => 'تەك تٴىركەلگٴىسٴىزدٴى بۇعاتتاۋ',
'ipbcreateaccount'            => 'تٴىركەلگٴى جاساۋىن كەدەرگٴىلەۋ',
'ipbenableautoblock'          => 'بۇل قاتىسۋشىنىڭ قولدانعان سوڭعى IP جايىن, جٴانە ٴارقايسى كەيٴىن تٴۇزەتۋ ٴىستەۋگە ٴۇمٴىتەلٴىگەن جايلارىن ٴوزدٴىك تٴۇردە بۇعاتتاۋ',
'ipbsubmit'                   => 'پايدالانۋشىنى بۇعاتتاۋ',
'ipbother'                    => 'باسقا مەرزٴىم',
'ipboptions'                  => '2 ساعات:2 hours,1 كٴۇن:1 day,3 كٴۇن:3 days,1 اپتا:1 week,2 اپتا:2 weeks,1 اي:1 month,3 اي:3 months,6 اي:6 months,1 جىل:1 year,مٴانگٴى:infinite',
'ipbotheroption'              => 'باسقا',
'badipaddress'                => 'جارامسىز IP جاي',
'blockipsuccesssub'           => 'بۇعاتتاۋ سٴاتتٴى ٴوتتٴى',
'blockipsuccesstext'          => '[[{{ns:special}}:Contributions/$1|$1]] دەگەن بۇعاتتالعان.
<br />بۇعاتتاۋلاردى [[{{ns:special}}:Ipblocklist|IP بۇعاتتاۋ تٴىزٴىمٴىندە]] قاراپ شىعىڭىز.',
'unblockip'                   => 'پايدالانۋشىنى بۇعاتتاماۋ',
'unblockiptext'               => 'تٴومەندەگٴى ٴۇلگٴىت بەلگٴىلٴى IP جايىمەن نە اتاۋىمەن
بۇرىن بۇعاتتالعان پايدالانۋشىنىڭ جازۋ رۇقساتىن قايتارۋ ٴۇشٴىن قولدانىلادى.',
'ipusubmit'                   => 'وسى جايدى بۇعاتتاماۋ',
'unblocked'                   => '[[{{ns:user}}:$1|$1]] بۇعاتتاۋى ٴوشٴىرٴىلدٴى',
'ipblocklist'                 => 'بۇعاتتالعان پايدالانۋشى / IP- جاي تٴىزٴىمٴى',
'blocklistline'               => '$1, $2 «$3» دەگەندٴى بۇعاتتادى ($4)',
'infiniteblock'               => 'مٴانگٴى',
'expiringblock'               => 'بٴىتۋٴى: $1',
'anononlyblock'               => 'تەك تٴىركەلگٴىسٴىزدٴى',
'noautoblockblock'            => 'ٴوزدٴىك بۇعاتتاۋ ٴوشٴىرٴىلەنگەن',
'createaccountblock'          => 'تٴىركەلگٴى جاساۋى بۇعاتتالعان',
'ipblocklistempty'            => 'بۇعاتتاۋ تٴىزٴىمٴى بوس.',
'blocklink'                   => 'بۇعاتتاۋ',
'unblocklink'                 => 'بۇعاتتاماۋ',
'contribslink'                => 'ٴۇلەسٴى',
'autoblocker'                 => "IP جايىڭىزدى جۋىقتا «[[{{ns:user}}:1|$1]]» پايدالانعان, سوندىقتان ٴوزدٴىك تٴۇردە بۇعاتتالعان. $1 بۇعاتتاۋ سەبەبٴى: «'''$2'''».",
'blocklogpage'                => 'بۇعاتتاۋ_جۋرنالى',
'blocklogentry'               => '«[[$1]]» بۇعاتتادى, بٴىتەتٴىن مەرزٴىمٴى: $2',
'blocklogtext'                => 'بۇل پايدالانۋشىلاردى بۇعاتتاۋ/بۇعاتتاماۋ ٴارەكەتتەرٴىنٴىڭ جۋرنالى. ٴوزدٴىك تٴۇردە
بۇعاتتالعان IP جايلار وسىندا تٴىزٴىمدەلگەمەگەن. اعىمداعى بەلسەندٴى بۇعاتتاۋلارىن
[[{{ns:special}}:Ipblocklist|IP بۇعاتتاۋ تٴىزٴىمٴىنەن]] قاراۋعا بولادى.',
'unblocklogentry'             => '«$1» بۇعاتتاۋىن ٴوشٴىردٴى',
'range_block_disabled'        => 'اۋقىم بۇعاتتاۋىن جاساۋ ٴاكٴىمشٴىلٴىك مٴۇمكٴىندٴىگٴى ٴوشٴىرٴىلگەن.',
'ipb_expiry_invalid'          => 'بٴىتەتٴىن ۋاقىتى جارامسىز.',
'ipb_already_blocked'         => '«$1» بۇعاتتالعان تٴۇگە',
'ip_range_invalid'            => 'IP جاي اۋقىمى جارامسىز.',
'proxyblocker'                => 'پروكسي سەرۆەرلەردٴى بۇعاتتاۋىش',
'ipb_cant_unblock'            => 'قاتە: IP $1 بۇعاتتاۋى تابىلمادى. ونىڭ بۇعاتتاۋى ٴوشٴىرلگەن سيياقتى.',
'proxyblockreason'            => 'IP جايىڭىز اشىق پروكسي سەرۆەرگە جاتاتىندىقتان بۇعاتتالعان. ينتەرنەت قىزمەتٴىن جابدىقتاۋشىڭىزبەن, نە تەحنيكالىق مەدەۋ قىزمەتٴىمەن قاتىناسىڭىز, جٴانە ولارعا وسى وتە كٴۇردەلٴى قاۋىپسٴىزدٴىك شاتاق تۋرالى اقپارات بەرٴىڭٴىز.',
'proxyblocksuccess'           => 'بٴىتتٴى.',
'sorbs'                       => 'DNSBL قارا تٴىزٴىمٴى',
'sorbsreason'                 => 'سٴىزدٴىڭ IP جايىڭىز وسى توراپتا قولدانىلعان DNSBL قارا تٴىزٴىمٴىندەگٴى اشىق پروكسي-سەرۆەر دەپ تابىلادى.',
'sorbs_create_account_reason' => 'سٴىزدٴىڭ IP جايىڭىز وسى توراپتا قولدانىلعان DNSBL قارا تٴىزٴىمٴىندەگٴى اشىق پروكسي-سەرۆەر دەپ تابىلادى. تٴىركەلگٴى جاساي المايسىز.',

# Developer tools
'lockdb'              => 'دەرەكقوردى قۇلىپتاۋ',
'unlockdb'            => 'دەرەكقوردى قۇلىپتاماۋ',
'lockdbtext'          => 'دەرەكقوردىن قۇلىپتالۋى بارلىق پايدالانۋشىنىڭ
بەت ٴوڭدەۋ, باپتاۋىن قالاۋ, باقىلاۋ تٴىزٴىمٴىن, تاعى باسقا
دەرەكقوردى ٴوزگەرتەتٴىن مٴۇمكٴىندٴىكتەرٴىن توقتاتا تۇرادى.
وسى ماقساتىڭىزدى, جٴانە جٴوندەۋٴىڭٴىز بٴىتكەندە
دەرەكقوردى اشاتىڭىزدى راستاڭىز.',
'unlockdbtext'        => 'دەرەكقودىن اشىلۋى بارلىق پايدالانۋشىنىڭ بەت ٴوڭدەۋ,
باپتاۋىن قالاۋ, باقىلاۋ تٴىزٴىمٴىن, تاعى باسقا دەرەكقوردى ٴوزگەرتەتٴىن
مٴۇمكٴىندٴىكتەرٴىن قايتا اشادى.
وسى ماقساتىڭىزدى راستاڭىز.',
'lockconfirm'         => 'يٴا, مەن دەرەكقوردى راستان قۇلىپتايمىن.',
'unlockconfirm'       => 'يٴا, مەن دەرەكقوردى راستان قۇلىپتامايمىن.',
'lockbtn'             => 'دەرەكقوردى قۇلىپتا',
'unlockbtn'           => 'دەرەكقوردى قۇلىپتاما',
'locknoconfirm'       => 'راستاۋ بەلگٴىسٴىن قويماپسىز.',
'lockdbsuccesssub'    => 'دەرەكقوردى قۇلىپتاۋ سٴاتتٴى ٴوتتٴى',
'unlockdbsuccesssub'  => 'قۇلىپتالعان دەرەكقور اشىلدى',
'lockdbsuccesstext'   => 'دەرەكقور قۇلىپتالدى.
<br />جٴوندەۋٴىڭٴىز بٴىتكەننەن كەيٴىن [[{{ns:special}}:Unlockdb|قۇلىپتاۋىن ٴوشٴىرۋگە]] ۇمىتپاڭىز.',
'unlockdbsuccesstext' => 'قۇلىپتالعان دەرەكقور سٴاتتٴى اشىلدى.',
'lockfilenotwritable' => 'دەرەكقور قۇلىپتاۋ فايلى جازىلمايدى. دەرەكقوردى قۇلىپتاۋ نە اشۋ ٴۇشٴىن, ۆەب-سەرۆەر فايلعا جازۋ رۇقساتى بولۋ قاجەت.',
'databasenotlocked'   => 'دەرەكقور قۇلىپتالعان جوق.',

# Make sysop
'makesysoptitle'     => 'قاتىسۋشىنى ٴاكٴىمشٴى قىلۋ',
'makesysoptext'      => 'بۇل ٴۇلگٴىتتٴى قاراپايىم قاتىسۋشىنى ٴاكٴىمشٴى قىلۋ ٴۇشٴىن تٴورەشٴىلەر قولدانادى.
جولاققا قاتىسۋشى اتىن ەنگٴىزٴىڭٴىز دە, جٴانە بۇل قاتىسۋشىنى ٴاكٴىمشٴى قىلۋ ٴۇشٴىن, تٴۇيمەنٴى باسىڭىز.',
'makesysopname'      => 'قاتىسۋشى اتى:',
'makesysopsubmit'    => 'بۇل قاتىسۋشىنى ٴاكٴىمشٴى قىل',
'makesysopok'        => '<b>«$1» دەگەن قاتىسۋشى ەندٴى ٴاكٴىمشٴى بوپ تاعايىندالدى</b>',
'makesysopfail'      => '<b>«$1» دەگەن قاتىسۋشى ٴاكٴىمشٴى بوپ تاعايىندالمادى. (اتىن دۇرىس ەنگٴىزدٴىڭٴىز بە?)</b>',
'setbureaucratflag'  => 'قاتىسۋشىنى تٴورەشٴى قىلۋ',
'rightslog'          => 'قاتىسۋشى_قۇقىقتارى_جۋرنالى',
'rightslogtext'      => 'بۇل پايدالانۋشى قۇقىقتارىن ٴوزگەرتۋ جۋرنالى.',
'rightslogentry'     => ' $1 توپ مٴۇشەلگٴىن $2 دەگەننەن $3 دەگەنگە ٴوزگەرتتٴى',
'rights'             => 'قۇقىقتارى:',
'set_user_rights'    => 'قاتىسۋشى قۇقىقتارىن تاعايىنداۋ',
'user_rights_set'    => '<b>«$1» دەگەن قاتىسۋشىنىڭ قۇقىقتارى جاڭارتىلدى</b>',
'set_rights_fail'    => '<b>«$1» دەگەن قاتىسۋشىنىڭ قۇقىقتارى تاعايىندالمادى. (اتىن دۇرىس ەنگٴىزدٴىڭٴىز بە?)</b>',
'makesysop'          => 'قاتىسۋشىنى ٴاكٴىمشٴى قىلۋ',
'already_sysop'      => 'بۇل قاتىسۋشى ٴاكٴىمشٴى بوپتى تٴۇگە',
'already_bureaucrat' => 'بۇل قاتىسۋشى تورەشٴى بوپتى تٴۇگە',
'rightsnone'         => '(ەشقانداي)',

# Move page
'movepage'                => 'بەتتٴى جىلجىتۋ',
'movepagetext'            => "تٴومەندەگٴى ٴۇلگٴىتتٴى قولدانىپ بەتتەردٴى قايتا اتايدى,
بارلىق تاريحىن جاڭا اتاۋعا جىلجىتادى.
بۇرىنعى بەت اتاۋى جاڭا اتاۋعا ايداتاتىن بەت بولادى.
ەسكٴى اتاۋىنا سٴىلتەيتٴىن  سٴىلتەمەلەر ٴوزگەرتٴىلمەيدٴى; جىلجىتۋدان سوڭ
شىنجىرلى ايداتۋلار بار-جوعىن تەكسەرٴىڭٴىز.
سٴىلتەمەلەر بۇرىنعى جولداۋىمەن بىلايعى ٴوتۋٴىن تەكسەرۋٴىنە
سٴىز مٴىندەتتٴى بولاسىز.

ەسكەرٴىڭٴىز, ەگەر جىلجىتىلاتىن اتاۋدا بەت بولسا, سول ەسكٴى بەتكە ايداتۋ
بولعانشا جٴانە تاريحى بولسا, بەت '''جىلجىتىلمايدى'''.
وسىنىڭ ماعىناسى: ەگەر بەتتٴى قاتەلٴىك پەن قايتا اتالسا,
بۇرىنعى اتاۋىنا قايتا اتاۋعا بولادى,
بٴىراق بار بەتتٴىڭ ٴۇستٴىنە جازۋعا بولمايدى.

<b>نازار سالىڭىز!</b>
بۇل دٴارٴىپتٴى بەتكە قاتاڭ جٴانە كەنەت ٴوزگەرٴىس جاساۋعا مٴۇمكٴىن;
ٴارەكەتتٴىڭ الدىنان وسىنىڭ زارداپتارىن تٴۇسٴىنگەنٴىڭٴىزگە باتىل
بولىڭىز.",
'movepagetalktext'        => "كەلەسٴى سەبەپتەر '''بولعانشا''' دەيٴىن, تالقىلاۋ بەتٴى ٴوزدٴىك تٴۇردە بٴىرگە جىلجىتىلادى:
* بوس ەمەس تالقىلاۋ بەتٴى جاڭا اتاۋدا بولعاندا, نەمەسە
* تٴومەندەگٴى قابىشاقتا بەلگٴىنٴى الاستاتقاندا.

وسى ورايدا, قالاۋىڭىز بولسا, بەتتٴى قولدان جىلجىتا نە قوسا الاسىز.",
'movearticle'             => 'بەتتٴى جىلجىتۋ',
'movenologin'             => 'جٴۇيەگە كٴىرمەگەنسٴىز',
'movenologintext'         => 'بەتتٴى جىلجىتۋ ٴۇشٴىن تٴىركەلگەن بولۋىڭىز جٴانە
 [[{{ns:special}}:Userlogin|كٴىرۋٴىڭٴىز]] قاجەت.',
'newtitle'                => 'جاڭا اتاۋعا',
'movepagebtn'             => 'بەتتٴى جىلجىت',
'pagemovedsub'            => 'جىلجىتۋ سٴاتتٴى اياقتالدى',
'pagemovedtext'           => '«[[$1]]» بەتٴى «[[$2]]» بەتٴىنە جىلجىتىلدى.',
'articleexists'           => 'بىلاي اتاۋلى بەت بار بولدى, نە تاڭداعان
اتاۋىڭىز جارامدى ەمەس.
باسقا اتاۋ تانداڭىز',
'talkexists'              => "'''بەتتٴىڭ ٴوزٴى سٴاتتٴى جىلجىتىلدى, بٴىراق تالقىلاۋ بەتٴى بٴىرگە جىلجىتىلمادى, ونىڭ سەبەبٴى جاڭا اتاۋدىڭ تالقىلاۋ بەتٴى بار تٴۇگە. بۇنى قولمەن قوسىڭىز.'''",
'movedto'                 => 'مىناعان جىلجىتىلدى:',
'movetalk'                => 'قاتىستى تالقىلاۋ بەتٴىمەن بٴىرگە جىلجىتۋ',
'talkpagemoved'           => 'قاتىستى تالقىلاۋ بەتٴى دە جىلجىتىلدى.',
'talkpagenotmoved'        => 'قاتىستى تالقىلاۋ بەتٴى <strong>جىلجىتىلمادى</strong>.',
'1movedto2'               => '«[[$1]]» بەتٴىندە ايداتۋ قالدىرىپ «[[$2]]» بەتٴىنە جىلجىتتى',
'1movedto2_redir'         => '«[[$1]]» بەتٴىن «[[$2]]» ايداتۋ بەتٴىنٴىڭ ٴۇستٴىنە جىلجىتتى',
'movelogpage'             => 'جىلجىتۋ جۋرنالى',
'movelogpagetext'         => 'تٴومەندە جىلجىتىلعان بەتتەردٴىڭ تٴىزٴىمٴى بەرٴىلٴىپ تۇر.',
'movereason'              => 'سەبەبٴى',
'revertmove'              => 'قايتارۋ',
'delete_and_move'         => 'جويۋ جٴانە جىلجىتۋ',
'delete_and_move_text'    => '==جويۋ قاجەت==

اقىرعى «[[$1]]» بەت اتاۋى بار تٴۇگە.
جىلجىتۋعا جول بەرۋ ٴۇشٴىن جويامىز با?',
'delete_and_move_confirm' => 'يٴا, وسى بەتتٴى جوي',
'delete_and_move_reason'  => 'جىلجىتۋعا جول بەرۋ ٴۇشٴىن جويىلعان',
'selfmove'                => 'قاينار جٴانە اقىرعى اتاۋى بٴىردەي; بەت ٴوزٴىنە جىلجىتىلمايدى.',
'immobile_namespace'      => 'قاينار نەمەسە اقىرعى اتاۋى ارنايى تٴۇرٴىندە بولدى; وسىنداي ەسٴىم اياسى جاعىنا جٴانە جاعىنان بەتتەر جىلجىتىلمايدى.',

# Export
'export'          => 'بەتتەردٴى سىرتقا بەرۋ',
'exporttext'      => 'XML پٴىشٴىمٴىنە قاپتالعان بٴولەك بەت نە بەتتەر بۋماسى
مٴاتٴىنٴىڭ جٴانە ٴوڭدەۋ تاريحىن سىرتقا بەرە الاسىز. وسىنى, باسقا ۋيكي-گە
{{ns:special}}:Import page MediaWiki قۇرالى ارقىلى, سىرتتان الۋعا بولادى.

بەتتەردٴى سىرتقا بەرۋ ٴۇشٴىن, اتاۋلارىن تٴومەندەگٴى مٴاتٴىن اۋماعىنا ەنگٴىزٴىڭٴىز,
بٴىر جولدا بٴىر اتاۋ, جٴانە تانداڭىز: نە اعىمدىق نۇسقاسىن, بارلىق ەسكٴى نۇسقالارى مەن
جٴانە تاريحى جولدارى مەن بٴىرگە, نە دٴال اعىمدىق نۇسقاسىن, سوڭعى ٴوڭدەۋ تۋرالى اقپاراتى مەن بٴىرگە.

سوڭعى جاعدايدا سٴىلتەمەنٴى دە قولدانۋعا بولادى, مىسالى {{int:mainpage}} بەتٴى ٴۇشٴىن [[{{ns:Special}}:Export/{{int:mainpage}}]].',
'exportcuronly'   => 'تولىق تاريحىن ەمەس, تەك اعىمدىق نۇسقاسىن كٴىرٴىستٴىرٴىڭٴىز',
'exportnohistory' => "----
'''اڭعارتپا:''' ٴونٴىمدٴىلٴىك ٴاسەرٴى سەبەپتەرٴىنەن, بەتتەر تولىق تاريحىن سىرتقا بەرۋٴى ٴوشٴىرٴىلگەن.",
'export-submit'   => 'سىرتقا بەر',

# Namespace 8 related
'allmessages'               => 'جٴۇيە حابارلارى',
'allmessagesname'           => 'اتاۋى',
'allmessagesdefault'        => 'ٴادەپكٴى مٴاتٴىنٴى',
'allmessagescurrent'        => 'اعىمدىق مٴاتٴىنٴى',
'allmessagestext'           => 'مىندا «MediaWiki:» ەسٴىم اياسىنداعى بارلىق قاتىناۋلى جٴۇيە حابار تٴىزٴىمٴى بەرٴىلٴىپ تۇر.',
'allmessagesnotsupportedUI' => 'Your current interface language <b>$1</b> is not supported by Special:Allmessages at this site.',
'allmessagesnotsupportedDB' => "'''wgUseDatabaseMessages''' بابى ٴوشٴىرٴىلگەن سەبەبٴىنەن '''{{ns:special}}:AllMessages''' سيپاتى سٴۇەمەلدەنبەيدٴى.",
'allmessagesfilter'         => 'حاباردى اتاۋى بويىنشا سٴۇزگٴىلەۋ:',
'allmessagesmodified'       => 'تەك ٴوزگەرتٴىلگەندٴى كٴورسەت',

# Thumbnails
'thumbnail-more'  => 'ٴۇلكەيتۋ',
'missingimage'    => '<b>جوعالعان سۋرەت </b><br /><i>$1</i>',
'filemissing'     => 'جوعالعان فايل',
'thumbnail_error' => 'نوباي قۇرۋ قاتەسٴى: $1',

# Special:Import
'import'                     => 'بەتتەردٴى سىرتتان الۋ',
'importinterwiki'            => 'ۋيكي-تاسىمالداپ سىرتتان الۋ',
'import-interwiki-text'      => 'سىرتتان الاتىن ۋيكي جوباسىن جٴانە بەت اتاۋىن تانداڭىز.
نۇسقا كٴۇن-ايى جٴانە ٴوڭدەۋشٴى اتتارى ساقتالادى.
بارلىق ۋيكي-تاسىمالداپ سىرتتان الۋ ٴارەكەتتەر [[{{ns:special}}:Log/import|سىرتتان الۋ جۋرنالىنا]] جازىلىپ الىنادى.',
'import-interwiki-history'   => 'وسى بەتتٴىڭ بارلىق تاريحي نۇسقالارىن كٴوشٴىرۋ',
'import-interwiki-submit'    => 'سىرتتان الۋ',
'import-interwiki-namespace' => 'مىنا ەسٴىم اياسىنا بەتتەردٴى تاسىمالداۋ:',
'importtext'                 => 'قاينار ۋيكيدەن «Special:Export» قۋرالىن قولدانىپ, فايلدى سىرتقا بەرٴىڭٴىز, ديسكٴىڭٴىزگە ساقتاڭىز, سوسىن مىندا قوتارىڭىز.',
'importstart'                => 'بەتتەردٴى سىرتتان الۋى…',
'import-revision-count'      => '$1 نۇسقا',
'importnopages'              => 'سىرتتان الىناتىن بەتتەر جوق.',
'importfailed'               => 'سىرتتان الۋ سٴاتسٴىز بٴىتتٴى: $1',
'importunknownsource'        => 'Cىرتتان الۋ قاينار تٴۇرٴى تانىمالسىز',
'importcantopen'             => 'سىرتتان الۋ فايلى اشىلمايدى',
'importbadinterwiki'         => 'جارامسىز ۋيكي-ارالىق سٴىلتەمە',
'importnotext'               => 'بوستى, نە مٴاتٴىنٴى جوق',
'importsuccess'              => 'سىرتتان الۋ سٴاتتٴى اياقتالدى!',
'importhistoryconflict'      => 'تاريحىنىڭ ەگەس نۇسقالارى بار (بۇل بەتتٴى الدىندا سىرتتان الىنعان سيياقتى)',
'importnosources'            => 'ەشقانداي ۋيكي-تاسىمالداپ سىرتتان الۋ قاينارى بەلگٴىلەنمەگەن, جٴانە تاريحىن تٴىكەلەي قوتارۋى ٴوشٴىرٴىلگەن.',
'importnofile'               => 'سىرتتان الىناتىن فايل قوتارىلعان جوق.',
'importuploaderror'          => 'سىرتتان الۋ فايلدىڭ قوتارۋى سٴاتسٴىز بٴىتتٴى; وسى فايل مٴولشەرٴى رۇقسات ەتٴىلگەن مٴولشەردەن اسۋى مٴۇمكٴىن.',

# Import log
'importlogpage'                    => 'سىرتتان الۋ جۋرنالى',
'importlogpagetext'                => 'باسقا ۋيكيلەردەن ٴوڭدەۋ تاريحىمەن بٴىرگە بەتتەردٴى ٴاكٴىمشٴىلٴىك رەتٴىندە سىرتتان الۋ.',
'import-logentry-upload'           => 'فايل قوتارۋىمەن سىرتتان «[[$1]]» بەتٴى الىندى',
'import-logentry-upload-detail'    => '$1 نۇسقا',
'import-logentry-interwiki'        => 'ۋيكي-تاسىمالدانعان $1',
'import-logentry-interwiki-detail' => '$2 دەگەننەن $1 نۇسقا',

# Keyboard access keys for power users
'accesskey-search'                  => 'f',
'accesskey-minoredit'               => 'i',
'accesskey-save'                    => 's',
'accesskey-preview'                 => 'p',
'accesskey-diff'                    => 'v',
'accesskey-compareselectedversions' => 'v',
'accesskey-watch'                   => 'w',

# Tooltip help for some actions, most are in Monobook.js
'tooltip-search'                  => '{{SITENAME}} جوباسىنان ٴىزدەستٴىرۋ [alt-f]',
'tooltip-minoredit'               => 'وسىنى شاعىن تٴۇزەتۋ دەپ بەلگٴىلەۋ [alt-i]',
'tooltip-save'                    => 'تٴۇزەتۋٴىڭٴىزدٴى ساقتاۋ [alt-s]',
'tooltip-preview'                 => 'ساقتاۋدىڭ الدىنان تٴۇزەتۋٴىڭٴىزدٴى قاراپ شىعىڭىز! [alt-p]',
'tooltip-diff'                    => 'مٴاتٴىنگە قانداي ٴوزگەرٴىستەردٴى جاساعانىڭىزدى قاراۋ. [alt-v]',
'tooltip-compareselectedversions' => 'بەتتٴىڭ ەكٴى نۇسقاسىنىڭ ايىرماسىن قاراۋ. [alt-v]',
'tooltip-watch'                   => 'بۇل بەتتٴى باقىلاۋ تٴىزٴىمٴىڭٴىزگە ٴۇستەۋ [alt-w]',

# Stylesheets
'common.css'   => '/** مىنداعى CSS ٴامٴىرلەرٴى بارلىق بەزەندٴىرۋ مٴانەرٴىندەردە قولدانىلادى */',
'monobook.css' => '/* مىنداعى CSS ٴامٴىرلەرٴى «دارا كٴىتاپ» بەزەندٴىرۋ مٴانەرٴىن پايدالانۋشىلارعا ٴاسەر ەتەدٴى */',

# Metadata
'nodublincore'      => 'وسى سەرۆەرگە «Dublin Core RDF» مەتا-دەرەكتەرٴى ٴوشٴىرٴىلگەن.',
'nocreativecommons' => 'وسى سەرۆەرگە «Creative Commons RDF» مەتا-دەرەكتەرٴى ٴوشٴىرٴىلگەن.',
'notacceptable'     => 'وسى ۋيكي سەرۆەرٴى سٴىزدٴىڭ «پايدالانۋشى ٴارەكەتكٴىشٴى» وقي الاتىن پٴىشٴىمٴى بار دەرەكتەردٴى جٴىبەرە المايدى.',

# Attribution
'anonymous'        => '{{SITENAME}} تٴىركەلگٴىسٴىز پايدالانۋشى(لار)',
'siteuser'         => '{{SITENAME}} قاتىسۋشى $1',
'lastmodifiedatby' => 'بۇل بەتتٴى $3 قاتىسۋشى سوڭعى ٴوزگەرتكەن كەزٴى: $2, $1.', # $1 date, $2 time, $3 user
'and'              => 'جٴانە',
'othercontribs'    => 'شىعارما نەگٴىزٴىن $1 جازعان.',
'others'           => 'باسقالار',
'siteusers'        => '{{SITENAME}} قاتىسۋشى(لار) $1',
'creditspage'      => 'بەتتٴى جازعاندار',
'nocredits'        => 'بۇل بەتتٴى جازعاندار تۋرالى اقپارات جوق.',

# Spam protection
'spamprotectiontitle'    => '«سپام»-نان قورعايتىن سٴۇزگٴى',
'spamprotectiontext'     => 'بۇل بەتتٴىڭ ساقتاۋىن «سپام» سٴۇزگٴىسٴى بۇعاتتادى. بۇنىڭ سەبەبٴى سىرتقى توراپ سٴىلتەمەسٴىنەن بولۋى مٴۇمكٴىن.',
'spamprotectionmatch'    => 'كەلەسٴى «سپام» مٴاتٴىنٴى سٴۇزگٴىلەنگەن: $1',
'subcategorycount'       => 'بۇل ساناتتا {{PLURAL:$1|بٴىر|$1}} تٴومەنگٴى سانات بار.',
'categoryarticlecount'   => 'بۇل ساناتتا {{PLURAL:$1|بٴىر|$1}} بەت بار.',
'category-media-count'   => 'بۇل ساناتتا {{PLURAL:$1|بٴىر|$1}} فايل بار.',
'listingcontinuesabbrev' => ' (جالع.)',
'spambot_username'       => 'MediaWiki spam cleanup',
'spam_reverting'         => '$1 دەگەنگە سٴىلتەمەسٴى جوق سوڭعى نۇسقاسىنا قايتارىلدى',
'spam_blanking'          => '$1 دەگەنگە سٴىلتەمەسٴى بار بارلىق نۇسقالار تازارتىلدى',

# Info page
'infosubtitle'   => 'بەت تۋرالى اقپارات',
'numedits'       => 'تٴۇزەتۋ سانى (نەگٴىزگٴى بەتٴى): $1',
'numtalkedits'   => 'تٴۇزەتۋ سانى (تالقىلاۋ بەتٴى): $1',
'numwatchers'    => 'باقىلاۋشى سانى: $1',
'numauthors'     => 'ٴارتٴۇرلٴى اۋتورلار سانى (نەگٴىزگٴى بەتٴى): $1',
'numtalkauthors' => 'ٴارتٴۇرلٴى اۋتور سانى (تالقىلاۋ بەتٴى): $1',

# Math options
'mw_math_png'    => 'ٴارقاشان PNG تٴۇرٴىمەن كٴورسەت',
'mw_math_simple' => 'كٴادٴىمگٴى بولسا HTML پٴىشٴىمٴىمەن, باسقاشا PNG تٴۇرٴىمەن',
'mw_math_html'   => 'ىقتيمال بولسا HTML پٴىشٴىمٴىمەن, باسقاشا PNG تٴۇرٴىمەن',
'mw_math_source' => 'TeX پٴىشٴىمٴىندە قالدىرۋ (مٴاتٴىندٴىك شولعىشتارىنا)',
'mw_math_modern' => 'وسى زاماننىڭ شولعىشتارىنا ۇسىنىلعان',
'mw_math_mathml' => 'ىقتيمال بولسا MathML پشٴىمٴىمەن (سىناق تٴۇرٴىندە)',

# Patrolling
'markaspatrolleddiff'        => 'كٴۇزەتتە دەپ بەلگٴىلەۋ',
'markaspatrolledtext'        => 'وسى بەتتٴى كٴۇزەتۋدە دەپ بەلگٴىلەۋ',
'markedaspatrolled'          => 'كٴۇزەتتە دەپ بەلگٴىلەندٴى',
'markedaspatrolledtext'      => 'تالعانعان نۇسقا كٴۇزەتتە دەپ بەلگٴىلەندٴى.',
'rcpatroldisabled'           => 'جۋىقتاعى ٴوزگەرٴىستەر كٴۇزەتٴى ٴوشٴىرٴىلگەن',
'rcpatroldisabledtext'       => 'جۋىقتاعى ٴوزگەرٴىستەر كٴۇزەتٴى قاسيەتٴى اعىمدا ٴوشٴىرٴىلگەن.',
'markedaspatrollederror'     => 'كٴۇزەتتە دەپ بەلگٴىلەنبەيدٴى',
'markedaspatrollederrortext' => 'كٴۇزەتتە دەپ بەلگٴىلەۋ ٴۇشٴىن نۇسقاسىن ەنگٴىزٴىڭٴىز.',

# Monobook.js: tooltips and access keys for monobook
'monobook.js' => "/* tooltips and access keys */
var ta = new Object();
ta['pt-userpage'] = new Array('.','جەكە بەتٴىم');
ta['pt-anonuserpage'] = new Array('.','وسى IP جايدىڭ جەكە بەتٴى');
ta['pt-mytalk'] = new Array('n','تالقىلاۋ بەتٴىم');
ta['pt-anontalk'] = new Array('n','وسى IP جاي تٴۇزەتۋلەرٴىن تالقىلاۋ');
ta['pt-preferences'] = new Array('','باپتاۋىم');
ta['pt-watchlist'] = new Array('l','ٴوزگەرٴىستەرٴىن باقىلاپ تۇرعان بەتتەر تٴىزٴىمٴىم.');
ta['pt-mycontris'] = new Array('y','ٴۇلەستەرٴىمدٴىڭ تٴىزٴىمٴى');
ta['pt-login'] = new Array('o','كٴىرۋٴىڭٴىزدٴى ۇسىنامىز, ول مٴىندەتتٴى ەمەس.');
ta['pt-anonlogin'] = new Array('o','كٴىرۋٴىڭٴىزدٴى ۇسىنامىز, بٴىراق, ول مٴىندەتتٴى ەمەس.');
ta['pt-logout'] = new Array('','شىعۋ');
ta['ca-talk'] = new Array('t','ماعلۇمات بەتتٴى تالقىلاۋ');
ta['ca-edit'] = new Array('e','بۇل بەتتٴى ٴوڭدەي الاسىز. ساقتاۋدىڭ الدىندا «قاراپ شىعۋ» تٴۇيمەسٴىن نۇقىڭىز.');
ta['ca-addsection'] = new Array('+','بۇل تالقىلاۋ بەتٴىندە جاڭا تاراۋ باستاۋ.');
ta['ca-viewsource'] = new Array('e','بۇل بەت قورعالعان, بٴىراق, قاينارىن قاراۋعا بولادى.');
ta['ca-history'] = new Array('h','بۇل بەتتٴىن جۋىقتاعى نۇسقالارى.');
ta['ca-protect'] = new Array('=','بۇل بەتتٴى قورعاۋ');
ta['ca-unprotect'] = new Array('=','بۇل بەتتٴى قورعاماۋ');
ta['ca-delete'] = new Array('d','بۇل بەتتٴى جويۋ');
ta['ca-undelete'] = new Array('d','بۇل بەتتٴىڭ جويۋدىڭ الدىنداعى بولعان تٴۇزەتۋلەرٴىن قايتارۋ');
ta['ca-move'] = new Array('m','بۇل بەتتٴى جىلجىتۋ');
ta['ca-nomove'] = new Array('m','بۇل بەتتٴى جىلجىتۋعا رۇقساتىڭىز جوق');
ta['ca-watch'] = new Array('w','بۇل بەتتٴى باقىلاۋ تٴىزٴىمٴىڭٴىزگە ٴۇستەۋ');
ta['ca-unwatch'] = new Array('w','بۇل بەتتٴى باقىلاۋ تٴىزٴىمٴىڭٴىزدەن الاستاتۋ');
ta['ca-varlang-0'] = new Array('','كيريلل جازۋى');
ta['ca-varlang-1'] = new Array('','لاتىن جازۋى');
ta['ca-varlang-2'] = new Array('','اراب جازۋى');
ta['search'] = new Array('f','وسى ۋيكيدەن ٴىزدەۋ');
ta['p-logo'] = new Array('','باستى بەتكە');
ta['n-mainpage'] = new Array('z','باستى بەتكە بارىپ كەتٴىڭٴىز');
ta['n-portal'] = new Array('','جوبا تۋرالى, نە ٴىستەۋٴىڭٴىزگە بولاتىن, قايدان تابۋعا بولاتىن تۋرالى');
ta['n-currentevents'] = new Array('','اعىمداعى وقيعالارعا قاتىستى اقپارات');
ta['n-recentchanges'] = new Array('r','وسى ۋيكيدەگٴى جۋىقتاعى ٴوزگەرٴىستەر تٴىزٴىمٴى.');
ta['n-randompage'] = new Array('x','كەزدەيسوق بەتتٴى جٴۇكتەۋ');
ta['n-help'] = new Array('','انىقتاما تابۋ ورنى.');
ta['n-sitesupport'] = new Array('','بٴىزگە جٴاردەم ەتٴىڭٴىز');
ta['t-whatlinkshere'] = new Array('j','مىندا سٴىلتەگەن بارلىق بەتتەردٴىڭ تٴىزٴىمٴى');
ta['t-recentchangeslinked'] = new Array('k','مىننان سٴىلتەنگەن بەتتەردٴىڭ جۋىقتاعى ٴوزگەرٴىستەرٴى');
ta['feed-rss'] = new Array('','بۇل بەتتٴىڭ RSS ارناسى');
ta['feed-atom'] = new Array('','بۇل بەتتٴىڭ Atom ارناسى');
ta['t-contributions'] = new Array('','وسى قاتىسۋشىنىڭ ٴۇلەس تٴىزٴىمٴىن قاراۋ');
ta['t-emailuser'] = new Array('','وسى قاتىسۋشىعا email جٴىبەرۋ');
ta['t-upload'] = new Array('u','سۋرەت نە مەديا فايلدارىن قوتارۋ');
ta['t-specialpages'] = new Array('q','بارلىق ارنايى بەتتەر تٴىزٴىمٴى');
ta['t-print'] = new Array('','وسى بەتتٴىڭ باسىپ شىعارۋ نۇسقاسى');
ta['t-permalink'] = new Array('','بەتتٴىڭ وسى نۇسقاسىنىڭ تۇراقتى سٴىلتەمەسٴى');
ta['ca-nstab-main'] = new Array('c','ماعلۇمات بەتٴىن قاراۋ');
ta['ca-nstab-user'] = new Array('c','قاتىسۋشى بەتٴىن قاراۋ');
ta['ca-nstab-media'] = new Array('c','تاسپا بەتٴىن قاراۋ');
ta['ca-nstab-special'] = new Array('','بۇل ارنايى بەت, بەتتٴىڭ ٴوزٴى ٴوڭدەلٴىنبەيدٴى.');
ta['ca-nstab-project'] = new Array('a','جوبا بەتٴىن قاراۋ');
ta['ca-nstab-image'] = new Array('c','سۋرەت بەتٴىن قاراۋ');
ta['ca-nstab-mediawiki'] = new Array('c','جٴۇيە حابارىن قاراۋ');
ta['ca-nstab-template'] = new Array('c','ٴۇلگٴىنٴى قاراۋ');
ta['ca-nstab-help'] = new Array('c','انىقتىما بەتٴىن قاراۋ');
ta['ca-nstab-category'] = new Array('c','سانات بەتٴىن قاراۋ');",

# Common.js: contains nothing but a placeholder comment
'common.js' => '/* مىنداعى كەز كەلگەن JavaScript ٴامٴىرلەرٴى ٴارقايسى بەت جٴۇكتەلگەندە بارلىق پايدالانۋشىلارعا جٴۇكتەلەدٴى. */

// BEGIN workaround for RTL
if (wgUserLanguage == "kk-cn"){
  document.direction="rtl";
  document.write(\'<style type="text/css">html {direction: rtl;}</style>\');
  document.write(\'<link rel="stylesheet" type="text/css" href="\'+stylepath+\'/common/common_rtl.css">\');
  document.write(\'<link rel="stylesheet" type="text/css" href="\'+stylepath+\'/\'+skin+\'/rtl.css">\');
}
// END workaround for RTL',

# Image deletion
'deletedrevision' => 'مىنا ەسكٴى نۇسقاسىن جويدى: $1.',

# Browsing diffs
'previousdiff' => '← الدىڭعىمەن ايىرماسى',
'nextdiff'     => 'كەلەسٴىمەن ايىرماسى →',

'imagemaxsize' => 'سۋرەت تٴۇيٴىندەمە بەتٴىندەگٴى سۋرەتتٴىڭ مٴولشەرٴىن شەكتەۋٴى:',
'thumbsize'    => 'نوباي مٴولشەرٴى:',
'showbigimage' => 'جوعارى اجىراتىلىمدى ($1×$2, $3 كب) نۇسقاسىن جٴۇكتەۋ',

'newimages'    => 'ەڭ جاڭا فايلدار قويماسى',
'showhidebots' => '(بوتتاردى $1)',
'noimages'     => 'كٴورەتٴىن ەشتەڭە جوق.',

# Variants for Kazakh language
'variantname-kk-tr' => 'Latın',
'variantname-kk-kz' => 'Кирил',
'variantname-kk-cn' => 'توتە',
'variantname-kk'    => 'disable',

# Labels for User: and Title: on Special:Log pages
'specialloguserlabel'  => 'قاتىسۋشى:',
'speciallogtitlelabel' => 'اتاۋ:',

'passwordtooshort' => 'قۇپييا سٴوزٴىڭٴىز تىم قىسقا. ەڭ كەمٴىندە $1 ٴارٴىپ بولۋى قاجەت.',

# Media Warning
'mediawarning' => "'''نازار سالىڭىز''': بۇل فايل تٴۇرٴىندە قاسكٴۇنەمدٴى ٴامٴىردٴىڭ بار بولۋى ىقتيمال; فايلدى جەگٴىپ جٴۇيەڭٴىزگە زييان كەلتٴىرۋٴىڭٴىز مٴۇمكٴىن.<hr />",

'fileinfo' => '$1 كب, MIME تٴۇرٴى: <code>$2</code>',

# Metadata
'metadata'          => 'مەتا-دەرەكتەرٴى',
'metadata-help'     => 'وسى فايلدا قوسىمشا اقپارات بار. بٴالكٴىم, وسى اقپارات فايلدى جاساپ شىعارۋ, نە ساندىلاۋ ٴۇشٴىن پايدالانعان ساندىق كامەرا, نە مٴاتٴىنالعىردان الىنعان. ەگەر وسى فايل نەگٴىزگٴى كٴۇيٴىنەن ٴوزگەرتٴىلگەن بولسا, كەيبٴىر ەجەلەلەرٴى ٴوزگەرتٴىلگەن فوتوسۋرەتكە لايىق بولماس.',
'metadata-expand'   => 'ەگجەي-تەگجەيٴىن كٴورسەت',
'metadata-collapse' => 'ەگجەي-تەگجەيٴىن جاسىر',
'metadata-fields'   => 'وسى حاباردا تٴىزٴىمدەلگەن EXIF مەتا-دەرەك اۋماقتارى,
سۋرەت بەتٴى كٴورسەتۋ كەزٴىندە مەتا-دەرەك كەستە جاسىرىلىعاندا كٴىرٴىستٴىرلەدٴى.
باسقاسى ٴادەپكٴىدەن جاسىرىلادى.
* make
* model
* datetimeoriginal
* exposuretime
* fnumber
* focallength',

# EXIF tags
'exif-imagewidth'                  => 'ەنٴى',
'exif-imagelength'                 => 'بيٴىكتٴىگٴى',
'exif-bitspersample'               => 'قۇراش سايىن بيت سانى',
'exif-compression'                 => 'قىسىم سۇلباسى',
'exif-photometricinterpretation'   => 'پيكسەل قيىسۋى',
'exif-orientation'                 => 'مەگزەۋٴى',
'exif-samplesperpixel'             => 'قۇراش سانى',
'exif-planarconfiguration'         => 'دەرەك رەتتەۋٴى',
'exif-ycbcrsubsampling'            => 'Y قۇراشىنىڭ C قۇراشىنا جارناقتاۋى',
'exif-ycbcrpositioning'            => 'Y قۇراشى جٴانە C قۇراشى مەكەندەۋٴى',
'exif-xresolution'                 => 'دەرەلەي اجىراتىلىمدىعى',
'exif-yresolution'                 => 'تٴىرەلەي اجىراتىلىمدىعى',
'exif-resolutionunit'              => 'X جٴانە Y اجىراتىلىمدىقتارىعىنىڭ ٴولشەمٴى',
'exif-stripoffsets'                => 'سۋرەت دەرەرەكتەرٴىنٴىڭ جايعاسۋى',
'exif-rowsperstrip'                => 'بەلدٴىك سايىن جول سانى',
'exif-stripbytecounts'             => 'قىسىمدالعان بەلدٴىك سايىن بايت سانى',
'exif-jpeginterchangeformat'       => 'JPEG SOI دەگەننەن ىعىسۋى',
'exif-jpeginterchangeformatlength' => 'JPEG دەرەكتەرٴىنٴىڭ بايت سانى',
'exif-transferfunction'            => 'تاسىمالداۋ فۋنكتسيياسى',
'exif-whitepoint'                  => 'اق نٴۇكتە تٴۇستٴىلٴىگٴى',
'exif-primarychromaticities'       => 'العى شەپتەگٴى تٴۇستٴىلٴىكتەرٴى',
'exif-ycbcrcoefficients'           => 'تٴۇس اياسىن تاسىمالداۋ ماتريتسالىق ەسەلٴىكتەرٴى',
'exif-referenceblackwhite'         => 'قارا جٴانە اق انىقتاۋىش قوس كولەمدەرٴى',
'exif-datetime'                    => 'فايلدىڭ ٴوزگەرتٴىلگەن كٴۇن-ايى',
'exif-imagedescription'            => 'سۋرەت اتاۋى',
'exif-make'                        => 'كامەرا ٴوندٴىرۋشٴىسٴى',
'exif-model'                       => 'كامەرا ٴۇلگٴىسٴى',
'exif-software'                    => 'قولدانىلعان باعدارلاما',
'exif-artist'                      => 'جىعارماشىسى',
'exif-copyright'                   => 'جىعارماشىلىق قۇقىقتار يەسٴى',
'exif-exifversion'                 => 'Exif نۇسقاسى',
'exif-flashpixversion'             => 'سٴۇيەمدەلٴىنگەن Flashpix نۇسقاسى',
'exif-colorspace'                  => 'تٴۇس اياسى',
'exif-componentsconfiguration'     => 'ٴارقايسى قۇراش مٴانٴى',
'exif-compressedbitsperpixel'      => 'سۋرەت قىسىمداۋ تٴارتٴىبٴى',
'exif-pixelydimension'             => 'سۋرەتتٴىڭ جارامدى ەنٴى',
'exif-pixelxdimension'             => 'سۋرەتتٴىڭ جارامدى بيٴىكتٴىگٴى',
'exif-makernote'                   => 'ٴوندٴىرۋشٴى ەسكەرتپەلەرٴى',
'exif-usercomment'                 => 'پايدالانۋشى مٴاندەمەلەرٴى',
'exif-relatedsoundfile'            => 'قاتىستى دىبىس فايلى',
'exif-datetimeoriginal'            => 'جاسالعان كەزٴى',
'exif-datetimedigitized'           => 'ساندىقتاۋ كەزٴى',
'exif-subsectime'                  => 'جاسالعان كەزٴىنٴىڭ سەكۋند بٴولشەكتەرٴى',
'exif-subsectimeoriginal'          => 'تٴۇپنۇسقا كەزٴىنٴىڭ سەكۋند بٴولشەكتەرٴى',
'exif-subsectimedigitized'         => 'ساندىقتاۋ كەزٴىنٴىڭ سەكۋند بٴولشەكتەرٴى',
'exif-exposuretime'                => 'ۇستالىم ۋاقىتى',
'exif-exposuretime-format'         => '$1 س ($2)',
'exif-fnumber'                     => 'ساڭىلاۋ مٴولشەرٴى',
'exif-fnumber-format'              => 'f/$1',
'exif-exposureprogram'             => 'ۇستالىم باعدارلاماسى',
'exif-spectralsensitivity'         => 'سپەكتر بويىنشا سەزگٴىشتٴىگٴى',
'exif-isospeedratings'             => 'ISO جىلدامدىق جارناقتاۋى (جارىق سەزگٴىشتٴىگٴى)',
'exif-oecf'                        => 'وپتوەلەكتروندى تٴۇرلەتۋ ىقپالى',
'exif-shutterspeedvalue'           => 'جاپقىش جىلدامدىلىعى',
'exif-aperturevalue'               => 'ساڭىلاۋلىق',
'exif-brightnessvalue'             => 'اشىقتىق',
'exif-exposurebiasvalue'           => 'ۇستالىم ٴوتەمٴى',
'exif-maxaperturevalue'            => 'بارىنشا ساڭىلاۋ اشۋى',
'exif-subjectdistance'             => 'نىسانا قاشىقتىعى',
'exif-meteringmode'                => 'ٴولشەۋ تٴارتٴىبٴى',
'exif-lightsource'                 => 'جارىق كٴوزٴى',
'exif-flash'                       => 'جارقىلداعىش',
'exif-focallength'                 => 'شوعىرلاۋ الشاقتىعى',
'exif-focallength-format'          => '$1 mm',
'exif-subjectarea'                 => 'نىسانا اۋقىمى',
'exif-flashenergy'                 => 'جارقىلداعىش قارقىنى',
'exif-spatialfrequencyresponse'    => 'كەڭٴىستٴىك-جيٴىلٴىك ٴاسەرشٴىلٴىگٴى',
'exif-focalplanexresolution'       => 'ح بويىنشا شوعىرلاۋ جايپاقتىقتىڭ اجىراتىلىمدىعى',
'exif-focalplaneyresolution'       => 'Y بويىنشا شوعىرلاۋ جايپاقتىقتىڭ اجىراتىلىمدىعى',
'exif-focalplaneresolutionunit'    => 'شوعىرلاۋ جايپاقتىقتىڭ اجىراتىلىمدىق ٴولشەمٴى',
'exif-subjectlocation'             => 'نىسانا مەكەندەۋٴى',
'exif-exposureindex'               => 'ۇستالىم ايقىنداۋى',
'exif-sensingmethod'               => 'سەنسوردٴىڭ ٴولشەۋ ٴادٴىسٴى',
'exif-filesource'                  => 'فايل قاينارى',
'exif-scenetype'                   => 'ساحنا تٴۇرٴى',
'exif-cfapattern'                  => 'CFA سٴۇزگٴى كەيٴىپٴى',
'exif-customrendered'              => 'قوسىمشا سۋرەت ٴوڭدەتۋٴى',
'exif-exposuremode'                => 'ۇستالىم تٴارتٴىبٴى',
'exif-whitebalance'                => 'اق تٴۇسٴىنٴىڭ تەندەستٴىگٴى',
'exif-digitalzoomratio'            => 'ساندىق اۋقىمداۋ جارناقتاۋى',
'exif-focallengthin35mmfilm'       => '35 mm تاسپاسىنىڭ شوعىرلاۋ الشاقتىعى',
'exif-scenecapturetype'            => 'تٴۇسٴىرگەن ساحنا تٴۇرٴى',
'exif-gaincontrol'                 => 'ساحنانى مەڭگەرۋ',
'exif-contrast'                    => 'قاراما-قارسىلىق',
'exif-saturation'                  => 'قانىقتىق',
'exif-sharpness'                   => 'ايقىندىق',
'exif-devicesettingdescription'    => 'جابدىق باپتاۋ سيپاتتارى',
'exif-subjectdistancerange'        => 'ساحنا قاشىقتىعىنىڭ كٴولەمٴى',
'exif-imageuniqueid'               => 'سۋرەتتٴىڭ بٴىرەگەي نٴومٴىرٴى (ID)',
'exif-gpsversionid'                => 'GPS بەلگٴىشەسٴىنٴىڭ نۇسقاسى',
'exif-gpslatituderef'              => 'سولتٴۇستٴىك نەمەسە وڭتٴۇستٴىك بويلىعى',
'exif-gpslatitude'                 => 'بويلىعى',
'exif-gpslongituderef'             => 'شىعىس نەمەسە باتىس ەندٴىگٴى',
'exif-gpslongitude'                => 'ەندٴىگٴى',
'exif-gpsaltituderef'              => 'بيٴىكتٴىك كٴورسەتۋٴى',
'exif-gpsaltitude'                 => 'بيٴىكتٴىك',
'exif-gpstimestamp'                => 'GPS ۋاقىتى (اتوم ساعاتى)',
'exif-gpssatellites'               => 'ٴولشەۋگە پيدالانىلعان جەر سەرٴىكتەرٴى',
'exif-gpsstatus'                   => 'قابىلداعىش كٴۇيٴى',
'exif-gpsmeasuremode'              => 'ٴولشەۋ تٴارتٴىبٴى',
'exif-gpsdop'                      => 'ٴولشەۋ دٴالدٴىگٴى',
'exif-gpsspeedref'                 => 'جىلدامدىلىق ٴولشەمٴى',
'exif-gpsspeed'                    => 'GPS قابىلداعىشتىڭ جىلدامدىلىعى',
'exif-gpstrackref'                 => 'قوزعالىس باعىتىن كٴورسەتۋٴى',
'exif-gpstrack'                    => 'قوزعالىس باعىتى',
'exif-gpsimgdirectionref'          => 'سۋرەت باعىتىن كٴورسەتۋٴى',
'exif-gpsimgdirection'             => 'سۋرەت باعىتى',
'exif-gpsmapdatum'                 => 'پايدالانىلعان گەودەزييالىق تٴۇسٴىرمە دەرەكتەرٴى',
'exif-gpsdestlatituderef'          => 'نىسانا بويلىعىن كٴورسەتۋٴى',
'exif-gpsdestlatitude'             => 'نىسانا بويلىعى',
'exif-gpsdestlongituderef'         => 'نىسانا ەندٴىگٴىن كٴورسەتۋٴى',
'exif-gpsdestlongitude'            => 'نىسانا ەندٴىگٴى',
'exif-gpsdestbearingref'           => 'نىسانا ازيمۋتىن كٴورسەتۋٴى',
'exif-gpsdestbearing'              => 'نىسانا ازيمۋتى',
'exif-gpsdestdistanceref'          => 'نىسانا قاشىقتىعىن كٴورسەتۋٴى',
'exif-gpsdestdistance'             => 'نىسانا قاشىقتىعى',
'exif-gpsprocessingmethod'         => 'GPS ٴوڭدەتۋ ٴادٴىسٴىنٴىڭ اتاۋى',
'exif-gpsareainformation'          => 'GPS اۋماعىنىڭ اتاۋى',
'exif-gpsdatestamp'                => 'GPS كٴۇن-ايى',
'exif-gpsdifferential'             => 'GPS سارالانعان تٴۇزەتۋ',

# EXIF attributes
'exif-compression-1' => 'ۇلعايتىلعان',
'exif-compression-6' => 'JPEG',

'exif-photometricinterpretation-2' => 'RGB',
'exif-photometricinterpretation-6' => 'YCbCr',

'exif-orientation-1' => 'قالىپتى', # 0th row: top; 0th column: left
'exif-orientation-2' => 'دەرەلەي شاعىلىسقان', # 0th row: top; 0th column: right
'exif-orientation-3' => '180° بۇرىشقا اينالعان', # 0th row: bottom; 0th column: right
'exif-orientation-4' => 'تٴىرەلەي شاعىلىسقان', # 0th row: bottom; 0th column: left
'exif-orientation-5' => 'ساعات تٴىلشەسٴىنە قارسى 90° بۇرىشقا اينالعان جٴانە تٴىرەلەي شاعىلىسقان', # 0th row: left; 0th column: top
'exif-orientation-6' => 'ساعات تٴىلشە بويىنشا 90° بۇرىشقا اينالعان', # 0th row: right; 0th column: top
'exif-orientation-7' => 'ساعات تٴىلشە بويىنشا 90° بۇرىشقا اينالعان جٴانە تٴىرەلەي شاعىلىسقان', # 0th row: right; 0th column: bottom
'exif-orientation-8' => 'ساعات تٴىلشەسٴىنە قارسى 90° بۇرىشقا اينالعان', # 0th row: left; 0th column: bottom

'exif-planarconfiguration-1' => 'تالپاق پٴىشٴىم',
'exif-planarconfiguration-2' => 'تايپاق پٴىشٴىم',

'exif-xyresolution-i' => '$1 dpi',
'exif-xyresolution-c' => '$1 dpc',

'exif-colorspace-1'      => 'sRGB',
'exif-colorspace-ffff.h' => 'FFFF.H',

'exif-componentsconfiguration-0' => 'بار بولمادى',
'exif-componentsconfiguration-1' => 'Y',
'exif-componentsconfiguration-2' => 'Cb',
'exif-componentsconfiguration-3' => 'Cr',
'exif-componentsconfiguration-4' => 'R',
'exif-componentsconfiguration-5' => 'G',
'exif-componentsconfiguration-6' => 'B',

'exif-exposureprogram-0' => 'انىقتالماعان',
'exif-exposureprogram-1' => 'قولمەن',
'exif-exposureprogram-2' => 'باعدارلامالى ٴادٴىس (قالىپتى)',
'exif-exposureprogram-3' => 'ساڭىلاۋ باسىڭقىلىعى',
'exif-exposureprogram-4' => 'ىسىرما باسىڭقىلىعى',
'exif-exposureprogram-5' => 'ٴونەر باعدارلاماسى (انىقتىق تەرەندٴىگٴىنە ساناسقان)',
'exif-exposureprogram-6' => 'قيمىل باعدارلاماسى (جاپقىش شاپشاندىلىعىنا ساناسقان)',
'exif-exposureprogram-7' => 'تٴىرەلەي ٴادٴىسٴى (ارتى شوعىرلاۋسىز تاياۋ تٴۇسٴىرمەلەر)',
'exif-exposureprogram-8' => 'دەرەلەي ٴادٴىسٴى (ارتى شوعىرلانعان دەرەلەي تٴۇسٴىرمەلەر)',

'exif-subjectdistance-value' => '$1 m',

'exif-meteringmode-0'   => 'بەلگٴىسٴىز',
'exif-meteringmode-1'   => 'بٴىركەلكٴى',
'exif-meteringmode-2'   => 'بۇلدىر داق',
'exif-meteringmode-3'   => 'بٴىرداقتى',
'exif-meteringmode-4'   => 'كٴوپداقتى',
'exif-meteringmode-5'   => 'ٴورنەكتٴى',
'exif-meteringmode-6'   => 'جىرتىندى',
'exif-meteringmode-255' => 'باسقا',

'exif-lightsource-0'   => 'بەلگٴىسٴىز',
'exif-lightsource-1'   => 'كٴۇن جارىعى',
'exif-lightsource-2'   => 'كٴۇنجارىقتى شام',
'exif-lightsource-3'   => 'قىزدىرعىشتى شام',
'exif-lightsource-4'   => 'جارقىلداعىش',
'exif-lightsource-9'   => 'اشىق كٴۇن',
'exif-lightsource-10'  => 'بۇلىنعىر كٴۇن',
'exif-lightsource-11'  => 'كٴولەنكەلٴى',
'exif-lightsource-12'  => 'كٴۇنجارىقتى شام (D 5700–7100 K)',
'exif-lightsource-13'  => 'كٴۇنجارىقتى شام (N 4600–5400 K)',
'exif-lightsource-14'  => 'كٴۇنجارىقتى شام (W 3900–4500 K)',
'exif-lightsource-15'  => 'كٴۇنجارىقتى شام (WW 3200–3700 K)',
'exif-lightsource-17'  => 'قالىپتى جارىق قاينارى A',
'exif-lightsource-18'  => 'قالىپتى جارىق قاينارى B',
'exif-lightsource-19'  => 'قالىپتى جارىق قاينارى C',
'exif-lightsource-20'  => 'D55',
'exif-lightsource-21'  => 'D65',
'exif-lightsource-22'  => 'D75',
'exif-lightsource-23'  => 'D50',
'exif-lightsource-24'  => 'ستۋدييالىق ISO كٴۇنجارىقتى شام',
'exif-lightsource-255' => 'باسقا جارىق قاينارى',

'exif-focalplaneresolutionunit-2' => 'ديۋيم',

'exif-sensingmethod-1' => 'انىقتالماعان',
'exif-sensingmethod-2' => '1-چيپتٴى اۋماقتى تٴۇسسەزگٴىش',
'exif-sensingmethod-3' => '2-چيپتٴى اۋماقتى تٴۇسسەزگٴىش',
'exif-sensingmethod-4' => '3-چيپتٴى اۋماقتى تٴۇسسەزگٴىش',
'exif-sensingmethod-5' => 'كەزەكتٴى اۋماقتى تٴۇسسەزگٴىش',
'exif-sensingmethod-7' => '3-سىزىقتى تٴۇسسەزگٴىش',
'exif-sensingmethod-8' => 'كەزەكتٴى سىزىقتى تٴۇسسەزگٴىش',

'exif-filesource-3' => 'DSC',

'exif-scenetype-1' => 'تٴىكەلەي تٴۇسٴىرٴىلگەن فوتوسۋرەت',

'exif-customrendered-0' => 'قالىپتى ٴوڭدەتۋ',
'exif-customrendered-1' => 'قوسىمشا ٴوڭدەتۋ',

'exif-exposuremode-0' => 'ٴوزدٴىك ۇستالىمداۋ',
'exif-exposuremode-1' => 'قولمەن ۇستالىمداۋ',
'exif-exposuremode-2' => 'ٴوزدٴىك جارقىلداۋ',

'exif-whitebalance-0' => 'اق تٴۇسٴىنٴىڭ ٴوزدٴىك تەندەستٴىرۋ',
'exif-whitebalance-1' => 'اق تٴۇسٴىنٴىڭ قولمەن تەندەستٴىرۋ',

'exif-scenecapturetype-0' => 'قالىپتى',
'exif-scenecapturetype-1' => 'دەرەلەي',
'exif-scenecapturetype-2' => 'تٴىرەلەي',
'exif-scenecapturetype-3' => 'تٴۇنگٴى ساحنا',

'exif-gaincontrol-0' => 'جوق',
'exif-gaincontrol-1' => 'تٴومەن زورايۋ',
'exif-gaincontrol-2' => 'جوعارى زورايۋ',
'exif-gaincontrol-3' => 'تٴومەن باياۋلاۋ',
'exif-gaincontrol-4' => 'جوعارى باياۋلاۋ',

'exif-contrast-0' => 'قالىپتى',
'exif-contrast-1' => 'ۇيان',
'exif-contrast-2' => 'تۇرپايى',

'exif-saturation-0' => 'قالىپتى',
'exif-saturation-1' => 'تٴومەن قانىقتى',
'exif-saturation-2' => 'جوعارى قانىقتى',

'exif-sharpness-0' => 'قالىپتى',
'exif-sharpness-1' => 'ۇيان',
'exif-sharpness-2' => 'تۇرپايى',

'exif-subjectdistancerange-0' => 'بەلگٴىسٴىز',
'exif-subjectdistancerange-1' => 'تاياۋ تٴۇسٴىرٴىلگەن',
'exif-subjectdistancerange-2' => 'جاقىن تٴۇسٴىرٴىلگەن',
'exif-subjectdistancerange-3' => 'الىس تٴۇسٴىرٴىلگەن',

# Pseudotags used for GPSLatitudeRef and GPSDestLatitudeRef
'exif-gpslatitude-n' => 'سولتٴۇستٴىك بويلىعى',
'exif-gpslatitude-s' => 'وڭتٴۇستٴىك بويلىعى',

# Pseudotags used for GPSLongitudeRef and GPSDestLongitudeRef
'exif-gpslongitude-e' => 'شىعىس ەندٴىگٴى',
'exif-gpslongitude-w' => 'باتىس ەندٴىگٴى',

'exif-gpsstatus-a' => 'ٴولشەۋ ۇلاسۋدا',
'exif-gpsstatus-v' => 'ٴولشەۋ ٴوزارا ٴارەكەتتە',

'exif-gpsmeasuremode-2' => '2-باعىتتىق ٴولشەم',
'exif-gpsmeasuremode-3' => '3-باعىتتىق ٴولشەم',

# Pseudotags used for GPSSpeedRef and GPSDestDistanceRef
'exif-gpsspeed-k' => 'km/h',
'exif-gpsspeed-m' => 'mil/h',
'exif-gpsspeed-n' => 'ج. تٴۇيٴىن',

# Pseudotags used for GPSTrackRef, GPSImgDirectionRef and GPSDestBearingRef
'exif-gpsdirection-t' => 'شىن باعىت',
'exif-gpsdirection-m' => 'ماگنيتتى باعىت',

# External editor support
'edit-externally'      => 'بۇل فايلدى سىرتقى قۇرال/باعدارلاما ارقىلى ٴوڭدەۋ',
'edit-externally-help' => 'كٴوبٴىرەك اقپارات ٴۇشٴىن [http://meta.wikimedia.org/wiki/Help:External_editors ورناتۋ نۇسقاۋلارىن] قاراڭىز.',

# 'all' in various places, this might be different for inflected languages
'recentchangesall' => 'بارلىعىن',
'imagelistall'     => 'بارلىعى',
'watchlistall1'    => 'بارلىعى',
'watchlistall2'    => 'بارلىق',
'namespacesall'    => 'بارلىعى',

# E-mail address confirmation
'confirmemail'            => 'ە-پوشتا جايىن كۋٴالاندىرۋ',
'confirmemail_noemail'    => '[[{{ns:special}}:Preferences|قاتىسۋشى باپتاۋىڭىزدا]] جارامدى ە-پوشتا جايىن ەنگٴىزبەپسٴىز.',
'confirmemail_text'       => 'بۇل ۋيكيدە ە-پوشتا قاسيەتتەرٴىن پايدالانۋدىڭ الدىنان ە-پوشتا جايىڭىزدى
كۋٴالاندىرۋ قاجەت. ٴوزٴىڭٴىزدٴىڭ جايىڭىزعا كۋٴالاندىرۋ حاتىن جٴىبەرۋ ٴۇشٴىن تٴومەندەگٴى تٴۇيمەنٴى نۇقىڭىز.
حاتتىڭ ٴىشٴىندە ارنايى كودى بار سٴىلتەمە كٴىرٴىستٴىرلەدٴى;	ە-پوشتا جايىڭىزدىڭ جارامدىعىن كۋٴالاندىرۋ ٴۇشٴىن
سٴىلتەمەنٴى شولعىشتىڭ مەكەن-جاي جولاعىنا ەنگٴىزٴىپ اشىڭىز.',
'confirmemail_send'       => 'كۋٴالاندىرۋ كودىن جٴىبەرۋ',
'confirmemail_sent'       => 'كۋٴالاندىرۋ ە-پوشتا حاتى جٴىبەرٴىلدٴى.',
'confirmemail_sendfailed' => 'كۋٴالاندىرۋ حاتى جٴىبەرٴىلمەدٴى. ەنگٴىزٴىلگەن جايدى جارامسىز ٴارٴىتەرٴىنە تەكسەرٴىپ شىعىڭىز.

ە-پوشتا قىزمەتٴى قايتارعانى: $1',
'confirmemail_invalid'    => 'كۋٴالاندىرۋ كودى جارامسىز. كودتىڭ مەرزٴىمٴى بٴىتكەن شىعار.',
'confirmemail_needlogin'  => 'ە-پوشتا جايىڭىزدى كۋٴالاندىرۋ ٴۇشٴىن $1 قاجەت.',
'confirmemail_success'    => 'ە-پوشتا جايىڭىز كۋٴالاندىرىلدى. ەندٴى ۋيكيگە كٴىرٴىپ جۇمىسقا كٴىرٴىسۋگە بولادى',
'confirmemail_loggedin'   => 'ە-پوشتا جايىڭىز كۋٴالاندىرىلدى.',
'confirmemail_error'      => 'كۋٴالاندىرۋىڭىزدى ساقتاعاندا بەلگٴىسٴىز قاتە بولدى.',
'confirmemail_subject'    => '{{SITENAME}} تورابىنان ە-پوشتا جايىڭىزدى كۋٴالاندىرۋ حاتى',
'confirmemail_body'       => "كەيبٴىرەۋ, مىنا $1 IP جايىنان, ٴوزٴىڭٴىز بولۋى مٴۇمكٴىن,
{{SITENAME}} جوباسىنداعى ە-پوشتا جايىن قولدانىپ «$2» تٴىركەلگٴى جاساپتى.

وسى تٴىركەلگٴى راستان سٴىزدٴىكٴى ەكەنٴىن كۋٴالاندىرۋ ٴۇشٴىن, جٴانە {{SITENAME}} جوباسىنىڭ
ە-پوشتا قاسيەتتەرٴىن بەلسەندٴىرۋ ٴۇشٴىن, مىنا سٴىلتەمەنٴى شولعىشپەن اشىڭىز:

$3

بۇل سٴىزدٴىكٴى '''ەمەس''' بولسا, سٴىلتەمەگە ەرمەڭٴىز. كۋٴالاندىرۋ كودىنىڭ
مەرزٴىمٴى $4 كەزٴىندە بٴىتەدٴى.",

# Inputbox extension, may be useful in other contexts as well
'tryexact'       => 'دٴال سٴايكەسٴىن سىناپ كٴورٴىڭٴىز',
'searchfulltext' => 'تولىق مٴاتٴىنٴىمەن ٴىزدەۋ',
'createarticle'  => 'بەتتٴى باستاۋ',

# Scary transclusion
'scarytranscludedisabled' => '[ۋيكي-ارا كٴىرەگۋ ٴوشٴىرٴىلگەن]',
'scarytranscludefailed'   => '[$1 بەتٴىنە ٴۇلگٴى ٴوڭدەتۋ سٴاتسٴىز بٴىتتٴى; كەشٴىرٴىڭٴىز]',
'scarytranscludetoolong'  => '[URL جايى تىم ۇزىن; كەشٴىرٴىڭٴىز]',

# Trackbacks
'trackbackbox'      => '<div id="mw_trackbacks">
بۇل بەتتٴىڭ اڭىستاۋلارى:<br />
$1
</div>',
'trackbackremove'   => '([$1 جويىلدى])',
'trackbacklink'     => 'اڭىستاۋ',
'trackbackdeleteok' => 'اڭىستاۋ جويۋى سٴاتتٴى ٴوتتٴى.',

# Delete conflict
'deletedwhileediting' => 'نازار سالىڭىز:سٴىز بۇل بەتتٴىڭ ٴوڭدەۋٴىن باستاعاندا, وسى بەت جويىلدى!',
'confirmrecreate'     => "سٴىز بۇل بەتتٴىڭ ٴوندەۋٴىن باستاعاندا [[{{ns:user}}:$1|$1]] ([[{{ns:user_talk}}:$1|تالقىلاۋى]]) وسى بەتتٴى جويدى, كٴورسەتكەن سەبەبٴى:
: ''$2''
وسى بەتتٴى شىنىنان قايتا جاساۋىن راستاڭىز.",
'recreate'            => 'قايتا جاساۋ',
'tooltip-recreate'    => 'بۇل بەتتٴى جويىلۋىنا قاراماي قايتا جاساۋ',

'unit-pixel' => ' px',

# HTML dump
'redirectingto' => '[[$1]] بەتٴىنە ايداتۋدا…',

# action=purge
'confirm_purge'        => 'قوسالقى قالتاداعى وسى بەتٴىن تازالايمىز با?<br /><br />$1',
'confirm_purge_button' => 'جارايدى',

'youhavenewmessagesmulti' => '$1 دەگەنگە جاڭا حابارلار تٴۇستٴى',

'searchcontaining' => "مىنا سٴوزٴى بار بەت اراسىنان ٴىزدەۋ: ''$1''.",
'searchnamed'      => "مىنا اتاۋلى بەت اراسىنان ٴىزدەۋ: ''$1''.",
'articletitles'    => "اتاۋلارى مىنادان باستالعان بەتتەر: ''$1''",
'hideresults'      => 'نٴاتيجەلەردٴى جاسىر',

# DISPLAYTITLE
'displaytitle' => '(بۇل بەتتٴىڭ سٴىلتەمەسٴى: [[$1]])',

'loginlanguagelabel' => 'تٴىل: $1',

# Multipage image navigation
'imgmultipageprev' => '&larr; الدىڭعى بەتكە',
'imgmultipagenext' => 'كەلەسٴى بەتكە &rarr;',
'imgmultigo'       => 'ٴوتۋ!',
'imgmultigotopre'  => 'مىنا بەتكە ٴوتۋ',

# Table pager
'ascending_abbrev'         => 'ٴوسۋ',
'descending_abbrev'        => 'كەمۋ',
'table_pager_next'         => 'كەلەسٴى بەتكە',
'table_pager_prev'         => 'الدىڭعى بەتكە',
'table_pager_first'        => 'العاشقى بەتكە',
'table_pager_last'         => 'سوڭعى بەتكە',
'table_pager_limit'        => 'بەت سايىن $1 دانا كٴورسەت',
'table_pager_limit_submit' => 'ٴوتۋ',
'table_pager_empty'        => 'ەش نٴاتيجە جوق',

# Auto-summaries
'autosumm-blank'   => 'بەتتٴىڭ بارلىق ماعلۇماتىن الاستاتتى',
'autosumm-replace' => "بەتتٴى '$1' دەگەنمەن الماستىردى",
'autoredircomment' => '[[$1]] دەگەنگە ايدادى', # This should be changed to the new naming convention, but existed beforehand
'autosumm-new' => 'جاڭا بەت ماعلۇماتى: $1',
);

?>
