<?php
/** Norwegian (Norsk (bokmål))
 *
 * @package MediaWiki
 * @subpackage Language
 */

$quickbarSettings = array(
	'Ingen', 'Fast venstre', 'Fast høyre', 'Flytende venstre'
);

$skinNames = array(
	'standard'    => 'Standard',
	'nostalgia'   => 'Nostalgi',
	'cologneblue' => 'Kölnerblå'
);

$bookstoreList = array(
	'Antikvariat.net' => 'http://www.antikvariat.net/',
	'Frida' => 'http://wo.uio.no/as/WebObjects/frida.woa/wa/fres?action=sok&isbn=$1&visParametre=1&sort=alfabetisk&bs=50',
	'Bibsys' => 'http://ask.bibsys.no/ask/action/result?cmd=&kilde=biblio&fid=isbn&term=$1&op=and&fid=bd&term=&arstall=&sortering=sortdate-&treffPrSide=50',
	'Akademika' => 'http://www.akademika.no/sok.php?ts=4&sok=$1',
	'Haugenbok' => 'http://www.haugenbok.no/resultat.cfm?st=extended&isbn=$1',
	'Amazon.com' => 'http://www.amazon.com/exec/obidos/ISBN=$1'
);

$namespaceNames = array(
	NS_MEDIA          => 'Medium',
	NS_SPECIAL        => 'Spesial',
	NS_MAIN           => '',
	NS_TALK           => 'Diskusjon',
	NS_USER           => 'Bruker',
	NS_USER_TALK      => 'Brukerdiskusjon',
	# NS_PROJECT set by $wgMetaNamespace
	NS_PROJECT_TALK   => '$1-diskusjon',
	NS_IMAGE          => 'Bilde',
	NS_IMAGE_TALK     => 'Bildediskusjon',
	NS_MEDIAWIKI      => 'MediaWiki',
	NS_MEDIAWIKI_TALK => 'MediaWiki-diskusjon',
	NS_TEMPLATE       => 'Mal',
	NS_TEMPLATE_TALK  => 'Maldiskusjon',
	NS_HELP           => 'Hjelp',
	NS_HELP_TALK      => 'Hjelpdiskusjon',
	NS_CATEGORY       => 'Kategori',
	NS_CATEGORY_TALK  => 'Kategoridiskusjon',
);

$separatorTransformTable = array(',' => "\xc2\xa0", '.' => ',' );
$linkTrail = '/^([æøåa-z]+)(.*)$/sDu';

$dateFormats = array(
	'mdy time' => 'H:i',
	'mdy date' => 'M j., Y',
	'mdy both' => 'M j., Y "kl." H:i',

	'dmy time' => 'H:i',
	'dmy date' => 'j. M Y',
	'dmy both' => 'j. M Y "kl." H:i',

	'ymd time' => 'H:i',
	'ymd date' => 'Y M j.',
	'ymd both' => 'Y M j. "kl." H:i',
);


$messages = array(
'tog-underline'         => 'Strek under lenker:',
'tog-highlightbroken'   => 'Formater ødelagte lenker <a href="" class="new">slik</a> (alternativt: slik<a href="" class="internal">?</a>).',
'tog-justify'           => 'Blokkjusterte avsnitt',
'tog-hideminor'         => 'Skjul mindre endringer i siste endringer',
'tog-extendwatchlist'   => 'Utvid overvåkningslista til å vise alle endringer i valgt tidsrom',
'tog-usenewrc'          => 'Forbedret siste endringer (ikke for alle nettlesere)',
'tog-numberheadings'    => 'Nummerer overskrifter',
'tog-showtoolbar'       => 'Vis verktøylinje (JavaScript)',
'tog-editondblclick'    => 'Rediger sider ved å dobbeltklikke (JavaScript)',
'tog-editsection'       => 'Rediger avsnitt ved hjelp av [rediger]-lenke',
'tog-editsectiononrightclick'=> 'Rediger avsnitt ved å høyreklikke på avsnittsoverskrift (JavaScript)',
'tog-showtoc'           => 'Vis innholdsfortegnelse (for sider med mer enn tre seksjoner)',
'tog-rememberpassword'  => 'Husk passordet',
'tog-editwidth'         => 'Full bredde på redigeringsboksen',
'tog-watchcreations'    => 'Overvåk sider du oppretter',
'tog-watchdefault'      => 'Overvåk alle redigerte sider',
'tog-minordefault'      => 'Merk i utgangspunktet alle redigeringer som mindre',
'tog-previewontop'      => 'Flytt forhåndsvisningen foran redigeringsboksen',
'tog-previewonfirst'    => 'Vis forhåndsvisning ved første redigering av en side',
'tog-nocache'           => 'Skru av mellomlagring av sider («caching»)',
'tog-enotifwatchlistpages'=> 'E-post med ved sideenringer',
'tog-enotifusertalkpages'=> 'E-post meg ved endringer på brukerdiskusjonssiden min',
'tog-enotifminoredits'  => 'E-post meg også ved mindre sideendringer',
'tog-enotifrevealaddr'  => 'Vis e-postadressen min i e-poster',
'tog-shownumberswatching'=> 'Vis antall overvåkende brukere',
'tog-fancysig'          => 'Råsignatur (uten automatisk lenke)',
'tog-externaleditor'    => 'Bruk ekstern behandler som standard',
'tog-externaldiff'      => 'Bruk ekstern differanse som standard',
'tog-showjumplinks'     => 'Slå på «gå til»-lenker',
'tog-uselivepreview'    => 'Bruk levende forhåndsvisning (eksperimentell JavaScript)',
'tog-autopatrol'        => 'Merk mine redigeringer som godkjente automatisk',
'tog-forceeditsummary'  => 'Advar meg når jeg ikke har noen redigeringsforklaring',
'tog-watchlisthideown'  => 'Skjul mine endringer fra overvåkningslista',
'tog-watchlisthidebots' => 'Skjul robotendringer fra overvåkningslista',
'underline-always'      => 'Alltid',
'underline-never'       => 'Aldri',
'underline-default'     => 'Bruk nettleserstandard',
'skinpreview'           => '(forhåndsvisning)',
'sunday'                => 'søndag',
'monday'                => 'mandag',
'tuesday'               => 'tirsdag',
'wednesday'             => 'onsdag',
'thursday'              => 'torsdag',
'friday'                => 'fredag',
'saturday'              => 'lørdag',
'january'               => 'januar',
'february'              => 'februar',
'march'                 => 'mars',
'april'                 => 'april',
'may_long'              => 'mai',
'june'                  => 'juni',
'july'                  => 'juli',
'august'                => 'august',
'september'             => 'september',
'october'               => 'oktober',
'november'              => 'november',
'december'              => 'desember',
'jan'                   => 'jan',
'feb'                   => 'feb',
'mar'                   => 'mar',
'apr'                   => 'apr',
'may'                   => 'mai',
'jun'                   => 'jun',
'jul'                   => 'jul',
'aug'                   => 'aug',
'sep'                   => 'sep',
'oct'                   => 'okt',
'nov'                   => 'nov',
'dec'                   => 'des',
'categories'            => 'Kategorier',
'pagecategories'        => '{{PLURAL:$1|Kategori|Kategorier}}',
'category_header'       => 'Artikler i kategorien «$1»',
'subcategories'         => 'Underkategorier',
'mainpage'              => 'Hovedside',
'mainpagetext'          => '<big>\'\'\'MediaWiki-programvaren er nå installert.\'\'\'</big>',
'mainpagedocfooter'     => 'Se [http://meta.wikimedia.org/wiki/Help:Contents brukerveiledningen] for informasjon om hvordan du bruker wiki-programvaren.

==Å starte==
*[http://www.mediawiki.org/wiki/Help:Configuration_settings Konfigurasjonsliste]
*[http://www.mediawiki.org/wiki/Help:FAQ Ofte spurte spørsmål]
*[http://mail.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki e-postliste]',
'portal'                => 'Prosjektportal',
'portal-url'            => 'Project:Prosjektportal',
'about'                 => 'Om',
'aboutsite'             => 'Om {{SITENAME}}',
'aboutpage'             => 'Project:Om',
'article'               => 'Artikkel',
'help'                  => 'Hjelp',
'helppage'              => 'Help:Hjelp',
'bugreports'            => 'Feilmeldinger',
'bugreportspage'        => 'Project:Feilmeldinger',
'sitesupport'           => 'Donasjoner',
'sitesupport-url'       => 'Project:Donasjoner',
'faq'                   => 'Ofte spurte spørsmål',
'faqpage'               => 'Project:Ofte spurte spørsmål',
'edithelp'              => 'Redigeringshjelp',
'newwindow'             => '(åpner i nytt vindu)',
'edithelppage'          => 'Help:Hvordan redigere',
'cancel'                => 'Avbryt',
'qbfind'                => 'Finn',
'qbbrowse'              => 'Søk',
'qbedit'                => 'Rediger',
'qbpageoptions'         => 'Sideinnstillinger',
'qbpageinfo'            => 'Sideinformasjon',
'qbmyoptions'           => 'Egne innstillinger',
'qbspecialpages'        => 'Spesialsider',
'moredotdotdot'         => 'Mer…',
'mypage'                => 'Min side',
'mytalk'                => 'Min diskusjonsside',
'anontalk'              => 'Brukerdiskusjon for denne IP-adressen',
'navigation'            => 'Navigasjon',
'metadata_help'         => 'Metadata (se [[Project:Metadata]] for en forklaring):',
'currentevents'         => 'Aktuelt',
'currentevents-url'     => 'Project:Aktuelt',
'disclaimers'           => 'Opphavsrett',
'disclaimerpage'        => 'Project:Opphavsrett',
'privacy'               => 'Personvern',
'privacypage'           => 'Project:Personvern',
'errorpagetitle'        => 'Feil',
'returnto'              => 'Tilbake til $1.',
'tagline'               => 'Fra {{SITENAME}}',
'search'                => 'Søk',
'searchbutton'          => 'Søk',
'go'                    => 'Gå',
'searcharticle'                    => 'Gå',
'history'               => 'Historikk',
'history_short'         => 'Historikk',
'updatedmarker'         => 'oppdatert siden mitt forrige besøk',
'info_short'            => 'Informasjon',
'printableversion'      => 'Utskriftsvennlig versjon',
'permalink'             => 'Permanent lenke',
'print'                 => 'Skriv ut',
'edit'                  => 'Rediger',
'editthispage'          => 'Rediger siden',
'delete'                => 'Slett',
'deletethispage'        => 'Slett side',
'undelete_short'        => 'Gjenopprett $1 revisjoner',
'protect'               => 'Lås',
'protectthispage'       => 'Lås siden',
'unprotect'             => 'Åpne',
'unprotectthispage'     => 'Åpne siden',
'newpage'               => 'Ny side',
'talkpage'              => 'Diskuter siden',
'specialpage'           => 'Spesialside',
'personaltools'         => 'Personlige verktøy',
'postcomment'           => 'Legg til en kommentar',
'articlepage'           => 'Vis artikkel',
'talk'                  => 'Diskusjon',
'views'                 => 'Visninger',
'toolbox'               => 'Verktøy',
'userpage'              => 'Vis brukerside',
'projectpage'           => 'Vis prosjektside',
'imagepage'             => 'Bildeside',
'viewtalkpage'          => 'Vis diskusjon',
'otherlanguages'        => 'Andre språk',
'redirectedfrom'        => '(Omdirigert fra $1)',
'autoredircomment'      => 'Omdirigerer til [[$1]]',
'redirectpagesub'       => 'Omdirigeringsside',
'lastmodifiedat'          => 'Denne siden ble sist endret $2, $1.',
'viewcount'             => 'Denne siden er vist $1 {{plural:$1|gang|ganger}}.',
'copyright'             => 'Innholdet er tilgjengelig under $1.',
'protectedpage'         => 'Låst side',
'jumpto'                => 'Gå til:',
'jumptonavigation'      => 'navigasjon',
'jumptosearch'          => 'søk',
'badaccess'             => 'Rettighetsfeil',
'versionrequired'       => 'Versjon $1 av MediaWiki påtrengt',
'versionrequiredtext'   => 'Versjon $1 av MediaWiki er nødvendig for å bruke denne siden. Se [[Special:Version]]',
'ok'                    => 'OK',
'pagetitle'             => '$1 - {{SITENAME}}',
'retrievedfrom'         => 'Hentet fra «$1»',
'youhavenewmessages'    => 'Du har $1 ($2).',
'newmessageslink'       => 'nye meldinger',
'newmessagesdifflink'   => 'forskjell fra forrige beskjed',
'editsection'           => 'rediger',
'editold'               => 'rediger',
'editsectionhint'       => 'Rediger seksjon: $1',
'toc'                   => 'Innhold',
'showtoc'               => 'vis',
'hidetoc'               => 'skjul',
'thisisdeleted'         => 'Se eller gjenopprett $1?',
'viewdeleted'           => 'Vis $1?',
'restorelink'           => '{{plural:$1|én slettet revisjon|$1 slettede revisjoner}}',
'feedlinks'             => 'Mating:',
'feed-invalid'          => 'Ugyldig matingstype.',
'nstab-main'            => 'Artikkel',
'nstab-user'            => 'Brukerside',
'nstab-media'           => 'Mediaside',
'nstab-special'         => 'Spesial',
'nstab-project'         => 'Prosjektside',
'nstab-image'           => 'Fil',
'nstab-mediawiki'       => 'Melding',
'nstab-template'        => 'Mal',
'nstab-help'            => 'Hjelp',
'nstab-category'        => 'Kategori',
'nosuchaction'          => 'Funksjonen finnes ikke',
'nosuchactiontext'      => 'MediaWiki-programvaren kjenner ikke igjen funksjonen som er spesifisert i URL-en.',
'nosuchspecialpage'     => 'En slik spesialside finnes ikke',
'nospecialpagetext'     => 'Du har bedt om en ugyldig spesialside; en liste over gyldige spesialsider finnes på [[Special:Specialpages]].',
'error'                 => 'Feil',
'databaseerror'         => 'databasefeil',
'dberrortext'           => 'Det har skjedd en syntaksfeil i databasen. Den sist forsøkte forespørsel var: <blockquote><tt>$1</tt></blockquote> fra funksjonen «<tt>$2</tt>». MySQL returnerte feilen «<tt>$3: $4</tt>».',
'dberrortextcl'         => 'Det har skjedd en syntaksfeil i databasen. Den sist forsøkte forespørselen var: «$1» fra funksjonen «$2». MySQL returnerte feilen «$3: $4».',
'noconnect'             => 'Beklager! Wikien har tekniske problemer, og kan ikke kontakte databasetjeneren.<br />$1',
'nodb'                  => 'Kunne ikke velge databasen $1',
'cachederror'           => 'Det følgende er en lagret kopi av den ønskede siden, og er ikke nødvendigvis oppdatert.',
'laggedslavemode'       => 'Advarsel: Dette kan være en eldre versjon av siden.',
'readonly'              => 'Databasen er skrivebeskyttet',
'enterlockreason'       => 'Skriv en begrunnelse for skrivebeskyttelsen, inkludert et estimat angående når den vil bli opphevet',
'readonlytext'          => 'Databasen er for øyeblikket skrivebeskyttet, sannsynligvis på grunn av rutinemessig vedlikehold.

Administratoren som låste databasen ga forklaringen: $1',
'missingarticle'        => 'Databasen fant ikke teksten til en side den skulle ha funnet, «$1».

Hvis dette er en nylig endret side vil det vanligvis hjelpe å prøve igjen
om et minutt eller to. Ellers er det mulig du har fulgt en lenke til en side
som er blitt slettet.

Hvis dette ikke er tilfelle er det mulig du har støtt på en programfeil.
Send en rapport om dette til en administrator, og inkluder adressen (URL-en)
til siden.',
'readonly_lag'          => 'Databasen er automatisk skrivebeskyttet så slavetjenerne kan ta igjen mestertjeneren',
'internalerror'         => 'Intern feil',
'filecopyerror'         => 'Kunne ikke kopiere filen «$1» til «$2».',
'filerenameerror'       => 'Kunne ikke omdøpe filen «$1» til «$2».',
'filedeleteerror'       => 'Kunne ikke slette filen «$1».',
'filenotfound'          => 'Kunne ikke finne filen «$1».',
'unexpected'            => 'Uventet verdi: «$1»=«$2».',
'formerror'             => 'Feil: kunne ikke sende skjema',
'badarticleerror'       => 'Handlingen kan ikke utføres på denne siden.',
'cannotdelete'          => 'Kunne ikke slette filen (den kan allerede være slettet av noen andre).',
'badtitle'              => 'Ugyldig tittel',
'badtitletext'          => 'Den ønskede tittelen var ugyldig, tom eller galt lenket fra et annet språk.',
'perfdisabled'          => 'Denne funksjonen er midlertidig utilgjengelig av vedlikeholdsgrunner.',
'perfdisabledsub'       => 'Her er en lagret kopi fra $1:',
'perfcached'            => 'Følgende data er en lagret kopi, og ikke nødvendigvis den siste versjonen i databasen.',
'perfcachedts'          => 'Følgende data er en lagret kopi, og ble sist oppdatert $1.',
'viewsource'            => 'Vis kildekode',
'viewsourcefor'         => 'for $1',
'protectedtext'         => 'Denne siden er sperret for redigeringer; det kan være flere grunner til dette, se [[Project:Beskyttet side]].

Du kan se og kopiere kildekoden til denne siden:',
'protectedinterface'    => 'Denne siden viser brukergrensesnittet for programvaren, og er låst for å hindre misbruk.',
'editinginterface'      => '\'\'\'Advarsel:\'\'\' Du redigerer en side som brukes i grensesnittet for programvaren. Endringer på denne siden vil påvirke hvordan grensesnittet vil se ut.',
'sqlhidden'             => '(SQL-spørring skjult)',
'logouttitle'           => 'Logg ut',
'logouttext'            => '<strong>Du er nå logget ut.</strong><br />
Du kan fortsette å bruke {{SITENAME}} anonymt, eller logge inn igjen som samme eller annen bruker.',
'welcomecreation'       => '==Velkommen, $1!==

Brukerkontoen din har blitt opprettet. Ikke glem å endre [[Special:Preferences|innstillingene dine]].',
'loginpagetitle'        => 'Logg inn',
'yourname'              => 'Brukernavn',
'yourpassword'          => 'Passord',
'yourpasswordagain'     => 'Gjenta passord',
'remembermypassword'    => 'Husk passordet',
'yourdomainname'        => 'Ditt domene',
'loginproblem'          => '<strong>Du ble ikke logget inn.</strong><br />Prøv igjen!',
'alreadyloggedin'       => '\'\'\'$1 er allerede logget inn!\'\'\'<br />',
'login'                 => 'Logg inn',
'loginprompt'           => 'Du må ha slått på cookies for å logge in på {{SITENAME}}.',
'userlogin'             => 'Logg inn eller registrer deg',
'logout'                => 'Logg ut',
'userlogout'            => 'Logg ut',
'notloggedin'           => 'Ikke innlogget',
'nologin'               => 'Er du ikke registrert? $1.',
'nologinlink'           => 'Registrer deg',
'createaccount'         => 'Opprett ny konto',
'gotaccount'            => 'Har du allerede et brukernavn? $1.',
'gotaccountlink'        => 'Logg inn',
'createaccountmail'     => 'per e-post',
'badretype'             => 'Passordene samsvarte ikke.',
'userexists'            => 'Brukernavnet er allerede i bruk. Velg et nytt.',
'youremail'             => 'E-postadresse',
'username'              => 'Brukernavn:',
'uid'                   => 'Bruker-ID:',
'yourrealname'          => 'Virkelig navn *',
'yourlanguage'          => 'Språk:',
'yourvariant'           => 'Variant',
'yournick'              => 'Signatur',
'badsig'                => 'Ugyldig råsignatur; sjekk HTML-tagger.',
'email'                 => 'E-post',
'prefs-help-email-enotif'=> 'Denne adressen brukes også til å sende e-postmeldinger dersom du har slått på dette.',
'prefs-help-realname'   => '* Virkelig navn (valgfritt): dersom du velger å oppgi navnet, vil det bli brukt til å kreditere deg for ditt arbeid.',
'loginerror'            => 'Innloggingsfeil',
'prefs-help-email'      => '* E-post (valgfritt): Muliggjør at andre kan kontakte deg uten at identiteten din blir avslørt.',
'nocookiesnew'          => 'Din brukerkonto er nå opprettet, men du har ikke logget på. {{SITENAME}} bruker informasjonskapsler («cookies») for å logge brukere på. Du har slått dem av. Slå dem p åfor å kunne logge på med ditt nye brukernavn og passord.',
'nocookieslogin'        => '{{SITENAME}} bruker informasjonskapsler («cookies») for å logge brukere på. Du har slått dem av. Slå dem på og prøv igjen.',
'noname'                => 'Du har ikke oppgitt et gyldig brukernavn.',
'loginsuccesstitle'     => 'Du er nå logget inn',
'loginsuccess'          => 'Du er nå logget inn på {{SITENAME}} som «$1».',
'nosuchuser'            => 'Det eksisterer ingen bruker ved navn «$1». Sjekk stavemåten eller opprett en ny konto.',
'nosuchusershort'       => 'Det finnes ingen bruker ved navn «$1». Kontroller stavemåten.',
'nouserspecified'       => 'Du må oppgi et brukernavn.',
'wrongpassword'         => 'Du har oppgitt et ugyldig passord. Prøv igjen.',
'wrongpasswordempty'    => 'Du oppga ikke noe passord. Prøv igjen.',
'mailmypassword'        => 'Send nytt passord.',
'passwordremindertitle' => 'Nytt passord fra {{SITENAME}}',
'passwordremindertext'  => 'Noen (antagelig deg, fra IP-adressen $1) ba oss sende deg et nytt passord til {{SITENAME}} ($4). Passordet for kontoen «$2» er nå «$3». Du bør logge inn og endre pasordet nå.

Dersom noen andre gjorde denne forespørselen eller om du kom på passordet og ikke lenger ønsker å endre det, kan du ignorere denne beskjeden og fortsette å bruke det gamle passordet.',
'noemail'               => 'Det er ikke registrert noen e-postadresse for brukeren «$1».',
'passwordsent'          => 'Et nytt passord har blitt send til e-postadressen registrert på bruker «$1». Logg inn når du har mottatt det nye passordet.',
'eauthentsent'          => 'En bekreftelses e-post har blitt sendt til den angitte e-postadressen. Før andre e-poster kan sendes til kontoen, må du følge instruksjonene i e-posten for å bekrefte at kontoen faktisk er din.',
'mailerror'             => 'Feil under sending av e-post: $1',
'acct_creation_throttle_hit'=> 'Beklager, du har allerede opprettet $1 kontoer. Du kan ikke opprette flere.',
'emailauthenticated'    => 'E-postadressen ble bekreftet $1.',
'emailnotauthenticated' => 'E-postadressen er ikke bekreftet. Ingen e-poster vil bli sendt for følgende tjenester.',
'noemailprefs'          => '<strong>Ingen e-postadresse er oppgitt</strong>, så følgende funksjoner vil ikke fungere.',
'emailconfirmlink'      => 'Bekreft e-postadressen din.',
'invalidemailaddress'   => 'E-postadressen kan ikke aksepteres fordi den er ugyldig formatert. Skriv inn en fungerende e-postadresse eller tøm feltet.',
'accountcreated'        => 'Brukerkonto opprettet',
'accountcreatedtext'    => 'Brukerkonto for $1 har blitt opprettet.',
'bold_sample'           => 'Fet tekst',
'bold_tip'              => 'Fet tekst',
'italic_sample'         => 'Kursiv tekst',
'italic_tip'            => 'Kursiv tekst',
'link_sample'           => 'Lenketittel',
'link_tip'              => 'Intern lenke',
'extlink_sample'        => '{{SERVER}} lenketittel',
'extlink_tip'           => 'Ekstern lenke (husk prefikset http://)',
'headline_sample'       => 'Overskrift',
'headline_tip'          => 'Overskrift',
'math_sample'           => 'Sett inn formel her',
'math_tip'              => 'Matematisk formel (LaTeX)',
'nowiki_sample'         => 'Sett inn uformatert tekst her',
'nowiki_tip'            => 'Ignorer wikiformatering',
'image_sample'          => 'Eksempel.jpg',
'image_tip'             => 'Bilde',
'media_sample'          => 'Eksempel.ogg',
'media_tip'             => 'Mediafillenke',
'sig_tip'               => 'Din signatur med dato',
'hr_tip'                => 'Horisontal linje',
'summary'               => 'Redigeringsforklaring',
'subject'               => 'Overskrift',
'minoredit'             => 'Mindre endring',
'watchthis'             => 'Overvåk side',
'savearticle'           => 'Lagre siden',
'preview'               => 'Forhåndsvisning',
'showpreview'           => 'Forhåndsvisning',
'showlivepreview'       => 'Levende forhåndsvisning',
'showdiff'              => 'Vis endringer',
'anoneditwarning'       => '\'\'\'Advarsel:\'\'\' Du er ikke logget inn. Din IP-adresse vil bli bevart i sidens redigeringshistorikk.',
'missingsummary'        => '\'\'\'Påminnelse:\'\'\' Du har ikke lagt inn en [[Help:Redigeringsforklaring|redigeringsforklaring]]. velger du \'\'Lagre siden\'\' en gang til blir endringene lagret uten forklaring.',
'missingcommenttext'    => 'Vennligst legg inn en kommentar under.',
'blockedtitle'          => 'Brukeren er blokkert',
'blockedtext'           => 'Brukernavnet eller IP-adressen er blokkert av $1 med følgende begrunnelse:<br />\'\'$2\'\'

Du kan kontakte $1 eller en annen [[Project:Administratorer|administrator]] for å diskutere utestengelsen.

Din ip-adresse er $3. Vennligst inkluder denne i alle forespørsler du gjør.',
'whitelistedittitle'    => 'Innlogging kreves for å redigere',
'whitelistedittext'     => 'Du må [[Special:userlogin|logge inn}} for å redigere artikler.',
'whitelistreadtitle'    => 'Innlogging kreves for å lese',
'whitelistreadtext'     => 'Du må [[Special:Userlogin|logge inn]] for å lese artikler.',
'whitelistacctitle'     => 'Du har ikke adgang til å opprette en konto',
'whitelistacctext'      => 'For å få adgang til å opprette kontoer må du [[Special:Userlogin|logge inn]] og ha tilstrekkelige rettigheter.',
'confirmedittitle'      => 'E-postbekreftelse nødvendig før du kan redigere',
'confirmedittext'       => 'Du må bekrefte e-postadressen din før du kan redigere sider. Vennligst oppgi og valider e-postadressen din via [[Special:Preferences|innstillingene dine]].',
'loginreqtitle'         => 'Innlogging kreves',
'loginreqlink'          => 'logge inn',
'loginreqpagetext'      => 'Du må [[Special:Userlogin|logge inn]] for å se andre sider.',
'accmailtitle'          => 'Passord sendt',
'accmailtext'           => 'Passordet for «$1» har blitt sendt til $2.',
'newarticle'            => '(ny)',
'newarticletext'        => 'Du har fulgt en lenke til en side som ikke finnes ennå. For å opprette siden, start å skrive i boksen under (se [[Project:Hjelp|hjelpesiden]] for mer informasjon). Om du kom hit ved en feil, trykk på nettleserens \'\'\'tilbake\'\'\'-knapp.',
'anontalkpagetext'      => '----
\'\'Dette er en diskusjonsside for en anonym bruker som ikke har opprettet konto eller ikke er logget inn. Vi er derfor nødt til å bruke den numeriske IP-adressen til å identifisere ham eller henne. En IP-adresse kan være delt mellom flere brukere. Hvis du er en anonym bruker og synes at du har fått irrelevante kommentarer på en slik side, [[Special:Userlogin|logg på]] så vi unngår framtidige forvekslinger med andre anonyme brukere.\'\'',
'noarticletext'         => 'Det er ikke noe tekst på denne siden. Du kan [[Special:Search/{{PAGENAME}}|søke etter siden]] i andre sider, eller [{{fullurl:{{FULLPAGENAME}}|action=edit}} redigere siden].',
'clearyourcache'        => '\'\'\'NB:\'\'\' Etter å ha lagret må du tømme nettleserens mellomlager («cache») for å kunne se endringene: \'\'\'Mozilla/Safari/Konqueror:\'\'\' hold nede \'\'Shift\'\' mens du klikker på \'\'Reload\'\' (eller trykk \'\'Ctrl-Shift-R\'\'), \'\'\'IE:\'\'\' trykk \'\'Ctrl-F5\'\', \'\'\'Opera:\'\'\' trykk \'\'F5\'\'.',
'usercssjsyoucanpreview'=> '<strong>Tips:</strong> Bruk «Forhåndsvisning»-knappen for å teste din nye CSS/JS før du lagrer.',
'usercsspreview'        => '\'\'\'Husk at dette bare er en forhåndsvisning av din bruker-CSS og at den ikke er lagret!\'\'\'',
'userjspreview'         => '\'\'\'Husk at dette bare er en test eller forhåndsvisning av ditt bruker-JavaScript, og det ikke er lagret!\'\'\'',
'userinvalidcssjstitle' => '\'\'\'Advarsel:\'\'\' Det finnes ikke noe utseende ved navn «$1». Husk at .css- og .js-sider bruker titler i små bokstaver, for eksempel User:Eksempel/monobook.css, ikke User:Eksempel/Monobook.css',
'updated'               => '(Oppdatert)',
'note'                  => '<strong>Merk:</strong>',
'previewnote'           => '<strong>Dette er bare en forhåndsvisning; endringer har ikke blitt lagret!</strong>',
'session_fail_preview'  => '<strong>Beklager! Redigeringen din kunne ikke lagres. Vennligst prøv igjen. Om det fortsetter å gå galt, prøv å logge ut og så inn igjen.</strong>',
'previewconflict'       => 'Slik vil teksten i redigeringsvinduet se ut dersom du lagrer den.',
'session_fail_preview_html'=> '<strong>Beklager! Redigeringen din kunne ikke lagres på grunn av tap av sesjonsdata.</strong>

\'\'Fordi denne wikien har rå HTML slått på, er forhåndsvisningen skjult for å forhindre JavaScript-angrep.\'\'',
'importing'             => 'Importerer $1',
'editing'               => 'Redigerer $1',
'editinguser'               => 'Redigerer $1',
'editingsection'        => 'Redigerer $1 (seksjon)',
'editingcomment'        => 'Redigerer $1 (kommentar)',
'editconflict'          => 'Redigeringskonflikt: $1',
'explainconflict'       => 'Noen andre har endret teksten siden du begynte å redigere.
Den øverste boksen inneholder den nåværende tekst.
Dine endringer vises i den nederste boksen.
Du er nødt til å flette dine endringer sammen med den nåværende teksten.
<b>Kun</b> teksten i den øverste tekstboksen vil bli lagret når du
trykker «Lagre siden».<br />',
'yourtext'              => 'Din tekst',
'storedversion'         => 'Den lagrede versjonen',
'nonunicodebrowser'     => '<strong>ADVARSEL: Nettleseren din har ikke støtte for nicode. Skru det på før du begynner å redigere artikler.</strong>',
'editingold'            => '\'\'\'ADVARSEL: Du redigerer en gammel versjon av denne siden. Hvis du lagrer den, vil alle endringer foretatt siden denne versjonen bli overskrevet.\'\'\'',
'yourdiff'              => 'Forskjeller',
'copyrightwarning'      => 'Vennligst merk at alle bidrag til {{SITENAME}} anses som utgitt under $2 (se $1 for detaljer). Om du ikke vil at dine bidrag skal kunne redigeres og distribuert fritt, ikke legg det til her.<br />
Du lover også at du har skrevet dette selv, eller kopiert det fra en ressurs som er i public domain eller lignende. <strong>IKKE LEGG TIL OPPHAVSBESKYTTET MATERIALE UTEN TILLATELSE!</strong>',
'copyrightwarning2'     => 'Vennligst merk at alle bidrag til {{SITENAME}} kan bli redigert, endret eller fjernet av andre bidragsytere. Om du ikke vil at dine bidrag skal kunne redigeres fritt, ikke legg det til her.<br />
Du lover også at du har skrevet dette selv, eller kopiert det fra en ressurs som er i public domain eller lignende (se $1 for detaljer). <strong>IKKE LEGG TIL OPPHAVSBESKYTTET MATERIALE UTEN TILLATELSE!</strong>',
'longpagewarning'       => '<strong>ADVARSEL: Denne siden er $1&nbsp;kB lang; noen eldre nettlesere kan ha problemer med å redigere sider som nærmer seg eller er lengre enn 32&nbsp;kB. Overvei om ikke siden kan deles opp i mindre deler.</strong>',
'longpageerror'         => '<strong>FEIL: Teksten du har forsøkt å lagre er $1&nbsp;kB lang, dvs. lenger enn det maksimale $2&nbsp;kB. Den kan ikke lagres.</strong>',
'readonlywarning'       => '<strong>ADVARSEL: Databasen er låst på grunn av vedlikehold,
så du kan ikke lagre dine endringer akkurat nå. Det kan være en god idé å
kopiere teksten din til en tekstfil, så du kan lagre den til senere.</strong>',
'protectedpagewarning'  => '<strong>ADVARSEL: Denne siden er låst slik at bare administratorer kan redigere den. Sørg for at du følger [[Project:Retningslinjer for låsing av sider|retningslinjer for låsing av sider]].</strong>',
'semiprotectedpagewarning'=> '\'\'\'Merk:\'\'\' Denne siden har blitt låst slik at kun registrerte brukere kan endre den. Nyopprettede og anonyme brukere kan ikke redigere.',
'templatesused'         => 'Maler i bruk på denne siden:',
'edittools'             => '<!-- Teksten her vil vises under redigerings- og opplastingsboksene. -->',
'nocreatetitle'         => 'Sideoppretting er begrenset',
'nocreatetext'          => 'Denne siden har begrensede muligheter for oppretting av nye sider. Du kan gå tilbake og redigere en eksisterende side, eller [[Special:Userlogin|logge inn eller opprette en ny konto]].',
'revhistory'            => 'Historikk',
'nohistory'             => 'Denne siden har ingen historikk.',
'revnotfound'           => 'Versjonen er ikke funnet',
'revnotfoundtext'       => 'Den gamle versjonen av siden du etterspurte finnes ikke. Vennligst kontroller adressen du brukte for å få adgang til denne siden.',
'loadhist'              => 'Laster historikk',
'currentrev'            => 'Nåværende versjon',
'revisionasof'          => 'Versjonen fra $1',
'previousrevision'      => '← Eldre versjon',
'nextrevision'          => 'Nyere versjon →',
'currentrevisionlink'   => 'vis nåværende versjon',
'cur'                   => 'nå',
'next'                  => 'neste',
'last'                  => 'forrige',
'orig'                  => 'original',
'histlegend'            => 'Forklaring: (nå) = forskjell fra nåværende versjon, (forrige) = forskjell fra forrige versjon, M = mindre endring.',
'deletedrev'            => '[slettet]',
'histfirst'             => 'Første',
'histlast'              => 'Siste',
'rev-deleted-comment'   => '(kommentar fjernet)',
'rev-deleted-user'      => '(brukernavn fjernet)',
'rev-deleted-text-permission'=> '<div class="mw-warning plainlinks">
Denne sidehistorikken har blitt fjernet fra de offentlige arkivene. Det kan være detaljer i [{{fullurl:Special:Log/delete|page={{PAGENAMEE}}}} slettingsloggen].
</div>',
'rev-deleted-text-view' => '<div class="mw-warning plainlinks">
Denne revisjonen har blitt fjernet fra det offentlige arkivet. Som administrator har du mulighet til å se den; det kan være detaljer i [{{fullurl:Special:Log/delete|page={{PAGENAMEE}}}} slettingsloggen].
</div>',
'rev-delundel'          => 'vis/skjul',
'history-feed-title'    => 'Revisjonshistorikk',
'history-feed-description'=> 'Revisjonshistorikk for denne siden',
'history-feed-item-nocomment'=> '$1 på $2',
'history-feed-empty'    => 'Den etterspurte siden finnes ikke. Den kan ha blitt slettet fra wikien, eller fått et nytt navn. Prøv å [[Special:Search|søke]] etter beslektede sider.',
'revisiondelete'        => 'Slett/gjenopprett revisjoner',
'revdelete-selected'    => 'Valgte revisjon av [[:$1]]:',
'revdelete-text'        => 'Slettede revisjoner vil fortsatt vises i sidehistorikken, men innholdet vil ikke være tilgjengelig for offentligheten.

Andre administratorer på denne wikien vil fortsatt kunne se det skjulte innholdet, og kan gjenopprette det, med mindre videre begrensninger blir gitt av sideoperatørene.',
'revdelete-legend'      => 'Sett revisjonsbegrensninger:',
'revdelete-hide-text'   => 'Skjul revisjonstekst',
'revdelete-hide-comment'=> 'Skjul redigeringsforklaring',
'revdelete-hide-user'   => 'Skjul bidragsyters brukernavn eller IP',
'revdelete-hide-restricted'=> 'Disse restriksjonene gjelder også for administratorer',
'revdelete-log'         => 'Loggkommentar:',
'revdelete-submit'      => 'Utfør for valgte revisjoner',
'revdelete-logentry'    => 'endre revisjonssynlighet for [[$1]]',
'difference'            => '(Forskjeller mellom versjoner)',
'loadingrev'            => 'laster revisjon for å se forskjeller',
'lineno'                => 'Linje $1:',
'editcurrent'           => 'Rediger nåværende versjon av denne siden',
'selectnewerversionfordiff'=> 'Velg en nyere versjon for sammenligning',
'selectolderversionfordiff'=> 'Velg en eldre versjon for sammenligning',
'compareselectedversions'=> 'Sammenlign valgte versjoner',
'searchresults'         => 'Søkeresultater',
'searchresulttext'      => 'For mer informasjon om søking i {{SITENAME}}, se [[Project:Søking]].',
'badquery'              => 'Ugyldig forespørsel',
'badquerytext'          => 'Forespørselen kunne ikke bli utført. Det er sannsynligvis fordi du har prøvd å søke etter et ord med færre en tre bokstaver, noe som ikke fungerer ennå. Det kan også hende at du har skrevet feil. Prøv igjen.',
'matchtotals'           => 'Forespørselen «$1» ga treff på {{plural:$2|én artikkel|$2 artikler}} og på teksten i {{plural:$3|én artikkel|$3 artikler}}.',
'titlematches'          => 'Artikkeltitler med treff på forespørselen',
'notitlematches'        => 'Ingen artikkeltitler hadde treff på forespørselen',
'textmatches'           => 'Artikkeltekster med treff på forespørselen',
'notextmatches'         => 'Ingen artikkeltekster hadde treff på forespørselen',
'prevn'                 => 'forrige $1',
'nextn'                 => 'neste $1',
'viewprevnext'          => 'Vis ($1) ($2) ($3).',
'showingresults'        => 'Nedenfor vises opptil \'\'\'$1\'\'\' resultater som starter med nummer \'\'\'$2\'\'\'.',
'showingresultsnum'     => 'Nedenfor vises \'\'\'$3\'\'\' resultater som starter med nummer \'\'\'$2\'\'\'.',
'nonefound'             => '\'\'\'Merk:\'\'\' Søk uten resultat skyldes ofte at man søker etter alminnelige ord som «i» eller «på», som ikke er indeksert, eller ved å spesifisere mer enn et søkeord (da kun sider som inneholder alle søkeordene blir funnet).',
'powersearch'           => 'Søk',
'powersearchtext'       => 'Søk i navnerom:<br />$1<br />$2 List opp omdirigeringer<br />Søk etter $3 $9',
'searchdisabled'        => 'Søkefunksjonen er slått av. Du kan søke via Google i mellomtiden. Merk at Googles indeksering av {{SITENAME}} muligens er utdatert.',
'blanknamespace'        => '(Hoved)',
'preferences'           => 'Innstillinger',
'prefsnologin'          => 'Ikke logget inn',
'prefsnologintext'      => 'Du må være [[Special:Userlogin|logget inn]] for å endre brukerinnstillingene.',
'prefsreset'            => 'Brukerinnstillingene er tilbakestilt.',
'qbsettings'            => 'Brukerinnstillinger for hurtigmeny.',
'changepassword'        => 'Endre passord',
'skin'                  => 'Utseende',
'math'                  => 'Matteformler',
'dateformat'            => 'Datoformat',
'datedefault'           => 'Ingen foretrukket',
'datetime'              => 'Dato og tid',
'math_failure'          => 'Feil i matematikken',
'math_unknown_error'    => 'ukjent feil',
'math_unknown_function' => 'ukjent funksjon',
'math_lexing_error'     => 'lexerfeil',
'math_syntax_error'     => 'syntaksfeil',
'math_image_error'      => 'PNG-konversjon mislyktes',
'math_bad_tmpdir'       => 'Kan ikke skrive til eller opprette midlertidig mappe',
'math_bad_output'       => 'Kan ikke skrive til eller opprette resultatmappe',
'prefs-personal'        => 'Brukerdata',
'prefs-rc'              => 'Siste endringer',
'prefs-watchlist'       => 'Overvåkningsliste',
'prefs-watchlist-days'  => 'Antall dager vist i overvåkningslista:',
'prefs-watchlist-edits' => 'Antall redigeringer som skal vises i utvidet overvåkningsliste:',
'prefs-misc'            => 'Diverse',
'saveprefs'             => 'Lagre innstillinger',
'resetprefs'            => 'Tilbakestill instillinger',
'oldpassword'           => 'Gammelt passord:',
'newpassword'           => 'Nytt passord:',
'retypenew'             => 'Gjenta nytt passord:',
'textboxsize'           => 'Redigering',
'rows'                  => 'Rader:',
'columns'               => 'Kolonner',
'searchresultshead'     => 'Søking',
'resultsperpage'        => 'Resultater per side:',
'contextlines'          => 'Linjer per resultat',
'contextchars'          => 'Tegn per linje i resultatet',
'stubthreshold'         => 'Grense for markering av småartikler:',
'recentchangescount'    => 'Antall titler i «siste endringer»:',
'savedprefs'            => 'Innstillingene har blitt lagret.',
'timezonelegend'        => 'Tidssone',
'timezonetext'          => 'Tast inn antall timer lokaltid differerer fra tjenertiden (UTC).',
'localtime'             => 'Lokaltid',
'timezoneoffset'        => 'Forskjell',
'servertime'            => 'Tjenerens tid er nå',
'guesstimezone'         => 'Hent tidssone fra nettleseren',
'allowemail'            => 'Tillat andre å sende e-post til meg',
'defaultns'             => 'Søk i disse navnerommene som standard:',
'default'               => 'standard',
'files'                 => 'Filer',
'userrights-lookup-user'=> 'Ordne brukergrupper',
'userrights-user-editname'=> 'Skriv inn et brukernavn:',
'editusergroup'         => 'Endre brukergrupper',
'userrights-editusergroup'=> 'Rediger brukergrupper',
'saveusergroups'        => 'Lagre brukergrupper',
'userrights-groupsmember'=> 'Medlem av:',
'userrights-groupsavailable'=> 'Tilgjengelige grupper:',
'userrights-groupshelp' => 'Velg grupper du vil at brukeren skal fjernes fra eller lagt til. Ikke valgte grupper vil ikke bli forandret. Du kan fjerne merkingen av en gruppe med Ctrl + Venstreklikk.',
'group'                 => 'Gruppe:',
'group-bot'             => 'Roboter',
'group-sysop'           => 'Administratorer',
'group-bureaucrat'      => 'Byråkrater',
'group-all'             => '(alle)',
'group-bot-member'      => 'Robot',
'group-sysop-member'    => 'Administrator',
'group-bureaucrat-member'=> 'Byråkrat',
'grouppage-bot'         => 'Project:Roboter',
'grouppage-sysop'       => 'Project:Administratorer',
'grouppage-bureaucrat'  => 'Project:Byråkrater',
'changes'               => 'endringer',
'recentchanges'         => 'Siste endringer',
'recentchangestext'     => 'Vis de siste endringene til denne siden',
'rcnote'                => 'Nedenfor vises de siste <strong>$1</strong> endringene de siste <strong>$2</strong> dagene, fra $3.',
'rcnotefrom'            => 'Nedenfor er endringene fra <strong>$2</strong> til <strong>$1</strong> vist.',
'rclistfrom'            => 'Vis nye endringer med start fra $1',
'rcshowhideminor'       => '$1 mindre endringer',
'rcshowhidebots'        => '$1 roboter',
'rcshowhideliu'         => '$1 innloggede brukere',
'rcshowhideanons'       => '$1 anonyme brukere',
'rcshowhidepatr'        => '$1 godkjente endringer',
'rcshowhidemine'        => '$1 mine endringer',
'rclinks'               => 'Vis siste $1 endringer i de siste $2 dagene<br />$3',
'diff'                  => 'diff',
'hist'                  => 'hist',
'hide'                  => 'skjul',
'show'                  => 'vis',
'minoreditletter'       => 'm',
'newpageletter'         => 'N',
'sectionlink'           => '→',
'number_of_watching_users_pageview'=> '[$1 overvåkende {{plural:$1|bruker|brukere}}]',
'rc_categories'         => 'Begrens til kategorier (skilletegn: «|»)',
'rc_categories_any'     => 'Alle',
'upload'                => 'Last opp fil',
'uploadbtn'             => 'Last opp fil',
'reupload'              => 'Last opp fil igjen',
'reuploaddesc'          => 'Tilbake til skjemaet for å laste opp filer.',
'uploadnologin'         => 'Ikke logget inn',
'uploadnologintext'     => 'Du må være [[Special:Userlogin|logget inn]] for å kunne laste opp filer.',
'upload_directory_read_only'=> 'Opplastingsmappa ($1) er ikke skrivbar for tjeneren.',
'uploaderror'           => 'Feil under opplasting av fil',
'uploadtext'            => 'Bruk skjemaet under for å laste opp filer. For å se eller søke i tidligere opplastede filer, gå til [[Special:Imagelist|fillista]]. Opplastinger lagres også i [[Special:Log/upload|opplastingsloggen]].

For å inkludere et bilde på en side, bruk ei slik lenke:
*\'\'\'<nowiki>[[</nowiki>{{ns:Image}}:Filnavn.jpg<nowiki>]]</nowiki>\'\'\'
*\'\'\'<nowiki>[[</nowiki>{{ns:Image}}:Filnavn.png|Alternativ tekst<nowiki>]]</nowiki>\'\'\'
For å lenke direkte til bildet, skriv:
*\'\'\'<nowiki>[[</nowiki>{{ns:Media}}:Filnavn.ogg<nowiki>]]</nowiki>\'\'\'',
'uploadlog'             => 'opplastingslogg',
'uploadlogpage'         => 'Opplastingslogg',
'uploadlogpagetext'     => 'Her er en liste over de siste opplastede filene.',
'filename'              => 'Filnavn',
'filedesc'              => 'Beskrivelse',
'fileuploadsummary'     => 'Filbeskrivelse:',
'filestatus'            => 'Opphavsrettsstatus',
'filesource'            => 'Kilde',
'copyrightpage'         => 'Project:Opphavsrett',
'copyrightpagename'     => 'Opphavsrett',
'uploadedfiles'         => 'Filer som er lastet opp',
'ignorewarning'         => 'Lagre filen likevel.',
'ignorewarnings'        => 'Ignorer eventuelle advarsler',
'minlength'             => 'Navnet på filen må bestå av minst tre bokstaver.',
'illegalfilename'       => 'Filnavnet «$1» inneholder ugyldige tegn; gi filem et nytt navn og prøv igjen.',
'badfilename'           => 'Navnet på filen er blitt endret til «$1».',
'badfiletype'           => '«.$1» er ikke et tillatt filformat.',
'largefile'             => 'Det anbefales at filer ikke er større enn $1&nbsp;bytes; denne filen er $2&nbsp;bytes',
'largefileserver'       => 'Denne filen er større enn det tjeneren er konfigurert til å tillate.',
'emptyfile'             => 'Filen du lastet opp ser ut til å være tom. Dette kan komme av en skrivefeil i filnavnet. Sjekk om du virkelig vil laste opp denne filen.',
'fileexists'            => 'En fil med dette navnet finnes allerede. Sjekk $1 hvis du ikke er sikker på at du vil forandre den.',
'fileexists-forbidden'  => 'En fil med dette navnet finnes fra før; gå tilbake og last opp filen under et nytt navn. [[Image:$1|thumb|center|$1]]',
'fileexists-shared-forbidden'=> 'En fil med dette navnet finnes fra før i det delte fillageret; gå tilbake og last opp filen under et nytt navn. [[Image:$1|thumb|center|$1]]',
'successfulupload'      => 'Opplastingen er gjennomført',
'fileuploaded'          => 'Opplastingen av $1 var vellykket. Vennligst følg denne lenken $2 til beskrivelsessiden og fyll inn informasjon om filen, som hvor den kom fra, når og av hvem den ble laget, og annen informasjon. Om filen er et bilde, kan du sette det inn slik: <tt><nowiki>[[Image:$1|thumb|Beskrivelse]]</nowiki></tt>',
'uploadwarning'         => 'Opplastingsadvarsel',
'savefile'              => 'Lagre fil',
'uploadedimage'         => 'Lastet opp «[[$1]]»',
'uploaddisabled'        => 'Opplastingsfunksjonen er deaktivert',
'uploaddisabledtext'    => 'Opplasting er slått av på denne wikien.',
'uploadscripted'        => 'Denne filen inneholder HTML eller skripting som kan feiltolkes av en nettleser.',
'uploadcorrupt'         => 'Denne filen er ødelagt eller er en ugyldig filtype. Sjekk filen og last den opp på nytt.',
'uploadvirus'           => 'Denne filen inneholder virus! Detaljer: $1',
'sourcefilename'        => 'Velg en fil',
'destfilename'          => 'Ønsket filnavn',
'filewasdeleted'        => 'En fil ved dette navnet har blitt lastet opp tidligere og så slettet. Sjekk $1 før du forsøker å laste det opp igjen.',
'license'               => 'Lisensiering',
'nolicense'             => 'Ingen spesifisert',
'imagelist'             => 'Bildeliste',
'imagelisttext'         => 'Her er en liste med <strong>$1</strong> filer sortert <strong>$2</strong>.',
'imagelistforuser'      => 'Denne listen viser filer lastet opp av $1.',
'getimagelist'          => 'henter filliste',
'ilsubmit'              => 'Søk',
'showlast'              => 'Vis de siste $1 filene sortert $2.',
'byname'                => 'etter navn',
'bydate'                => 'etter dato',
'bysize'                => 'etter størrelse',
'imgdelete'             => 'slett',
'imgdesc'               => 'beskrivelse',
'imglegend'             => 'Forklaring: (beskrivelse) = vis/rediger filbeskrivelse.',
'imghistory'            => 'Filhistorikk',
'revertimg'             => 'gjenopprett',
'deleteimg'             => 'slett',
'deleteimgcompletely'   => 'Slett alle revisjoner av denne filen',
'imghistlegend'         => 'Forklaring: (nå) = dette er den nåværende filen, (slett) = slett denne gamle versjonen, (gjenopprett) = gjenopprett en gammel versjon.
<br /><i>Klikk på en dato for å se filen som ble lastet opp</i>.',
'imagelinks'            => 'Lenker',
'linkstoimage'          => 'Følgende sider har lenker til denne filen:',
'nolinkstoimage'        => 'Det er ingen sider som bruker denne filen.',
'sharedupload'          => 'Denne filen deles av andre prosjekter.',
'shareduploadwiki'      => 'Se $1 for mer informasjon.',
'shareduploadwiki-linktext'=> 'filbeskrivelsesside',
'noimage'               => 'Ingen fil ved dette navnet finnes, du kan $1.',
'noimage-linktext'      => 'laste det opp',
'uploadnewversion-linktext'=> 'Last opp en ny versjon av denne filen',
'mimesearch'            => 'MIME-søk',
'mimetype'              => 'MIME-type:',
'download'              => 'last ned',
'unwatchedpages'        => 'Sider som ikke er overvåket',
'listredirects'         => 'Liste over omdirigeringer',
'unusedtemplates'       => 'Ubrukte maler',
'unusedtemplatestext'   => 'Denne siden lister opp alle sider i malnavnerommet som ikke er inkludert på en annen side. Husk å sjekke for andre slags lenker til malen før du sletter den.',
'unusedtemplateswlh'    => 'andre lenker',
'randomredirect'        => 'Tilfeldig omdirigering',
'statistics'            => 'Statistikk',
'sitestats'             => '{{SITENAME}}-statistikk',
'userstats'             => 'Brukerstatistikk',
'sitestatstext'         => 'Det er til sammen \'\'\'$1\'\'\' sider i databasen. Dette inkluderer diskusjonssider, sider om {{SITENAME}}, små stubbsider, omdirigeringer, og annet som antageligvis ikke gjelder som ordentlig innhold. Om man ikke regner med disse er det \'\'\'$2\'\'\' sider som sannsynligvis er ordentlige innholdssider.

\'\'\'$8\'\'\' filer har blitt lastet opp.

Det har vært totalt \'\'\'$3\'\'\' sidevisninger, og \'\'\'$4\'\'\' redigeringer siden wikien ble satt opp. Det blir i snitt \'\'\'$5\'\'\' redigeringer per side, og \'\'\'$6\'\'\' visninger per redigering.

[http://meta.wikimedia.org/wiki/Help:Job_queue Arbeidskøen] er på \'\'\'$7\'\'\'.',
'userstatstext'         => 'Det er \'\'\'$1\'\'\' registrerte brukere. \'\'\'$2\'\'\' av disse (eller $4 %) er administratorer (se $3).',
'disambiguations'       => 'Artikler med flertydige titler',
'disambiguationspage'   => 'Template:Peker',
'disambiguationstext'   => 'Følgende artikler har lenker til \'\'artikler med flertydige titler\'\'. De bør ha en lenke til en entydig tittel i stedet. En artikkel blir behandlet som flertydig dersom den lenker til $1. Lenker fra andre navnerom listes \'\'ikke\'\' her.',
'doubleredirects'       => 'Doble omdirigeringer',
'doubleredirectstext'   => '\'\'\'NB:\'\'\' Denne listen kan inneholde gale resultater. Det er som regel fordi siden inneholder ekstra tekst under den første <tt>#redirect</tt>.<br />Hver linje inneholder lenker til den første og den andre omdirigeringen, og den første linjen fra den andre omdirigeringsteksten. Det gir som regel den «riktige» artikkelen, som den første omdirigeringen skulle ha pekt på.',
'brokenredirects'       => 'Ødelagte omdirigeringer',
'brokenredirectstext'   => 'Følgende omdirigeringer peker til ikke-eksisterende sider.',
'nbytes'                => '$1 {{plural:$1|byte|bytes}}',
'ncategories'           => '$1 {{plural:$1|kategori|kategorier}}',
'nlinks'                => '$1 {{plural:$1|lenke|lenker}}',
'nmembers'              => '$1 {{plural:$1|medlem|medlemmer}}',
'nrevisions'            => '$1 {{plural:$1|revisjon|revisjoner}}',
'nviews'                => '$1 {{plural:$1|visning|visninger}}',
'lonelypages'           => 'Foreldreløse sider',
'uncategorizedpages'    => 'Ukategoriserte sider',
'uncategorizedcategories'=> 'Ukategoriserte kategorier',
'unusedcategories'      => 'Ubrukte kategorier',
'unusedimages'          => 'Ubrukte filer',
'popularpages'          => 'Populære sider',
'wantedcategories'      => 'Ønskede kategorier',
'wantedpages'           => 'Etterspurte sider',
'mostlinked'            => 'Sider med flest lenker til seg',
'mostlinkedcategories'  => 'Kategorier med flest sider',
'mostcategories'        => 'Sider med flest kategorier',
'mostimages'            => 'Mest brukte bilder',
'mostrevisions'         => 'Artikler med flest revisjoner',
'allpages'              => 'Alle sider',
'prefixindex'           => 'Prefiksindeks',
'randompage'            => 'Tilfeldig side',
'shortpages'            => 'Korte sider',
'longpages'             => 'Lange sider',
'deadendpages'          => 'Blindveisider',
'listusers'             => 'Brukerliste',
'specialpages'          => 'Spesialsider',
'spheading'             => 'Spesialsider for alle brukere',
'restrictedpheading'    => 'Spesialsider for administratorer',
'recentchangeslinked'   => 'Relaterte endringer',
'rclsub'                => '(til sider med lenke fra «$1»)',
'newpages'              => 'Nye sider',
'ancientpages'          => 'Eldste sider',
'intl'                  => 'Språklenker',
'move'                  => 'Flytt',
'movethispage'          => 'Flytt siden',
'unusedimagestext'      => '<p>Merk at andre sider kanskje lenker til et bilde med en direkte lenke, så bildet listes her selv om det faktisk er i bruk.</p>',
'unusedcategoriestext'  => 'Følgende kategorier eksisterer, men det er ingen sider i dem.',
'booksources'           => 'Bokkilder',
'categoriespagetext'    => 'Følgende kategorier finnes i wikien.',
'data'                  => 'data',
'userrights'            => 'Brukerrettighetskontroll',
'groups'                => 'Brukergrupper',
'booksourcetext'        => 'Her er en liste over lenker til steder som låner ut og/eller selger nye og brukte bøker, og som kanskje også har ytterligere informasjon om bøker du leter etter.',
'isbn'                  => 'ISBN',
'alphaindexline'        => '$1 til $2',
'version'               => 'Versjon',
'log'                   => 'Logger',
'alllogstext'           => 'Kombinert visning av alle loggene. Du kan begrense visningen ved å velge loggtype, bruker og/eller påvirket side.',
'logempty'              => 'Ingen elementer i loggen.',
'nextpage'              => 'Neste side ($1)',
'allpagesfrom'          => 'Vis sider som starter med:',
'allarticles'           => 'Alle artikler',
'allinnamespace'        => 'Alle sider i $1-navnerommet',
'allnotinnamespace'     => 'Alle sider (ikke i $1-navnerommet)',
'allpagesprev'          => 'Forrige',
'allpagesnext'          => 'Neste',
'allpagessubmit'        => 'Gå',
'allpagesprefix'        => 'Vis sider med prefikset:',
'mailnologin'           => 'Ingen avsenderadresse',
'mailnologintext'       => 'Du må være [[Special:Userlogin|logget inn]] og ha en gyldig e-postadresse satt i [[Special:Preferences|brukerinnstillingene]] for å sende e-post til andre brukere.',
'emailuser'             => 'E-post til denne brukeren',
'emailpage'             => 'E-post til bruker.',
'emailpagetext'         => 'Hvis denne brukeren har oppgitt en gyldig e-postadresse i sine innstillinger, vil dette skjemaet sende en enkelt beskjed. Den e-postadressen du har satt i innstillingene dine vil dukke opp i «Fra»-feltet på denne e-posten, så mottakeren er i stand til å svare.',
'defemailsubject'       => 'E-post fra {{SITENAME}}',
'noemailtitle'          => 'Ingen e-postadresse',
'noemailtext'           => 'Denne brukeren har ikke oppgitt en gyldig e-postadresse eller har valgt å ikke motta e-post fra andre brukere.',
'emailfrom'             => 'Fra',
'emailto'               => 'Til',
'emailsubject'          => 'Emne',
'emailmessage'          => 'Beskjed',
'emailsend'             => 'Send',
'emailsent'             => 'E-post sendt',
'emailsenttext'         => 'E-postbeskjeden er sendt',
'watchlist'             => 'Overvåkningsliste',
'nowatchlist'           => 'Du har ingenting i overvåkningslista.',
'watchlistcount'        => '\'\'\'Du har $1 {{plural:$1|objekt|objekter}} i overvåkningslista di, inkludert diskusjonssider.\'\'\'',
'clearwatchlist'        => 'Nullstill overvåkningsliste',
'watchlistcleartext'    => 'Er du sikker på at du vil fjerne dem?',
'watchlistclearbutton'  => 'Nullstill overvåkningsliste',
'watchlistcleardone'    => 'Overvåkningslisten din er nullstilt. $1 {{plural:$1|objekt|objekter}} ble fjernet.',
'watchnologin'          => 'Ikke logget inn',
'watchnologintext'      => 'Du må være [[Special:Userlogin|logget inn]] for å kunne endre overvåkningslisten.',
'addedwatch'            => 'Lagt til overvåkningslista',
'addedwatchtext'        => 'Siden «$1» er føyd til [[Special:Watchlist|overvåkningslistea]]. Fremtidige endringer til denne siden og den tilhørende diskusjonssiden vil bli listet opp her, og siden vil fremstå \'\'\'fremhevet\'\'\' i [[Special:Recentchanges|lista over de siste endringene]] for å gjøre det lettere å finne den.

Hvis du senere vil fjerne siden fra overvåkningslista, klikk «Avslutt overvåkning» ute i siden.',
'removedwatch'          => 'Fjernet fra overvåkningslista',
'removedwatchtext'      => 'Siden «[[:$1]]» er fjernet fra overvåkningslista di.',
'watch'                 => 'Overvåk',
'watchthispage'         => 'Overvåk siden',
'unwatch'               => 'Avslutt overvåkning',
'unwatchthispage'       => 'Fjerner overvåkning',
'notanarticle'          => 'Ikke en artikkel',
'watchnochange'         => 'Ingen av sidene i overvåkningslista er endret i den valgte perioden.',
'watchdetails'          => '* $1 sider overvåket, utenom diskusjonssider.
* [[Special:Watchlist/edit|Vis og rediger hele lista]]
* [[Special:Watchlist/clear|Fjern alle sider]]',
'wlheader-enotif'       => '* E-postnotifikasjon er slått på.',
'wlheader-showupdated'  => '* Sider som har blitt forandret siden du sist besøkte dem vises i \'\'\'fet tekst\'\'\'',
'watchmethod-recent'    => 'sjekker siste endringer for sider overvåkningslista',
'watchmethod-list'      => 'sjekker siste endringer for sider i overvåkningstlista',
'removechecked'         => 'Fjern valgte sider fra overvåkningslista',
'watchlistcontains'     => 'Overvåkningslista inneholder $1 {{plural:$1|side|sider}}.',
'watcheditlist'         => 'Her er en alfabetisk liste over sidene i overvåkningslista. Velg sidene du vil fjerne fra overvåkningslista og klikk på knappen «fjern valgte sider fra overvåkningslista» nederst på denne siden.',
'removingchecked'       => 'Fjerner de valgte sidene fra overvåkningslista…',
'couldntremove'         => 'Kunne ikke fjerne «$1»…',
'iteminvalidname'       => 'Problem med «$1», ugyldig navn…',
'wlnote'                => 'Nedenfor er de siste $1 endringene de siste <b>$2</b> timene.',
'wlshowlast'            => 'Vis siste $1 timer $2 dager $3',
'wlsaved'               => 'Dette er en lagret versjon av overvåkningslista di. Den er ikke nødvendigvis oppdatert.',
'wlhideshowown'         => '$1 mine endringer.',
'wlhideshowbots'        => '$1 robotendringer',
'wldone'                => 'Utført.',
'enotif_mailer'         => '{{SITENAME}} påminnelsessystem',
'enotif_reset'          => 'Merk alle sider som besøkt',
'enotif_newpagetext'    => 'Dette er en ny side.',
'changed'               => 'endret',
'created'               => 'opprettet',
'enotif_subject'        => '{{SITENAME}}-siden $PAGETITLE har blitt $CHANGEDORCREATED av $PAGEEDITOR',
'enotif_lastvisited'    => 'Se $1 for alle endringer siden ditt forrige besøk.',
'enotif_body'           => '$WATCHINGUSERNAME,

{{SITENAME}}-siden $PAGETITLE har blitt $CHANGEDORCREATED $PAGEEDITDATE av $PAGEEDITOR, se $PAGETITLE_URL for den nåværende versjonen.

$NEWPAGE

Redigeringssammendrag: $PAGESUMMARY $PAGEMINOREDIT

Kontakt brukeren:
e-post: $PAGEEDITOR_EMAIL
wiki: $PAGEEDITOR_WIKI

Det vil ikke komme flere påminnelser om endringer på denne siden med mindre du besøker den. Du kan også fjerne påminnelsesflagg for alle sider i overvåkningslista di.

Med vennlig hilsen,
{{SITENAME}}s påminnelsessystem

--
For å endre innstillingene i overvåkningslista di, besøk {{fullurl:Special:Watchlist/edit}}

Tilbakemeldinger og videre assistanse:
{{fullurl:Project:Hjelp}}',
'deletepage'            => 'Slett side',
'confirm'               => 'Bekreft',
'excontent'             => 'Innholdet var: «$1»',
'excontentauthor'       => 'innholdet var «$1» (og eneste bidragsyter var [[{{ns:special}}:Contributions/$2|$2]])',
'exbeforeblank'         => 'innholdet før siden ble tømt var: «$1»',
'exblank'               => 'siden var tom',
'confirmdelete'         => 'Bekreft sletting',
'deletesub'             => '(Sletter «[[$1]]»)',
'historywarning'        => 'Advarsel: Siden du er i ferd med å slette har en historikk:',
'confirmdeletetext'     => 'Du holder på å slette en side eller et bilde sammen med historikken. Bilder som slettes kan ikke gjenopprettes, men alle andre sider som slettes på denne måten kan gjenopprettes. Bekreft at du virkelig vil slette denne siden, og at du gjør det i samsvar med [[Project:Retningslinjer for sletting|retningslinjene]].',
'actioncomplete'        => 'Gjennomført',
'deletedtext'           => '«[[$1]]» er slettet. Se $2 for en oversikt over de siste slettingene.',
'deletedarticle'        => 'slettet «[[$1]]»',
'dellogpage'            => 'Slettingslogg',
'dellogpagetext'        => 'Under er ei liste over nylige slettinger.',
'deletionlog'           => 'slettingslogg',
'reverted'              => 'Gjenopprettet en tidligere versjon',
'deletecomment'         => 'Begrunnelse for sletting',
'imagereverted'         => 'Tilbakestilling til tidligere versjon gjennomført.',
'rollback'              => 'Fjern redigeringer',
'rollback_short'        => 'Tilbakestill',
'rollbacklink'          => 'tilbakestill',
'rollbackfailed'        => 'Kunne ikke tilbakestille',
'cantrollback'          => 'Kan ikke fjerne redigering; den siste brukeren er den eneste forfatteren.',
'alreadyrolled'         => 'Kan ikke fjerne den siste redigeringen på [[:$1]] av [[User:$2|$2]] ([[User talk:$2|diskusjon]]); en annen har allerede redigert siden eller fjernet redigeringen. Den siste redigeringen er foretatt av [[User:$3|$3]] ([[User talk:$3|diskusjon]]).',
'editcomment'           => 'Redigeringskommentaren var: «\'\'$1\'\'»',
'revertpage'            => 'Tilbakestilte endring av [[Special:Contributions/$2|$2]] ([[User talk:$2|diskusjon]] · [[Special:Blockip/$2|blokker]]) til siste versjon av $1',
'sessionfailure'        => 'Det ser ut til å være et problem med innloggingen din, og den har blitt avbrutt av sikkerhetshensyn. Trykk \'\'Tilbake\'\' i nettleseren din, oppdater siden og prøv igjen.',
'protectlogpage'        => 'Låsingslogg',
'protectlogtext'        => 'Her er en liste over sider som er blitt beskyttet eller har fått fjernet beskyttelsen. Se [[Project:Beskyttet side]] for mer informasjon.',
'protectedarticle'      => 'låste [[$1]]',
'unprotectedarticle'    => 'åpnet [[$1]]',
'protectsub'            => '(Låser «$1»)',
'confirmprotecttext'    => 'Vil du virkelig låse siden?',
'confirmprotect'        => 'Bekreft låsing',
'protectmoveonly'       => 'Bare lås for flytting',
'protectcomment'        => 'Låsingsbegrunnelse',
'unprotectsub'          => '(Åpner «$1»)',
'confirmunprotecttext'  => 'Vil du virkelig åpne denne siden?',
'confirmunprotect'      => 'Bekreft åpning',
'unprotectcomment'      => 'Åpningsbegrunnelse',
'protect-unchain'       => 'Spesielle flyttingstillatelser',
'protect-text'          => 'Du kan se og forandre beskyttelsesnivået for siden [[$1]] her. Vennligst følg [[Project:Beskyttelsesretningslinjer|beskyttelsesretningslinjene]].',
'protect-viewtext'      => 'Kontoen din har ikke tillatelse til å forandre sidens beskyttelsesnivå. Dette er de nåværende innstillingene for siden <strong>$1</strong>:',
'protect-default'       => '(standard)',
'protect-level-autoconfirmed'=> 'Blokker uregistrerte brukere',
'protect-level-sysop'   => 'Kun administratorer',
'restriction-edit'      => 'Redigering',
'restriction-move'      => 'Flytting',
'undelete'              => 'Vis slettede sider',
'undeletepage'          => 'Se og gjenopprett slettede sider',
'viewdeletedpage'       => 'Vis slettede sider',
'undeletepagetext'      => 'Følgende sider er slettet, men finnes fortsatt i arkivet og kan gjenopprettes. Arkivet blir periodevis slettet.',
'undeleteextrahelp'     => 'For å gjenopprette hele siden, la alle boksene være som de er, og klikk \'\'\'Gjenopprett\'\'\'. For å gjenopprette kun deler, kryss av revisjonenes bokser, og klikk \'\'\'Gjenopprett\'\'\'.',
'undeletearticle'       => 'Gjenopprett slettet side',
'undeleterevisions'     => '$1 revisjoner arkivert',
'undeletehistory'       => 'Hvis du gjenoppretter siden, vil alle de historiske
revisjoner også bli gjenopprettet. Hvis en ny side med det samme navnet
er opprettet siden denne ble slettet, vil de gjenopprettede revisjonene
dukke opp i den tidligere historikken, og den nyeste revisjonen vil forbli
på siden.',
'undeletehistorynoadmin'=> 'Denne artikkelen har blitt slettet. Grunnen for slettingen vises i oppsummeringen nedenfor, sammen med detaljer om brukerne som redigerte siden før den ble slettet. Teksten i disse slettede revisjonene er kun tilgjengelig for [[Project:Administratorer|administratorer]].',
'undeleterevision'      => 'Slettet revisjon fra $1',
'undeletebtn'           => 'Gjenopprett',
'undeletereset'         => 'Resett skjema',
'undeletecomment'       => 'Forklaring:',
'undeletedarticle'      => 'gjenopprettet «[[$1]]»',
'undeletedrevisions'    => '$1 revisjoner gjenopprettet',
'undeletedrevisions-files'=> '{{PLURAL:$1|Én revisjon|$1 revisjoner}} og {{PLURAL:$2|én fil|$2 filer}} gjenopprettet',
'undeletedfiles'        => '{{PLURAL:$1|Én fil|$1 filer}} gjenopprettet',
'cannotundelete'        => 'Gjenoppretting feilet; noen andre kan ha gjenopprettet siden først.',
'undeletedpage'         => '<big>\'\'\'$1 har blitt gjenopprettet\'\'\'</big>

Sjekk [[Special:Log/delete|slettingsloggen]] for en liste over nylige slettinger og gjenopprettelser.',
'namespace'             => 'Navnerom:',
'invert'                => 'Inverter',
'contributions'         => 'Bidrag',
'mycontris'             => 'Mine bidrag',
'contribsub'            => 'For $1',
'nocontribs'            => 'Ingen endringer er funnet som passer disse kriteriene.',
'ucnote'                => 'Her er denne brukerens siste <b>$1</b> endringer i de siste <b>$2</b> dagene.',
'uclinks'               => 'Vis de siste $1 endringene; vis de siste $2 dagene.',
'uctop'                 => ' (topp)',
'newbies'               => 'nybegynnere',
'sp-newimages-showfrom' => 'Vis nye bilder fra og med $1',
'sp-contributions-newest'=> 'Nyeste',
'sp-contributions-oldest'=> 'Eldste',
'sp-contributions-newer'=> '$1 nyere',
'sp-contributions-older'=> '$1 eldre',
'sp-contributions-newbies-sub'=> 'For nybegynnere',
'whatlinkshere'         => 'Lenker hit',
'notargettitle'         => 'Intet mål',
'notargettext'          => 'Du har ikke spesifisert en målside eller bruker å utføre denne funksjonen på.',
'linklistsub'           => '(Liste over lenker)',
'linkshere'             => 'Følgende sider lenker hit:',
'nolinkshere'           => 'Ingen sider lenker hit.',
'isredirect'            => 'omdirigeringsside',
'istemplate'            => 'inklusjon',
'blockip'               => 'Blokker IP-adresse',
'blockiptext'           => 'Bruk skjemaet under for å blokkere en IP-adresses tilgang til å redigere artikler. Dette må kun gjøres for å forhindre hærverk, og i overensstemmelse med [[Project:Retningslinjer for blokkering|retningslinjene]]. Fyll ut en spesiell begrunnelse under.',
'ipaddress'             => 'IP-adresse',
'ipadressorusername'    => 'IP-adresse eller brukernavn',
'ipbexpiry'             => 'Utløper',
'ipbreason'             => 'Begrunnelse',
'ipbsubmit'             => 'Blokker denne adressen',
'ipbother'              => 'Annen tid',
'ipboptions'            => '2 timer:2 hours,1 dag:1 day,3 dager:3 days,1 uke:1 week,2 uker:2 weeks,1 måned:1 month,3 måneder:3 months,6 måneder:6 months,1 år:1 year,uendelig:infinite',
'ipbotheroption'        => 'annet',
'badipaddress'          => 'Ugyldig IP-adresse.',
'blockipsuccesssub'     => 'Blokkering utført',
'blockipsuccesstext'    => 'IP-adressen «$1» er blokkert. Se [[Special:Ipblocklist|blokkeringslista]] for alle blokkeringer.',
'unblockip'             => 'Opphev blokkering',
'unblockiptext'         => 'Bruk skjemaet under for å gjenopprette skriveadgangen for en tidligere blokkert adresse eller bruker.',
'ipusubmit'             => 'Opphav blokkeringen av denne adressen',
'unblocked'             => '[[User:$1|$1]] har blitt avblokkert',
'ipblocklist'           => 'Liste over blokkerte IP-adresser og brukere',
'blocklistline'         => '$1, $2 blokkerte $3 ($4)',
'infiniteblock'         => 'uendelig',
'expiringblock'         => 'utgår $1',
'ipblocklistempty'      => 'Blokkeringslista er tom.',
'blocklink'             => 'blokker',
'unblocklink'           => 'opphev blokkering',
'contribslink'          => 'bidrag',
'autoblocker'           => 'Du har blitt automatisk blokkert fordi du deler IP-adresse med «[[User:$1|$1]]». Grunnen som ble gitt til at «$1» ble blokkert var: «$2».',
'blocklogpage'          => 'Blokkeringslogg',
'blocklogentry'         => 'Blokkerte «[[$1]]» med en utløpstid på $2',
'blocklogtext'          => 'Dette er en logg som viser hvilke brukere som har blitt blokkert og avblokkert. Automatisk blokkerte IP-adresser vises ikke. Se [[Special:Ipblocklist|blokkeringslista]] for en liste over IP-adresser som er blokkert i nåværende tidspunkt.',
'unblocklogentry'       => 'opphevet blokkeringen av $1',
'range_block_disabled'  => 'Muligheten til å blokkere flere IP-adresser om gangen er slått av.',
'ipb_expiry_invalid'    => 'Ugyldig utløpstid.',
'ip_range_invalid'      => 'Ugyldig IP-rad.',
'proxyblocker'          => 'Proxyblokker',
'proxyblockreason'      => 'IP-adressen din har blitt blokkert fordi den er en åpen proxy. Kontakt internettleverandør eller teknisk støtte og informer dem om dette alvorlige sikkerhetsproblemet.',
'proxyblocksuccess'     => 'Utført.',
'sorbs'                 => 'SORBS DNSBL',
'sorbsreason'           => 'IP-adressen din er oppgitt som åpen proxy i [http://sorbs.net/ SORBS]\' DNSBL.',
'sorbs_create_account_reason'=> 'IP-adressen din oppgis som en åpen proxy i [http://sorbs.net/ SORBS]\' DNSBL. Du kan ikke opprette en konto.',
'lockdb'                => 'Lås database',
'unlockdb'              => 'Åpne database',
'lockdbtext'            => 'Å låse databasen vil avbryte alle brukere fra å kunne
redigere sider, endre deres innstillinger, redigere deres
overvåkningsliste, og andre ting som krever endringer i databasen.
Bekreft at du har til hensikt å gjøre dette, og at du vil
låse opp databasen når vedlikeholdet er utført.',
'unlockdbtext'          => 'Å låse opp databasen vil si at alle brukere igjen
kan redigere sider, endre sine innstillinger, redigere sin
overvåkningsliste, og andre ting som krever endringer i databasen.
Bekreft at du har til hensikt å gjøre dette.',
'lockconfirm'           => 'Ja, jeg vil virkelig låse databasen.',
'unlockconfirm'         => 'Ja, jeg vil virkelig låse opp databasen.',
'lockbtn'               => 'Lås databasen',
'unlockbtn'             => 'Åpne databasen',
'locknoconfirm'         => 'Du har ikke bekreftet handlingen.',
'lockdbsuccesssub'      => 'Databasen er nå låst',
'unlockdbsuccesssub'    => 'Databasen er nå lås opp',
'lockdbsuccesstext'     => 'Databasen er låst.<br />Husk å fjerne låsen når du er ferdig med vedlikeholdet.',
'unlockdbsuccesstext'   => 'Databasen er låst opp.',
'makesysoptitle'        => 'Gjør en bruker til administrator',
'makesysoptext'         => 'Dette skjemaet blir brukt av byråkrater for å gjøre vanlige brukere til administratorer. Skriv brukernavnet i boksen og trykk på knappen for å gjøre en bruker til administrator.',
'makesysopname'         => 'Brukernavn:',
'makesysopsubmit'       => 'Gjør denne brukeren til administrator',
'makesysopok'           => '<b>«$1» er nå administrator</b>',
'makesysopfail'         => '<b>«$1» kunne ikke bli administrator. (Er brukernavnet skrevet riktig?)</b>',
'setbureaucratflag'     => 'Gjør til byråkrat',
'rightslog'             => 'Rettighetslogg',
'rightslogtext'         => 'Dette er en logg over forandringer i brukerrettigheter.',
'rightslogentry'        => 'endret gruppe for $1 fra $2 til $3',
'rights'                => 'Rettigheter:',
'set_user_rights'       => 'Sett brukerrettigheter',
'user_rights_set'       => '<b>Brukerrettigheter for «$1» er oppdatert</b>',
'set_rights_fail'       => '<b>Brukerrettigheter for «$1» kunne ikke settes. (Skrev du navnet riktig?)</b>',
'makesysop'             => 'Gjør en bruker til administrator',
'already_sysop'         => 'Den brukeren er allerede administrator',
'already_bureaucrat'    => 'Denne brukeren er allerede byråkrat',
'rightsnone'            => '(ingen)',
'movepage'              => 'Flytt side',
'movepagetext'          => 'Når du bruker skjemaet under, vil du få omdøpt en 
side og flyttet hele historikken til det nye navnet.
Den gamle tittelen vil bli en omdirigeringsside til den nye tittelen.
Lenker til den gamle tittelen vil ikke bli endret. Eventuelle omdirigeringer vil bli brutt.

<span style="color:#ff0000"><b>Det er <u>ditt ansvar</u> å rette alle omdirigeringer (bruk «Lenker hit» for å finne dem) hvis du flytter en side!</b></span>

Legg merke til at siden \'\'\'ikke\'\'\' kan flyttes hvis det allerede finnes en side 
med den nye tittelen, med mindre den siden er tom eller er en omdirigering 
uten noen historikk. Det betyr at du kan flytte en side tilbake dit
den kom fra hvis du gjør en feil.

<b>ADVARSEL!</b>
Dette kan være en drastisk og uventet endring for en populær side;
vær sikker på at du forstår konsekvensene av dette før du
fortsetter.',
'movepagetalktext'      => 'Den tilhørende diskusjonssiden, hvis det finnes en,
vil automatisk bli flyttet med siden \'\'\'med mindre:\'\'\'
*En ikke-tom diskusjonsside allerede eksisterer under det nye navnet, eller
*Du fjerner markeringen i boksen nedenunder.

I disse tilfellene er du nødt til å flytte eller flette sammen siden manuelt.',
'movearticle'           => 'Flytt side',
'movenologin'           => 'Ikke logget inn',
'movenologintext'       => 'Du må være registrert bruker og være [[Special:Userlogin|logget på]] for å flytte en side.',
'newtitle'              => 'Til ny tittel',
'movepagebtn'           => 'Flytt side',
'pagemovedsub'          => 'Flytting gjennomført',
'pagemovedtext'         => 'Siden «<span class="plainlinks">[{{fullurl:$1|redirect=no}} $1]</span>» er nå flyttet til «[[$2]]». \'\'\'Vennligst [[Special:Whatlinkshere/$2|sjekk]]\'\'\' om denne flyttingen har skapt noen [[Special:DoubleRedirects|doble omdirigeringssider]], og fiks dem om nødvendig.',
'articleexists'         => 'En side med det navnet eksisterer allerede, eller valgte navn er ugyldig. Velg et annet navn.',
'talkexists'            => '\'\'\'Siden ble flyttet korrekt, men den tilhørende diskusjonssiden kunne ikke flyttes, fordi det allerede eksisterer en med den nye tittelen. Du er nødt til å flette dem sammen manuelt.\'\'\'',
'movedto'               => 'flyttet til',
'movetalk'              => 'Flytt også diskusjonssiden, hvis den eksisterer.',
'talkpagemoved'         => 'Den tilhørende diskusjonssiden ble også flyttet.',
'talkpagenotmoved'      => 'Den tilhørende diskusjonssiden ble <strong>ikke</strong> flyttet.',
'1movedto2'             => '[[$1]] flyttet til [[$2]]',
'1movedto2_redir'       => '[[$1]] flyttet til [[$2]] over omdirigeringsside',
'movelogpage'           => 'Flyttelogg',
'movelogpagetext'       => 'Her er ei liste over sider som har blitt flyttet.',
'movereason'            => 'Årsak',
'revertmove'            => 'tilbakestill',
'delete_and_move'       => 'Slett og flytt',
'delete_and_move_text'  => '==Sletting nødvendig==
Målsiden «[[$1]]» finnes allerede. Vil du slette den så denne siden kan flyttes dit?',
'delete_and_move_confirm'=> 'Ja, slett siden',
'delete_and_move_reason'=> 'Slettet grunnet flytting',
'selfmove'              => 'Kilde- og destinasjonstittel er den samme; kan ikke flytte siden.',
'immobile_namespace'    => 'Sider kan ikke flyttes til dette navnerommet.',
'export'                => 'Eksportsider',
'exporttext'            => 'Du kan eksportere teksten og redigeringshistorikken for en bestemt side eller en gruppe sider i XML. Dette kan senere importeres til en annen wiki som bruker MediaWiki ved hjelp av [[Special:Import]].

For å eksportere sider, skriv inn titler i tekstboksen under, én tittel per linje, og velg om du vil ha kun nåværende versjon, eller alle versjoner i historikken. Dersom du bare vil ha nåværende versjon, kan du også bruke en lenke, for eksempel [[Special:Export/{{Mediawiki:Mainpage}}]] for siden «{{Mediawiki:Mainpage}}».',
'exportcuronly'         => 'Inkluder kun den nåværende versjonen, ikke hele historikken.',
'exportnohistory'       => '----
\'\'\'Merk:\'\'\' Eksportering av hele historikken gjennom dette skjemaet har blitt slått av av ytelsesgrunner.',
'export-submit'         => 'Eksporter',
'allmessages'           => 'Systemmeldinger',
'allmessagesname'       => 'Navn',
'allmessagesdefault'    => 'Standardtekst',
'allmessagescurrent'    => 'Nåværende tekst',
'allmessagestext'       => 'Dette er en liste over tilgjengelige systemmeldinger i MediaWiki-navnerommet.',
'allmessagesnotsupportedUI'=> 'Språket du bruker, \'\'\'$1\'\'\', støttes ikke av Special:Allmessages på denne siden.',
'allmessagesnotsupportedDB'=> '\'\'\'Special:Allmessages\'\'\' kan ikke brukes fordi \'\'\'$wgUseDatabaseMessages\'\'\' er slått av.',
'allmessagesfilter'     => 'Filter:',
'allmessagesmodified'   => 'Vis kun endrede',
'thumbnail-more'        => 'Forstørr',
'missingimage'          => '<b>Bilde mangler</b><br /><i>$1</i>',
'filemissing'           => 'Filen mangler',
'thumbnail_error'       => 'Feil under oppretting av miniatyrbilde: $1',
'import'                => 'Importer sider',
'importinterwiki'       => 'Transwiki-importering',
'import-interwiki-text' => 'Velg en wiki og en side å importere. Revisjonsdatoer og bidragsyteres navn vil bli bevart. Alle transwiki-importeringer spares i [[Special:Log/import|importloggen]].',
'import-interwiki-history'=> 'Kopier all historikk for denne siden',
'import-interwiki-submit'=> 'Importer',
'importtext'            => 'Importer filen fra kildewikien med Special:Export-verktøyet, lagre den på den egen datamaskin, og last den opp hit.',
'importstart'           => 'Importerer sider…',
'import-revision-count' => '{{PLURAL:$1|Én revisjon|$1 revisjoner}}',
'importnopages'         => 'Ingen sider å importere.',
'importfailed'          => 'Importering mislyktes: $1',
'importunknownsource'   => 'Ukjent importkildetype',
'importcantopen'        => 'Kunne ikke åpne importfil',
'importbadinterwiki'    => 'Ugyldig interwikilenke',
'importnotext'          => 'Tom eller ingen tekst',
'importsuccess'         => 'Import lyktes!',
'importhistoryconflict' => 'Motstridende revisjoner finnes (siden kan ha blitt importert tidligere)',
'importnosources'       => 'Ingen transwikiimportkilder er definert, og direkte historikkimporteringer er slått av.',
'importnofile'          => 'Ingen importfil opplastet.',
'importuploaderror'     => 'Opplasting av importfil feilet; kanskje filen er større en den tillatte opplastingsstørrelsen.',
'importlogpage'         => 'Importlogg',
'importlogpagetext'     => 'Administrativ import av sider med redigeringshistorikk fra andre wikier.',
'import-logentry-upload'=> 'importerte [[$1]] ved opplasting',
'import-logentry-upload-detail'=> '{{PLURAL:$1|Én revisjon|$1 revisjoner}}',
'import-logentry-interwiki'=> 'transwikiimporterte $1',
'import-logentry-interwiki-detail'=> '{{PLURAL:$1|Én revisjon|$1 revisjoner}} fra $2',
'accesskey-search'      => 'f',
'accesskey-minoredit'   => 'i',
'accesskey-save'        => 's',
'accesskey-preview'     => 'p',
'accesskey-diff'        => 'v',
'accesskey-compareselectedversions'=> 'v',
'accesskey-watch'       => 'w',
'tooltip-search'        => 'Søk i {{SITENAME}} [alt-f]',
'tooltip-minoredit'     => 'Merk dette som en mindre endring [alt-i]',
'tooltip-save'          => 'Lagre endringer [alt-s]',
'tooltip-preview'       => 'Forhåndsvis endringene, vennligst bruk denne funksjonen før du lagrer! [alt-p]',
'tooltip-diff'          => 'Vis hvilke endringer du har gjort på teksten. [alt-v]',
'tooltip-compareselectedversions'=> 'Se forskjellene mellom de to valgte versjonene av denne siden. [alt-v]',
'tooltip-watch'         => 'Legg denne siden til din overvåkningsliste [alt-w]',
'common.css'            => '/* CSS plassert i denne filen vil gjelde for alle utseender. */',
'monobook.css'          => '/* rediger denne filen for å tilpasse Monobook-skinnet for hele siden */',
'nodublincore'          => 'Dublin Core RDF-metadata er slått av på denne tjeneren.',
'nocreativecommons'     => 'Create Commons RDF-metadata er slått av på denne tjeneren.',
'notacceptable'         => 'Tjeneren har ingen mulige måter å vise data i din nettleser.',
'anonymous'             => 'Anonym(e) bruker(e) av {{SITENAME}}',
'siteuser'              => '{{SITENAME}}-bruker $1',
'lastmodifiedatby'        => 'Denne siden var sist redigert $2, $1 av $3.',
'and'                   => 'og',
'othercontribs'         => 'Basert på arbeid av $1.',
'others'                => 'andre',
'siteusers'             => '{{SITENAME}}-bruker(e) $1',
'creditspage'           => 'Sidekreditteringer',
'nocredits'             => 'Ingen krediteringer er tilgjengelig for denne siden.',
'spamprotectiontitle'   => 'Søppelpostfilter',
'spamprotectiontext'    => 'Siden du ønsket å lagre ble blokkert av spamfilteret. Dette er sannsynligvis forårsaket av en lenke til et eksternt nettsted.',
'spamprotectionmatch'   => 'Følgende tekst er det som aktiverte spamfilteret: $1',
'subcategorycount'      => 'Det er {{PLURAL:$1|én underkategori|$1 underkategorier}} i denne kategorien.',
'categoryarticlecount'  => 'Det er {{PLURAL:$1|en artikkel|$1 artikler}} i denne kategorien.',
'listingcontinuesabbrev'=> ' forts.',
'spambot_username'      => 'MediaWikis spamopprydning',
'spam_reverting'        => 'Tilbakestiller til siste versjon uten lenke til $1',
'spam_blanking'         => 'Alle revisjoner inneholdt lenke til $1, tømmer siden',
'infosubtitle'          => 'Sideinformasjon',
'numedits'              => 'Antall redigeringer (artikkel): $1',
'numtalkedits'          => 'Antall redigeringer (diskusjonsside): $1',
'numwatchers'           => 'Antall overvåkere: $1',
'numauthors'            => 'Antall forskjellige bidragsytere (artikkel): $1',
'numtalkauthors'        => 'Antall forskjellige bidragsytere (diskusjonsside): $1',
'mw_math_png'           => 'Vis alltid som PNG',
'mw_math_simple'        => 'HTML hvis veldig enkel, ellers PNG',
'mw_math_html'          => 'HTML vis mulig, ellers PNG',
'mw_math_source'        => 'Behold som TeX (for tekst-nettlesere)',
'mw_math_modern'        => 'Anbefalt for moderne nettlesere',
'mw_math_mathml'        => 'MathML hvis mulig',
'markaspatrolleddiff'   => 'Godkjenn endringen',
'markaspatrolledtext'   => 'Godkjenn denne siden',
'markedaspatrolled'     => 'Merket som godkjent',
'markedaspatrolledtext' => 'Endringen er merket som godkjent.',
'rcpatroldisabled'      => 'Siste endringer-patruljering er slått av',
'rcpatroldisabledtext'  => 'Siste endringer-patruljeringsfunksjonen er slått av.',
'markedaspatrollederror'=> 'Kan ikke merke som godkjent',
'markedaspatrollederrortext'=> 'Du må spesifisere en versjon å merke som godkjent.',
'monobook.js'           => '/* tooltips and access keys */
 var ta = new Object();
 ta[\'pt-userpage\'] = new Array(\'.\',\'Min brukerside\');
 ta[\'pt-anonuserpage\'] = new Array(\'.\',\'Brukersiden for IP-adressen du redigerer fra\');
 ta[\'pt-mytalk\'] = new Array(\'n\',\'Min diskusjonsside\');
 ta[\'pt-anontalk\'] = new Array(\'n\',\'Diskusjon om redigeringer fra denne IP-adressen\');
 ta[\'pt-preferences\'] = new Array(\'\',\'Mine innstillinger\');
 ta[\'pt-watchlist\'] = new Array(\'l\',\'Liste over sider du overvåker for endringer.\');
 ta[\'pt-mycontris\'] = new Array(\'y\',\'Liste over mine bidrag\');
 ta[\'pt-login\'] = new Array(\'o\',\'Du oppfordres til å logge inn, men det er ikke obligatorisk.\');
 ta[\'pt-anonlogin\'] = new Array(\'o\',\'Du oppfordres til å logge inn, men det er ikke obligatorisk.\');
 ta[\'pt-logout\'] = new Array(\'\',\'Logg ut\');
 ta[\'ca-talk\'] = new Array(\'t\',\'Diskusjon om innholdssiden\');
 ta[\'ca-edit\'] = new Array(\'e\',\'Du kan redigere denne siden. Vennligst bruk Forhåndsvis-knappen før du lagrer.\');
 ta[\'ca-addsection\'] = new Array(\'+\',\'Legg til et diskusjonsinnlegg.\');
 ta[\'ca-viewsource\'] = new Array(\'e\',\'Denne siden er beskyttet. Du kan se kildeteksten.\');
 ta[\'ca-history\'] = new Array(\'h\',\'Tidligere revisjoner av denne siden.\');
 ta[\'ca-protect\'] = new Array(\'=\',\'Beskytt denne siden\');
 ta[\'ca-delete\'] = new Array(\'d\',\'Slette denne siden\');
 ta[\'ca-undelete\'] = new Array(\'d\',\'Gjenopprett redigerenge som ble gjort på denne siden før den ble slettet.\');
 ta[\'ca-move\'] = new Array(\'m\',\'Flytt denne siden\');
 ta[\'ca-nomove\'] = new Array(\'\',\'Du har ikke tillatelse til å flytte denne siden\');
 ta[\'ca-watch\'] = new Array(\'w\',\'Legg til denne siden til din overvåkningsliste.\');
 ta[\'ca-unwatch\'] = new Array(\'w\',\'Fjern denne siden fra din overvåkningsliste.\');
 ta[\'search\'] = new Array(\'f\',\'Søk i denne wikien\');
 ta[\'p-logo\'] = new Array(\'\',\'Hovedside\');
 ta[\'n-mainpage\'] = new Array(\'z\',\'Gå til hovedsiden\');
 ta[\'n-portal\'] = new Array(\'\',\'Om prosjektet; hva du kan gjøre og hvor du kan finne ting\');
 ta[\'n-currentevents\'] = new Array(\'\',\'Finn bakgrunnsinformasjon om aktuelle hendelser\');
 ta[\'n-recentchanges\'] = new Array(\'r\',\'Liste over siste endringer på wikien.\');
 ta[\'n-randompage\'] = new Array(\'x\',\'Gå inn på en tilfeldig side\');
 ta[\'n-help\'] = new Array(\'\',\'Stedet for å få hjelp.\');
 ta[\'n-sitesupport\'] = new Array(\'\',\'Støtt oss\');
 ta[\'t-whatlinkshere\'] = new Array(\'j\',\'Liste over alle sider som lenker hit\');
 ta[\'t-recentchangeslinked\'] = new Array(\'k\',\'Siste endringer i sider som blir lenket fra denne siden\');
 ta[\'feed-rss\'] = new Array(\'\',\'RSS-føde for denne siden\');
 ta[\'feed-atom\'] = new Array(\'\',\'Atom-føde for denne siden\');
 ta[\'t-contributions\'] = new Array(\'\',\'Vis liste over bidrag fra denne brukeren\');
 ta[\'t-emailuser\'] = new Array(\'\',\'Send en e-post til denne brukeren\');
 ta[\'t-upload\'] = new Array(\'u\',\'Last opp bilder eller mediafiler\');
 ta[\'t-specialpages\'] = new Array(\'q\',\'Liste over alle spesialsider\');
 ta[\'ca-nstab-main\'] = new Array(\'c\',\'Vis innholdssiden\');
 ta[\'ca-nstab-user\'] = new Array(\'c\',\'Vis brukersiden\');
 ta[\'ca-nstab-media\'] = new Array(\'c\',\'Vis mediasiden\');
 ta[\'ca-nstab-special\'] = new Array(\'\',\'Dette er en spesialside, og kan ikke redigeres.\');
 ta[\'ca-nstab-project\'] = new Array(\'a\',\'Vis prosjektsiden\');
 ta[\'ca-nstab-image\'] = new Array(\'c\',\'Vis bildesiden\');
 ta[\'ca-nstab-mediawiki\'] = new Array(\'c\',\'Vis systembeskjeden\');
 ta[\'ca-nstab-template\'] = new Array(\'c\',\'Vis malen\');
 ta[\'ca-nstab-help\'] = new Array(\'c\',\'Vis hjelpesiden\');
 ta[\'ca-nstab-category\'] = new Array(\'c\',\'Vis kategorisiden\');
 ta[\'history-prevlink\'] = new Array(\'-\',\'Forrige\');
 ta[\'history-nextlink\'] = new Array(\'+\',\'Neste\');',
'deletedrevision'       => 'Slettet gammel revisjon $1.',
'previousdiff'          => '← Gå til forrige revisjon',
'nextdiff'              => 'Gå til neste diff →',
'imagemaxsize'          => 'Begrens bilder på bildebeskrivelsessider til:',
'thumbsize'             => 'Miniatyrbildestørrelse:',
'showbigimage'          => 'Last ned versjon med høy opløsning ($1×$2, $3&nbsp;KB)',
'newimages'             => 'Galleri over nye filer',
'showhidebots'          => '($1 roboter)',
'noimages'              => 'Ingenting å se.',
'variantname-zh-cn'     => 'cn',
'variantname-zh-tw'     => 'tw',
'variantname-zh-hk'     => 'hk',
'variantname-zh-sg'     => 'sg',
'variantname-zh'        => 'zh',
'variantname-sr-ec'     => 'sr-ec',
'variantname-sr-el'     => 'sr-el',
'variantname-sr-jc'     => 'sr-jc',
'variantname-sr-jl'     => 'sr-jl',
'variantname-sr'        => 'sr',
'specialloguserlabel'   => 'Bruker:',
'speciallogtitlelabel'  => 'Tittel:',
'passwordtooshort'      => 'Passordet ditt er for kort. Det må ha minst $1 tegn.',
'mediawarning'          => '\'\'\'Advarsel\'\'\': Denne filen kan inneholde farlig kode; ved å åpne den kan systemet ditt kompromitteres.<hr />',
'fileinfo'              => '$1&nbsp;KB, MIME-type: <code>$2</code>',
'metadata'              => 'Metadata',
'metadata-help'         => 'Denne filen inneholder tilleggsinformasjon, antagligvis fra digitalkameraet eller skanneren brukt til å lage eller digitalisere det. Hvis filen har blitt forandret fra utgangspunktet kan enkelte detaljer være unøyaktige.',
'metadata-expand'       => 'Vis detaljer',
'metadata-collapse'     => 'Skjul detaljer',
'exif-imagewidth'       => 'Bredde',
'exif-imagelength'      => 'Høyde',
'exif-bitspersample'    => 'Bits per komponent',
'exif-photometricinterpretation'=> 'Pixelsammensetning',
'exif-samplesperpixel'  => 'Antall komponenter',
'exif-xresolution'      => 'Horisontal oppløsning',
'exif-yresolution'      => 'Vertikal oppløsning',
'exif-imagedescription' => 'Bildetittel',
'exif-make'             => 'Kameraprodusent',
'exif-model'            => 'Kameramodell',
'exif-software'         => 'Programvare brukt',
'exif-artist'           => 'Opphavsperson',
'exif-copyright'        => 'Opphavsbeskyttelse tilhører',
'exif-pixelydimension'  => 'Gyldig bildebredde',
'exif-pixelxdimension'  => 'Gyldig bildehøyde',
'exif-usercomment'      => 'Brukerkommentarer',
'exif-relatedsoundfile' => 'Relatert lydfil',
'edit-externally'       => 'Rediger denne filen med en ekstern applikasjon',
'edit-externally-help'  => 'Se [http://meta.wikimedia.org/wiki/Help:External_editors oppsettsinstruksjonene] for mer informasjon.',
'recentchangesall'      => 'alle',
'imagelistall'          => 'alle',
'watchlistall1'         => 'alle',
'watchlistall2'         => 'alle',
'namespacesall'         => 'alle',
'confirmemail'          => 'Bekreft e-postadresse',
'confirmemail_text'     => 'Denne wikien krever at du bekrefter e-postadressen din før e-posttjenester kan bli brukt. Trykk på knappen under for å sende en bekreftelsese-post til din adresse. E-posten vil inneholde en lenke med en kode; last lenken i nettleseren din for å bekrefte at e-postadressen er gyldig.',
'confirmemail_send'     => 'Send en bekreftelseskode.',
'confirmemail_sent'     => 'Bekreftelsese-post sendt.',
'confirmemail_sendfailed'=> 'Kunne ikke sende bekreftelseskode. Sjekk e-postadressen for ugyldige tegn.',
'confirmemail_invalid'  => 'Ugyldig bekreftelseskode. Koden kan ha utløpt.',
'confirmemail_needlogin'=> 'Du må $1 for å bekrefte e-postadressen di.',
'confirmemail_success'  => 'E-postadressen din har blitt bekreftet. Du kan nå logge inn og nyte wikien.',
'confirmemail_loggedin' => 'E-postadressen din har blitt bekreftet.',
'confirmemail_error'    => 'Noe gitt galt under registrering av din bekreftelse.',
'confirmemail_subject'  => 'Bekreftelsese-post fra {{SITENAME}}',
'confirmemail_body'     => 'Noen, antageligvis deg, fra IP-adressen $1, har registrert kontoen «$2» på {{SITENAME}}, og oppgitt denne e-post-adressen. For å bekrefte at kontoen virkelig tilhører deg og for å aktivere e-posttjenester på {{SITENAME}}, åpne denne lenken i din nettleser: $3

Om dette ikke er deg, ikke følg lenken. Denne bekreftelseskoden vil utløpe $4.',
'tryexact'              => 'Prøv nøyaktig treff',
'searchfulltext'        => 'Søk full tekst',
'createarticle'         => 'Opprett artikkel',
'scarytranscludedisabled'=> '[Interwiki-transkludering er slått av]',
'scarytranscludefailed' => '[Malen kunne ikke hentes for $1; beklager]',
'scarytranscludetoolong'=> '[URL-en er for lang; beklager]',
'trackbackbox'          => '<div id="mw_trackbacks">
Tilbakesporinger for denne artikkelen:<br />
$1
</div>',
'trackbackremove'       => ' ([$1 Slett])',
'trackbacklink'         => 'Tilbakesporing',
'trackbackdeleteok'     => 'Tilbakesporingen ble slettet.',
'deletedwhileediting'   => 'Advarsel: Denne siden har blitt slettet etter at du begynte å redigere den!',
'confirmrecreate'       => '«[[User:$1|$1]]» ([[User talk:$1|diskusjon]]) slettet siden etter at du begynte å redigere den, med begrunnelsen «$2». Vennligst bekreft at du vil gjenopprette siden.',
'recreate'              => 'Gjenopprett',
'tooltip-recreate'      => 'Gjenopprett siden til tross for at den har blitt slettet',
'unit-pixel'            => 'px',
'redirectingto'         => 'Omdirigerer til [[$1]]…',
'confirm_purge'         => 'Vil du slette tjenerens mellomlagrede versjon (\'\'cache\'\') av denne siden? $1',
'confirm_purge_button'  => 'OK',
'youhavenewmessagesmulti'=> 'Du har nye beskjeder på $1',
'searchcontaining'      => 'Søk etter artikler som inneholder \'\'$1\'\'.',
'searchnamed'           => 'Søk for artikler ved navn \'\'$1\'\'.',
'articletitles'         => 'Artikler som begynner med \'\'$1\'\'',
'hideresults'           => 'Skjul resultater',
'displaytitle'          => '(Lenke til denne siden som [[$1]])',
'loginlanguagelabel'    => 'Språk: $1',
);
?>
