#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "mgwtypes.h"
#include "callbacks.h"
#include "interface.h"
#include "image.h"
#include "utils.h"
#include "support.h"

static void
open_file_cbf (GtkWidget *widget, gpointer data)
{
  gchar filename[MAX_FILENAME_LENGTH];
  GtkWidget *fselect = GTK_WIDGET (data);

  if (widget == (GTK_FILE_SELECTION (fselect)->cancel_button))
    gtk_widget_destroy (fselect);
  else {
    strcpy (filename,
	    gtk_file_selection_get_filename (GTK_FILE_SELECTION (fselect)));
    gtk_widget_destroy (fselect);
    display_image_file (filename);
  }
}

static void
save_file_cbf (GtkWidget *widget, gpointer data)
{
  GtkWidget *fselect = GTK_WIDGET (data);
  GdkCursor *watch;
  struct stat statinfo;
  gchar *filename;

  if (widget == (GTK_FILE_SELECTION (fselect)->ok_button)) {
    filename = (gchar *) gtk_file_selection_get_filename (GTK_FILE_SELECTION (fselect));
    if (!stat (filename, &statinfo)) {
      show_error_dialog (data, _("File exists!"));
      return;
    }
    watch = gdk_cursor_new (GDK_WATCH);
    gdk_window_set_cursor (fselect->window, watch);
    gdk_flush ();

    save_current_image_as (filename);

    gdk_cursor_destroy (watch);
  }
  gtk_widget_destroy (fselect);
}

/* Entry point */
void
on_open_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  GtkWidget *fselect = gtk_file_selection_new (_("Read Directory/File"));
  gchar *filename = get_current_filename ();

  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (fselect)->ok_button),
		      "clicked", GTK_SIGNAL_FUNC (open_file_cbf), fselect);
  gtk_signal_connect (GTK_OBJECT
		      (GTK_FILE_SELECTION (fselect)->cancel_button),
		      "clicked", GTK_SIGNAL_FUNC (open_file_cbf), fselect);
  gtk_signal_connect (GTK_OBJECT (fselect), "destroy",
		      GTK_SIGNAL_FUNC (gtk_grab_remove), fselect);
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (fselect));

  gtk_file_selection_set_filename (GTK_FILE_SELECTION (fselect), filename);
  gtk_widget_show (fselect);
  gtk_grab_add (fselect);
}

void
on_save_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  save_current_image_as ("OVERWRITE");
}

void
on_save_as_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  GtkWidget *fselect;

  fselect = gtk_file_selection_new (_("SAVING FILE"));

  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (fselect)->ok_button),
		      "clicked", GTK_SIGNAL_FUNC (save_file_cbf), fselect);
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (fselect)->cancel_button),
		      "clicked", GTK_SIGNAL_FUNC (save_file_cbf), fselect);
  gtk_signal_connect (GTK_OBJECT (fselect), "destroy",
		      GTK_SIGNAL_FUNC (gtk_grab_remove), fselect);
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (fselect));
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (fselect),
				   get_current_filename ());
  gtk_window_set_position (GTK_WINDOW (fselect), GTK_WIN_POS_CENTER);
  gtk_widget_show (fselect);
  gtk_grab_add (fselect);
}

void
on_revert_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  revert_image ();
}

void
on_quit_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  gtk_main_quit ();
}

void
on_cut_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  g_warning ("NOT IMPLEMENTED YET!");
}

void
on_copy_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  g_warning ("NOT IMPLEMENTED YET!");
}

void
on_paste_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  g_warning ("NOT IMPLEMENTED YET!");
}

void
on_clear_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  g_warning ("NOT IMPLEMENTED YET!");
}

void
on_properties_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  g_warning ("NOT IMPLEMENTED YET!");
}

void
on_preferences_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  g_warning ("NOT IMPLEMENTED YET!");
}

void
on_about_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  GtkWidget *about;

  about = (GtkWidget *) create_about ();
  gtk_widget_show (about);
}
