#define MAX_FILENAME_LENGTH 256

typedef enum {
  INITIAL,
  IMAGE_ON,
  LOCK,
  UNLOCK
} MenuStatus;

typedef struct _MgwClipRect       MgwClipRect;
typedef struct _MgwImageInfo      MgwImageInfo;
typedef struct _MgwSizeInfo       MgwSizeInfo;
typedef struct _MgwBorderProperty MgwBorderProperty;

struct _MgwClipRect
{
  gint x0;
  gint y0;
  gint x1;
  gint y1;
  gint xp;
  gint yp;
};

struct _MgwImageInfo
{
  gboolean changed;
  gboolean has_clip;
  gboolean drifting;
  gboolean handling;
  gchar filename[MAX_FILENAME_LENGTH];
  gint width;
  gint height;
  gint xmargin;
  gint ymargin;
  gint xscroll;
  gint yscroll;
  gint xdrift;
  gint ydrift;
  gdouble zoom;
  MgwClipRect clip;
  GdkPixbuf *pbuf, *org;
  GdkPixbufFormat *pfmt;
};

struct _MgwSizeInfo
{
  gint w;
  gint h;
  gint rs;
  gint nc;
};

struct _MgwBorderProperty
{
  GdkColor background;
  GdkColor wooden;
};
