# Ming/Slide
# $Id: $
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License, or (at your option) any later version.
#
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# RD -> Ming/Slide

require 'rd/rdvisitor'
require 'rd/version'

module RD

  class RD2MSDVisitor < RDVisitor

	OUTPUT_SUFFIX = 'msd'
	INCLUDE_SUFFIX = ['msd']

	METACHAR = {}

	attr_accessor :font_path, :style_path, :style, :swf_file

	def initialize

	  @version = '0.0.1'
	  @page = -1 
	  @style_path = ['.']
	  @style_files = ['default.mst']
	  @font_path = ['.']
	  @output_file = 'slide.msd'
	  @swf_file = 'slide.swf'

	  @title = nil

	  super
	end
	
	def visit(tree)
	  prepare_labels(tree, 'label:')

	  super(tree)
	end

	def apply_to_DocumentElement(element, content)
	  ret = ''

	  ret << msd_head

	  @style_files.each do |style|
		ret << %Q[load "#{style}"\n]
	  end

	  ret << content.join
	  
	  ret << msd_tail
	  
	  ret << "\n"

	  ret
	end

	def apply_to_Headline(element, title)
	  ret = ''

	  case element.level
	  when 1
		@page = @page + 1
		ret << %Q(slide.display\n\n) if @page > 0
		unless @title
		  @title = title
		  ret << "\n"
		  ret << %Q(movie = SlideMovie.new("#{@title}")\n\n)
		  ret << %Q(slide = movie.newpage\n)
		  ret << %Q(slide.style = 'title'\n)
		else
		  ret << %Q(slide = movie.newpage\n)
		  ret << %Q(slide.style = 'plain'\n)
		end
		
		ret << %Q[slide.add('headline', "#{title}", #{element.level})\n]
	  when 2, 3, 4
		ret << %Q[slide.add('headline', "#{title}", #{element.level})\n]
	  else
	  end

	  ret
	end

	def apply_to_TextBlock(element, content)

	  string = content.join.chomp
	  ret = ''

	  if (is_this_textblock_only_one_block_of_parent_listitem?(element) or
		  is_this_textblock_only_one_block_other_than_sublists_in_parent_listitem?(element))
		ret << content.join('').chomp
	  else
		string.gsub!(/\n/, '')
		ret << %Q[slide.add('textblock', "#{string}")\n]
	  end

	  ret
	end

    def is_this_textblock_only_one_block_of_parent_listitem?(element)
      (element.parent.is_a?(ItemListItem) or
       element.parent.is_a?(EnumListItem)) and
        consist_of_one_textblock?(element.parent)
    end
	
    def consist_of_one_textblock?(listitem)
      listitem.content.size == 1 and listitem.content[0].is_a?(TextBlock)
    end
    private :consist_of_one_textblock?

    def is_this_textblock_only_one_block_other_than_sublists_in_parent_listitem?(element)
      (element.parent.is_a?(ItemListItem) or
       element.parent.is_a?(EnumListItem)) and
        consist_of_one_textblock_and_sublists(element.parent)
    end

    def consist_of_one_textblock_and_sublists(element)
      i = 0
      element.each_child do |child|
        if i == 0
          return false unless child.is_a?(TextBlock)
        else
          return false unless child.is_a?(List)
        end
        i += 1
      end
      return true
    end


	def apply_to_Verbatim(element)

	  ret = ''

	  #content = []
	  #element.each_line do |i|
	#	content.push(i)
	#  end

	  element.each_line do |string|
		string.chomp!
		ret << %Q[slide.add('verbatim', "#{string}")\n]
	  end

	  ret
	end

	def add_style(style)
	  @style_files.push(style)
	end

	def add_list(type, items)
	  ret = ''

	  ret << %Q[slide.start('#{type}')\n]

	  items.each do |i|
		ret << i if i
	  end

	  ret << %Q[slide.end('#{type}')\n]

	  ret

	end

	def apply_to_ItemList(element, items)
	  add_list('itemlist', items)
	end

	def apply_to_EnumList(element, items)
	  add_list('enumlist', items)
	end

	def apply_to_DescList(element, items)
	  add_list('desclist', items)
	end

	def apply_to_MethodList(element, items)
	  add_list('methodlist', items)
	end

	def add_listitem(type, content)
	  ret = ''

	  content.each do |i|
		re = /slide.start\('#{type}'\)\n(.*)slide.end\('#{type}'\)\n/m
		if  re =~ i
		  ret << %Q[slide.start('#{type}')\n]
		  ret << Regexp.last_match[1]
		  ret << %Q[slide.end('#{type}')\n]
		else
		  ret << %Q[slide.add('#{type}', "#{i}")\n]
		end
	  end

	  ret
	end

	def apply_to_ItemListItem(element, content)
	  add_listitem('itemlist', content)
	end

	def apply_to_EnumListItem(element, content)
	  add_listitem('enumlist', content)
	end

	def apply_to_DescListItem(element, term, description)
	  ret = ''

	  ret << %Q[slide.add('desclist', "#{term}")\n]
	  ret << %Q[#{description}]

	  ret
	end

	def apply_to_MethodListItem(element, term, description)
	end

	def apply_to_StringElement(element)
	  element.content
	end

	def apply_to_Emphasis(element, content)
	  content.join('')
	end

	def apply_to_Code(element, content)
	  content.join('')
	end

	def apply_to_Var(element, content)
	  content.join('')
	end

	def apply_to_Keyboard(element, content)
	  content.join('')
	end

	def apply_to_Index(element, content)
	  content.join('')
	end

	def apply_to_Reference(element, content)
	  content.join('') # ad-hoc experimentally implementation
	end

	def msd_head
	  ret = '# Ming/Slide ' + @version.to_s + "\n#\n\n"
	  ret << %Q[require 'ming/slide/slide'\n\n]

	  ret
	end

	def msd_tail
	  ret = ''
	  ret << %Q(slide.display\n\n)
	  ret << %Q[movie.save("#{@swf_file}")\n]

	  ret
	end
	
  end

end

$Visitor_Class = RD::RD2MSDVisitor
$RD2_Sub_OptionParser = 'ming/slide/rd2msd-opt'
