/******************************************************************************
 * mod_uploader / FileWriter.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: FileWriter.h 469 2005-07-19 00:23:53Z svn $
 *****************************************************************************/

#ifndef FILEWRITER_H
#define FILEWRITER_H

#include "apr_file_io.h"

#include <cstdlib>

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

using namespace std;
/**
 * @brief եإǡ񤭽Ф饹
 */
class FileWriter
{
public:
    FileWriter(apr_pool_t *pool, apr_file_t *fd);
    virtual void write(const void *buf, apr_size_t size) = 0;
    virtual void close();
    virtual ~FileWriter();
protected:
    apr_pool_t *get_pool()
    {
        return pool_;
    }

    apr_file_t *get_fd()
    {
        return fd_;
    }

private:
    apr_pool_t *pool_;
    apr_file_t *fd_;
    bool is_closed_;

    FileWriter(const FileWriter &);
    FileWriter &operator=(const FileWriter &);
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
