/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import base.drawable.TimeBoundingBox;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import viewer.zoomable.CoordPixelImage;
import viewer.zoomable.Debug;
import viewer.zoomable.InfoDialog;
import viewer.zoomable.InfoDialogForTime;
import viewer.zoomable.ModelTime;
import viewer.zoomable.ScrollableView;

public abstract class ScrollableObject
extends JComponent
implements ScrollableView {
    private static final int NumImages = 3;
    protected static final int NumViewsPerImage = 2;
    protected static final int NumViewsTotal = 6;
    private ModelTime model = null;
    private JViewport src_vport;
    private Image[] offscreenImages;
    private TimeBoundingBox[] tImages;
    private double tImage_extent;
    private TimeBoundingBox tImages_all;
    private int half_NumImages;
    private int cur_img_idx;
    private Dimension visible_size;
    private Dimension image_size;
    private Dimension component_size;

    public ScrollableObject(ModelTime modelTime) {
        this.model = modelTime;
        this.offscreenImages = new Image[3];
        this.tImages = new TimeBoundingBox[3];
        for (int i = 0; i < 3; ++i) {
            this.tImages[i] = new TimeBoundingBox();
        }
        this.tImages_all = new TimeBoundingBox();
        super.setDoubleBuffered(false);
        this.half_NumImages = 1;
        this.setImagesInitTimeBounds();
        this.image_size = new Dimension(0, 0);
        this.component_size = super.getSize();
        this.setDebugGraphicsOptions(7);
    }

    private void setImagesInitTimeBounds() {
        double d = this.model.getTimeViewExtent();
        this.tImage_extent = 2.0 * d;
        this.tImages_all.reinitialize();
        int n = 0;
        this.tImages[n].setEarliestTime(this.model.getTimeViewPosition() - 0.5 * d * 5.0);
        this.tImages[n].setLatestFromEarliest(this.tImage_extent);
        this.tImages_all.affectTimeBounds(this.tImages[n]);
        for (n = 1; n < 3; ++n) {
            this.tImages[n].setEarliestTime(this.tImages[n - 1].getLatestTime());
            this.tImages[n].setLatestFromEarliest(this.tImage_extent);
            this.tImages_all.affectTimeBounds(this.tImages[n]);
        }
        this.cur_img_idx = this.half_NumImages;
    }

    public String getStringforTimesOfImages() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 3; ++i) {
            stringBuffer.append("tImages[ " + i + " ] = " + this.tImages[i] + "\n");
        }
        return stringBuffer.toString();
    }

    public TimeBoundingBox getTimeBoundsOfImages() {
        return new TimeBoundingBox(this.tImages_all);
    }

    private int getValidImageIndex(int n) {
        int n2 = n % 3;
        if (n2 < 0) {
            return n2 + 3;
        }
        return n2;
    }

    private int getNearPastImageIndex(int n) {
        if (n == 0) {
            return 2;
        }
        return n - 1;
    }

    private int getNearFutureImageIndex(int n) {
        if (n == 2) {
            return 0;
        }
        return n + 1;
    }

    private int getNearImageIndex(int n, int n2) {
        if (n2 < 0) {
            return this.getNearPastImageIndex(n);
        }
        return this.getNearFutureImageIndex(n);
    }

    private Image createImage(Dimension dimension) {
        if (Debug.isActive()) {
            Debug.println("ScrollableObject: createImage()'s image_sz = " + dimension);
        }
        if (dimension.width > 0 && dimension.height > 0) {
            return super.createImage(dimension.width, dimension.height);
        }
        return null;
    }

    private int getNumImagesMoved() {
        double d = this.model.getTimeViewPosition();
        double d2 = this.model.getTimeViewExtent();
        double d3 = d + d2;
        if (Debug.isActive()) {
            Debug.println("ScrollableObject: getNumImagesMoved()'s START: ");
            Debug.println("cur_tView_init  = " + d + ",  " + "cur_tView_final = " + d3);
            Debug.println("tImages[ cur ] = " + this.tImages[this.cur_img_idx]);
        }
        double d4 = this.tImages_all.getEarliestTime();
        if (Debug.isActive()) {
            Debug.println("ScrollableObject: getNumImagesMoved() tImages_init = " + d4);
        }
        double d5 = (d - d4) / this.tImage_extent;
        int n = (int)Math.floor(d5) - this.half_NumImages;
        double d6 = (d3 - d4) / this.tImage_extent;
        int n2 = (int)Math.floor(d6) - this.half_NumImages;
        int n3 = 0;
        if (n > 0) {
            n3 = n;
        }
        if (n2 < 0) {
            n3 = n2;
        }
        if (Debug.isActive()) {
            Debug.println("ScrollableObject: getNumImagesMoved() Nmages_moved = " + n3);
            Debug.println("ScrollableObject: getNumImagesMoved()'s END: ");
        }
        return n3;
    }

    public void checkToZoomView() {
        double d;
        if (Debug.isActive()) {
            Debug.println("ScrollableObject: checkToZoomView()'s START: ");
        }
        if ((d = this.model.getTimeViewExtent()) * 2.0 != this.tImage_extent) {
            this.setImagesInitTimeBounds();
            this.initializeAllOffImages(this.tImages_all);
            for (int i = 0; i < 3; ++i) {
                this.drawOneOffImage(this.offscreenImages[i], this.tImages[i]);
            }
            this.finalizeAllOffImages(this.tImages_all);
        }
        if (Debug.isActive()) {
            Debug.println("ScrollableObject: checkToZoomView()'s END: ");
        }
    }

    public void checkToScrollView() {
        if (Debug.isActive()) {
            Debug.println("ScrollableObject: checkToScrollView()'s START: ");
        }
        int n = 0;
        int n2 = this.getNumImagesMoved();
        if (n2 != 0) {
            if (Math.abs(n2) <= 3) {
                int n3;
                int n4;
                n = n2 / Math.abs(n2);
                int n5 = this.getValidImageIndex(this.cur_img_idx + n * this.half_NumImages);
                for (n4 = 1; n4 <= Math.abs(n2); ++n4) {
                    n3 = this.getValidImageIndex(n5 + n * n4);
                    if (Debug.isActive()) {
                        Debug.println("ScrollableObject: checkToScrollView() cur_img_idx = " + this.cur_img_idx + ", " + "start_idx = " + n5 + ", " + "img_idx = " + n3);
                    }
                    if (!this.tImages_all.remove(this.tImages[n3])) {
                        System.err.println("ScrollableObject: checkToScrollView() tImages[" + n3 + "] = " + this.tImages[n3] + " does NOT " + "cover the end of tImages_all = " + this.tImages_all);
                    }
                    if (n > 0) {
                        int n6 = this.getNearPastImageIndex(n3);
                        this.tImages[n3].setEarliestTime(this.tImages[n6].getLatestTime());
                        this.tImages[n3].setLatestFromEarliest(this.tImage_extent);
                    } else {
                        int n7 = this.getNearFutureImageIndex(n3);
                        this.tImages[n3].setLatestTime(this.tImages[n7].getEarliestTime());
                        this.tImages[n3].setEarliestFromLatest(this.tImage_extent);
                    }
                    this.tImages_all.affectTimeBounds(this.tImages[n3]);
                }
                this.initializeAllOffImages(this.tImages_all);
                if (n > 0) {
                    for (n4 = Math.abs(n2); n4 >= 1; --n4) {
                        n3 = this.getValidImageIndex(n5 + n * n4);
                        if (this.offscreenImages[n3] == null) continue;
                        this.drawOneOffImage(this.offscreenImages[n3], this.tImages[n3]);
                    }
                } else {
                    for (n4 = 1; n4 <= Math.abs(n2); ++n4) {
                        n3 = this.getValidImageIndex(n5 + n * n4);
                        if (this.offscreenImages[n3] == null) continue;
                        this.drawOneOffImage(this.offscreenImages[n3], this.tImages[n3]);
                    }
                }
                this.finalizeAllOffImages(this.tImages_all);
                this.cur_img_idx = this.getValidImageIndex(this.cur_img_idx + n2);
            } else {
                if (Debug.isActive()) {
                    Debug.println("****************************************");
                    Debug.println("ScrollableObject: checkToScrollView() | Nimages_moved( " + n2 + " ) | >= NumImages( " + 3 + " )");
                }
                this.setImagesInitTimeBounds();
                this.initializeAllOffImages(this.tImages_all);
                for (int i = 0; i < 3; ++i) {
                    this.drawOneOffImage(this.offscreenImages[i], this.tImages[i]);
                }
                this.finalizeAllOffImages(this.tImages_all);
            }
        }
        if (Debug.isActive()) {
            Debug.println("ScrollableObject: checkToScrollView()'s END: ");
        }
    }

    protected int time2pixel(double d) {
        return (int)Math.round((d - this.tImages_all.getEarliestTime()) * this.model.getViewPixelsPerUnitTime());
    }

    protected double pixel2time(int n) {
        return (double)n / this.model.getViewPixelsPerUnitTime() + this.tImages_all.getEarliestTime();
    }

    public int getXaxisViewPosition() {
        if (Debug.isActive()) {
            Debug.println("ScrollableObject: getViewPosition() : model.getTimeViewPosition()=" + this.model.getTimeViewPosition());
        }
        return this.time2pixel(this.model.getTimeViewPosition());
    }

    protected abstract void initializeAllOffImages(TimeBoundingBox var1);

    protected abstract void drawOneOffImage(Image var1, TimeBoundingBox var2);

    protected abstract void finalizeAllOffImages(TimeBoundingBox var1);

    public void paintComponent(Graphics graphics) {
        int n;
        if (Debug.isActive()) {
            Debug.println("ScrollableObject : paintComponent()'s START : ");
            Debug.println("ScrollableObject : paintComponent() g.getClipBounds() = " + graphics.getClipBounds());
            Debug.println("ScrollableObject : paintComponent() this = " + this);
            if (this.src_vport != null) {
                Debug.println("ScrollableObject: paintComponent() src_vport.getViewPosition() = " + this.src_vport.getViewPosition());
            }
        }
        n = (n = this.model.getViewportMovingDir()) < 0 ? -1 : 1;
        int n2 = this.image_size.width;
        int n3 = this.cur_img_idx;
        int n4 = this.half_NumImages * n2;
        if (this.offscreenImages[n3] != null) {
            graphics.drawImage(this.offscreenImages[n3], n4, 0, this);
        }
        for (int i = 1; i <= this.half_NumImages; ++i) {
            for (int j = 1; j >= -1; j -= 2) {
                int n5 = j * n * i;
                n3 = this.getValidImageIndex(this.cur_img_idx + n5);
                if (Debug.isActive()) {
                    Debug.println("ScrollableObject: paintComponent() side_offset = " + n5 + ",  " + "img_idx = " + n3);
                }
                n4 = (this.half_NumImages + n5) * n2;
                if (this.offscreenImages[n3] == null) continue;
                graphics.drawImage(this.offscreenImages[n3], n4, 0, this);
            }
        }
        if (Debug.isActive()) {
            Debug.println("ScrollableObject : paintComponent()'s END : ");
        }
    }

    public abstract int getJComponentHeight();

    public void componentResized(JViewport jViewport) {
        int n;
        if (Debug.isActive()) {
            Debug.println("ScrollableObject: componentResized()'s START: ");
            Debug.println("incoming viewport = " + jViewport);
        }
        this.src_vport = jViewport;
        if (this.src_vport != null) {
            this.visible_size = this.src_vport.getExtentSize();
            if (Debug.isActive()) {
                Debug.println("ScrollableObject: componentResized()'s src_vport.getViewPosition() = " + this.src_vport.getViewPosition());
            }
        } else {
            this.visible_size = this.getVisibleRect().getSize();
        }
        this.image_size.setSize(this.visible_size.width * 2, this.getJComponentHeight());
        int n2 = 0;
        for (n = 0; n < 3; ++n) {
            this.offscreenImages[n] = this.createImage(this.image_size);
            if (this.offscreenImages[n] == null) continue;
            ++n2;
        }
        if (n2 == 3 && this.visible_size.width > 0) {
            this.model.setViewPixelsPerUnitTime(this.visible_size.width);
            this.model.updatePixelCoords();
        }
        this.component_size.setSize(this.image_size.width * 3, this.image_size.height);
        this.setSize(this.component_size);
        n = this.getValidImageIndex(this.cur_img_idx + this.half_NumImages + 1);
        this.initializeAllOffImages(this.tImages_all);
        for (int i = 0; i < 3; ++i) {
            this.drawOneOffImage(this.offscreenImages[n], this.tImages[n]);
            n = this.getNearFutureImageIndex(n);
        }
        this.finalizeAllOffImages(this.tImages_all);
        if (Debug.isActive()) {
            Debug.println("ScrollableObject: componentResized()'s END: ");
        }
    }

    public Dimension getPreferredSize() {
        if (Debug.isActive()) {
            Debug.println("ScrollableObject: pref_size = " + this.component_size);
        }
        return this.component_size;
    }

    public Dimension getSize() {
        if (Debug.isActive()) {
            Debug.println("ScrollableObject: size = " + this.component_size);
        }
        return this.component_size;
    }

    public void setCursor(Cursor cursor) {
    }

    public abstract InfoDialog getPropertyAt(Point var1, TimeBoundingBox var2);

    protected InfoDialog getTimePropertyAt(Point point) {
        CoordPixelImage coordPixelImage = new CoordPixelImage(this, 0, this.getTimeBoundsOfImages());
        Window window = SwingUtilities.windowForComponent(this);
        if (window instanceof Frame) {
            return new InfoDialogForTime((Frame)window, coordPixelImage.convertPixelToTime(point.x));
        }
        return new InfoDialogForTime((Dialog)window, coordPixelImage.convertPixelToTime(point.x));
    }
}

