/*
 * Decompiled with CFR 0.152.
 */
package logformat.clog2;

import java.io.DataInputStream;
import java.io.IOException;
import logformat.clog2.LineID;

public class RecMsg {
    public static final int RECTYPE = 7;
    private static final int BYTESIZE = 24;
    public Integer etype;
    private int icomm;
    private int rank;
    public int tag;
    public int size;
    private static int pad;
    public int lineID;

    public int readFromDataStream(DataInputStream in) {
        try {
            this.etype = new Integer(in.readInt());
            this.icomm = in.readInt();
            this.rank = in.readInt();
            this.tag = in.readInt();
            this.size = in.readInt();
            pad = in.readInt();
        }
        catch (IOException ioerr) {
            ioerr.printStackTrace();
            return 0;
        }
        this.lineID = LineID.compute(this.icomm, this.rank);
        return 24;
    }

    public int skipBytesFromDataStream(DataInputStream in) {
        try {
            in.skipBytes(24);
        }
        catch (IOException ioerr) {
            ioerr.printStackTrace();
            return 0;
        }
        return 24;
    }

    private String toEventString() {
        switch (this.etype) {
            case -101: {
                return "send";
            }
            case -102: {
                return "recv";
            }
        }
        return "Unknown(" + this.etype + ")";
    }

    public String toString() {
        return "RecMsg[ etype=" + this.toEventString() + ", icomm=" + this.icomm + ", rank=" + this.rank + ", tag=" + this.tag + ", size=" + this.size + " ]";
    }
}

