/*
 * Decompiled with CFR 0.152.
 */
package logformat.clog;

import java.io.DataInputStream;
import java.io.IOException;

public class RecHeader {
    private static final int BYTESIZE = 24;
    public double timestamp;
    public int rectype;
    public int length;
    public int taskID;
    private static int pad;

    public RecHeader() {
        this.timestamp = Double.MIN_VALUE;
        this.rectype = Integer.MIN_VALUE;
        this.length = Integer.MIN_VALUE;
        this.taskID = Integer.MIN_VALUE;
        pad = Integer.MIN_VALUE;
    }

    public RecHeader(DataInputStream istm) {
        this.readFromDataStream(istm);
    }

    public int readFromDataStream(DataInputStream istm) {
        try {
            this.timestamp = istm.readDouble();
            this.rectype = istm.readInt();
            this.length = istm.readInt();
            this.taskID = istm.readInt();
            pad = istm.readInt();
        }
        catch (IOException ioerr) {
            ioerr.printStackTrace();
            return 0;
        }
        return 24;
    }

    public int skipBytesFromDataStream(DataInputStream in) {
        try {
            in.skipBytes(24);
        }
        catch (IOException ioerr) {
            ioerr.printStackTrace();
            return 0;
        }
        return 24;
    }

    public RecHeader copy() {
        RecHeader cp = new RecHeader();
        cp.timestamp = this.timestamp;
        cp.rectype = this.rectype;
        cp.length = this.length;
        cp.taskID = this.taskID;
        return cp;
    }

    public int getRecType() {
        return this.rectype;
    }

    public String toString() {
        return "RecHeader[ timestamp=" + this.timestamp + ", rectype=" + this.rectype + ", length=" + this.length + ", taskID=" + this.taskID + " ]";
    }
}

