/*
 * Decompiled with CFR 0.152.
 */
package base.statistics;

import base.drawable.CoordPixelXform;
import base.drawable.Drawable;
import base.drawable.Shadow;
import base.drawable.TimeBoundingBox;
import base.drawable.Topology;
import base.statistics.Summarizable;
import base.statistics.TimeAveBox;
import base.topology.SummaryArrow;
import base.topology.SummaryState;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BufForTimeAveBoxes
extends TimeBoundingBox {
    private Map map_lines2nestable = new HashMap();
    private Map map_lines2nestless = new HashMap();
    private Map map_rows2nestable = null;
    private Map map_rows2nestless = null;
    private float init_state_height_ftr;
    private float next_state_height_ftr;
    private boolean drawStates = true;
    private boolean drawArrows = true;

    public BufForTimeAveBoxes(TimeBoundingBox timebox) {
        super(timebox);
    }

    public void mergeWithNestable(Drawable dobj) {
        ArrayList<Object> key = new ArrayList<Object>();
        Topology topo = dobj.getCategory().getTopology();
        key.add(topo);
        Integer lineID_start = new Integer(dobj.getStartVertex().lineID);
        Integer lineID_final = new Integer(dobj.getFinalVertex().lineID);
        key.add(lineID_start);
        key.add(lineID_final);
        TimeAveBox avebox = null;
        avebox = (TimeAveBox)this.map_lines2nestable.get(key);
        if (avebox == null) {
            avebox = new TimeAveBox(this, true);
            this.map_lines2nestable.put(key, avebox);
        }
        if (dobj instanceof Shadow) {
            avebox.mergeWithShadow((Shadow)dobj);
        } else {
            avebox.mergeWithReal(dobj);
        }
    }

    public void mergeWithNestless(Drawable dobj) {
        ArrayList<Object> key = new ArrayList<Object>();
        Topology topo = dobj.getCategory().getTopology();
        key.add(topo);
        Integer lineID_start = new Integer(dobj.getStartVertex().lineID);
        Integer lineID_final = new Integer(dobj.getFinalVertex().lineID);
        key.add(lineID_start);
        key.add(lineID_final);
        TimeAveBox avebox = null;
        avebox = (TimeAveBox)this.map_lines2nestless.get(key);
        if (avebox == null) {
            avebox = new TimeAveBox(this, false);
            this.map_lines2nestless.put(key, avebox);
        }
        if (dobj instanceof Shadow) {
            avebox.mergeWithShadow((Shadow)dobj);
        } else {
            avebox.mergeWithReal(dobj);
        }
    }

    public void setNestingExclusion() {
        Iterator avebox_itr = this.map_lines2nestable.values().iterator();
        while (avebox_itr.hasNext()) {
            TimeAveBox avebox = (TimeAveBox)avebox_itr.next();
            avebox.setNestingExclusion();
        }
    }

    public String toString() {
        TimeAveBox avebox;
        Object[] key;
        Map.Entry entry;
        Iterator entries;
        StringBuffer rep = new StringBuffer(super.toString());
        if (this.map_lines2nestable.size() > 0) {
            entries = this.map_lines2nestable.entrySet().iterator();
            while (entries.hasNext()) {
                entry = entries.next();
                key = ((List)entry.getKey()).toArray();
                avebox = (TimeAveBox)entry.getValue();
                rep.append("\n" + key[0] + ": " + key[1] + ", " + key[2]);
                rep.append("\n" + avebox);
            }
            rep.append("\n");
        }
        if (this.map_lines2nestless.size() > 0) {
            entries = this.map_lines2nestless.entrySet().iterator();
            while (entries.hasNext()) {
                entry = entries.next();
                key = ((List)entry.getKey()).toArray();
                avebox = (TimeAveBox)entry.getValue();
                rep.append("\n" + key[0] + ": " + key[1] + ", " + key[2]);
                rep.append("\n" + avebox);
            }
            rep.append("\n");
        }
        return rep.toString();
    }

    private static List getLine2RowMappedKey(Map map_line2row, List old_keylist) {
        ArrayList<Object> new_keylist = new ArrayList<Object>();
        Object[] old_keys = old_keylist.toArray();
        new_keylist.add(old_keys[0]);
        new_keylist.add(map_line2row.get((Integer)old_keys[1]));
        new_keylist.add(map_line2row.get((Integer)old_keys[2]));
        return new_keylist;
    }

    public void setDrawingStates(boolean isDrawing) {
        this.drawStates = isDrawing;
    }

    public void setDrawingArrows(boolean isDrawing) {
        this.drawArrows = isDrawing;
    }

    public void initializeDrawing(Map map_line2row, Color background_color, boolean isZeroTimeOrigin, float init_state_height, float next_state_height) {
        TimeAveBox rowed_avebox;
        List rowed_key;
        TimeAveBox lined_avebox;
        List lined_key;
        Map.Entry entry;
        this.map_rows2nestable = new HashMap();
        Iterator entry_itr = this.map_lines2nestable.entrySet().iterator();
        while (entry_itr.hasNext()) {
            entry = entry_itr.next();
            lined_key = (List)entry.getKey();
            lined_avebox = (TimeAveBox)entry.getValue();
            rowed_key = BufForTimeAveBoxes.getLine2RowMappedKey(map_line2row, lined_key);
            rowed_avebox = (TimeAveBox)this.map_rows2nestable.get(rowed_key);
            if (rowed_avebox == null) {
                rowed_avebox = new TimeAveBox(lined_avebox);
                this.map_rows2nestable.put(rowed_key, rowed_avebox);
                continue;
            }
            rowed_avebox.mergeWithTimeAveBox(lined_avebox);
        }
        Iterator avebox_itr = this.map_rows2nestable.values().iterator();
        while (avebox_itr.hasNext()) {
            rowed_avebox = (TimeAveBox)avebox_itr.next();
            rowed_avebox.setNestingExclusion();
            rowed_avebox.initializeCategoryTimeBoxes();
            if (isZeroTimeOrigin) {
                SummaryState.setTimeBoundingBox(rowed_avebox, 0.0, super.getDuration());
                continue;
            }
            SummaryState.setTimeBoundingBox(rowed_avebox, super.getEarliestTime(), super.getLatestTime());
        }
        this.map_rows2nestless = new HashMap();
        entry_itr = this.map_lines2nestless.entrySet().iterator();
        while (entry_itr.hasNext()) {
            entry = entry_itr.next();
            lined_key = (List)entry.getKey();
            lined_avebox = (TimeAveBox)entry.getValue();
            rowed_key = BufForTimeAveBoxes.getLine2RowMappedKey(map_line2row, lined_key);
            rowed_avebox = (TimeAveBox)this.map_rows2nestless.get(rowed_key);
            if (rowed_avebox == null) {
                rowed_avebox = new TimeAveBox(lined_avebox);
                this.map_rows2nestless.put(rowed_key, rowed_avebox);
                continue;
            }
            rowed_avebox.mergeWithTimeAveBox(lined_avebox);
        }
        avebox_itr = this.map_rows2nestless.values().iterator();
        while (avebox_itr.hasNext()) {
            rowed_avebox = (TimeAveBox)avebox_itr.next();
            rowed_avebox.initializeCategoryTimeBoxes();
            if (isZeroTimeOrigin) {
                SummaryArrow.setTimeBoundingBox(rowed_avebox, 0.0, super.getDuration());
                continue;
            }
            SummaryArrow.setTimeBoundingBox(rowed_avebox, super.getEarliestTime(), super.getLatestTime());
        }
        SummaryState.setBackgroundColor(background_color);
        this.init_state_height_ftr = init_state_height;
        this.next_state_height_ftr = next_state_height;
    }

    public int drawAllStates(Graphics2D g, CoordPixelXform coord_xform) {
        if (!this.drawStates) {
            return 0;
        }
        int count = 0;
        float avebox_hgt = (this.init_state_height_ftr - this.next_state_height_ftr) / 2.0f;
        Iterator entries = this.map_rows2nestable.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Object[] key = ((List)entry.getKey()).toArray();
            TimeAveBox avebox = (TimeAveBox)entry.getValue();
            Topology topo = (Topology)key[0];
            int rowID = (Integer)key[1];
            float rStart = (float)rowID - this.init_state_height_ftr / 2.0f;
            float rFinal = rStart + this.init_state_height_ftr;
            count += SummaryState.draw(g, avebox, coord_xform, rStart, rFinal, avebox_hgt);
        }
        return count;
    }

    public int drawAllArrows(Graphics2D g, CoordPixelXform coord_xform) {
        if (!this.drawArrows) {
            return 0;
        }
        int count = 0;
        Iterator entries = this.map_rows2nestless.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Object[] key = ((List)entry.getKey()).toArray();
            TimeAveBox avebox = (TimeAveBox)entry.getValue();
            Topology topo = (Topology)key[0];
            int rowID1 = (Integer)key[1];
            int rowID2 = (Integer)key[2];
            float rStart = rowID1;
            float rFinal = rowID2;
            count += SummaryArrow.draw(g, avebox, coord_xform, rStart, rFinal);
        }
        return count;
    }

    public Summarizable getSummarizableAt(CoordPixelXform coord_xform, Point pix_pt) {
        float rFinal;
        float rStart;
        TimeAveBox avebox;
        Map.Entry entry;
        Iterator entries;
        Topology topo = null;
        int rowID1 = -1;
        int rowID2 = -1;
        Object[] key = null;
        Object clicked_obj = null;
        if (this.drawArrows) {
            entries = this.map_rows2nestless.entrySet().iterator();
            while (entries.hasNext() && clicked_obj == null) {
                entry = entries.next();
                key = ((List)entry.getKey()).toArray();
                avebox = (TimeAveBox)entry.getValue();
                topo = (Topology)key[0];
                rowID1 = (Integer)key[1];
                rowID2 = (Integer)key[2];
                rStart = rowID1;
                rFinal = rowID2;
                clicked_obj = SummaryArrow.containsPixel(avebox, coord_xform, pix_pt, rStart, rFinal);
            }
            if (clicked_obj != null) {
                return new Summarizable(clicked_obj, topo, rowID1, rowID2);
            }
        }
        if (this.drawStates) {
            float avebox_hgt = (this.init_state_height_ftr - this.next_state_height_ftr) / 2.0f;
            entries = this.map_rows2nestable.entrySet().iterator();
            while (entries.hasNext() && clicked_obj == null) {
                entry = entries.next();
                key = ((List)entry.getKey()).toArray();
                avebox = (TimeAveBox)entry.getValue();
                topo = (Topology)key[0];
                rowID1 = (Integer)key[1];
                rStart = (float)rowID1 - this.init_state_height_ftr / 2.0f;
                rFinal = rStart + this.init_state_height_ftr;
                clicked_obj = SummaryState.containsPixel(avebox, coord_xform, pix_pt, rStart, rFinal, avebox_hgt);
            }
            if (clicked_obj != null) {
                return new Summarizable(clicked_obj, topo, rowID1, rowID1);
            }
        }
        return null;
    }
}

