/*
 * Decompiled with CFR 0.152.
 */
package viewer.legends;

import base.drawable.ColorAlpha;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import viewer.legends.CategoryIcon;

public class CategoryIconEditor
extends DefaultCellEditor
implements TableCellEditor,
ActionListener {
    private JButton delegate_btn = new JButton();
    private ColorAlpha saved_color;
    private Color prev_color;

    public CategoryIconEditor() {
        super(new JCheckBox());
        this.delegate_btn.addActionListener(this);
        this.editorComponent = this.delegate_btn;
        super.setClickCountToStart(1);
        this.saved_color = null;
        this.prev_color = null;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int irow, int icolumn) {
        CategoryIcon icon = (CategoryIcon)value;
        this.prev_color = icon.getDisplayedColor();
        this.delegate_btn.setIcon(icon);
        return this.delegate_btn;
    }

    public void actionPerformed(ActionEvent evt) {
        Color new_color = JColorChooser.showDialog(this.delegate_btn, "Pick a Color", this.prev_color);
        this.saved_color = new_color != null ? new ColorAlpha(new_color, 255) : new ColorAlpha(this.prev_color, 255);
        this.fireEditingStopped();
    }

    public Object getCellEditorValue() {
        return this.saved_color;
    }
}

