/*
 * Decompiled with CFR 0.152.
 */
package viewer.legends;

import base.drawable.Category;
import java.util.Comparator;
import viewer.common.Parameters;

public class LegendComparators {
    public static final Comparator INDEX_ORDER = new IndexOrder();
    private static final Comparator PREVIEW_ORDER = new PreviewOrder();
    private static final Comparator TOPOLOGY_ORDER = new TopologyOrder();
    public static final Comparator CASE_SENSITIVE_ORDER = new CaseSensitiveOrder();
    public static final Comparator CASE_INSENSITIVE_ORDER = new CaseInsensitiveOrder();

    public static class CaseInsensitiveOrder
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Category type1 = (Category)o1;
            Category type2 = (Category)o2;
            int diff = 0;
            if (Parameters.LEGEND_TOPOLOGY_ORDER && (diff = TOPOLOGY_ORDER.compare(type1, type2)) != 0) {
                return diff;
            }
            if (Parameters.LEGEND_PREVIEW_ORDER && (diff = PREVIEW_ORDER.compare(type1, type2)) != 0) {
                return diff;
            }
            return type1.getName().compareToIgnoreCase(type2.getName());
        }
    }

    public static class CaseSensitiveOrder
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Category type1 = (Category)o1;
            Category type2 = (Category)o2;
            int diff = 0;
            if (Parameters.LEGEND_TOPOLOGY_ORDER && (diff = TOPOLOGY_ORDER.compare(type1, type2)) != 0) {
                return diff;
            }
            if (Parameters.LEGEND_PREVIEW_ORDER && (diff = PREVIEW_ORDER.compare(type1, type2)) != 0) {
                return diff;
            }
            return type1.getName().compareTo(type2.getName());
        }
    }

    public static class TopologyOrder
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Category type1 = (Category)o1;
            Category type2 = (Category)o2;
            return type2.getTopology().hashCode() - type1.getTopology().hashCode();
        }
    }

    public static class PreviewOrder
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Category type1 = (Category)o1;
            Category type2 = (Category)o2;
            int pview1 = type1.getIndex() < 0 ? 0 : 1;
            int pview2 = type2.getIndex() < 0 ? 0 : 1;
            return pview1 - pview2;
        }
    }

    public static class IndexOrder
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Category type1 = (Category)o1;
            Category type2 = (Category)o2;
            return type1.getIndex() - type2.getIndex();
        }
    }
}

