/*
 * Decompiled with CFR 0.152.
 */
package viewer.legends;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import logformat.slog2.CategoryMap;
import viewer.legends.CategoryIconEditor;
import viewer.legends.CategoryIconRenderer;
import viewer.legends.Const;
import viewer.legends.GenericHeaderRenderer;
import viewer.legends.LegendTableModel;
import viewer.legends.OperationBooleanMenu;
import viewer.legends.OperationStringMenu;
import viewer.legends.TableColumnHandler;
import viewer.legends.TableHeaderHandler;

public class LegendTable
extends JTable {
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static final Color CELL_BACKCOLOR = Const.CELL_BACKCOLOR;
    private static final Color CELL_FORECOLOR = Const.CELL_FORECOLOR;
    private static final Color CELL_BACKCOLOR_SELECTED = Const.CELL_BACKCOLOR_SELECTED;
    private static final Color CELL_FORECOLOR_SELECTED = Const.CELL_FORECOLOR_SELECTED;
    private LegendTableModel table_model;
    private TableColumnModel column_model;
    private JTableHeader table_header;
    static /* synthetic */ Class class$viewer$legends$CategoryIcon;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    public LegendTable(CategoryMap map) {
        this.table_model = new LegendTableModel(map);
        super.setModel(this.table_model);
        super.setDefaultRenderer(class$viewer$legends$CategoryIcon == null ? (class$viewer$legends$CategoryIcon = LegendTable.class$("viewer.legends.CategoryIcon")) : class$viewer$legends$CategoryIcon, new CategoryIconRenderer());
        super.setDefaultEditor(class$viewer$legends$CategoryIcon == null ? (class$viewer$legends$CategoryIcon = LegendTable.class$("viewer.legends.CategoryIcon")) : class$viewer$legends$CategoryIcon, new CategoryIconEditor());
        super.setAutoResizeMode(0);
        super.setIntercellSpacing(new Dimension(2, 2));
        super.setShowHorizontalLines(false);
        super.setShowVerticalLines(true);
        this.column_model = super.getColumnModel();
        this.table_header = this.getTableHeader();
        this.setColumnHeaderRenderers();
        this.initColumnSize();
    }

    private void setColumnHeaderRenderers() {
        int column_count = this.table_model.getColumnCount();
        for (int icol = 0; icol < column_count; ++icol) {
            MouseAdapter handler;
            JPopupMenu pop_menu;
            TableColumn column = this.column_model.getColumn(icol);
            TableCellRenderer renderer = column.getHeaderRenderer();
            Class class_type = this.table_model.getColumnClass(icol);
            if (class_type == (class$java$lang$Boolean == null ? LegendTable.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                renderer = new GenericHeaderRenderer(this, icol);
                ((GenericHeaderRenderer)renderer).initPressablePullDownTab();
                column.setHeaderRenderer(renderer);
                pop_menu = new OperationBooleanMenu(this, icol);
                handler = new TableHeaderHandler(this, icol, pop_menu);
                this.table_header.addMouseListener(handler);
                handler = new TableColumnHandler(this, icol, pop_menu);
                this.addMouseListener(handler);
            }
            if (class_type == (class$java$lang$String == null ? LegendTable.class$("java.lang.String") : class$java$lang$String)) {
                renderer = new GenericHeaderRenderer(this, icol);
                ((GenericHeaderRenderer)renderer).initPressablePullDownTab();
                column.setHeaderRenderer(renderer);
                pop_menu = new OperationStringMenu(this, icol);
                handler = new TableHeaderHandler(this, icol, pop_menu);
                this.table_header.addMouseListener(handler);
                handler = new TableColumnHandler(this, icol, pop_menu);
                this.addMouseListener(handler);
                continue;
            }
            if (renderer == null) {
                renderer = new GenericHeaderRenderer(this, icol);
                column.setHeaderRenderer(renderer);
                continue;
            }
            ((JComponent)((Object)renderer)).setToolTipText(this.table_model.getColumnToolTip(icol));
        }
    }

    private void initColumnSize() {
        int vport_width = 0;
        int vport_height = 0;
        int row_height = 0;
        Dimension intercell_gap = super.getIntercellSpacing();
        int column_count = this.table_model.getColumnCount();
        for (int icol = 0; icol < column_count; ++icol) {
            TableColumn column = this.column_model.getColumn(icol);
            TableCellRenderer renderer = column.getHeaderRenderer();
            Component component = renderer.getTableCellRendererComponent(this, column.getHeaderValue(), false, false, -1, icol);
            Dimension header_size = component.getPreferredSize();
            Insets header_insets = ((JComponent)component).getInsets();
            int header_width = header_size.width + intercell_gap.width + header_insets.left + header_insets.right;
            renderer = column.getCellRenderer();
            if (renderer == null) {
                renderer = super.getDefaultRenderer(this.table_model.getColumnClass(icol));
            }
            component = renderer.getTableCellRendererComponent(this, this.table_model.getColumnTypicalValue(icol), false, false, 0, icol);
            Dimension cell_size = component.getPreferredSize();
            Insets cell_insets = component instanceof CategoryIconRenderer ? ((JComponent)component).getInsets() : EMPTY_INSETS;
            int cell_width = cell_size.width + cell_insets.left + cell_insets.right;
            if (cell_width > header_width) {
                column.setPreferredWidth(cell_width);
                vport_width += cell_width;
            } else {
                column.setPreferredWidth(header_width);
                vport_width += header_width;
            }
            int cell_height = cell_size.height + cell_insets.top + cell_insets.bottom;
            if (cell_height <= row_height) continue;
            row_height = cell_height;
        }
        super.setRowHeight(row_height);
        int row_count = this.table_model.getRowCount();
        vport_height = row_count > 25 ? row_height * 25 : row_height * row_count;
        super.setPreferredScrollableViewportSize(new Dimension(vport_width, vport_height));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

