/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import viewer.common.Dialogs;

public class InfoDialog
extends JDialog {
    private JPanel btn_panel;
    private JButton close_btn;
    private double clicked_time;

    public InfoDialog(Frame ancestor_frame, String title_str, double time) {
        super(ancestor_frame, title_str);
        this.clicked_time = time;
        this.init();
    }

    public InfoDialog(Dialog ancestor_dialog, String title_str, double time) {
        super(ancestor_dialog, title_str);
        this.clicked_time = time;
        this.init();
    }

    private void init() {
        super.setDefaultCloseOperation(0);
        this.btn_panel = new JPanel();
        this.close_btn = new JButton("close");
        this.close_btn.setAlignmentX(0.5f);
        this.btn_panel.add(this.close_btn);
        this.btn_panel.setAlignmentX(0.0f);
        Dimension panel_max_size = this.btn_panel.getPreferredSize();
        panel_max_size.width = Short.MAX_VALUE;
        this.btn_panel.setMaximumSize(panel_max_size);
    }

    public JButton getCloseButton() {
        return this.close_btn;
    }

    public JPanel getCloseButtonPanel() {
        return this.btn_panel;
    }

    public double getClickedTime() {
        return this.clicked_time;
    }

    public void setVisibleAtLocation(Point global_pt) {
        this.setLocation(global_pt);
        this.pack();
        this.setVisible(true);
        this.toFront();
    }

    private class InfoDialogWindowListener
    extends WindowAdapter {
        private InfoDialog info_popup;

        public InfoDialogWindowListener(InfoDialog info) {
            this.info_popup = info;
        }

        public void windowClosing(WindowEvent e) {
            Dialogs.info(this.info_popup, "Use the CLOSE button please!", null);
        }
    }
}

