/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import viewer.common.Dialogs;
import viewer.common.LabeledTextField;
import viewer.zoomable.Debug;
import viewer.zoomable.ModelTime;
import viewer.zoomable.TimeEvent;
import viewer.zoomable.TimeListener;
import viewer.zoomable.ViewportTime;

public class ModelTimePanel
extends JPanel
implements TimeListener {
    private ModelTime model = null;
    private LabeledTextField fld_iZoom_level;
    private LabeledTextField fld_tGlobal_min;
    private LabeledTextField fld_tGlobal_max;
    private LabeledTextField fld_tView_init;
    private LabeledTextField fld_tView_final;
    private LabeledTextField fld_tZoom_focus;
    private LabeledTextField fld_time_per_pixel;
    private List vport_list;

    public ModelTimePanel(ModelTime model) {
        this.model = model;
        this.setLayout(new BoxLayout(this, 0));
        this.vport_list = new ArrayList();
        this.fld_iZoom_level = new LabeledTextField("Zoom Level ", "#,##0");
        this.fld_iZoom_level.setEditable(false);
        this.fld_iZoom_level.setHorizontalAlignment(0);
        this.add(this.fld_iZoom_level);
        this.fld_tGlobal_min = new LabeledTextField("Global Min Time", "#,##0.00########");
        this.fld_tGlobal_min.setEditable(false);
        this.add(this.fld_tGlobal_min);
        this.fld_tView_init = new LabeledTextField("View  Init Time", "#,##0.00########");
        this.fld_tView_init.setEditable(true);
        this.add(this.fld_tView_init);
        this.fld_tZoom_focus = new LabeledTextField("Zoom Focus Time", "#,##0.00########");
        this.fld_tZoom_focus.setEditable(true);
        this.add(this.fld_tZoom_focus);
        this.fld_tView_final = new LabeledTextField("View Final Time", "#,##0.00########");
        this.fld_tView_final.setEditable(true);
        this.add(this.fld_tView_final);
        this.fld_tGlobal_max = new LabeledTextField("Global Max Time", "#,##0.00########");
        this.fld_tGlobal_max.setEditable(false);
        this.add(this.fld_tGlobal_max);
        this.fld_time_per_pixel = new LabeledTextField("Time Per Pixel", "#,##0.00########");
        this.fld_time_per_pixel.setEditable(true);
        this.add(this.fld_time_per_pixel);
        super.setBorder(BorderFactory.createEtchedBorder());
        TimeFocusActionListener time_focus_action = new TimeFocusActionListener(model, this.vport_list, this.fld_tZoom_focus);
        this.fld_tZoom_focus.addActionListener(time_focus_action);
        TimeBoundsActionListener time_bounds_action = new TimeBoundsActionListener(model, this.vport_list, this.fld_tView_init, this.fld_tView_final);
        this.fld_tView_init.addActionListener(time_bounds_action);
        this.fld_tView_final.addActionListener(time_bounds_action);
        TimePixelActionListener time_pixel_action = new TimePixelActionListener(model, this.vport_list, this.fld_time_per_pixel);
        this.fld_time_per_pixel.addActionListener(time_pixel_action);
    }

    public void addViewportTime(ViewportTime vport) {
        if (vport != null) {
            this.vport_list.add(vport);
        }
    }

    public void zoomLevelChanged() {
        this.fld_iZoom_level.setInteger(this.model.getZoomLevel());
    }

    public void timeChanged(TimeEvent evt) {
        if (Debug.isActive()) {
            Debug.println("ModelTimePanel: timeChanged()'s START: ");
        }
        this.fld_tGlobal_min.setDouble(this.model.getTimeGlobalMinimum());
        this.fld_tView_init.setDouble(this.model.getTimeViewPosition());
        this.fld_tZoom_focus.setDouble(this.model.getTimeZoomFocus());
        this.fld_tView_final.setDouble(this.model.getTimeViewPosition() + this.model.getTimeViewExtent());
        this.fld_tGlobal_max.setDouble(this.model.getTimeGlobalMaximum());
        this.fld_time_per_pixel.setDouble(1.0 / this.model.getViewPixelsPerUnitTime());
        if (Debug.isActive()) {
            Debug.println("ModelTimePanel: timeChanged()'s END: ");
        }
    }

    private class TimePixelActionListener
    implements ActionListener {
        private ModelTime time_model = null;
        private List vport_list = null;
        private LabeledTextField fld_time_pixel = null;

        public TimePixelActionListener(ModelTime model, List vports, LabeledTextField field_time_pixel) {
            this.time_model = model;
            this.vport_list = vports;
            this.fld_time_pixel = field_time_pixel;
        }

        public void actionPerformed(ActionEvent evt) {
            if (this.fld_time_pixel.getDouble() <= 0.0) {
                Window win = SwingUtilities.windowForComponent(ModelTimePanel.this);
                Dialogs.error(win, "Time Per Pixel is less than or equal to 0.0!\nRestore the old value.");
                this.fld_time_pixel.setDouble(1.0 / this.time_model.getViewPixelsPerUnitTime());
                return;
            }
            double tView_extent = this.time_model.computeTimeViewExtent(this.fld_time_pixel.getDouble());
            double tView_focus = this.time_model.getTimeZoomFocus();
            double tView_init = tView_focus - tView_extent / 2.0;
            this.time_model.zoomRapidly(tView_init, tView_extent);
            for (int idx = this.vport_list.size() - 1; idx >= 0; --idx) {
                ViewportTime vport = (ViewportTime)this.vport_list.get(idx);
                vport.repaint();
                vport.resetToolBarZoomButtons();
            }
        }
    }

    private class TimeBoundsActionListener
    implements ActionListener {
        private ModelTime time_model = null;
        private List vport_list = null;
        private LabeledTextField fld_tView_init = null;
        private LabeledTextField fld_tView_final = null;

        public TimeBoundsActionListener(ModelTime model, List vports, LabeledTextField field_tView_init, LabeledTextField field_tView_final) {
            this.time_model = model;
            this.vport_list = vports;
            this.fld_tView_init = field_tView_init;
            this.fld_tView_final = field_tView_final;
        }

        public void actionPerformed(ActionEvent evt) {
            double tView_final;
            Window win;
            boolean isOK = true;
            double tView_init = this.fld_tView_init.getDouble();
            if (tView_init < this.time_model.getTimeGlobalMinimum() || tView_init > this.time_model.getTimeGlobalMaximum()) {
                win = SwingUtilities.windowForComponent(ModelTimePanel.this);
                Dialogs.error(win, "View Init Time is out of the range of the\nGlobal Min/Max Times! Restore the old value.");
                this.fld_tView_init.setDouble(this.time_model.getTimeViewPosition());
                isOK = false;
            }
            if ((tView_final = this.fld_tView_final.getDouble()) < this.time_model.getTimeGlobalMinimum() || tView_final > this.time_model.getTimeGlobalMaximum()) {
                win = SwingUtilities.windowForComponent(ModelTimePanel.this);
                Dialogs.error(win, "View Final Time is out of the range of the\nGlobal Min/Max Times! Restore the old value.");
                this.fld_tView_final.setDouble(this.time_model.getTimeViewPosition() + this.time_model.getTimeViewExtent());
                isOK = false;
            }
            if (tView_init >= tView_final) {
                win = SwingUtilities.windowForComponent(ModelTimePanel.this);
                Dialogs.error(win, "View Init Time is later or equal to\nView Final Time!  Restore the old value.");
                this.fld_tView_init.setDouble(this.time_model.getTimeViewPosition());
                this.fld_tView_final.setDouble(this.time_model.getTimeViewPosition() + this.time_model.getTimeViewExtent());
                isOK = false;
            }
            if (!isOK) {
                return;
            }
            double tView_extent = tView_final - tView_init;
            this.time_model.zoomRapidly(tView_init, tView_extent);
            double tView_focus = (tView_init + tView_final) / 2.0;
            this.time_model.setTimeZoomFocus(tView_focus);
            for (int idx = this.vport_list.size() - 1; idx >= 0; --idx) {
                ViewportTime vport = (ViewportTime)this.vport_list.get(idx);
                vport.repaint();
                vport.resetToolBarZoomButtons();
            }
        }
    }

    private class TimeFocusActionListener
    implements ActionListener {
        private ModelTime time_model = null;
        private List vport_list = null;
        private LabeledTextField fld_tZoom_focus = null;

        public TimeFocusActionListener(ModelTime model, List vports, LabeledTextField field_tZoom_focus) {
            this.time_model = model;
            this.vport_list = vports;
            this.fld_tZoom_focus = field_tZoom_focus;
        }

        public void actionPerformed(ActionEvent evt) {
            double tView_focus = this.fld_tZoom_focus.getDouble();
            if (tView_focus < this.time_model.getTimeGlobalMinimum() || tView_focus > this.time_model.getTimeGlobalMaximum()) {
                Window win = SwingUtilities.windowForComponent(ModelTimePanel.this);
                Dialogs.error(win, "Zoom Focus Time is out of the range of the\nGlobal Min/Max Times! Restore the old value.");
                this.fld_tZoom_focus.setDouble(this.time_model.getTimeZoomFocus());
                return;
            }
            this.time_model.setTimeZoomFocus(tView_focus);
            for (int idx = this.vport_list.size() - 1; idx >= 0; --idx) {
                ViewportTime vport = (ViewportTime)this.vport_list.get(idx);
                vport.repaint();
            }
        }
    }
}

