/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import base.drawable.TimeBoundingBox;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import viewer.zoomable.CoordPixelImage;
import viewer.zoomable.Debug;
import viewer.zoomable.InfoDialog;
import viewer.zoomable.InfoDialogForTime;
import viewer.zoomable.ModelTime;
import viewer.zoomable.ScrollableView;

public abstract class ScrollableObject
extends JComponent
implements ScrollableView {
    private static final int NumImages = 3;
    protected static final int NumViewsPerImage = 2;
    protected static final int NumViewsTotal = 6;
    private ModelTime model = null;
    private JViewport src_vport;
    private Image[] offscreenImages;
    private TimeBoundingBox[] tImages;
    private double tImage_extent;
    private TimeBoundingBox tImages_all;
    private int half_NumImages;
    private int cur_img_idx;
    private Dimension visible_size;
    private Dimension image_size;
    private Dimension component_size;

    public ScrollableObject(ModelTime model) {
        this.model = model;
        this.offscreenImages = new Image[3];
        this.tImages = new TimeBoundingBox[3];
        for (int idx = 0; idx < 3; ++idx) {
            this.tImages[idx] = new TimeBoundingBox();
        }
        this.tImages_all = new TimeBoundingBox();
        super.setDoubleBuffered(false);
        this.half_NumImages = 1;
        this.setImagesInitTimeBounds();
        this.image_size = new Dimension(0, 0);
        this.component_size = super.getSize();
        this.setDebugGraphicsOptions(7);
    }

    private void setImagesInitTimeBounds() {
        double model_view_extent = this.model.getTimeViewExtent();
        this.tImage_extent = 2.0 * model_view_extent;
        this.tImages_all.reinitialize();
        int img_idx = 0;
        this.tImages[img_idx].setEarliestTime(this.model.getTimeViewPosition() - 0.5 * model_view_extent * 5.0);
        this.tImages[img_idx].setLatestFromEarliest(this.tImage_extent);
        this.tImages_all.affectTimeBounds(this.tImages[img_idx]);
        for (img_idx = 1; img_idx < 3; ++img_idx) {
            this.tImages[img_idx].setEarliestTime(this.tImages[img_idx - 1].getLatestTime());
            this.tImages[img_idx].setLatestFromEarliest(this.tImage_extent);
            this.tImages_all.affectTimeBounds(this.tImages[img_idx]);
        }
        this.cur_img_idx = this.half_NumImages;
    }

    public String getStringforTimesOfImages() {
        StringBuffer rep = new StringBuffer();
        for (int img_idx = 0; img_idx < 3; ++img_idx) {
            rep.append("tImages[ " + img_idx + " ] = " + this.tImages[img_idx] + "\n");
        }
        return rep.toString();
    }

    public TimeBoundingBox getTimeBoundsOfImages() {
        return new TimeBoundingBox(this.tImages_all);
    }

    private int getValidImageIndex(int img_idx) {
        int adj_img_idx = img_idx % 3;
        if (adj_img_idx < 0) {
            return adj_img_idx + 3;
        }
        return adj_img_idx;
    }

    private int getNearPastImageIndex(int img_idx) {
        if (img_idx == 0) {
            return 2;
        }
        return img_idx - 1;
    }

    private int getNearFutureImageIndex(int img_idx) {
        if (img_idx == 2) {
            return 0;
        }
        return img_idx + 1;
    }

    private int getNearImageIndex(int img_idx, int dir) {
        if (dir < 0) {
            return this.getNearPastImageIndex(img_idx);
        }
        return this.getNearFutureImageIndex(img_idx);
    }

    private Image createImage(Dimension image_sz) {
        if (Debug.isActive()) {
            Debug.println("ScrollableObject: createImage()'s image_sz = " + image_sz);
        }
        if (image_sz.width > 0 && image_sz.height > 0) {
            return super.createImage(image_sz.width, image_sz.height);
        }
        return null;
    }

    private int getNumImagesMoved() {
        double cur_tView_init = this.model.getTimeViewPosition();
        double cur_tView_extent = this.model.getTimeViewExtent();
        double cur_tView_final = cur_tView_init + cur_tView_extent;
        if (Debug.isActive()) {
            Debug.println("ScrollableObject: getNumImagesMoved()'s START: ");
            Debug.println("cur_tView_init  = " + cur_tView_init + ",  " + "cur_tView_final = " + cur_tView_final);
            Debug.println("tImages[ cur ] = " + this.tImages[this.cur_img_idx]);
        }
        double tImages_init = this.tImages_all.getEarliestTime();
        if (Debug.isActive()) {
            Debug.println("ScrollableObject: getNumImagesMoved() tImages_init = " + tImages_init);
        }
        double view_init_in_imgs = (cur_tView_init - tImages_init) / this.tImage_extent;
        int Nimages_moved_fwd = (int)Math.floor(view_init_in_imgs) - this.half_NumImages;
        double view_final_in_imgs = (cur_tView_final - tImages_init) / this.tImage_extent;
        int Nimages_moved_back = (int)Math.floor(view_final_in_imgs) - this.half_NumImages;
        int Nimages_moved = 0;
        if (Nimages_moved_fwd > 0) {
            Nimages_moved = Nimages_moved_fwd;
        }
        if (Nimages_moved_back < 0) {
            Nimages_moved = Nimages_moved_back;
        }
        if (Debug.isActive()) {
            Debug.println("ScrollableObject: getNumImagesMoved() Nmages_moved = " + Nimages_moved);
            Debug.println("ScrollableObject: getNumImagesMoved()'s END: ");
        }
        return Nimages_moved;
    }

    public void checkToZoomView() {
        double cur_tView_extent;
        if (Debug.isActive()) {
            Debug.println("ScrollableObject: checkToZoomView()'s START: ");
        }
        if ((cur_tView_extent = this.model.getTimeViewExtent()) * 2.0 != this.tImage_extent) {
            this.setImagesInitTimeBounds();
            this.initializeAllOffImages(this.tImages_all);
            for (int img_idx = 0; img_idx < 3; ++img_idx) {
                this.drawOneOffImage(this.offscreenImages[img_idx], this.tImages[img_idx]);
            }
            this.finalizeAllOffImages(this.tImages_all);
        }
        if (Debug.isActive()) {
            Debug.println("ScrollableObject: checkToZoomView()'s END: ");
        }
    }

    public void checkToScrollView() {
        if (Debug.isActive()) {
            Debug.println("ScrollableObject: checkToScrollView()'s START: ");
        }
        int img_mv_dir = 0;
        int Nimages_moved = this.getNumImagesMoved();
        if (Nimages_moved != 0) {
            if (Math.abs(Nimages_moved) <= 3) {
                int img_idx;
                int idx;
                img_mv_dir = Nimages_moved / Math.abs(Nimages_moved);
                int start_idx = this.getValidImageIndex(this.cur_img_idx + img_mv_dir * this.half_NumImages);
                for (idx = 1; idx <= Math.abs(Nimages_moved); ++idx) {
                    img_idx = this.getValidImageIndex(start_idx + img_mv_dir * idx);
                    if (Debug.isActive()) {
                        Debug.println("ScrollableObject: checkToScrollView() cur_img_idx = " + this.cur_img_idx + ", " + "start_idx = " + start_idx + ", " + "img_idx = " + img_idx);
                    }
                    if (!this.tImages_all.remove(this.tImages[img_idx])) {
                        System.err.println("ScrollableObject: checkToScrollView() tImages[" + img_idx + "] = " + this.tImages[img_idx] + " does NOT " + "cover the end of tImages_all = " + this.tImages_all);
                    }
                    if (img_mv_dir > 0) {
                        int past_img_idx = this.getNearPastImageIndex(img_idx);
                        this.tImages[img_idx].setEarliestTime(this.tImages[past_img_idx].getLatestTime());
                        this.tImages[img_idx].setLatestFromEarliest(this.tImage_extent);
                    } else {
                        int future_img_idx = this.getNearFutureImageIndex(img_idx);
                        this.tImages[img_idx].setLatestTime(this.tImages[future_img_idx].getEarliestTime());
                        this.tImages[img_idx].setEarliestFromLatest(this.tImage_extent);
                    }
                    this.tImages_all.affectTimeBounds(this.tImages[img_idx]);
                }
                this.initializeAllOffImages(this.tImages_all);
                if (img_mv_dir > 0) {
                    for (idx = Math.abs(Nimages_moved); idx >= 1; --idx) {
                        img_idx = this.getValidImageIndex(start_idx + img_mv_dir * idx);
                        if (this.offscreenImages[img_idx] == null) continue;
                        this.drawOneOffImage(this.offscreenImages[img_idx], this.tImages[img_idx]);
                    }
                } else {
                    for (idx = 1; idx <= Math.abs(Nimages_moved); ++idx) {
                        img_idx = this.getValidImageIndex(start_idx + img_mv_dir * idx);
                        if (this.offscreenImages[img_idx] == null) continue;
                        this.drawOneOffImage(this.offscreenImages[img_idx], this.tImages[img_idx]);
                    }
                }
                this.finalizeAllOffImages(this.tImages_all);
                this.cur_img_idx = this.getValidImageIndex(this.cur_img_idx + Nimages_moved);
            } else {
                if (Debug.isActive()) {
                    Debug.println("****************************************");
                    Debug.println("ScrollableObject: checkToScrollView() | Nimages_moved( " + Nimages_moved + " ) | >= NumImages( " + 3 + " )");
                }
                this.setImagesInitTimeBounds();
                this.initializeAllOffImages(this.tImages_all);
                for (int img_idx = 0; img_idx < 3; ++img_idx) {
                    this.drawOneOffImage(this.offscreenImages[img_idx], this.tImages[img_idx]);
                }
                this.finalizeAllOffImages(this.tImages_all);
            }
        }
        if (Debug.isActive()) {
            Debug.println("ScrollableObject: checkToScrollView()'s END: ");
        }
    }

    protected int time2pixel(double time_coord) {
        return (int)Math.round((time_coord - this.tImages_all.getEarliestTime()) * this.model.getViewPixelsPerUnitTime());
    }

    protected double pixel2time(int pixel_coord) {
        return (double)pixel_coord / this.model.getViewPixelsPerUnitTime() + this.tImages_all.getEarliestTime();
    }

    public int getXaxisViewPosition() {
        if (Debug.isActive()) {
            Debug.println("ScrollableObject: getViewPosition() : model.getTimeViewPosition()=" + this.model.getTimeViewPosition());
        }
        return this.time2pixel(this.model.getTimeViewPosition());
    }

    protected abstract void initializeAllOffImages(TimeBoundingBox var1);

    protected abstract void drawOneOffImage(Image var1, TimeBoundingBox var2);

    protected abstract void finalizeAllOffImages(TimeBoundingBox var1);

    public void paintComponent(Graphics g) {
        int vport_mv_dir;
        if (Debug.isActive()) {
            Debug.println("ScrollableObject : paintComponent()'s START : ");
            Debug.println("ScrollableObject : paintComponent() g.getClipBounds() = " + g.getClipBounds());
            Debug.println("ScrollableObject : paintComponent() this = " + this);
            if (this.src_vport != null) {
                Debug.println("ScrollableObject: paintComponent() src_vport.getViewPosition() = " + this.src_vport.getViewPosition());
            }
        }
        vport_mv_dir = (vport_mv_dir = this.model.getViewportMovingDir()) < 0 ? -1 : 1;
        int img_width = this.image_size.width;
        int img_idx = this.cur_img_idx;
        int screen_img_pos = this.half_NumImages * img_width;
        if (this.offscreenImages[img_idx] != null) {
            g.drawImage(this.offscreenImages[img_idx], screen_img_pos, 0, this);
        }
        for (int side_idx = 1; side_idx <= this.half_NumImages; ++side_idx) {
            for (int side_bit = 1; side_bit >= -1; side_bit -= 2) {
                int side_offset = side_bit * vport_mv_dir * side_idx;
                img_idx = this.getValidImageIndex(this.cur_img_idx + side_offset);
                if (Debug.isActive()) {
                    Debug.println("ScrollableObject: paintComponent() side_offset = " + side_offset + ",  " + "img_idx = " + img_idx);
                }
                screen_img_pos = (this.half_NumImages + side_offset) * img_width;
                if (this.offscreenImages[img_idx] == null) continue;
                g.drawImage(this.offscreenImages[img_idx], screen_img_pos, 0, this);
            }
        }
        if (Debug.isActive()) {
            Debug.println("ScrollableObject : paintComponent()'s END : ");
        }
    }

    public abstract int getJComponentHeight();

    public void componentResized(JViewport viewport) {
        int img_idx;
        if (Debug.isActive()) {
            Debug.println("ScrollableObject: componentResized()'s START: ");
            Debug.println("incoming viewport = " + viewport);
        }
        this.src_vport = viewport;
        if (this.src_vport != null) {
            this.visible_size = this.src_vport.getExtentSize();
            if (Debug.isActive()) {
                Debug.println("ScrollableObject: componentResized()'s src_vport.getViewPosition() = " + this.src_vport.getViewPosition());
            }
        } else {
            this.visible_size = this.getVisibleRect().getSize();
        }
        this.image_size.setSize(this.visible_size.width * 2, this.getJComponentHeight());
        int NumOKImages = 0;
        for (img_idx = 0; img_idx < 3; ++img_idx) {
            this.offscreenImages[img_idx] = this.createImage(this.image_size);
            if (this.offscreenImages[img_idx] == null) continue;
            ++NumOKImages;
        }
        if (NumOKImages == 3 && this.visible_size.width > 0) {
            this.model.setViewPixelsPerUnitTime(this.visible_size.width);
            this.model.updatePixelCoords();
        }
        this.component_size.setSize(this.image_size.width * 3, this.image_size.height);
        this.setSize(this.component_size);
        img_idx = this.getValidImageIndex(this.cur_img_idx + this.half_NumImages + 1);
        this.initializeAllOffImages(this.tImages_all);
        for (int idx = 0; idx < 3; ++idx) {
            this.drawOneOffImage(this.offscreenImages[img_idx], this.tImages[img_idx]);
            img_idx = this.getNearFutureImageIndex(img_idx);
        }
        this.finalizeAllOffImages(this.tImages_all);
        if (Debug.isActive()) {
            Debug.println("ScrollableObject: componentResized()'s END: ");
        }
    }

    public Dimension getPreferredSize() {
        if (Debug.isActive()) {
            Debug.println("ScrollableObject: pref_size = " + this.component_size);
        }
        return this.component_size;
    }

    public Dimension getSize() {
        if (Debug.isActive()) {
            Debug.println("ScrollableObject: size = " + this.component_size);
        }
        return this.component_size;
    }

    public void setCursor(Cursor new_cursor) {
    }

    public abstract InfoDialog getPropertyAt(Point var1, TimeBoundingBox var2);

    protected InfoDialog getTimePropertyAt(Point local_click) {
        CoordPixelImage coord_xform = new CoordPixelImage(this, 0, this.getTimeBoundsOfImages());
        Window window = SwingUtilities.windowForComponent(this);
        if (window instanceof Frame) {
            return new InfoDialogForTime((Frame)window, coord_xform.convertPixelToTime(local_click.x));
        }
        return new InfoDialogForTime((Dialog)window, coord_xform.convertPixelToTime(local_click.x));
    }
}

