/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.drawable.InfoType;
import base.io.MixedDataIO;
import base.io.MixedDataInput;
import base.io.MixedDataOutput;
import java.io.IOException;

public class InfoValue
implements MixedDataIO {
    private InfoType type;
    private Object value;

    public InfoValue() {
        this.type = null;
        this.value = null;
    }

    public InfoValue(InfoType in_type) {
        this.type = in_type;
        this.value = null;
    }

    public InfoValue(InfoType in_type, Object in_value) {
        this.type = in_type;
        this.value = in_value;
    }

    public InfoType getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object in_value) throws ClassCastException {
        if (this.type == null || in_value == null) {
            this.value = in_value;
            return;
        }
        if (!InfoValue.isValueConsistentWithType(this.type, in_value)) {
            throw new ClassCastException("Unmatched InfoType " + this.type + " for the value " + in_value);
        }
        this.value = in_value;
    }

    private static boolean isValueConsistentWithType(InfoType aType, Object aValue) {
        if (aType == null || aValue == null) {
            return true;
        }
        if (aType.equals(InfoType.STR)) {
            return aValue instanceof String;
        }
        if (aType.equals(InfoType.INT2)) {
            return aValue instanceof Short;
        }
        if (aType.equals(InfoType.INT4) || aType.equals(InfoType.BYTE4)) {
            return aValue instanceof Integer;
        }
        if (aType.equals(InfoType.INT8) || aType.equals(InfoType.BYTE8)) {
            return aValue instanceof Long;
        }
        if (aType.equals(InfoType.FLT4)) {
            return aValue instanceof Float;
        }
        if (aType.equals(InfoType.FLT8)) {
            return aValue instanceof Double;
        }
        return false;
    }

    public int getByteSize() {
        if (this.value != null) {
            if (this.value instanceof String) {
                return 3 + ((String)this.value).length();
            }
            if (this.value instanceof Short) {
                return 3;
            }
            if (this.value instanceof Integer) {
                return 5;
            }
            if (this.value instanceof Long) {
                return 9;
            }
            if (this.value instanceof Float) {
                return 5;
            }
            if (this.value instanceof Double) {
                return 9;
            }
        }
        return 0;
    }

    public void writeValue(MixedDataOutput outs) throws IOException {
        if (this.type.equals(InfoType.STR)) {
            outs.writeString((String)this.value);
        } else if (this.type.equals(InfoType.INT8) || this.type.equals(InfoType.BYTE8)) {
            outs.writeLong((Long)this.value);
        } else if (this.type.equals(InfoType.INT4) || this.type.equals(InfoType.BYTE4)) {
            outs.writeInt((Integer)this.value);
        } else if (this.type.equals(InfoType.INT2)) {
            outs.writeShort(((Short)this.value).shortValue());
        } else if (this.type.equals(InfoType.FLT4)) {
            outs.writeFloat(((Float)this.value).floatValue());
        } else if (this.type.equals(InfoType.FLT8)) {
            outs.writeDouble((Double)this.value);
        } else {
            throw new IOException("Unknown InfoType = " + this.type);
        }
    }

    public void readValue(MixedDataInput ins) throws IOException {
        if (this.type.equals(InfoType.STR)) {
            this.value = ins.readString();
        } else if (this.type.equals(InfoType.INT8) || this.type.equals(InfoType.BYTE8)) {
            this.value = new Long(ins.readLong());
        } else if (this.type.equals(InfoType.INT4) || this.type.equals(InfoType.BYTE4)) {
            this.value = new Integer(ins.readInt());
        } else if (this.type.equals(InfoType.INT2)) {
            this.value = new Short(ins.readShort());
        } else if (this.type.equals(InfoType.FLT4)) {
            this.value = new Float(ins.readFloat());
        } else if (this.type.equals(InfoType.FLT8)) {
            this.value = new Double(ins.readDouble());
        } else {
            throw new IOException("Unknown InfoType = " + this.type);
        }
    }

    public void writeObject(MixedDataOutput outs) throws IOException {
        this.type.writeObject(outs);
        this.writeValue(outs);
    }

    public InfoValue(MixedDataInput ins) throws IOException {
        this();
        this.readObject(ins);
    }

    public void readObject(MixedDataInput ins) throws IOException {
        this.type = new InfoType(ins);
        this.readValue(ins);
    }

    public String toString() {
        if (this.type.equals(InfoType.STR)) {
            return (String)this.value;
        }
        if (this.type.equals(InfoType.BYTE4)) {
            return Integer.toHexString((Integer)this.value);
        }
        if (this.type.equals(InfoType.BYTE8)) {
            return Long.toHexString((Long)this.value);
        }
        return this.value.toString();
    }
}

