/*
 * Decompiled with CFR 0.152.
 */
package base.topology;

import base.drawable.CoordPixelXform;
import base.drawable.TimeBoundingBox;
import base.statistics.CategoryTimeBox;
import base.statistics.TimeAveBox;
import base.topology.StateBorder;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Arrays;

public class SummaryState {
    private static StateBorder BorderStyle = StateBorder.WHITE_RAISED_BORDER;
    private static StateBorder BackBorder = StateBorder.COLOR_XOR_BORDER;
    private static Color BackColor = Color.black;
    public static Color ForeColor = Color.white;
    public static final String FIT_MOST_LEGENDS = "FitMostLegends";
    private static final int FIT_MOST_LEGENDS_ID = 0;
    public static final String OVERLAP_INCLUSION = "OverlapInclusionRatio";
    private static final int OVERLAP_INCLUSION_ID = 1;
    public static final String OVERLAP_EXCLUSION = "OverlapExclusionRatio";
    private static final int OVERLAP_EXCLUSION_ID = 3;
    public static final String CUMULATIVE_EXCLUSION = "CumulativeExclusionRatio";
    private static final int CUMULATIVE_EXCLUSION_ID = 4;
    private static int DisplayType = 1;
    private static int MinCategoryHeight = 2;
    private static int MinCategorySeparation = 4;

    public static void setBorderStyle(StateBorder state_border) {
        BorderStyle = state_border;
    }

    public static void setBackgroundColor(Color color) {
        BackColor = color;
        ForeColor = BackColor == Color.black ? Color.lightGray : (BackColor == Color.white ? Color.darkGray : (BackColor == Color.darkGray ? Color.white : (BackColor == Color.lightGray ? Color.darkGray : Color.white)));
    }

    public static void setDisplayType(String new_display_type) {
        DisplayType = new_display_type.equals(FIT_MOST_LEGENDS) ? 0 : (new_display_type.equals(OVERLAP_INCLUSION) ? 1 : (new_display_type.equals(OVERLAP_EXCLUSION) ? 3 : (new_display_type.equals(CUMULATIVE_EXCLUSION) ? 4 : 1)));
    }

    public static boolean isDisplayTypeEqualWeighted() {
        return DisplayType == 0;
    }

    public static boolean isDisplayTypeExclusiveRatio() {
        return DisplayType == 3 || DisplayType == 4;
    }

    public static boolean isDisplayTypeCumulative() {
        return DisplayType == 4;
    }

    public static void setMinCategoryHeight(int new_min_category_height) {
        MinCategoryHeight = new_min_category_height;
    }

    private static int drawForward(Graphics2D g, Color color, CoordPixelXform coord_xform, double start_time, float start_ypos, double final_time, float final_ypos) {
        int iStart = coord_xform.convertTimeToPixel(start_time);
        int iFinal = coord_xform.convertTimeToPixel(final_time);
        int jStart = coord_xform.convertRowToPixel(start_ypos);
        int jFinal = coord_xform.convertRowToPixel(final_ypos);
        boolean isStartVtxInImg = iStart >= 0;
        boolean isFinalVtxInImg = iFinal < coord_xform.getImageWidth();
        int iHead = isStartVtxInImg ? iStart : 0;
        int jHead = jStart;
        int iTail = isFinalVtxInImg ? iFinal : coord_xform.getImageWidth() - 1;
        int jTail = jFinal;
        if (color == null) {
            color = ForeColor;
        }
        g.setColor(color);
        g.fillRect(iHead, jHead, iTail - iHead + 1, jTail - jHead + 1);
        BorderStyle.paintStateBorder(g, color, iHead, jHead, isStartVtxInImg, iTail, jTail, isFinalVtxInImg);
        return 1;
    }

    private static boolean isPixelIn(CoordPixelXform coord_xform, Point pt, double start_time, float start_ypos, double final_time, float final_ypos) {
        int pt_y = pt.y;
        int jStart = coord_xform.convertRowToPixel(start_ypos);
        if (pt_y < jStart) {
            return false;
        }
        int jFinal = coord_xform.convertRowToPixel(final_ypos);
        if (pt_y > jFinal) {
            return false;
        }
        int pt_x = pt.x;
        int iStart = coord_xform.convertTimeToPixel(start_time);
        if (pt_x < iStart) {
            return false;
        }
        int iFinal = coord_xform.convertTimeToPixel(final_time);
        return pt_x <= iFinal;
    }

    public static void setTimeBoundingBox(TimeAveBox avebox, double starttime, double finaltime) {
        CategoryTimeBox[] typeboxes = avebox.arrayOfCategoryTimeBoxes();
        if (SummaryState.isDisplayTypeExclusiveRatio()) {
            Arrays.sort(typeboxes, CategoryTimeBox.EXCL_RATIO_ORDER);
        } else {
            Arrays.sort(typeboxes, CategoryTimeBox.INCL_RATIO_ORDER);
        }
        TimeBoundingBox curr_timebox = avebox.getCurrentTimeBoundingBox();
        curr_timebox.reinitialize();
        if (SummaryState.isDisplayTypeEqualWeighted()) {
            int idx;
            int vis_typeboxes_length = 0;
            for (idx = typeboxes.length - 1; idx >= 0; --idx) {
                if (!typeboxes[idx].isCategoryVisiblySearchable()) continue;
                ++vis_typeboxes_length;
            }
            double prev_time = starttime;
            double interval = (finaltime - starttime) / (double)vis_typeboxes_length;
            for (idx = typeboxes.length - 1; idx >= 0; --idx) {
                CategoryTimeBox typebox = typeboxes[idx];
                if (!typebox.isCategoryVisiblySearchable()) continue;
                typebox.setEarliestTime(prev_time);
                typebox.setLatestFromEarliest(interval);
                prev_time = typebox.getLatestTime();
                curr_timebox.affectTimeBounds((TimeBoundingBox)typebox);
            }
        } else {
            boolean isInclusive;
            boolean bl = isInclusive = !SummaryState.isDisplayTypeExclusiveRatio();
            if (SummaryState.isDisplayTypeCumulative()) {
                double prev_time = starttime;
                double duration = finaltime - starttime;
                for (int idx = typeboxes.length - 1; idx >= 0; --idx) {
                    CategoryTimeBox typebox = typeboxes[idx];
                    if (!typebox.isCategoryVisiblySearchable()) continue;
                    double interval = duration * (double)typebox.getCategoryRatio(isInclusive);
                    typebox.setEarliestTime(prev_time);
                    typebox.setLatestFromEarliest(interval);
                    prev_time = typebox.getLatestTime();
                    curr_timebox.affectTimeBounds((TimeBoundingBox)typebox);
                }
            } else {
                double duration = finaltime - starttime;
                for (int idx = typeboxes.length - 1; idx >= 0; --idx) {
                    CategoryTimeBox typebox = typeboxes[idx];
                    if (!typebox.isCategoryVisiblySearchable()) continue;
                    double interval = duration * (double)typebox.getCategoryRatio(isInclusive);
                    typebox.setEarliestTime(starttime);
                    typebox.setLatestFromEarliest(interval);
                    curr_timebox.affectTimeBounds((TimeBoundingBox)typebox);
                }
            }
        }
    }

    public static int draw(Graphics2D g, TimeAveBox avebox, CoordPixelXform coord_xform, float start_ypos, float final_ypos, float avebox_height) {
        float tail_ypos;
        float head_ypos;
        if (start_ypos < final_ypos) {
            head_ypos = start_ypos;
            tail_ypos = final_ypos;
        } else {
            head_ypos = final_ypos;
            tail_ypos = start_ypos;
        }
        int count = 0;
        TimeBoundingBox curr_timebox = avebox.getCurrentTimeBoundingBox();
        CategoryTimeBox[] typeboxes = avebox.arrayOfCategoryTimeBoxes();
        if (SummaryState.isDisplayTypeEqualWeighted() || SummaryState.isDisplayTypeCumulative()) {
            double tail_time;
            double head_time;
            if (head_ypos + avebox_height < tail_ypos - avebox_height) {
                head_time = curr_timebox.getEarliestTime();
                tail_time = curr_timebox.getLatestTime();
                count += SummaryState.drawForward(g, null, coord_xform, head_time, head_ypos, tail_time, tail_ypos);
                head_ypos += avebox_height;
                tail_ypos -= avebox_height;
            }
            for (int idx = typeboxes.length - 1; idx >= 0; --idx) {
                CategoryTimeBox typebox = typeboxes[idx];
                Color color = typebox.getCategoryColor();
                head_time = typebox.getEarliestTime();
                tail_time = typebox.getLatestTime();
                count += SummaryState.drawForward(g, color, coord_xform, head_time, head_ypos, tail_time, tail_ypos);
            }
        } else {
            double tail_time;
            double head_time;
            if (head_ypos + avebox_height < tail_ypos - avebox_height) {
                head_time = curr_timebox.getEarliestTime();
                tail_time = curr_timebox.getLatestTime();
                count += SummaryState.drawForward(g, null, coord_xform, head_time, head_ypos, tail_time, tail_ypos);
                head_ypos += avebox_height;
                tail_ypos -= avebox_height;
            }
            float gap_ypos = (tail_ypos - head_ypos) / (float)(typeboxes.length * 2);
            for (int idx = typeboxes.length - 1; idx >= 0; --idx) {
                CategoryTimeBox typebox = typeboxes[idx];
                Color color = typebox.getCategoryColor();
                head_time = typebox.getEarliestTime();
                tail_time = typebox.getLatestTime();
                count += SummaryState.drawForward(g, color, coord_xform, head_time, head_ypos, tail_time, tail_ypos);
                head_ypos += gap_ypos;
                tail_ypos -= gap_ypos;
            }
        }
        return count;
    }

    public static Object containsPixel(TimeAveBox avebox, CoordPixelXform coord_xform, Point pt, float start_ypos, float final_ypos, float avebox_height) {
        float tail_ypos;
        float head_ypos;
        if (start_ypos < final_ypos) {
            head_ypos = start_ypos;
            tail_ypos = final_ypos;
        } else {
            head_ypos = final_ypos;
            tail_ypos = start_ypos;
        }
        if (pt.y < coord_xform.convertRowToPixel(head_ypos)) {
            return null;
        }
        if (pt.y > coord_xform.convertRowToPixel(tail_ypos)) {
            return null;
        }
        TimeBoundingBox curr_timebox = avebox.getCurrentTimeBoundingBox();
        CategoryTimeBox[] typeboxes = avebox.arrayOfCategoryTimeBoxes();
        if (SummaryState.isDisplayTypeEqualWeighted() || SummaryState.isDisplayTypeCumulative()) {
            double tail_time;
            double head_time;
            boolean hasBoundary;
            if (head_ypos + avebox_height < tail_ypos - avebox_height) {
                head_ypos += avebox_height;
                tail_ypos -= avebox_height;
                hasBoundary = true;
            } else {
                hasBoundary = false;
            }
            for (int idx = 0; idx < typeboxes.length; ++idx) {
                CategoryTimeBox typebox = typeboxes[idx];
                head_time = typebox.getEarliestTime();
                if (!SummaryState.isPixelIn(coord_xform, pt, head_time, head_ypos, tail_time = typebox.getLatestTime(), tail_ypos)) continue;
                return typebox;
            }
            if (hasBoundary && SummaryState.isPixelIn(coord_xform, pt, head_time = curr_timebox.getEarliestTime(), head_ypos -= avebox_height, tail_time = curr_timebox.getLatestTime(), tail_ypos += avebox_height)) {
                return avebox;
            }
        } else {
            double tail_time;
            double head_time;
            boolean hasBoundary;
            if (head_ypos + avebox_height < tail_ypos - avebox_height) {
                head_ypos += avebox_height;
                tail_ypos -= avebox_height;
                hasBoundary = true;
            } else {
                hasBoundary = false;
            }
            float gap_ypos = (tail_ypos - head_ypos) / (float)(typeboxes.length * 2);
            head_ypos += gap_ypos * (float)(typeboxes.length - 1);
            tail_ypos -= gap_ypos * (float)(typeboxes.length - 1);
            for (int idx = 0; idx < typeboxes.length; ++idx) {
                CategoryTimeBox typebox = typeboxes[idx];
                head_time = typebox.getEarliestTime();
                if (SummaryState.isPixelIn(coord_xform, pt, head_time, head_ypos, tail_time = typebox.getLatestTime(), tail_ypos)) {
                    return typebox;
                }
                head_ypos -= gap_ypos;
                tail_ypos += gap_ypos;
            }
            if (hasBoundary) {
                head_ypos += gap_ypos;
                tail_ypos -= gap_ypos;
                head_time = curr_timebox.getEarliestTime();
                if (SummaryState.isPixelIn(coord_xform, pt, head_time, head_ypos -= avebox_height, tail_time = curr_timebox.getLatestTime(), tail_ypos += avebox_height)) {
                    return avebox;
                }
            }
        }
        return null;
    }
}

