/*
 * Decompiled with CFR 0.152.
 */
package viewer.convertor;

import java.io.File;
import java.util.Properties;
import java.util.StringTokenizer;
import logformat.slog2.TraceName;

public class ConvertorConst {
    public static final String CLOG2_TO_SLOG2 = "  CLOG-2  -->  SLOG-2  ";
    public static final String CLOG_TO_SLOG2 = "  CLOG    -->  SLOG-2  ";
    public static final String RLOG_TO_SLOG2 = "  RLOG    -->  SLOG-2  ";
    public static final String UTE_TO_SLOG2 = "  UTE     -->  SLOG-2  ";
    private static final String CLOG2_TO_SLOG2_JAR = "clog2TOslog2.jar";
    private static final String CLOG_TO_SLOG2_JAR = "clogTOslog2.jar";
    private static final String RLOG_TO_SLOG2_JAR = "traceTOslog2.jar";
    private static final String UTE_TO_SLOG2_JAR = "traceTOslog2.jar";
    private static String FileSeparator = "/";
    private static String PathSeparator = ":";
    private static String JavaHome = null;
    private static String ClassPath = null;
    private static final String JVM = "java";
    private static String CLOG2_TraceLibPath = "";
    private static String CLOG_TraceLibPath = "";
    private static String RLOG_TraceLibPath = ".:../trace_rlog/lib";
    private static String UTE_TraceLibPath = ".:/usr/lpp/ppe.perf/lib";

    public static String getDefaultConvertor(String filename) {
        String log_ext = TraceName.getLogFormatExtension(filename);
        if (log_ext.equals(".clog2")) {
            return CLOG2_TO_SLOG2;
        }
        if (log_ext.equals(".clog")) {
            return CLOG_TO_SLOG2;
        }
        if (log_ext.equals(".rlog")) {
            return RLOG_TO_SLOG2;
        }
        if (log_ext.equals(".ute")) {
            return UTE_TO_SLOG2;
        }
        return "";
    }

    public static String getDefaultSLOG2Name(String filename) {
        return TraceName.getDefaultSLOG2Name(filename);
    }

    public static String getDefaultJarName(String convertor) {
        if (convertor.equals(CLOG2_TO_SLOG2)) {
            return CLOG2_TO_SLOG2_JAR;
        }
        if (convertor.equals(CLOG_TO_SLOG2)) {
            return CLOG_TO_SLOG2_JAR;
        }
        if (convertor.equals(RLOG_TO_SLOG2)) {
            return "traceTOslog2.jar";
        }
        if (convertor.equals(UTE_TO_SLOG2)) {
            return "traceTOslog2.jar";
        }
        return "";
    }

    public static String getDefaultJarPath(String prefix, String convertor) {
        if (prefix != null && prefix.length() > 0) {
            return prefix + FileSeparator + ConvertorConst.getDefaultJarName(convertor);
        }
        return ConvertorConst.getDefaultJarName(convertor);
    }

    public static String getDefaultTraceLibPath(String convertor, String prefix) {
        if (convertor.equals(CLOG2_TO_SLOG2)) {
            return ConvertorConst.updateLibraryPath(prefix, CLOG2_TraceLibPath);
        }
        if (convertor.equals(CLOG_TO_SLOG2)) {
            return ConvertorConst.updateLibraryPath(prefix, CLOG_TraceLibPath);
        }
        if (convertor.equals(RLOG_TO_SLOG2)) {
            return ConvertorConst.updateLibraryPath(prefix, RLOG_TraceLibPath);
        }
        if (convertor.equals(UTE_TO_SLOG2)) {
            return ConvertorConst.updateLibraryPath(prefix, UTE_TraceLibPath);
        }
        return ".";
    }

    private static boolean replaceCharOfTraceLibPaths(char old_char, char new_char) {
        if (old_char != new_char) {
            if (CLOG2_TraceLibPath != null) {
                CLOG2_TraceLibPath = CLOG2_TraceLibPath.replace(old_char, new_char);
            }
            if (CLOG_TraceLibPath != null) {
                CLOG_TraceLibPath = CLOG_TraceLibPath.replace(old_char, new_char);
            }
            if (RLOG_TraceLibPath != null) {
                RLOG_TraceLibPath = RLOG_TraceLibPath.replace(old_char, new_char);
            }
            if (UTE_TraceLibPath != null) {
                UTE_TraceLibPath = UTE_TraceLibPath.replace(old_char, new_char);
            }
            return true;
        }
        return false;
    }

    public static void initializeSystemProperties() {
        Properties sys_pptys = System.getProperties();
        String ppty_str = sys_pptys.getProperty("file.separator");
        if (ConvertorConst.replaceCharOfTraceLibPaths(FileSeparator.charAt(0), ppty_str.charAt(0))) {
            FileSeparator = ppty_str;
        }
        ppty_str = sys_pptys.getProperty("path.separator");
        if (ConvertorConst.replaceCharOfTraceLibPaths(PathSeparator.charAt(0), ppty_str.charAt(0))) {
            PathSeparator = ppty_str;
        }
        JavaHome = sys_pptys.getProperty("java.home");
        ClassPath = sys_pptys.getProperty("java.class.path");
    }

    public static String getDefaultPathToJVM() {
        String path2jvm = JavaHome + FileSeparator + "bin" + FileSeparator + JVM;
        File jvm_file = new File(path2jvm);
        if (!FileSeparator.equals("/") && !path2jvm.endsWith(".exe")) {
            path2jvm = path2jvm + ".exe";
            jvm_file = new File(path2jvm);
        }
        if (!jvm_file.exists()) {
            path2jvm = JVM;
        }
        return path2jvm;
    }

    public static String getDefaultPathToJarDir() {
        String path2jardir = null;
        StringTokenizer paths = new StringTokenizer(ClassPath, PathSeparator);
        while (paths.hasMoreTokens() && path2jardir == null) {
            String path = paths.nextToken();
            int char_idx = path.lastIndexOf(FileSeparator);
            if (char_idx < 0) continue;
            path2jardir = path.substring(0, char_idx);
        }
        return path2jardir;
    }

    private static String updateLibraryPath(String prefix_path, String old_libpath) {
        StringBuffer new_libpath = new StringBuffer();
        StringTokenizer paths = new StringTokenizer(old_libpath, PathSeparator);
        while (paths.hasMoreTokens()) {
            String path = paths.nextToken();
            if (new File(path).isAbsolute()) {
                new_libpath.append(path);
            } else if (path.equals(".")) {
                new_libpath.append(prefix_path);
            } else {
                new_libpath.append(prefix_path + FileSeparator + path);
            }
            if (!paths.hasMoreTokens()) continue;
            new_libpath.append(PathSeparator);
        }
        return new_libpath.toString();
    }
}

