/*
 * Decompiled with CFR 0.152.
 */
package viewer.convertor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import viewer.convertor.ConvertorPanel;

public class ConvertorFrame
extends JFrame {
    private static String in_filename;
    private ConvertorPanel top_panel;
    private static String help_msg;

    public ConvertorFrame() {
        super("Logfile Convertor");
        super.setDefaultCloseOperation(0);
        this.top_panel = new ConvertorPanel(null);
        this.top_panel.addActionListenerForOkayButton(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConvertorFrame.this.setVisible(false);
                ConvertorFrame.this.dispose();
                System.exit(0);
            }
        });
        this.top_panel.addActionListenerForCancelButton(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConvertorFrame.this.setVisible(false);
                ConvertorFrame.this.dispose();
                System.exit(0);
            }
        });
        super.setContentPane(this.top_panel);
        super.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ConvertorFrame.this.setVisible(false);
                ConvertorFrame.this.dispose();
                System.exit(0);
            }
        });
    }

    public void init(String trace_filename) {
        this.top_panel.init(trace_filename);
    }

    public static void main(String[] args) {
        ConvertorFrame.checkVersion();
        ConvertorFrame.parseCmdLineArgs(args);
        ConvertorFrame frame = new ConvertorFrame();
        frame.pack();
        frame.setVisible(true);
        frame.init(in_filename);
    }

    public static void checkVersion() {
        String vers = System.getProperty("java.version");
        System.out.println("Java is version " + vers + ".");
        if (vers.compareTo("1.2.0") < 0) {
            System.err.println("WARNING: Java is version " + vers + ". \n" + "\t It is too old to run this prototype.");
        }
    }

    private static void parseCmdLineArgs(String[] argv) {
        StringBuffer err_msg = new StringBuffer();
        int idx = 0;
        try {
            while (idx < argv.length) {
                if (argv[idx].startsWith("-")) {
                    if (argv[idx].equals("-h") || argv[idx].equals("-help") || argv[idx].equals("--help")) {
                        System.out.println(help_msg);
                        System.out.flush();
                        System.exit(0);
                        continue;
                    }
                    System.err.println("Unrecognized option, " + argv[idx] + ", at " + ConvertorFrame.indexOrderStr(idx + 1) + " command line argument");
                    System.out.flush();
                    System.exit(1);
                    continue;
                }
                in_filename = argv[idx];
                ++idx;
            }
        }
        catch (NumberFormatException numerr) {
            if (err_msg.length() > 0) {
                System.err.println(err_msg.toString());
            }
            String idx_order_str = ConvertorFrame.indexOrderStr(idx);
            System.err.println("Error occurs after option " + argv[idx - 1] + ", " + ConvertorFrame.indexOrderStr(idx) + " command line argument.  It needs a number.");
            numerr.printStackTrace();
        }
    }

    private static String indexOrderStr(int idx) {
        switch (idx) {
            case 1: {
                return Integer.toString(idx) + "st";
            }
            case 2: {
                return Integer.toString(idx) + "nd";
            }
            case 3: {
                return Integer.toString(idx) + "rd";
            }
        }
        return Integer.toString(idx) + "th";
    }

    static {
        help_msg = "Usage: java viewer.convertor.ConvertorFrame [options] trace_filename.\nOptions: \n\t [-h|-help|--help]                 \t Display this message.\n";
    }
}

