/*
 * Decompiled with CFR 0.152.
 */
package logformat.trace;

import base.drawable.Category;
import base.drawable.Composite;
import base.drawable.Drawable;
import base.drawable.Kind;
import base.drawable.Primitive;
import base.drawable.Topology;
import base.drawable.YCoordMap;
import java.util.Date;
import java.util.HashMap;
import logformat.trace.InputLog;

public class Print {
    private static String in_filename;
    private static String out_filename;
    private static boolean enable_endtime_check;
    private static String help_msg;

    public static final void main(String[] args) {
        Kind next_kind;
        double prev_dobj_endtime = Double.NEGATIVE_INFINITY;
        long offended_Nobjs = Integer.MIN_VALUE;
        Drawable offended_dobj = null;
        Print.parseCmdLineArgs(args);
        HashMap<Integer, Category> objdefs = new HashMap<Integer, Category>();
        HashMap<Topology, Category> shadefs = new HashMap<Topology, Category>();
        long Nobjs = 0L;
        Date time1 = new Date();
        InputLog dobj_ins = new InputLog(in_filename);
        Date time2 = new Date();
        while ((next_kind = dobj_ins.peekNextKind()) != Kind.EOF) {
            double curr_dobj_endtime;
            Category objdef;
            if (next_kind == Kind.TOPOLOGY) {
                Topology topo = dobj_ins.getNextTopology();
                objdef = Category.getShadowCategory(topo);
                objdefs.put(new Integer(objdef.getIndex()), objdef);
                shadefs.put(topo, objdef);
                System.out.println("trace.Print: " + topo);
                System.out.println("trace.Print: " + objdef);
                continue;
            }
            if (next_kind == Kind.YCOORDMAP) {
                YCoordMap ymap = dobj_ins.getNextYCoordMap();
                System.out.println("trace.Print: " + ymap);
                continue;
            }
            if (next_kind == Kind.CATEGORY) {
                objdef = dobj_ins.getNextCategory();
                objdefs.put(new Integer(objdef.getIndex()), objdef);
                System.out.println("trace.Print: " + objdef);
                continue;
            }
            if (next_kind == Kind.PRIMITIVE) {
                Primitive prime_obj = dobj_ins.getNextPrimitive();
                prime_obj.resolveCategory(objdefs);
                System.out.println(++Nobjs + " : " + prime_obj);
                if (!enable_endtime_check) continue;
                if (!prime_obj.isTimeOrdered()) {
                    System.out.println("**** Primitive Time Error ****");
                    System.exit(1);
                }
                if (prev_dobj_endtime > (curr_dobj_endtime = prime_obj.getLatestTime())) {
                    System.out.println("**** Violation of Increasing Endtime Order ****\n\t Offended Drawable -> " + offended_Nobjs + " : " + offended_dobj + "\n" + "\t Offending Primitive -> " + Nobjs + " : " + prime_obj + "\n" + "   previous drawable endtime ( " + prev_dobj_endtime + " ) " + " > current drawable endtiime ( " + curr_dobj_endtime + " ) ");
                    System.exit(1);
                    continue;
                }
                offended_Nobjs = Nobjs;
                offended_dobj = prime_obj;
                prev_dobj_endtime = curr_dobj_endtime;
                continue;
            }
            if (next_kind == Kind.COMPOSITE) {
                Composite cmplx_obj = dobj_ins.getNextComposite();
                cmplx_obj.resolveCategory(objdefs);
                System.out.println(++Nobjs + " : " + cmplx_obj);
                if (!enable_endtime_check) continue;
                if (!cmplx_obj.isTimeOrdered()) {
                    System.out.println("**** Composite Time Error ****");
                    System.exit(1);
                }
                if (prev_dobj_endtime > (curr_dobj_endtime = cmplx_obj.getLatestTime())) {
                    System.out.println("**** Violation of Increasing Endtime Order ****\n\t Offended Drawable -> " + offended_Nobjs + " : " + offended_dobj + "\n" + "\t Offending Composite -> " + Nobjs + " : " + cmplx_obj + "\n" + "   previous drawable endtime ( " + prev_dobj_endtime + " ) " + " > current drawable endtiime ( " + curr_dobj_endtime + " ) ");
                    System.exit(1);
                    continue;
                }
                offended_Nobjs = Nobjs;
                offended_dobj = cmplx_obj;
                prev_dobj_endtime = curr_dobj_endtime;
                continue;
            }
            System.err.println("trace.Print: Unrecognized return from peekNextKind() = " + next_kind);
        }
        dobj_ins.close();
        Date time3 = new Date();
        System.err.println("\n");
        System.err.println("Number of Drawables = " + Nobjs);
        System.err.println("timeElapsed between 1 & 2 = " + (time2.getTime() - time1.getTime()) + " msec");
        System.err.println("timeElapsed between 2 & 3 = " + (time3.getTime() - time2.getTime()) + " msec");
    }

    private static void parseCmdLineArgs(String[] argv) {
        StringBuffer err_msg = new StringBuffer();
        StringBuffer filespec_buf = new StringBuffer();
        int idx = 0;
        enable_endtime_check = false;
        try {
            while (idx < argv.length) {
                if (argv[idx].startsWith("-")) {
                    if (argv[idx].equals("-h") || argv[idx].equals("--h") || argv[idx].equals("-help") || argv[idx].equals("--help")) {
                        System.out.println(help_msg);
                        filespec_buf.append("-h ");
                        ++idx;
                        continue;
                    }
                    if (argv[idx].equals("-tc")) {
                        enable_endtime_check = true;
                        err_msg.append("\n endtime_order_check = true");
                        ++idx;
                        continue;
                    }
                    filespec_buf.append(argv[idx] + " ");
                    ++idx;
                    continue;
                }
                filespec_buf.append(argv[idx] + " ");
                ++idx;
            }
        }
        catch (ArrayIndexOutOfBoundsException idxerr) {
            if (err_msg.length() > 0) {
                System.err.println(err_msg.toString());
            }
            System.err.println("Error occurs after option " + argv[idx - 1] + ", " + Print.indexOrderStr(idx) + " command line argument.");
            idxerr.printStackTrace();
        }
        catch (NumberFormatException numerr) {
            if (err_msg.length() > 0) {
                System.err.println(err_msg.toString());
            }
            String idx_order_str = Print.indexOrderStr(idx);
            System.err.println("Error occurs after option " + argv[idx - 1] + ", " + Print.indexOrderStr(idx) + " command line argument.  It needs a number.");
            numerr.printStackTrace();
        }
        in_filename = filespec_buf.toString().trim();
        if (in_filename == null) {
            System.err.println("The Program needs a TRACE filename as a command line argument.");
            System.err.println(help_msg);
            System.exit(1);
        }
    }

    private static String indexOrderStr(int idx) {
        switch (idx) {
            case 1: {
                return Integer.toString(idx) + "st";
            }
            case 2: {
                return Integer.toString(idx) + "nd";
            }
            case 3: {
                return Integer.toString(idx) + "rd";
            }
        }
        return Integer.toString(idx) + "th";
    }

    static {
        System.loadLibrary("TraceInput");
        help_msg = "Usage: java trace.Print [options] trace_filename.\n options: \n\t [-h|--h|-help|--help]            \t Display this message.\n\t [-tc]                            \t Check increasing endtime order\n";
    }
}

