/*
 * Decompiled with CFR 0.152.
 */
package old_logformat.slog2.input;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import old_base.drawable.Drawable;
import old_base.drawable.TimeBoundingBox;
import old_base.io.MixedDataInput;
import old_base.io.MixedDataOutput;
import old_logformat.slog2.BufForDrawables;
import old_logformat.slog2.BufForObjects;
import old_logformat.slog2.BufForShadows;
import old_logformat.slog2.input.IteratorOfGroupObjects;

public class TreeNode
extends BufForDrawables {
    private BufForShadows[] shadowbufs = null;

    public TreeNode() {
        super(false);
    }

    public BufForObjects[] getChildStubs() {
        return this.shadowbufs;
    }

    public int getNodeByteSize() {
        int n = super.getByteSize() + 4;
        if (this.shadowbufs != null) {
            for (int i = 0; i < this.shadowbufs.length; ++i) {
                n += this.shadowbufs[i].getByteSize();
            }
        }
        return n;
    }

    public Iterator iteratorOfDrawables(TimeBoundingBox timeBoundingBox, Drawable.Order order, boolean bl, boolean bl2) {
        boolean bl3 = order.isIncreasingTimeOrdered();
        if (bl3) {
            if (bl2) {
                return super.nestableForeIterator(timeBoundingBox, bl);
            }
            return super.nestlessForeIterator(timeBoundingBox);
        }
        if (bl2) {
            return super.nestableBackIterator(timeBoundingBox, bl);
        }
        return super.nestlessBackIterator(timeBoundingBox);
    }

    public Iterator iteratorOfShadows(TimeBoundingBox timeBoundingBox, Drawable.Order order, boolean bl) {
        boolean bl2 = order.isIncreasingTimeOrdered();
        if (bl2) {
            if (bl) {
                return new ForeItrOfNestableShadows(timeBoundingBox);
            }
            return new ForeItrOfNestlessShadows(timeBoundingBox);
        }
        if (bl) {
            return new BackItrOfNestableShadows(timeBoundingBox);
        }
        return new BackItrOfNestlessShadows(timeBoundingBox);
    }

    public void writeObject(MixedDataOutput mixedDataOutput) throws IOException {
        System.err.println("ERROR! : slog2.input.TreeNode.writeObject() should NOT be called!");
    }

    public TreeNode(MixedDataInput mixedDataInput, Map map) throws IOException {
        this();
        this.readObject(mixedDataInput, map);
    }

    public void readObject(MixedDataInput mixedDataInput, Map map) throws IOException {
        super.readObject(mixedDataInput, map);
        int n = mixedDataInput.readInt();
        if (n > 0) {
            this.shadowbufs = new BufForShadows[n];
            for (int i = 0; i < this.shadowbufs.length; ++i) {
                this.shadowbufs[i] = new BufForShadows(mixedDataInput, map);
            }
        } else {
            this.shadowbufs = null;
        }
    }

    public void reorderDrawables(Drawable.Order order) {
        super.reorderDrawables(order);
        if (this.shadowbufs != null) {
            for (int i = 0; i < this.shadowbufs.length; ++i) {
                this.shadowbufs[i].reorderDrawables(order);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("\t*** Start of TreeNode ***\n");
        stringBuffer.append(super.toString() + "\n");
        if (this.shadowbufs != null) {
            for (int i = 0; i < this.shadowbufs.length; ++i) {
                stringBuffer.append("\t BufForShadows No. " + i + "\n");
                stringBuffer.append(this.shadowbufs[i]);
            }
        }
        stringBuffer.append("\t*** End of TreeNode ***\n");
        return stringBuffer.toString();
    }

    private class ForeItrOfNestlessShadows
    extends IteratorOfGroupObjects {
        private int shadowbufs_length;
        private int next_buf_idx;

        public ForeItrOfNestlessShadows(TimeBoundingBox timeBoundingBox) {
            super(timeBoundingBox);
            this.shadowbufs_length = TreeNode.this.shadowbufs != null ? TreeNode.this.shadowbufs.length : 0;
            this.next_buf_idx = 0;
            super.setObjGrpItr(this.nextObjGrpItr(timeBoundingBox));
        }

        protected Iterator nextObjGrpItr(TimeBoundingBox timeBoundingBox) {
            if (TreeNode.this.shadowbufs != null) {
                while (this.next_buf_idx < this.shadowbufs_length) {
                    BufForShadows bufForShadows = TreeNode.this.shadowbufs[this.next_buf_idx];
                    ++this.next_buf_idx;
                    if (!bufForShadows.overlaps(timeBoundingBox)) continue;
                    return bufForShadows.nestlessForeIterator(timeBoundingBox);
                }
            }
            return null;
        }
    }

    private class ForeItrOfNestableShadows
    extends IteratorOfGroupObjects {
        private static final boolean IS_COMPOSITE = false;
        private int shadowbufs_length;
        private int next_buf_idx;

        public ForeItrOfNestableShadows(TimeBoundingBox timeBoundingBox) {
            super(timeBoundingBox);
            this.shadowbufs_length = TreeNode.this.shadowbufs != null ? TreeNode.this.shadowbufs.length : 0;
            this.next_buf_idx = 0;
            super.setObjGrpItr(this.nextObjGrpItr(timeBoundingBox));
        }

        protected Iterator nextObjGrpItr(TimeBoundingBox timeBoundingBox) {
            if (TreeNode.this.shadowbufs != null) {
                while (this.next_buf_idx < this.shadowbufs_length) {
                    BufForShadows bufForShadows = TreeNode.this.shadowbufs[this.next_buf_idx];
                    ++this.next_buf_idx;
                    if (!bufForShadows.overlaps(timeBoundingBox)) continue;
                    return bufForShadows.nestableForeIterator(timeBoundingBox, false);
                }
            }
            return null;
        }
    }

    private class BackItrOfNestlessShadows
    extends IteratorOfGroupObjects {
        private int shadowbufs_length;
        private int next_buf_idx;

        public BackItrOfNestlessShadows(TimeBoundingBox timeBoundingBox) {
            super(timeBoundingBox);
            this.shadowbufs_length = TreeNode.this.shadowbufs != null ? TreeNode.this.shadowbufs.length : 0;
            this.next_buf_idx = this.shadowbufs_length - 1;
            super.setObjGrpItr(this.nextObjGrpItr(timeBoundingBox));
        }

        protected Iterator nextObjGrpItr(TimeBoundingBox timeBoundingBox) {
            if (TreeNode.this.shadowbufs != null) {
                while (this.next_buf_idx >= 0) {
                    BufForShadows bufForShadows = TreeNode.this.shadowbufs[this.next_buf_idx];
                    --this.next_buf_idx;
                    if (!bufForShadows.overlaps(timeBoundingBox)) continue;
                    return bufForShadows.nestlessBackIterator(timeBoundingBox);
                }
            }
            return null;
        }
    }

    private class BackItrOfNestableShadows
    extends IteratorOfGroupObjects {
        private static final boolean IS_COMPOSITE = false;
        private int shadowbufs_length;
        private int next_buf_idx;

        public BackItrOfNestableShadows(TimeBoundingBox timeBoundingBox) {
            super(timeBoundingBox);
            this.shadowbufs_length = TreeNode.this.shadowbufs != null ? TreeNode.this.shadowbufs.length : 0;
            this.next_buf_idx = this.shadowbufs_length - 1;
            super.setObjGrpItr(this.nextObjGrpItr(timeBoundingBox));
        }

        protected Iterator nextObjGrpItr(TimeBoundingBox timeBoundingBox) {
            if (TreeNode.this.shadowbufs != null) {
                while (this.next_buf_idx >= 0) {
                    BufForShadows bufForShadows = TreeNode.this.shadowbufs[this.next_buf_idx];
                    --this.next_buf_idx;
                    if (!bufForShadows.overlaps(timeBoundingBox)) continue;
                    return bufForShadows.nestableBackIterator(timeBoundingBox, false);
                }
            }
            return null;
        }
    }
}

