
/*============================================================================*/
/* ѹ                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : APIб 2003/08/21                                           */
/*============================================================================*/

#include <musashi.h>
#include <stdlib.h>
#include <math.h>

#include <xtasruleHelp.h>
struct mssComHelp comHelp={
  "xtasrule",     /* ޥ̾       */
  "1.0",          /* С       */
  HELPT,          /* ޥɥȥ */
  HELPS,          /*              */
  HELPE,          /*            */
  HELPR,          /* ȥޥ     */
  HELPA,          /* Ծ         */
  HELPB,          /* ХݡȾ */
  HELPH           /* ۡڡ     */
};

extern struct mssGlobalVariables mssGV;

int TotalCnt=0;        /*ȥ󥶥*/
int MinSupportCnt=0;   /*ݡȤη(TotalCnt*optSPP*100)*/
int DepthMax;          /*õƱƥκ(optMAX)*/
int PMML;              /*PMMLǽϤե饰*/

/**
 * νУƥॻåȤǼ빽¤
 */
struct OneItemList {
  struct mssHash *hash;
  struct mssHashNode **index;
  int cnt;
};

/**
 * OneItemList¤ΤѤ줿ƥоݤˡȥ󥶥󤫤
 * ʲΤ褦ʿDepthMaxΥĥ꡼롣
 * "Sn"Status¤ΤǤ롣
 * statusˤϡ(support)׻롣
 *
 *    a      b
 * S0-+---S1-+---S4
 *    |      |
 *    |      | c
 *    |      +---S5
 *    |
 *    | b    c
 *    +---S2-----S6
 *    |
 *    | c
 *    +---S3
 * |0   |  1   |  2  | -> status->depth
 *
 * ȥ󥶥{abc,bc}ʤС
 * S1->cnt=1, S2->cnt=2, S3->cnt=1
 * S4->cnt=1, S5->cnt=1, S6->cnt=2
 * Ȥʤ롣
 */
struct Status {
  struct mssHashNode *val;
  int depth;               /*statusο*/
  int support;             /*ݡȷ*/
  struct Hash *next;       /*statusؤΥϥåɽ*/
};

/*StatusStatusĤʤϥåɽ*/
struct HashNode {
  int str;
  struct Status *status;
  struct HashNode *next;
};

struct Hash {
  int hashVal;
  int cnt;                 /*줿ͤο*/
  struct HashNode **node;  /*줿ͤؤΥݥ*/
};

/**
 * 嵭Υĥ꡼˥ȥ󥶥"ab"򥻥åȤ뤳Ȥͤ롣
 * ޤtarget{S0}˥åȤ롣
 * S0"a"arc򤿤ɤꡢS1support򥫥ȥåפ롣
 * targetˡS1target={S0,S1}Ȥʤ롣
 * "b"ˤƤϡtargetˤS0,S1ξ"b"arc򤿤ɤꡢ
 * S2S4support򥫥ȥåפ롣
 * λɤĤS4οMaxDepthĶΤǡtargetˤɲäʤ
 * target={S0,S1,S2}Ȥʤ롣
 * ʾΤ褦ʼ򷫤֤Ƥ
 */
struct Target {
  int cnt;
  struct Status **list;
};


/**
 *------------------------------------------------------------------------------
 * status֤ΤĤʤΤHashɽϢδؿ
 *------------------------------------------------------------------------------
 */

/**
 * Hashɽν
 */
struct Hash *initHash(int size){
  struct Hash *hash;

  hash=mssMalloc(sizeof(struct Hash),"initHash");
  hash->hashVal = size;
  hash->cnt = 0;
  hash->node=mssCalloc(sizeof(struct HashNode *)*hash->hashVal,"initHash");
  return(hash);
}

/**
 * Hashɽγ
 */
void freeHash(struct Hash *hash)
{
  int i;
  struct HashNode *node;
  struct HashNode *tmp;

  if(hash==NULL) return;
  for(i=0; i<hash->hashVal; i++){
    if( NULL != (node=*(hash->node+i)) ){
      while(node!=NULL){
        tmp=node;
        node=node->next;
        mssFree(tmp);
      }
    }
  }
  mssFree(hash->node);
  mssFree(hash);
}


/**
 * Hashͤη׻
 * strϡƥʸǼmssHashɽΥɥ쥹Ǥ롣
 * Υɥ쥹̵intѴѤƤ롣
 */
static int getHashVal(int str,int hv){
  return(str % hv);
}

/**
 * Status->nextHashɽ˼status *valHashNodeɥ쥹֤
 * Ǥ¸ߤϡHashNodeɥ쥹֤
 */
struct HashNode *hashInsertAdd(struct Hash *hash, int str, struct Status *val)
{
  int hv;
  struct HashNode *newNode;
  struct HashNode *node;
  struct HashNode *last=NULL;

  hv=getHashVal(str,hash->hashVal);
  node=*(hash->node+hv);

  newNode=mssMalloc(sizeof(struct HashNode),"hashInsertAdd");

  if(node==NULL){
    *(hash->node+hv)=newNode;
  }else{
    while(node!=NULL){
      if( node->str==str ){
        mssFree(newNode);
        return(node);
      }else{
        last=node;
        node=node->next;
      }
    }
    last->next=newNode;
  }
  newNode->str=str;
  newNode->status=val;
  newNode->next=NULL;
  hash->cnt++;
  return(newNode);
}

/**
 * Status->nextHashɽ˼status뤫ΤᡢФHashNode֤
 * ʤNULL֤
 */
struct HashNode *hashMemberAdd(struct Hash *hash, int str)
{
  int hv;
  struct HashNode *node;

  hv=getHashVal(str,hash->hashVal);
  node=*(hash->node+hv);
  while(node!=NULL){
    if( node->str==str ){
      return(node);
    }else{
      node=node->next;
    }
  }
  return(NULL);
}

/**
 *------------------------------------------------------------------------------
 * Status¤&ĥ꡼Ϣ
 *------------------------------------------------------------------------------
 */

/**
 * Status¤Τν
 */
struct Status *initStatus(int depth){
  struct Status *status;
  status=mssCalloc(sizeof(struct Status),"initStatus");
  status->depth=depth;
  status->next=initHash(101);
  return(status);
}

/**
 * Status¤Τγ
 */
void freeStatus(struct Status *status){
  freeHash(status->next);
  mssFree(status);
}

/**
 * Target¤Τˡstatusɲä롣
 */
void addTarget(struct Target *target, struct Status *status){

  target->cnt++;
  target->list=mssRealloc(target->list, 
                          sizeof(struct Status *)*target->cnt,"addTarget");
  *(target->list+target->cnt-1)=status;
}

/**
 * statuschrArc򤿤ɤästatus֤
 * ⤷statusޤϿƤʤСɲä롣
 */
struct Status *nextStatus(struct Status *status, struct mssHashNode *chr){
  struct HashNode *node;
  struct Status *newStatus;

  node=hashMemberAdd(status->next, (int)chr);
  if(node==NULL){
    newStatus=initStatus(status->depth+1);
    newStatus->val=chr;
    node=hashInsertAdd(status->next, (int)chr, newStatus);
  }
  return(node->status);
}

/**
 * targetϿ줿status饢ƥchr򤿤ɤꡢStatussupport
 * 򥫥ȥåפ롣
 * ơΤɤ夤statusMaxDepthĶƤʤСstatus
 * targetɲϿ롣
 * ⤷statusޤϿƤʤСɲä롣
 */
void setStatus(struct Target *target, struct mssHashNode *chr){
  int i;
  int lastTargetCnt;
  struct Status *next;

  lastTargetCnt=target->cnt;
  for(i=0; i<lastTargetCnt; i++){
    next=nextStatus(*(target->list+i), chr);
    next->support++;
    if(next->depth<DepthMax){
      addTarget(target,next);
    }
  }
}

/**
 * ƥꥹstrˤäƥĥ꡼γstatussupport򥫥ȥåפ
 */
void addTree(struct Status *top, struct mssHashNode **str, int strLen){
  struct Target target;
  int i;

  target.cnt=0;
  target.list=NULL;

  addTarget(&target,top);

  for(i=0; i<strLen; i++){
    setStatus(&target,*(str+i));
  }
}

/**
 * ĥ꡼ɽ(ǥХå)
 */
void showTree(struct Status *status){
  int i;
  struct HashNode *node;


  for(i=0; i<status->depth; i++){
    printf("  ");
  }

  /*ȥåץΡȽ*/
  if(status->val!=NULL){
    printf("status=%s [%d]\n",status->val->str,status->support);
  }else{
    printf("[top]\n");
  }

  if(status->next->cnt==0){
    return;
  }

  for(i=0; i<status->next->hashVal; i++){
    if( NULL != (node=*(status->next->node+i)) ){
      while(node!=NULL){
        showTree(node->status);
        node=node->next;
      }
    }
  }
}

/**
 * ĥ꡼ΰ賫
 */
void freeTree(struct Status *status){
  int i;
  struct HashNode *node;

  if(status->next->cnt==0){
    freeStatus(status);
    return;
  }

  for(i=0; i<status->next->hashVal; i++){
    if( NULL != (node=*(status->next->node+i)) ){
      while(node!=NULL){
        freeTree(node->status);
        node=node->next;
      }
    }
  }
}

/**
 *------------------------------------------------------------------------------
 * ɽϢ
 *------------------------------------------------------------------------------
 */
struct OutItem {
  struct Status **list;
  struct Status *top;
  int cnt;
};

/**
 * OutItem¤ΤˡItem(mssHashNode)ɲä롣
 */
void addOutItem(struct OutItem *outItem, struct Status *item){

  outItem->cnt++;
  outItem->list=mssRealloc(outItem->list, 
                          sizeof(struct Status *)*outItem->cnt,"addOutItem");
  *(outItem->list+outItem->cnt-1)=item;
}

/**
 * OutItem¤ΤǸItem(mssHashNode)롣
 */
void delOutItem(struct OutItem *outItem){

  outItem->cnt--;
  if(outItem->cnt==0){
     mssFree(outItem->list);
     outItem->list=NULL;
  }else{
    outItem->list=mssRealloc(outItem->list, 
                          sizeof(struct Status *)*outItem->cnt,"delOutItem");
  }
}

/**
 * OutItem->listiܤItemʤItemSetη֤
 * outItem˰ΤItemʤ顢Τη֤
 */
int  getItemCnt(struct OutItem *outItem, int omit){
  struct Status *status;
  struct HashNode *hn;
  int i;

  if(outItem->cnt==1){
    return(TotalCnt);
  }

  status=outItem->top;
  for(i=0; i<outItem->cnt; i++){
    if(i!=omit){
      hn=hashMemberAdd(status->next, (int)(*(outItem->list+i))->val);
      if(hn==NULL) {
        mssShowErrMsg("internal error: getItemCnt");
        mssEnd(mssErrorNoDefault);
      }
      status=hn->status;
    }
  }
  return(status->support);
}

/**
 * OutItem->listiܤItemʤItemSetη֤
 * outItem˰ΤItemʤ顢Τη֤
 */
int  getOneItemCnt(struct OutItem *outItem, struct Status *status){
  struct HashNode *hn;

  hn=hashMemberAdd(outItem->top->next, (int)status->val);
  return(hn->status->support);
}

void writeRulePMML(
  struct OutItem *outItem,
  int conNo,   /*outItem->listˤֹ*/
  int conCnt,  /**/
  int antCnt,  /**/
  struct mssFPW *fpw){
  int i;
  int firstWrite;
  int conTotalCnt;
  double conf,supp,lift;

  /**/
  if(outItem->cnt==1){
    mssWriteNull(fpw);
    mssWriteDlm(fpw);
  }else{
    firstWrite=1;
    for(i=0; i<outItem->cnt; i++){
      if(i!=conNo){
        if(!firstWrite){
          mssWriteStr(",",fpw);
        }
        mssWriteStr((*(outItem->list+i))->val->str,fpw);
        firstWrite=0;
      }
    }
    mssWriteDlm(fpw);
  }
  conTotalCnt=getOneItemCnt(outItem,*(outItem->list+conNo));
  conf=(double)conCnt/(double)antCnt;
  supp=(double)conCnt/(double)TotalCnt;
  lift=conf/((double)conTotalCnt/(double)TotalCnt);

  /**/
  mssWriteStr( (*(outItem->list+conNo))->val->str, fpw);
  mssWriteDlm(fpw);

  /*Item(itemSize)*/
  mssWriteInt(outItem->cnt,fpw);
  mssWriteDlm(fpw);

  /*(antecedentCnt)*/
  mssWriteInt(antCnt,fpw);
  mssWriteDlm(fpw);

  /*(consequenctCnt)*/
  mssWriteInt(conCnt,fpw);
  mssWriteDlm(fpw);

  /*(consequenctTotal)*/
  mssWriteInt(conTotalCnt,fpw);
  mssWriteDlm(fpw);

  /*(totalCnt)*/
  mssWriteInt(TotalCnt,fpw);
  mssWriteDlm(fpw);

  /*Support*/
  mssWriteDbl(supp,fpw);
  mssWriteDlm(fpw);

  /*Confidence*/
  mssWriteDbl(conf,fpw);
  mssWriteDlm(fpw);

  /*Lift*/
  mssWriteDbl(lift,fpw);
  mssWriteRet(fpw);
}

void writeRuleTEXT(
  struct OutItem *outItem,
  int conNo,   /*outItem->listˤֹ*/
  int conCnt,  /**/
  int antCnt,  /**/
  struct mssFPW *fpw){
  int i;
  int firstWrite;
  int conTotalCnt;
  double conf,supp,lift;

  /**/
  if(outItem->cnt==1){
    mssWriteNull(fpw);
    mssWriteDlm(fpw);
  }else{
    firstWrite=1;
    for(i=0; i<outItem->cnt; i++){
      if(i!=conNo){
        if(!firstWrite){
          mssWriteStr(",",fpw);
        }
        mssWriteStr((*(outItem->list+i))->val->str,fpw);
        firstWrite=0;
      }
    }
    mssWriteDlm(fpw);
  }
  conTotalCnt=getOneItemCnt(outItem,*(outItem->list+conNo));
  conf=(double)conCnt/(double)antCnt;
  supp=(double)conCnt/(double)TotalCnt;
  lift=conf/((double)conTotalCnt/(double)TotalCnt);

  /**/
  mssWriteStr( (*(outItem->list+conNo))->val->str, fpw);
  mssWriteDlm(fpw);

  /*Item(itemSize)*/
  mssWriteInt(outItem->cnt,fpw);
  mssWriteDlm(fpw);

  /*(antecedentCnt)*/
  mssWriteInt(antCnt,fpw);
  mssWriteDlm(fpw);

  /*(consequenctCnt)*/
  mssWriteInt(conCnt,fpw);
  mssWriteDlm(fpw);

  /*(consequenctTotal)*/
  mssWriteInt(conTotalCnt,fpw);
  mssWriteDlm(fpw);

  /*(totalCnt)*/
  mssWriteInt(TotalCnt,fpw);
  mssWriteDlm(fpw);

  /*Support*/
  mssWriteDbl(supp,fpw);
  mssWriteDlm(fpw);

  /*Confidence*/
  mssWriteDbl(conf,fpw);
  mssWriteDlm(fpw);

  /*Lift*/
  mssWriteDbl(lift,fpw);
  mssWriteRet(fpw);
  mssGV.outCnt++;
}

/**
 * OutItem->list˥åȤ줿ItemConfʾΥ롼񤭽Ф
 */
void calConf(struct OutItem *outItem, int support, double minConf, struct mssFPW *fpw){
  int i;
  int antCnt; /**/
  int conCnt; /**/
  double conf;

  conCnt=(*(outItem->list+outItem->cnt-1))->support;
  for(i=0; i<outItem->cnt; i++){
    /*iǾʤƥ*/
    antCnt=getItemCnt(outItem,i);
    conf = (double)conCnt/(double)antCnt;
    if(conf>=minConf){
      if(PMML){
        writeRulePMML(outItem,i,conCnt,antCnt,fpw);
      }else{
        writeRuleTEXT(outItem,i,conCnt,antCnt,fpw);
      }
    }
  }
}

void writeRslSub(struct OutItem *outItem, struct Status *status,int minSupp, double minConf, struct mssFPW *fpw){
  int i;
  struct HashNode *node;

  /*ȥåץΡɤλϤȤФ*/
  if(status->val!=NULL){

    if(status->support < minSupp){
      return;
    }

    calConf(outItem, status->support, minConf,fpw);

    if(status->next->cnt==0){
      return;
    }
  }

  for(i=0; i<status->next->hashVal; i++){
    if( NULL != (node=*(status->next->node+i)) ){
      while(node!=NULL){
      addOutItem(outItem, node->status);
        writeRslSub(outItem,node->status,minSupp,minConf,fpw);
        delOutItem(outItem);
        node=node->next;
      }
    }
  }
}

void writeRsl(struct Status *top, int minSupp, double minConf, struct mssFPW *fpw){

  struct OutItem *outItem;
  outItem=mssMalloc(sizeof(struct OutItem), "writeRsl");
  outItem->cnt=0;
  outItem->list=NULL;
  outItem->top=top;

  writeRslSub(outItem,top,minSupp,minConf,fpw);

  mssFree(outItem->list);
  mssFree(outItem);

}

/**
 *------------------------------------------------------------------------------
 * νУƥॻåȴϢ
 *------------------------------------------------------------------------------
 */

/**
 * supportʾνУƥॻåȤϥåɽϿ
 */
struct OneItemList *setFrequent1ItemList(MssOptKEY *optKEY,int itemFldNo, double supp, struct mssFldRecDbl *frd,struct mssFPR *fpr){
  struct OneItemList *itemTable;
  struct mssHash *hash;
  int itemCnt;

  struct mssHashNode *node;
  MssValue v;
  int i;

  mssVinit(&v,INT);

  itemTable=mssMalloc(sizeof(struct OneItemList),"setItem");

  hash=mssInitHash(101);

  TotalCnt=1;
  while( EOF!=mssReadFRD(fpr,frd) ){

    /*֥쥤ν*/
    if(mssKeyBreak(frd, optKEY)){
      if(frd->eof) break;
      TotalCnt++; /*ѿȥ󥶥*/
    }

    node=mssHashInsertAdd(hash,*(frd->pnt[frd->new]+itemFldNo),v);
    node->val.v.i++;
  }
  MinSupportCnt=(int)ceil(TotalCnt*supp);

  /*ݡȷ꾯ʤΡɤ*/
  itemCnt=0;
  for(i=0; i<hash->hashVal; i++){
    if( NULL != (node=*(hash->node+i)) ){
      while(node!=NULL){
        if(node->val.v.i < MinSupportCnt){
          node=mssHashDeleteNode(hash,node);
          continue;
        }else{
          itemCnt++;
        }
        node=node->next;
      }
    }
  }

  itemTable->hash=hash;
  itemTable->cnt=itemCnt;

  return(itemTable);
}

/**
 * ȥ󥶥ʣƥseqơ֥Ͽ
 * λνУƥॻåȤϿƤʤƥϾʤ
 */
struct mssHashNode **setSeqDat(
  struct mssHashNode **seq, /*󥹤*/
  struct mssHash *hash,     /*νУƥॻå(hashɽ)*/
  int *seqCnt,                /*ȥ󥶥ǲܤitem*/
  char *str){               /*ϿʸȤƤitem*/

  struct mssHashNode *hn;  /*Ͽ줿hashNodeؤΥݥ*/

  if( NULL != (hn=mssHashMember(hash,str)) ){
    seq=mssRealloc(seq,sizeof(struct mssHashNode *)*(*seqCnt+1),"seq1");
    *(seq+*seqCnt)=hn;
    (*seqCnt)++;
  }
  return(seq);
}

void showSeqDat(
  struct mssHashNode **seq, /*󥹤*/
  struct mssHash *hash,     /*νУƥॻå(hashɽ)*/
  int seqCnt){              /*ȥ󥶥ǲܤitem*/
  int i;
  for(i=0; i<seqCnt; i++){
    printf("%s-",(*(seq+i))->str );
  }
  printf("\n");
}

int main(int argc, char *argv[]){
/*============================================================================*/
/* ץ                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* (ȥ󥶥̹)                                         */
/*----------------------------------------------------------------------------*/
  MssOptKEY optKEY={
    OKEY,   /* ץ󥿥                                             */
    "k",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "i",    /* оݤȤϥǡΥ(GUI)                  */
    1,      /* ǥե(Υץ󤬻ꤵʤäȤư) */
            /* 1:ƤιԤۤ륭ͤȤư                             */
            /* 2:ƤιԤƱͤȤư)                            */
    KEYT,   /* ΥץΥȥ(Helpɽ)                         */
    KEYC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ƥ                                                               */
/*----------------------------------------------------------------------------*/
  MssOptFLD optFLD={
    OFLD,   /* ץ󥿥                                             */
    "f",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "i",    /* оݤȤϥǡΥ(GUI)                  */
    1,      /* ɽĤ뤫ɤ(0:Բ,1:)                      */
    1,      /* ̾Ǥ뤫ɤ(0:Բ,1:)                    */
    NULL,   /* ܥץ(%ʲ)ǻǽʸ                        */
            /* ex) ԲĤξNULL, "nr": "-f ̾%rn"λǽ     */
    FLDT,   /* ΥץΥȥ(Helpɽ)                         */
    FLDC,   /* ΥץΥ(Helpɽ)                         */
    FLDF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* ݡȷ()                                                         */
/*----------------------------------------------------------------------------*/
  MssOptDBL optSPP={
    ODBL,   /* ץ󥿥                                             */
    "S",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    0.2,    /* ǥե(ͤȤƻ)                                   */
    0,      /* Ǿ                                                       */
    1,      /*                                                        */
    SPPT,   /* ΥץΥȥ(Helpɽ)                         */
    SPPC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* confidence                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptDBL optCNF={
    ODBL,   /* ץ󥿥                                             */
    "C",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    0.2,    /* ǥե(ͤȤƻ)                                   */
    0,      /* Ǿ                                                       */
    1,      /*                                                        */
    CNFT,   /* ΥץΥȥ(Helpɽ)                         */
    CNFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* õƱƥ                                               */
/*----------------------------------------------------------------------------*/
  MssOptINT optMAX={
    OINT,   /* ץ󥿥                                             */
    "M",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    4,      /* ǥե(ͤȤƻ)                                   */
    1,      /* Ǿ                                                       */
    10,     /*                                                        */
    MAXT,   /* ΥץΥȥ(Helpɽ)                         */
    MAXC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ̾                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptSLS optFNM={
    OSLS,   /* ץ󥿥                                             */
    "a",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    "antecedent,consequent,itemSize,antecedentCnt,consequentCnt,consequentTotal,totalCnt,support,confidence,lift", /* ǥե(ʸ)                   */
    10,     /* ޤǶڤǿκ                             */
    1,      /* ǤʸĹκǾ                                     */
    MssFieldNameMaxLen,/* ǤʸĹκ                          */
    0,      /* 1:Ǥ˥Ǥ,0:Բ  ex) aaaa:xxxxx            */
    FNMT,   /* ΥץΥȥ(Helpɽ)                         */
    FNMC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* ץ󥿥                                             */
    "i",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ                                         */
    1,      /* ǽκե                                     */
    0,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    INFT,   /* ΥץΥȥ(Helpɽ)                         */
    INFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* ץ󥿥                                             */
    "o",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    OTFT,   /* ΥץΥȥ(Helpɽ)                         */
    OTFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* PMML                                                                       */
/*----------------------------------------------------------------------------*/
  MssOptFLG optPML={
    OFLG,   /* ץ󥿥                                             */
    "p",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    PMLT,   /* ΥץΥȥ(Helpɽ)                         */
    PMLC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* ץ󥿥                                             */
    "t",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    TXTT,   /* ΥץΥȥ(Helpɽ)                         */
    TXTC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* եѥǥ쥯ȥ̾                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTMP={
    OSTR,   /* ץ󥿥                                             */
    "T",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    MssTempDir, /* ǥե                                               */
    1,      /* ʸκǾĹ                                               */
    MssFileNameMaxLen,  /* ʸκĹ                                  */
    TMPT,   /* ΥץΥȥ(Helpɽ)                         */
    TMPC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ץޤȤ                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optKEY,&optFLD,&optSPP,&optCNF,&optMAX,&optPML,&optFNM,
               &optINF,&optOTF,&optTXT,&optTMP,NULL};

/*============================================================================*/
/* ѿ                                                             */
/*============================================================================*/
  struct mssHeader    *hdi;      /*ϥե<head>Ǽ¤*/
  struct mssHeader    *hdo;      /*ϥե<head>Ǽ¤*/
  struct mssFPR       *fpr;      /*ϥե빽¤                */
  struct mssFPW       *fpw;      /*ϥե빽¤                */
  struct mssFldRecDbl *frd=NULL; /*-Хåե¤           */
  struct mssFields     *sf;      /*ȹܹ¤                  */
  int sorted;                    /*Ⱥѥå                */

  struct OneItemList *oneItemList; /*νУƥꥹ*/
  int itemFldNo;                 /*-fܤΥǡǤΰ*/
  struct mssHashNode **seq;      /*itemΥ󥹤*/
  int seqCnt;                     /*󥹤ǤΥitemֹ*/

  struct Status *topStatus;

/*----------------------------------------------------------------------------*/
/*                                                                      */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* ʥʤɤν              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* إ                                */
  mssSetOption(opt,argc,argv);       /* ޥɥץ              */
  fpr=mssOpenFPR(optINF.str,4);      /* ϥե륪ץ                  */
  hdi=mssReadHeader(fpr);            /* إåɤ߹                      */
  mssSetOptKey(&optKEY, hdi);        /* -k ܤإåܤ˴ϢŤ     */
  mssSetOptFld(&optFLD, hdi);        /* -f ܤإåܤ˴ϢŤ     */

  /*-pϸߥݡȤƤʤ*/
  if(optPML.set){
    mssShowErrMsg("PMML is not supported in the current version");
    mssEnd(mssErrorNoDefault);
  }

  /*-aꤹĿ10ǤʤФʤʤ*/
  if(optFNM.set && optFNM.cnt!=10){
    mssShowErrMsg("must specify 10 field names on -a");
    mssEnd(mssErrorNoDefault);
  }

  DepthMax=optMAX.val;
  PMML=optPML.set;

  /*ȹܤκ*/
  sf=mssInitFields();
  mssAddFieldsByFields(sf,optKEY.flds); /* -k ܤ򥽡ȹܤȤƥå    */
  mssAddFieldsByFields(sf,optFLD.flds); /* -k ܤ򥽡ȹܤȤƥå    */
  mssSetFieldsSortPriority(sf);         /* ֹͥϿˤդ   */
  sorted=mssChkSorted(sf,hdi);          /* ȺѤå                 */

/*mssShowFields(sf);*/
/*mssShowOption(opt);*/
/*mssShowHeader(hdi);*/


/*----------------------------------------------------------------------------*/
/*ᥤ롼                                                              */
/*----------------------------------------------------------------------------*/
  /*ȤɬѤʤХȤƥȺѤߥեȤƥץ*/
  if(!sorted){
    fpr=mssReopenFPRsort(fpr,4,sf,hdi->flds->cnt,optTMP.str);
  }


  /*------------------------------------------------*/
  /*ݡȷʾΣƥνХꥹȤ*/
  /*------------------------------------------------*/
  mssShowMsg("scanning frequent one item list");
  itemFldNo=MssFlds2num(optFLD.flds,0); /*itemܤΥǡǤΰ*/
  frd=mssInitFRD(hdi->flds->cnt);       /*쥳-ܹ¤*/
  oneItemList = setFrequent1ItemList(&optKEY,
                              MssFlds2num(optFLD.flds,0),
                              optSPP.val,
                              frd, fpr);
  if(MinSupportCnt<=0) MinSupportCnt=1;
/*printf("totalCnt=%d, MinSupportCnt=%d\n",TotalCnt,MinSupportCnt);*/

  /*mssShowHash(oneItemList->hash);*/
  mssFreeFRD(frd);

  /*------------------------------------------------*/
  /* ĥ꡼κ                                   */
  /*------------------------------------------------*/
  mssShowMsg("creating tree");
  topStatus=initStatus(0); /*ΥȥåץΡstatusκ*/
  seq=NULL;                /*ƥȥ󥶥󤴤ȤΥƥꥹ*/
  seqCnt=0;                /*󥹤ǤΥitemֹ*/
  mssSeekTopFPR(fpr);
  frd=mssInitFRD(hdi->flds->cnt);
  while( EOF!=mssReadFRD(fpr,frd) ){
    /*֥쥤ν*/
    if(mssKeyBreak(frd, &optKEY)){
      if(seqCnt>0){
        addTree(topStatus,seq,seqCnt);
      }
      /*showSeqDat(seq,oneItemList->hash, seqCnt);*/
      mssFree(seq);
      seq=NULL;
      seqCnt=0;
      if(frd->eof) break;
    }
   
    mssGV.inCnt++;
    /*̾Ԥν(ƥꥹȤκ)*/
    seq=setSeqDat(seq,oneItemList->hash, &seqCnt,
                  *(frd->pnt[frd->new]+itemFldNo));
  }
  /*showTree(topStatus);*/

  /*------------------------------------------------*/
  /* ̤ν                                     */
  /*------------------------------------------------*/
  mssShowMsg("outputing result");

  fpw=mssOpenFPW(optOTF.str,0,0);

  /*ϥإåν(ȥΥԡ)*/
  hdo=mssInitCpyHeader(hdi);

  mssAddFieldsByStr(hdo->flds,*(optFNM.strList+0)); /*unit̾ɲ*/
  mssAddFieldsByStr(hdo->flds,*(optFNM.strList+1)); /*no̾ɲ*/
  mssAddFieldsByStr(hdo->flds,*(optFNM.strList+2)); /*len̾ɲ*/
  mssAddFieldsByStr(hdo->flds,*(optFNM.strList+3)); /*cnt̾ɲ*/
  mssAddFieldsByStr(hdo->flds,*(optFNM.strList+4)); /*totalCnt̾ɲ*/
  mssAddFieldsByStr(hdo->flds,*(optFNM.strList+5)); /*totalCnt̾ɲ*/
  mssAddFieldsByStr(hdo->flds,*(optFNM.strList+6)); /*totalCnt̾ɲ*/
  mssAddFieldsByStr(hdo->flds,*(optFNM.strList+7)); /*totalCnt̾ɲ*/
  mssAddFieldsByStr(hdo->flds,*(optFNM.strList+8)); /*totalCnt̾ɲ*/
  mssAddFieldsByStr(hdo->flds,*(optFNM.strList+9)); /*totalCnt̾ɲ*/

  if(!PMML) mssWriteHeader(hdo, fpw);

  writeRsl(topStatus,MinSupportCnt,optCNF.val,fpw);

  /*------------------------------------------------*/
  /* Ƽΰ賫                                   */
  /*------------------------------------------------*/
  freeTree(topStatus);
  mssFreeHash(oneItemList->hash);
  mssFreeFRD(frd);

/*----------------------------------------------------------------------------*/
/*եå&λ                                                       */
/*----------------------------------------------------------------------------*/
  if(!PMML) mssWriteFooter(fpw);    /* եåν             */
  mssCloseFPR(fpr);       /* ϥեΥ     */
  mssCloseFPW(fpw);       /* ϥեΥ     */
  mssFreeFields(sf);      /* ȹܹ¤Τΰ賫 */
  mssFreeHeader(hdi);     /* ϥإåΰ賫         */
  mssFreeHeader(hdo);     /* ϥإåΰ賫         */
  mssFreeOption(opt);     /* ץΰ賫         */
  mssShowEndMsg();        /* λå             */
  mssEnd(mssExitSuccess); /* λ                       */
  return(0);              /* to avoid warning message   */
}
