#include <musashi.h>
#include <suffixTree.h>

extern struct mssGlobalVariables mssGV;

/*----------------------------------------------------------------------------*/
/* SuffixTreeν(depthϥǥȤΤ)                              */
/* prnSuffixTree(sn,0)ǸƤӽФФ褤                                      */
/*----------------------------------------------------------------------------*/
static void prnNode(struct SuffixNode *sn,int depth){
  struct SuffixNode *next;
  int i,j;

  if(sn->nextCnt==0) return;
  for(i=0; i<sn->nextCnt; i++){
    for(j=0; j<depth; j++) printf(" ");
    next=*(sn->next+i);
    printf("%s (cnt=%d) depth=%d\n",next->str->str,next->cnt,next->depth);
    prnNode(next,depth+1);
  }
}

/*----------------------------------------------------------------------------*/
/* SuffixTreeν(depthϥǥȤΤ)                              */
/* prnSuffixTree(sn,0)ǸƤӽФФ褤                                      */
/*----------------------------------------------------------------------------*/
void SUFXshow(struct SuffixTree *st){
  printf("------------------- SuffixTree\n");
  printf("maxDepth=%d\n",st->maxDepth);
  printf("maxCnt  =%d\n",st->maxCnt);
  prnNode(st->top,0);
}

/*----------------------------------------------------------------------------*/
/* SuffixNode                                                           */
/*----------------------------------------------------------------------------*/
static struct SuffixNode *makeNode(void){
  struct SuffixNode *sn;
  sn=mssMalloc(sizeof(struct SuffixNode),"initSuffix");
  sn->str =0;
  sn->next=NULL;
  sn->nextCnt=0;
  sn->workNo=0;
  sn->cnt=0;
  sn->depth=0;
  return(sn);
}

/*----------------------------------------------------------------------------*/
/* SuffixTreeγ(SuffixTreeΥȥåץΡɤͿ)                   */
/*----------------------------------------------------------------------------*/
static void freeNode(struct SuffixNode *sn){
  struct SuffixNode *next;
  int i;

  if(sn->nextCnt==0){
     mssFree(sn);
     return;
  }
  for(i=0; i<sn->nextCnt; i++){
    next=*(sn->next+i);
    freeNode(next);
  }
  mssFree(sn->next);
  mssFree(sn);
}

/*----------------------------------------------------------------------------*/
/* SuffixTreeν                                                         */
/*----------------------------------------------------------------------------*/
struct SuffixTree *SUFXinit(int depth){
  struct SuffixTree *st;
  st=mssMalloc(sizeof(struct SuffixTree),"SUFXinit");
  st->top=makeNode();
  st->maxDepth=depth;
  st->maxCnt=0;
  st->recNo=0;
  return(st);
}

/*----------------------------------------------------------------------------*/
/* SuffixTreeγ                                                           */
/*----------------------------------------------------------------------------*/
void SUFXfree(struct SuffixTree *st){
  freeNode(st->top);
  mssFree(st);
}

/*----------------------------------------------------------------------------*/
/* SuffixTreeʸɲ                                                   */
/*----------------------------------------------------------------------------*/
void addSuffix(
  struct SuffixTree *st,
  struct SuffixNode *sn,
  struct mssHashNode **str,
  int n,
  int workNo,
  int maxDepth){
  int i;
  struct SuffixNode *next;

  if(n==0) return;
  if(sn->depth>=maxDepth) return; /*ڤοmaxۤ鲿⤷ʤ*/

  /*ʸΥޥåȤޤsuffixNodeʤƤ*/
  for(i=0; i<sn->nextCnt; i++){
    next=*(sn->next+i);
    if( next->str==*str ){
      if( next->workNo!=workNo ){
        next->cnt++;
        if(next->cnt>st->maxCnt) st->maxCnt=next->cnt;
      }
      next->workNo=workNo;
      addSuffix(st,next,str+1,n-1,workNo,st->maxDepth);
      return;
    }
  }

  /*ȤȤϥޥåʤä*/
  sn->next=mssRealloc(sn->next,sizeof(struct SuffixNode *)*(sn->nextCnt+1),"add");
  *(sn->next+sn->nextCnt)=makeNode();
  next=*(sn->next+sn->nextCnt);
  next->str=*str;
  next->workNo=workNo;
  next->cnt++;
  next->depth=sn->depth+1;
  sn->nextCnt++;
  addSuffix(st,next,str+1,n-1,workNo,maxDepth);
  return;
}

/*----------------------------------------------------------------------------*/
/* SuffixTreeʸsuffixɲ                                         */
/* SuffixTree"st"Ĺ"n"ʸ"str"ɲä                             */
/*----------------------------------------------------------------------------*/
void SUFXaddStr(struct SuffixTree *st, struct mssHashNode **str, int n){
  int i;

  /*Ƥsuffixǲ*/
  for(i=0; i<n; i++){
    addSuffix(st,st->top,str+i,n-i,st->recNo,st->maxDepth);
  }
  st->recNo++;
}

int querySub(struct SuffixNode *sn,struct mssHashNode **str,int n){
  struct SuffixNode *next;
  int i;

  if(n==0)return(sn->cnt);
  for(i=0; i<sn->nextCnt; i++){
    next=*(sn->next+i);
    if(*str==next->str){
      return(querySub(next,str+1,n-1));
      break;
    }
  }
  return(0);

}

int SUFXqueryCnt(struct SuffixTree *st,struct mssHashNode **str,int n){
  return(querySub(st->top,str,n));
}

struct SuffixNode *tbl[100]; /*ѤΥơ֥*/
int outKeyCnt;
MssOptKEY *gKey;
char **gPnt;
void SUFXwriteXtSub(
  struct SuffixNode *sn,
  int minDepth,
  int maxDepth,
  int recNo,
  int support,
  struct mssFPW *fpw){
  struct SuffixNode *next;
  int i,j;

  if(sn->depth>=minDepth && sn->depth<=maxDepth && sn->cnt>=support){
    for(i=0; i<sn->depth; i++){
      for(j=0; j<gKey->cnt; j++){
        mssWriteStr(*(gPnt+MssFlds2num(gKey->flds,j)),fpw);
        mssWriteDlm(fpw);
      }
      mssWriteInt(outKeyCnt,fpw)       ; mssWriteDlm(fpw);
      mssWriteInt(i+1,fpw)             ; mssWriteDlm(fpw);
      mssWriteStr(tbl[i]->str->str,fpw); mssWriteDlm(fpw);
      mssWriteInt(sn->depth,fpw)       ; mssWriteDlm(fpw);
      mssWriteInt(sn->cnt,fpw)         ; mssWriteDlm(fpw);
      mssWriteInt(recNo,fpw)           ; mssWriteRet(fpw);
      mssGV.outCnt++;
    }
    outKeyCnt++;
  }

  if(sn->nextCnt==0){
    return;
  }

  for(i=0; i<sn->nextCnt; i++){
    next=*(sn->next+i);
    tbl[next->depth-1]=next;
    SUFXwriteXtSub(next,minDepth,maxDepth,recNo,support,fpw);
  }
}

void SUFXwriteXt(
  struct SuffixTree *st,
  int minDepth,
  int maxDepth,
  int recNo,
  int support,
  char **pnt,
  MssOptKEY  *key,
  struct mssFPW *fpw){

  outKeyCnt=1;
  gPnt=pnt;
  gKey=key;
  SUFXwriteXtSub(st->top,minDepth,maxDepth,recNo,support,fpw);
}
